# coding: utf-8

"""
    lakeFS API

    lakeFS HTTP API

    The version of the OpenAPI document: 1.0.0
    Contact: services@treeverse.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr

class StagingLocation(BaseModel):
    """
    location for placing an object when staging it
    """
    physical_address: Optional[StrictStr] = None
    presigned_url: Optional[StrictStr] = Field(None, description="if presign=true is passed in the request, this field will contain a pre-signed URL to use when uploading")
    presigned_url_expiry: Optional[StrictInt] = Field(None, description="If present and nonzero, physical_address is a pre-signed URL and will expire at this Unix Epoch time.  This will be shorter than the pre-signed URL lifetime if an authentication token is about to expire.  This field is *optional*. ")
    __properties = ["physical_address", "presigned_url", "presigned_url_expiry"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> StagingLocation:
        """Create an instance of StagingLocation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if presigned_url (nullable) is None
        # and __fields_set__ contains the field
        if self.presigned_url is None and "presigned_url" in self.__fields_set__:
            _dict['presigned_url'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> StagingLocation:
        """Create an instance of StagingLocation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return StagingLocation.parse_obj(obj)

        _obj = StagingLocation.parse_obj({
            "physical_address": obj.get("physical_address"),
            "presigned_url": obj.get("presigned_url"),
            "presigned_url_expiry": obj.get("presigned_url_expiry")
        })
        return _obj


