# coding: utf-8

"""
    lakeFS API

    lakeFS HTTP API

    The version of the OpenAPI document: 1.0.0
    Contact: services@treeverse.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr
from lakefs_sdk.models.access_key_credentials import AccessKeyCredentials

class Setup(BaseModel):
    """
    Setup
    """
    username: StrictStr = Field(..., description="an identifier for the user (e.g. jane.doe)")
    key: Optional[AccessKeyCredentials] = None
    __properties = ["username", "key"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Setup:
        """Create an instance of Setup from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of key
        if self.key:
            _dict['key'] = self.key.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Setup:
        """Create an instance of Setup from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Setup.parse_obj(obj)

        _obj = Setup.parse_obj({
            "username": obj.get("username"),
            "key": AccessKeyCredentials.from_dict(obj.get("key")) if obj.get("key") is not None else None
        })
        return _obj


