# coding: utf-8

"""
    lakeFS API

    lakeFS HTTP API

    The version of the OpenAPI document: 1.0.0
    Contact: services@treeverse.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json



from pydantic import BaseModel, Field, StrictInt, StrictStr

class RangeMetadata(BaseModel):
    """
    RangeMetadata
    """
    id: StrictStr = Field(..., description="ID of the range.")
    min_key: StrictStr = Field(..., description="First key in the range.")
    max_key: StrictStr = Field(..., description="Last key in the range.")
    count: StrictInt = Field(..., description="Number of records in the range.")
    estimated_size: StrictInt = Field(..., description="Estimated size of the range in bytes")
    __properties = ["id", "min_key", "max_key", "count", "estimated_size"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> RangeMetadata:
        """Create an instance of RangeMetadata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> RangeMetadata:
        """Create an instance of RangeMetadata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return RangeMetadata.parse_obj(obj)

        _obj = RangeMetadata.parse_obj({
            "id": obj.get("id"),
            "min_key": obj.get("min_key"),
            "max_key": obj.get("max_key"),
            "count": obj.get("count"),
            "estimated_size": obj.get("estimated_size")
        })
        return _obj


