# coding: utf-8

"""
    lakeFS API

    lakeFS HTTP API

    The version of the OpenAPI document: 1.0.0
    Contact: services@treeverse.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr

class ObjectCopyCreation(BaseModel):
    """
    ObjectCopyCreation
    """
    src_path: StrictStr = Field(..., description="path of the copied object relative to the ref")
    src_ref: Optional[StrictStr] = Field(None, description="a reference, if empty uses the provided branch as ref")
    force: Optional[StrictBool] = False
    __properties = ["src_path", "src_ref", "force"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ObjectCopyCreation:
        """Create an instance of ObjectCopyCreation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ObjectCopyCreation:
        """Create an instance of ObjectCopyCreation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ObjectCopyCreation.parse_obj(obj)

        _obj = ObjectCopyCreation.parse_obj({
            "src_path": obj.get("src_path"),
            "src_ref": obj.get("src_ref"),
            "force": obj.get("force") if obj.get("force") is not None else False
        })
        return _obj


