# coding: utf-8

"""
    lakeFS API

    lakeFS HTTP API

    The version of the OpenAPI document: 1.0.0
    Contact: services@treeverse.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json



from pydantic import BaseModel, Field, StrictStr, validator

class ImportLocation(BaseModel):
    """
    ImportLocation
    """
    type: StrictStr = Field(..., description="Path type, can either be 'common_prefix' or 'object'")
    path: StrictStr = Field(..., description="A source location to a 'common_prefix' or to a single object. Must match the lakeFS installation blockstore type.")
    destination: StrictStr = Field(..., description="Destination for the imported objects on the branch. Must be a relative path to the branch. If the type is an 'object', the destination is the exact object name under the branch. If the type is a 'common_prefix', the destination is the prefix under the branch. ")
    __properties = ["type", "path", "destination"]

    @validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('common_prefix', 'object'):
            raise ValueError("must be one of enum values ('common_prefix', 'object')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ImportLocation:
        """Create an instance of ImportLocation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ImportLocation:
        """Create an instance of ImportLocation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ImportLocation.parse_obj(obj)

        _obj = ImportLocation.parse_obj({
            "type": obj.get("type"),
            "path": obj.get("path"),
            "destination": obj.get("destination")
        })
        return _obj


