# coding: utf-8

"""
    lakeFS API

    lakeFS HTTP API

    The version of the OpenAPI document: 1.0.0
    Contact: services@treeverse.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr

class GarbageCollectionPrepareResponse(BaseModel):
    """
    GarbageCollectionPrepareResponse
    """
    run_id: StrictStr = Field(..., description="a unique identifier generated for this GC job")
    gc_commits_location: StrictStr = Field(..., description="location of the resulting commits csv table (partitioned by run_id)")
    gc_addresses_location: StrictStr = Field(..., description="location to use for expired addresses parquet table (partitioned by run_id)")
    gc_commits_presigned_url: Optional[StrictStr] = Field(None, description="a presigned url to download the commits csv")
    __properties = ["run_id", "gc_commits_location", "gc_addresses_location", "gc_commits_presigned_url"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GarbageCollectionPrepareResponse:
        """Create an instance of GarbageCollectionPrepareResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> GarbageCollectionPrepareResponse:
        """Create an instance of GarbageCollectionPrepareResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return GarbageCollectionPrepareResponse.parse_obj(obj)

        _obj = GarbageCollectionPrepareResponse.parse_obj({
            "run_id": obj.get("run_id"),
            "gc_commits_location": obj.get("gc_commits_location"),
            "gc_addresses_location": obj.get("gc_addresses_location"),
            "gc_commits_presigned_url": obj.get("gc_commits_presigned_url")
        })
        return _obj


