# =============================================================================== #
#                                                                                 #
#    This file has been generated automatically!! Do not change this manually!    #
#                                                                                 #
# =============================================================================== #
from __future__ import annotations

from pydantic import Field

from ..base_object import BaseObject


class LocalFile(BaseObject):
    """
    Represents a local file
    
    Params:
        path (:class:`str`)
            Local path to the locally available file part; may be empty
        
        can_be_downloaded (:class:`bool`)
            True, if it is possible to try to download or generate the file
        
        can_be_deleted (:class:`bool`)
            True, if the file can be deleted
        
        is_downloading_active (:class:`bool`)
            True, if the file is currently being downloaded (or a local copy is being generated by some other means)
        
        is_downloading_completed (:class:`bool`)
            True, if the local copy is fully available
        
        download_offset (:class:`int`)
            Download will be started from this offset. downloaded_prefix_size is calculated from this offset
        
        downloaded_prefix_size (:class:`int`)
            If is_downloading_completed is false, then only some prefix of the file starting from download_offset is ready to be read. downloaded_prefix_size is the size of that prefix
        
        downloaded_size (:class:`int`)
            Total downloaded file bytes. Should be used only for calculating download progress. The actual file size may be bigger, and some parts of it may contain garbage
        
    """

    ID: str = Field("localFile", alias="@type")
    path: str
    can_be_downloaded: bool
    can_be_deleted: bool
    is_downloading_active: bool
    is_downloading_completed: bool
    download_offset: int
    downloaded_prefix_size: int
    downloaded_size: int

    @staticmethod
    def read(q: dict) -> LocalFile:
        return LocalFile.construct(**q)
