"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Architecture = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Architectures supported by AWS Lambda.
 *
 * @stability stable
 */
class Architecture {
    constructor(archName) {
        this.name = archName;
    }
    /**
     * Used to specify a custom architecture name.
     *
     * Use this if the architecture name is not yet supported by the CDK.
     *
     * @param name the architecture name as recognized by AWS Lambda.
     * @stability stable
     */
    static custom(name) {
        return new Architecture(name);
    }
}
exports.Architecture = Architecture;
_a = JSII_RTTI_SYMBOL_1;
Architecture[_a] = { fqn: "@aws-cdk/aws-lambda.Architecture", version: "1.126.0" };
/**
 * 64 bit architecture with x86 instruction set.
 *
 * @stability stable
 */
Architecture.X86_64 = new Architecture('x86_64');
/**
 * 64 bit architecture with the ARM instruction set.
 *
 * @stability stable
 */
Architecture.ARM_64 = new Architecture('arm64');
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXJjaGl0ZWN0dXJlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiYXJjaGl0ZWN0dXJlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7QUFDQSxNQUFhLFlBQVk7SUFldkIsWUFBb0IsUUFBZ0I7UUFDbEMsSUFBSSxDQUFDLElBQUksR0FBRyxRQUFRLENBQUM7SUFDdkIsQ0FBQzs7Ozs7Ozs7O0lBVE0sTUFBTSxDQUFDLE1BQU0sQ0FBQyxJQUFZO1FBQy9CLE9BQU8sSUFBSSxZQUFZLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDaEMsQ0FBQzs7QUFWSCxvQ0FrQkM7Ozs7Ozs7O0FBaEJ3QixtQkFBTSxHQUFHLElBQUksWUFBWSxDQUFDLFFBQVEsQ0FBQyxDQUFDOzs7Ozs7QUFHcEMsbUJBQU0sR0FBRyxJQUFJLFlBQVksQ0FBQyxPQUFPLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIEFyY2hpdGVjdHVyZSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFg4Nl82NCA9IG5ldyBBcmNoaXRlY3R1cmUoJ3g4Nl82NCcpO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBBUk1fNjQgPSBuZXcgQXJjaGl0ZWN0dXJlKCdhcm02NCcpO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIGN1c3RvbShuYW1lOiBzdHJpbmcpIHtcbiAgICByZXR1cm4gbmV3IEFyY2hpdGVjdHVyZShuYW1lKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSBuYW1lOiBzdHJpbmc7XG5cbiAgcHJpdmF0ZSBjb25zdHJ1Y3RvcihhcmNoTmFtZTogc3RyaW5nKSB7XG4gICAgdGhpcy5uYW1lID0gYXJjaE5hbWU7XG4gIH1cbn0iXX0=