# This file is part of aiootp, an asynchronous one-time-pad based crypto
# and anonymity library.
#
# Licensed under the AGPLv3: https://www.gnu.org/licenses/agpl-3.0.html
# Copyright © 2019-2020 Gonzo Investigatory Journalism Agency, LLC
#            <gonzo.development@protonmail.ch>
#           © 2019-2020 Richard Machado <rmlibre@riseup.net>
# All rights reserved.
#


import hashlib


__all__ = [
    "bits",
    "primes",
    "power10",
    "NUM",
    "NONE",
    "ASCII_TABLE",
    "BASE_64_TABLE",
    "ONION_CHAR_TABLE",
    "ASCII_ALPHANUMERIC",
]


ASCII_TABLE = """ !"#$%&'()*+,-./0123456789:;<=>?@"""
ASCII_TABLE += "ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`"
ASCII_TABLE += "abcdefghijklmnopqrstuvwxyz{|}~"


ASCII_ALPHANUMERIC = "0123456789abcdefghijklmnopqrstuvwxyz"
ASCII_ALPHANUMERIC += "ABCDEFGHIJKLMNOPQRSTUVWXYZ"


BASE_64_TABLE = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
BASE_64_TABLE += "abcdefghijklmnopqrstuvwxyz0123456789+/"


ONION_CHAR_TABLE = "234567abcdefghijklmnopqrstuvwxyz"


power10 = {
    # A static table of powers of 10, for efficient, more readable logic
    # comparing and setting the magnitude of numbers. Each entry is named
    # after the log10 of its value.
    0: 1,
    1: 10,
    2: 100,
    3: 1000,
    4: 10000,
    5: 100000,
    6: 1000000,
    7: 10000000,
    8: 100000000,
    9: 1000000000,
    10: 10000000000,
    11: 100000000000,
    12: 1000000000000,
    13: 10000000000000,
    14: 100000000000000,
    15: 1000000000000000,
    16: 10000000000000000,
    17: 100000000000000000,
    18: 1000000000000000000,
    19: 10000000000000000000,
    20: 100000000000000000000,
    21: 1000000000000000000000,
    22: 10000000000000000000000,
    23: 100000000000000000000000,
    24: 1000000000000000000000000,
    25: 10000000000000000000000000,
    26: 100000000000000000000000000,
    27: 1000000000000000000000000000,
    28: 10000000000000000000000000000,
    29: 100000000000000000000000000000,
    30: 1000000000000000000000000000000,
    31: 10000000000000000000000000000000,
    32: 100000000000000000000000000000000,
    33: 1000000000000000000000000000000000,
    34: 10000000000000000000000000000000000,
    35: 100000000000000000000000000000000000,
    36: 1000000000000000000000000000000000000,
    37: 10000000000000000000000000000000000000,
    38: 100000000000000000000000000000000000000,
    39: 1000000000000000000000000000000000000000,
    40: 10000000000000000000000000000000000000000,
    41: 100000000000000000000000000000000000000000,
    42: 1000000000000000000000000000000000000000000,
    43: 10000000000000000000000000000000000000000000,
    44: 100000000000000000000000000000000000000000000,
    45: 1000000000000000000000000000000000000000000000,
    46: 10000000000000000000000000000000000000000000000,
    47: 100000000000000000000000000000000000000000000000,
    48: 1000000000000000000000000000000000000000000000000,
    49: 10000000000000000000000000000000000000000000000000,
    50: 100000000000000000000000000000000000000000000000000,
    51: 1000000000000000000000000000000000000000000000000000,
    52: 10000000000000000000000000000000000000000000000000000,
    53: 100000000000000000000000000000000000000000000000000000,
    54: 1000000000000000000000000000000000000000000000000000000,
    55: 10000000000000000000000000000000000000000000000000000000,
    56: 100000000000000000000000000000000000000000000000000000000,
    57: 1000000000000000000000000000000000000000000000000000000000,
    58: 10000000000000000000000000000000000000000000000000000000000,
    59: 100000000000000000000000000000000000000000000000000000000000,
    60: 1000000000000000000000000000000000000000000000000000000000000,
    61: 10000000000000000000000000000000000000000000000000000000000000,
    62: 100000000000000000000000000000000000000000000000000000000000000,
    63: 1000000000000000000000000000000000000000000000000000000000000000,
    64: 10000000000000000000000000000000000000000000000000000000000000000,
    65: 100000000000000000000000000000000000000000000000000000000000000000,
    66: 1000000000000000000000000000000000000000000000000000000000000000000,
    67: 10000000000000000000000000000000000000000000000000000000000000000000,
    68: 100000000000000000000000000000000000000000000000000000000000000000000,
    69: 1000000000000000000000000000000000000000000000000000000000000000000000,
    70: 10000000000000000000000000000000000000000000000000000000000000000000000,
    71: 100000000000000000000000000000000000000000000000000000000000000000000000,
    72: 1000000000000000000000000000000000000000000000000000000000000000000000000,
    73: 10000000000000000000000000000000000000000000000000000000000000000000000000,
    74: 100000000000000000000000000000000000000000000000000000000000000000000000000,
    75: 1000000000000000000000000000000000000000000000000000000000000000000000000000,
    76: 10000000000000000000000000000000000000000000000000000000000000000000000000000,
    77: 100000000000000000000000000000000000000000000000000000000000000000000000000000,
    78: 1000000000000000000000000000000000000000000000000000000000000000000000000000000,
    79: 10000000000000000000000000000000000000000000000000000000000000000000000000000000,
    80: 100000000000000000000000000000000000000000000000000000000000000000000000000000000,
    81: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    82: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    83: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    84: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    85: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    86: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    87: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    88: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    89: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    90: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    91: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    92: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    93: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    94: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    95: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    96: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    97: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    98: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    99: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    100: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    101: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    102: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    103: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    104: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    105: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    106: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    107: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    108: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    109: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    110: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    111: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    112: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    113: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    114: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    115: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    116: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    117: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    118: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    119: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    120: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    121: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    122: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    123: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    124: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    125: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    126: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    127: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    128: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    129: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    130: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    131: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    132: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    133: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    134: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    135: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    136: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    137: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    138: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    139: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    140: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    141: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    142: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    143: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    144: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    145: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    146: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    147: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    148: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    149: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    150: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    151: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    152: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    153: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    154: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    155: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    156: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    157: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    158: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    159: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    160: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    161: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    162: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    163: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    164: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    165: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    166: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    167: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    168: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    169: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    170: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    171: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    172: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    173: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    174: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    175: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    176: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    177: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    178: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    179: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    180: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    181: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    182: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    183: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    184: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    185: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    186: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    187: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    188: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    189: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    190: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    191: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    192: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    193: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    194: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    195: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    196: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    197: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    198: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    199: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    200: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    201: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    202: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    203: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    204: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    205: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    206: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    207: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    208: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    209: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    210: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    211: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    212: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    213: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    214: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    215: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    216: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    217: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    218: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    219: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    220: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    221: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    222: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    223: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    224: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    225: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    226: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    227: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    228: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    229: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    230: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    231: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    232: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    233: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    234: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    235: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    236: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    237: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    238: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    239: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    240: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    241: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    242: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    243: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    244: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    245: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    246: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    247: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    248: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    249: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    250: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    251: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    252: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    253: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    254: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    255: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    256: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    257: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    258: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    259: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    260: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    261: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    262: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    263: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    264: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    265: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    266: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    267: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    268: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    269: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    270: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    271: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    272: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    273: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    274: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    275: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    276: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    277: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    278: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    279: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    280: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    281: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    282: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    283: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    284: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    285: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    286: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    287: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    288: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    289: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    290: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    291: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    292: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    293: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    294: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    295: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    296: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    297: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    298: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    299: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    300: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    301: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    302: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    303: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    304: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    305: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    306: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    307: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    308: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    309: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    310: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    311: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    312: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    313: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    314: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    315: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    316: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    317: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    318: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    319: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    320: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    321: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    322: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    323: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    324: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    325: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    326: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    327: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    328: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    329: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    330: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    331: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    332: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    333: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    334: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    335: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    336: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    337: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    338: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    339: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    340: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    341: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    342: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    343: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    344: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    345: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    346: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    347: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    348: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    349: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    350: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    351: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    352: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    353: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    354: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    355: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    356: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    357: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    358: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    359: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    360: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    361: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    362: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    363: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    364: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    365: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    366: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    367: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    368: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    369: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    370: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    371: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    372: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    373: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    374: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    375: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    376: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    377: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    378: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    379: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    380: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    381: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    382: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    383: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    384: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    385: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    386: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    387: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    388: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    389: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    390: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    391: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    392: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    393: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    394: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    395: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    396: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    397: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    398: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    399: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    400: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    401: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    402: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    403: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    404: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    405: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    406: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    407: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    408: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    409: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    410: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    411: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    412: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    413: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    414: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    415: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    416: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    417: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    418: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    419: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    420: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    421: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    422: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    423: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    424: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    425: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    426: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    427: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    428: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    429: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    430: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    431: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    432: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    433: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    434: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    435: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    436: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    437: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    438: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    439: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    440: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    441: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    442: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    443: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    444: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    445: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    446: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    447: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    448: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    449: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    450: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    451: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    452: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    453: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    454: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    455: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    456: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    457: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    458: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    459: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    460: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    461: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    462: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    463: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    464: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    465: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    466: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    467: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    468: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    469: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    470: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    471: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    472: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    473: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    474: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    475: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    476: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    477: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    478: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    479: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    480: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    481: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    482: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    483: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    484: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    485: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    486: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    487: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    488: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    489: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    490: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    491: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    492: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    493: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    494: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    495: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    496: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    497: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    498: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    499: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    500: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    501: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    502: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    503: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    504: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    505: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    506: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    507: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    508: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    509: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    510: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    511: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    512: 100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    513: 1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
    514: 10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000,
}


bits = {
    # A static table of powers of 2, for efficient, more readable logic
    # requiring bit and entropy calculations. Each entry is named after
    # how many bits the value is.
    0: 1,
    1: 2,
    2: 4,
    3: 8,
    4: 16,
    5: 32,
    6: 64,
    7: 128,
    8: 256,
    9: 512,
    10: 1024,
    11: 2048,
    12: 4096,
    13: 8192,
    14: 16384,
    15: 32768,
    16: 65536,
    17: 131072,
    18: 262144,
    19: 524288,
    20: 1048576,
    21: 2097152,
    22: 4194304,
    23: 8388608,
    24: 16777216,
    25: 33554432,
    26: 67108864,
    27: 134217728,
    28: 268435456,
    29: 536870912,
    30: 1073741824,
    31: 2147483648,
    32: 4294967296,
    33: 8589934592,
    34: 17179869184,
    35: 34359738368,
    36: 68719476736,
    37: 137438953472,
    38: 274877906944,
    39: 549755813888,
    40: 1099511627776,
    41: 2199023255552,
    42: 4398046511104,
    43: 8796093022208,
    44: 17592186044416,
    45: 35184372088832,
    46: 70368744177664,
    47: 140737488355328,
    48: 281474976710656,
    49: 562949953421312,
    50: 1125899906842624,
    51: 2251799813685248,
    52: 4503599627370496,
    53: 9007199254740992,
    54: 18014398509481984,
    55: 36028797018963968,
    56: 72057594037927936,
    57: 144115188075855872,
    58: 288230376151711744,
    59: 576460752303423488,
    60: 1152921504606846976,
    61: 2305843009213693952,
    62: 4611686018427387904,
    63: 9223372036854775808,
    64: 18446744073709551616,
    65: 36893488147419103232,
    66: 73786976294838206464,
    67: 147573952589676412928,
    68: 295147905179352825856,
    69: 590295810358705651712,
    70: 1180591620717411303424,
    71: 2361183241434822606848,
    72: 4722366482869645213696,
    73: 9444732965739290427392,
    74: 18889465931478580854784,
    75: 37778931862957161709568,
    76: 75557863725914323419136,
    77: 151115727451828646838272,
    78: 302231454903657293676544,
    79: 604462909807314587353088,
    80: 1208925819614629174706176,
    81: 2417851639229258349412352,
    82: 4835703278458516698824704,
    83: 9671406556917033397649408,
    84: 19342813113834066795298816,
    85: 38685626227668133590597632,
    86: 77371252455336267181195264,
    87: 154742504910672534362390528,
    88: 309485009821345068724781056,
    89: 618970019642690137449562112,
    90: 1237940039285380274899124224,
    91: 2475880078570760549798248448,
    92: 4951760157141521099596496896,
    93: 9903520314283042199192993792,
    94: 19807040628566084398385987584,
    95: 39614081257132168796771975168,
    96: 79228162514264337593543950336,
    97: 158456325028528675187087900672,
    98: 316912650057057350374175801344,
    99: 633825300114114700748351602688,
    100: 1267650600228229401496703205376,
    101: 2535301200456458802993406410752,
    102: 5070602400912917605986812821504,
    103: 10141204801825835211973625643008,
    104: 20282409603651670423947251286016,
    105: 40564819207303340847894502572032,
    106: 81129638414606681695789005144064,
    107: 162259276829213363391578010288128,
    108: 324518553658426726783156020576256,
    109: 649037107316853453566312041152512,
    110: 1298074214633706907132624082305024,
    111: 2596148429267413814265248164610048,
    112: 5192296858534827628530496329220096,
    113: 10384593717069655257060992658440192,
    114: 20769187434139310514121985316880384,
    115: 41538374868278621028243970633760768,
    116: 83076749736557242056487941267521536,
    117: 166153499473114484112975882535043072,
    118: 332306998946228968225951765070086144,
    119: 664613997892457936451903530140172288,
    120: 1329227995784915872903807060280344576,
    121: 2658455991569831745807614120560689152,
    122: 5316911983139663491615228241121378304,
    123: 10633823966279326983230456482242756608,
    124: 21267647932558653966460912964485513216,
    125: 42535295865117307932921825928971026432,
    126: 85070591730234615865843651857942052864,
    127: 170141183460469231731687303715884105728,
    128: 340282366920938463463374607431768211456,
    129: 680564733841876926926749214863536422912,
    130: 1361129467683753853853498429727072845824,
    131: 2722258935367507707706996859454145691648,
    132: 5444517870735015415413993718908291383296,
    133: 10889035741470030830827987437816582766592,
    134: 21778071482940061661655974875633165533184,
    135: 43556142965880123323311949751266331066368,
    136: 87112285931760246646623899502532662132736,
    137: 174224571863520493293247799005065324265472,
    138: 348449143727040986586495598010130648530944,
    139: 696898287454081973172991196020261297061888,
    140: 1393796574908163946345982392040522594123776,
    141: 2787593149816327892691964784081045188247552,
    142: 5575186299632655785383929568162090376495104,
    143: 11150372599265311570767859136324180752990208,
    144: 22300745198530623141535718272648361505980416,
    145: 44601490397061246283071436545296723011960832,
    146: 89202980794122492566142873090593446023921664,
    147: 178405961588244985132285746181186892047843328,
    148: 356811923176489970264571492362373784095686656,
    149: 713623846352979940529142984724747568191373312,
    150: 1427247692705959881058285969449495136382746624,
    151: 2854495385411919762116571938898990272765493248,
    152: 5708990770823839524233143877797980545530986496,
    153: 11417981541647679048466287755595961091061972992,
    154: 22835963083295358096932575511191922182123945984,
    155: 45671926166590716193865151022383844364247891968,
    156: 91343852333181432387730302044767688728495783936,
    157: 182687704666362864775460604089535377456991567872,
    158: 365375409332725729550921208179070754913983135744,
    159: 730750818665451459101842416358141509827966271488,
    160: 1461501637330902918203684832716283019655932542976,
    161: 2923003274661805836407369665432566039311865085952,
    162: 5846006549323611672814739330865132078623730171904,
    163: 11692013098647223345629478661730264157247460343808,
    164: 23384026197294446691258957323460528314494920687616,
    165: 46768052394588893382517914646921056628989841375232,
    166: 93536104789177786765035829293842113257979682750464,
    167: 187072209578355573530071658587684226515959365500928,
    168: 374144419156711147060143317175368453031918731001856,
    169: 748288838313422294120286634350736906063837462003712,
    170: 1496577676626844588240573268701473812127674924007424,
    171: 2993155353253689176481146537402947624255349848014848,
    172: 5986310706507378352962293074805895248510699696029696,
    173: 11972621413014756705924586149611790497021399392059392,
    174: 23945242826029513411849172299223580994042798784118784,
    175: 47890485652059026823698344598447161988085597568237568,
    176: 95780971304118053647396689196894323976171195136475136,
    177: 191561942608236107294793378393788647952342390272950272,
    178: 383123885216472214589586756787577295904684780545900544,
    179: 766247770432944429179173513575154591809369561091801088,
    180: 1532495540865888858358347027150309183618739122183602176,
    181: 3064991081731777716716694054300618367237478244367204352,
    182: 6129982163463555433433388108601236734474956488734408704,
    183: 12259964326927110866866776217202473468949912977468817408,
    184: 24519928653854221733733552434404946937899825954937634816,
    185: 49039857307708443467467104868809893875799651909875269632,
    186: 98079714615416886934934209737619787751599303819750539264,
    187: 196159429230833773869868419475239575503198607639501078528,
    188: 392318858461667547739736838950479151006397215279002157056,
    189: 784637716923335095479473677900958302012794430558004314112,
    190: 1569275433846670190958947355801916604025588861116008628224,
    191: 3138550867693340381917894711603833208051177722232017256448,
    192: 6277101735386680763835789423207666416102355444464034512896,
    193: 12554203470773361527671578846415332832204710888928069025792,
    194: 25108406941546723055343157692830665664409421777856138051584,
    195: 50216813883093446110686315385661331328818843555712276103168,
    196: 100433627766186892221372630771322662657637687111424552206336,
    197: 200867255532373784442745261542645325315275374222849104412672,
    198: 401734511064747568885490523085290650630550748445698208825344,
    199: 803469022129495137770981046170581301261101496891396417650688,
    200: 1606938044258990275541962092341162602522202993782792835301376,
    201: 3213876088517980551083924184682325205044405987565585670602752,
    202: 6427752177035961102167848369364650410088811975131171341205504,
    203: 12855504354071922204335696738729300820177623950262342682411008,
    204: 25711008708143844408671393477458601640355247900524685364822016,
    205: 51422017416287688817342786954917203280710495801049370729644032,
    206: 102844034832575377634685573909834406561420991602098741459288064,
    207: 205688069665150755269371147819668813122841983204197482918576128,
    208: 411376139330301510538742295639337626245683966408394965837152256,
    209: 822752278660603021077484591278675252491367932816789931674304512,
    210: 1645504557321206042154969182557350504982735865633579863348609024,
    211: 3291009114642412084309938365114701009965471731267159726697218048,
    212: 6582018229284824168619876730229402019930943462534319453394436096,
    213: 13164036458569648337239753460458804039861886925068638906788872192,
    214: 26328072917139296674479506920917608079723773850137277813577744384,
    215: 52656145834278593348959013841835216159447547700274555627155488768,
    216: 105312291668557186697918027683670432318895095400549111254310977536,
    217: 210624583337114373395836055367340864637790190801098222508621955072,
    218: 421249166674228746791672110734681729275580381602196445017243910144,
    219: 842498333348457493583344221469363458551160763204392890034487820288,
    220: 1684996666696914987166688442938726917102321526408785780068975640576,
    221: 3369993333393829974333376885877453834204643052817571560137951281152,
    222: 6739986666787659948666753771754907668409286105635143120275902562304,
    223: 13479973333575319897333507543509815336818572211270286240551805124608,
    224: 26959946667150639794667015087019630673637144422540572481103610249216,
    225: 53919893334301279589334030174039261347274288845081144962207220498432,
    226: 107839786668602559178668060348078522694548577690162289924414440996864,
    227: 215679573337205118357336120696157045389097155380324579848828881993728,
    228: 431359146674410236714672241392314090778194310760649159697657763987456,
    229: 862718293348820473429344482784628181556388621521298319395315527974912,
    230: 1725436586697640946858688965569256363112777243042596638790631055949824,
    231: 3450873173395281893717377931138512726225554486085193277581262111899648,
    232: 6901746346790563787434755862277025452451108972170386555162524223799296,
    233: 13803492693581127574869511724554050904902217944340773110325048447598592,
    234: 27606985387162255149739023449108101809804435888681546220650096895197184,
    235: 55213970774324510299478046898216203619608871777363092441300193790394368,
    236: 110427941548649020598956093796432407239217743554726184882600387580788736,
    237: 220855883097298041197912187592864814478435487109452369765200775161577472,
    238: 441711766194596082395824375185729628956870974218904739530401550323154944,
    239: 883423532389192164791648750371459257913741948437809479060803100646309888,
    240: 1766847064778384329583297500742918515827483896875618958121606201292619776,
    241: 3533694129556768659166595001485837031654967793751237916243212402585239552,
    242: 7067388259113537318333190002971674063309935587502475832486424805170479104,
    243: 14134776518227074636666380005943348126619871175004951664972849610340958208,
    244: 28269553036454149273332760011886696253239742350009903329945699220681916416,
    245: 56539106072908298546665520023773392506479484700019806659891398441363832832,
    246: 113078212145816597093331040047546785012958969400039613319782796882727665664,
    247: 226156424291633194186662080095093570025917938800079226639565593765455331328,
    248: 452312848583266388373324160190187140051835877600158453279131187530910662656,
    249: 904625697166532776746648320380374280103671755200316906558262375061821325312,
    250: 1809251394333065553493296640760748560207343510400633813116524750123642650624,
    251: 3618502788666131106986593281521497120414687020801267626233049500247285301248,
    252: 7237005577332262213973186563042994240829374041602535252466099000494570602496,
    253: 14474011154664524427946373126085988481658748083205070504932198000989141204992,
    254: 28948022309329048855892746252171976963317496166410141009864396001978282409984,
    255: 57896044618658097711785492504343953926634992332820282019728792003956564819968,
    256: 115792089237316195423570985008687907853269984665640564039457584007913129639936,
    257: 231584178474632390847141970017375815706539969331281128078915168015826259279872,
    258: 463168356949264781694283940034751631413079938662562256157830336031652518559744,
    510: 3351951982485649274893506249551461531869841455148098344430890360930441007518386744200468574541725856922507964546621512713438470702986642486608412251521024,
    511: 6703903964971298549787012499102923063739682910296196688861780721860882015036773488400937149083451713845015929093243025426876941405973284973216824503042048,
    512: 13407807929942597099574024998205846127479365820592393377723561443721764030073546976801874298166903427690031858186486050853753882811946569946433649006084096,
    513: 26815615859885194199148049996411692254958731641184786755447122887443528060147093953603748596333806855380063716372972101707507765623893139892867298012168192,
    514: 53631231719770388398296099992823384509917463282369573510894245774887056120294187907207497192667613710760127432745944203415015531247786279785734596024336384,
    1022: 44942328371557897693232629769725618340449424473557664318357520289433168951375240783177119330601884005280028469967848339414697442203604155623211857659868531094441973356216371319075554900311523529863270738021251442209537670585615720368478277635206809290837627671146574559986811484619929076208839082406056034304,
    1023: 89884656743115795386465259539451236680898848947115328636715040578866337902750481566354238661203768010560056939935696678829394884407208311246423715319737062188883946712432742638151109800623047059726541476042502884419075341171231440736956555270413618581675255342293149119973622969239858152417678164812112068608,
    1024: 179769313486231590772930519078902473361797697894230657273430081157732675805500963132708477322407536021120113879871393357658789768814416622492847430639474124377767893424865485276302219601246094119453082952085005768838150682342462881473913110540827237163350510684586298239947245938479716304835356329624224137216,
    1025: 359538626972463181545861038157804946723595395788461314546860162315465351611001926265416954644815072042240227759742786715317579537628833244985694861278948248755535786849730970552604439202492188238906165904170011537676301364684925762947826221081654474326701021369172596479894491876959432609670712659248448274432,
    1026: 719077253944926363091722076315609893447190791576922629093720324630930703222003852530833909289630144084480455519485573430635159075257666489971389722557896497511071573699461941105208878404984376477812331808340023075352602729369851525895652442163308948653402042738345192959788983753918865219341425318496896548864,
    1534: 602578106730258147145029151507078528228023311986422237839918759766314347897950800167271256026836512415862191570222001196965604244698739581242403246972693662863803334845406306192695519479420374919211385784346955014399336464476149777365346780524876991249453910335575169407368338820404357102948540991946467592592242277305397985763558002890689612520144896962725248428723070869161657795378765951218343795565126561748209474676492753131460831100308246714251190084829184,
    1535: 1205156213460516294290058303014157056456046623972844475679837519532628695795901600334542512053673024831724383140444002393931208489397479162484806493945387325727606669690812612385391038958840749838422771568693910028798672928952299554730693561049753982498907820671150338814736677640808714205897081983892935185184484554610795971527116005781379225040289793925450496857446141738323315590757531902436687591130253123496418949352985506262921662200616493428502380169658368,
    1536: 2410312426921032588580116606028314112912093247945688951359675039065257391591803200669085024107346049663448766280888004787862416978794958324969612987890774651455213339381625224770782077917681499676845543137387820057597345857904599109461387122099507964997815641342300677629473355281617428411794163967785870370368969109221591943054232011562758450080579587850900993714892283476646631181515063804873375182260506246992837898705971012525843324401232986857004760339316736,
    1537: 4820624853842065177160233212056628225824186495891377902719350078130514783183606401338170048214692099326897532561776009575724833957589916649939225975781549302910426678763250449541564155835362999353691086274775640115194691715809198218922774244199015929995631282684601355258946710563234856823588327935571740740737938218443183886108464023125516900161159175701801987429784566953293262363030127609746750364521012493985675797411942025051686648802465973714009520678633472,
    1538: 9641249707684130354320466424113256451648372991782755805438700156261029566367212802676340096429384198653795065123552019151449667915179833299878451951563098605820853357526500899083128311670725998707382172549551280230389383431618396437845548488398031859991262565369202710517893421126469713647176655871143481481475876436886367772216928046251033800322318351403603974859569133906586524726060255219493500729042024987971351594823884050103373297604931947428019041357266944,
    2046: 8079251517827751825178719172167487990111025667428871008032586356881163784716972723299300352880728365922179490230474504873529889787622730273772038096612070780157719341825249022937549437597413026699014409596016892069198054660654939040459523584619042617645411463009076260721893972885266452151888099780982596380478583347417085605171243696641142373714044008831580514519451414832756548177115078537564648216044279181485900929615464339399587788075411476100924403308321807806781421177705052431289275431732830867419635645164174483761499317088249659553881291597359333885900533858307401161329619651238037048388963402764899057664,
    2047: 16158503035655503650357438344334975980222051334857742016065172713762327569433945446598600705761456731844358980460949009747059779575245460547544076193224141560315438683650498045875098875194826053398028819192033784138396109321309878080919047169238085235290822926018152521443787945770532904303776199561965192760957166694834171210342487393282284747428088017663161029038902829665513096354230157075129296432088558362971801859230928678799175576150822952201848806616643615613562842355410104862578550863465661734839271290328348967522998634176499319107762583194718667771801067716614802322659239302476074096777926805529798115328,
    2048: 32317006071311007300714876688669951960444102669715484032130345427524655138867890893197201411522913463688717960921898019494119559150490921095088152386448283120630877367300996091750197750389652106796057638384067568276792218642619756161838094338476170470581645852036305042887575891541065808607552399123930385521914333389668342420684974786564569494856176035326322058077805659331026192708460314150258592864177116725943603718461857357598351152301645904403697613233287231227125684710820209725157101726931323469678542580656697935045997268352998638215525166389437335543602135433229604645318478604952148193555853611059596230656,
    2049: 64634012142622014601429753377339903920888205339430968064260690855049310277735781786394402823045826927377435921843796038988239118300981842190176304772896566241261754734601992183500395500779304213592115276768135136553584437285239512323676188676952340941163291704072610085775151783082131617215104798247860771043828666779336684841369949573129138989712352070652644116155611318662052385416920628300517185728354233451887207436923714715196702304603291808807395226466574462454251369421640419450314203453862646939357085161313395870091994536705997276431050332778874671087204270866459209290636957209904296387111707222119192461312,
    2050: 129268024285244029202859506754679807841776410678861936128521381710098620555471563572788805646091653854754871843687592077976478236601963684380352609545793132482523509469203984367000791001558608427184230553536270273107168874570479024647352377353904681882326583408145220171550303566164263234430209596495721542087657333558673369682739899146258277979424704141305288232311222637324104770833841256601034371456708466903774414873847429430393404609206583617614790452933148924908502738843280838900628406907725293878714170322626791740183989073411994552862100665557749342174408541732918418581273914419808592774223414444238384922624,
    2558: 108325052568731694825308930748782632281712981078063391569207841636774413988317069718397999842113439843838114780160527292318560027655210879492525577806114606891011654056790278950415538089848862989723458870226252561675809860925481363435920931734697441985144381138931090599259839646862062185248488927095579270882962783439632883211173576184295773354642797513323249429103453928604435108563578917566833888302401636347475239663385425554691915718237277499865149249781429788942116694610807429979794933972744634256644012526875217335078547221775273815834966475270196786442978930592180211130462760093895572818706143611115604960479046718764593601082250812674643708058963967792099785020570725179607529143904274264672933816729426335346542904613168265881696009813157760509247233137311744,
    2559: 216650105137463389650617861497565264563425962156126783138415683273548827976634139436795999684226879687676229560321054584637120055310421758985051155612229213782023308113580557900831076179697725979446917740452505123351619721850962726871841863469394883970288762277862181198519679293724124370496977854191158541765925566879265766422347152368591546709285595026646498858206907857208870217127157835133667776604803272694950479326770851109383831436474554999730298499562859577884233389221614859959589867945489268513288025053750434670157094443550547631669932950540393572885957861184360422260925520187791145637412287222231209920958093437529187202164501625349287416117927935584199570041141450359215058287808548529345867633458852670693085809226336531763392019626315521018494466274623488,
    2560: 433300210274926779301235722995130529126851924312253566276831366547097655953268278873591999368453759375352459120642109169274240110620843517970102311224458427564046616227161115801662152359395451958893835480905010246703239443701925453743683726938789767940577524555724362397039358587448248740993955708382317083531851133758531532844694304737183093418571190053292997716413815714417740434254315670267335553209606545389900958653541702218767662872949109999460596999125719155768466778443229719919179735890978537026576050107500869340314188887101095263339865901080787145771915722368720844521851040375582291274824574444462419841916186875058374404329003250698574832235855871168399140082282900718430116575617097058691735266917705341386171618452673063526784039252631042036988932549246976,
    2561: 866600420549853558602471445990261058253703848624507132553662733094195311906536557747183998736907518750704918241284218338548480221241687035940204622448916855128093232454322231603324304718790903917787670961810020493406478887403850907487367453877579535881155049111448724794078717174896497481987911416764634167063702267517063065689388609474366186837142380106585995432827631428835480868508631340534671106419213090779801917307083404437535325745898219998921193998251438311536933556886459439838359471781957074053152100215001738680628377774202190526679731802161574291543831444737441689043702080751164582549649148888924839683832373750116748808658006501397149664471711742336798280164565801436860233151234194117383470533835410682772343236905346127053568078505262084073977865098493952,
    2562: 1733200841099707117204942891980522116507407697249014265107325466188390623813073115494367997473815037501409836482568436677096960442483374071880409244897833710256186464908644463206648609437581807835575341923620040986812957774807701814974734907755159071762310098222897449588157434349792994963975822833529268334127404535034126131378777218948732373674284760213171990865655262857670961737017262681069342212838426181559603834614166808875070651491796439997842387996502876623073867113772918879676718943563914148106304200430003477361256755548404381053359463604323148583087662889474883378087404161502329165099298297777849679367664747500233497617316013002794299328943423484673596560329131602873720466302468388234766941067670821365544686473810692254107136157010524168147955730196987904,
    3070: 1452401498842489515714875633326143592671743794090723809165371538071800932749277556434334011133279601812831539438745129360997632398635011780415721418046758100258027909926610124711012462747262906800061191451760453098682420135006026206994146092345380573090302194761192473185806437934519244892202827394781377833273310879888446204076595395040465050061873142112037560628826112394296901034107184645247543137893483536563957591601478750217410933013304641708136322776975930707908534649896601672581489931296861792264885201253077552409752937687190004273840183558736439354068248714003327154239632489576169409254795398522132086265321465974567940864323720886659719888577903861611582549813595585004073014272687793883472040479746823897882884174675323066921366379359478947705788711158695065025722929508123849018760474871378452781744326869742268714260927679037530328980506139189810309753288229927739117101594860728735403589276978615641832423424,
    3071: 2904802997684979031429751266652287185343487588181447618330743076143601865498555112868668022266559203625663078877490258721995264797270023560831442836093516200516055819853220249422024925494525813600122382903520906197364840270012052413988292184690761146180604389522384946371612875869038489784405654789562755666546621759776892408153190790080930100123746284224075121257652224788593802068214369290495086275786967073127915183202957500434821866026609283416272645553951861415817069299793203345162979862593723584529770402506155104819505875374380008547680367117472878708136497428006654308479264979152338818509590797044264172530642931949135881728647441773319439777155807723223165099627191170008146028545375587766944080959493647795765768349350646133842732758718957895411577422317390130051445859016247698037520949742756905563488653739484537428521855358075060657961012278379620619506576459855478234203189721457470807178553957231283664846848,
    3072: 5809605995369958062859502533304574370686975176362895236661486152287203730997110225737336044533118407251326157754980517443990529594540047121662885672187032401032111639706440498844049850989051627200244765807041812394729680540024104827976584369381522292361208779044769892743225751738076979568811309579125511333093243519553784816306381580161860200247492568448150242515304449577187604136428738580990172551573934146255830366405915000869643732053218566832545291107903722831634138599586406690325959725187447169059540805012310209639011750748760017095360734234945757416272994856013308616958529958304677637019181594088528345061285863898271763457294883546638879554311615446446330199254382340016292057090751175533888161918987295591531536698701292267685465517437915790823154844634780260102891718032495396075041899485513811126977307478969074857043710716150121315922024556759241239013152919710956468406379442914941614357107914462567329693696,
    3073: 11619211990739916125719005066609148741373950352725790473322972304574407461994220451474672089066236814502652315509961034887981059189080094243325771344374064802064223279412880997688099701978103254400489531614083624789459361080048209655953168738763044584722417558089539785486451503476153959137622619158251022666186487039107569632612763160323720400494985136896300485030608899154375208272857477161980345103147868292511660732811830001739287464106437133665090582215807445663268277199172813380651919450374894338119081610024620419278023501497520034190721468469891514832545989712026617233917059916609355274038363188177056690122571727796543526914589767093277759108623230892892660398508764680032584114181502351067776323837974591183063073397402584535370931034875831581646309689269560520205783436064990792150083798971027622253954614957938149714087421432300242631844049113518482478026305839421912936812758885829883228714215828925134659387392,
    3074: 23238423981479832251438010133218297482747900705451580946645944609148814923988440902949344178132473629005304631019922069775962118378160188486651542688748129604128446558825761995376199403956206508800979063228167249578918722160096419311906337477526089169444835116179079570972903006952307918275245238316502045332372974078215139265225526320647440800989970273792600970061217798308750416545714954323960690206295736585023321465623660003478574928212874267330181164431614891326536554398345626761303838900749788676238163220049240838556047002995040068381442936939783029665091979424053234467834119833218710548076726376354113380245143455593087053829179534186555518217246461785785320797017529360065168228363004702135552647675949182366126146794805169070741862069751663163292619378539121040411566872129981584300167597942055244507909229915876299428174842864600485263688098227036964956052611678843825873625517771659766457428431657850269318774784,
    3582: 19473520333640844691127176862977149658590968948136526555247820243011272528285939061837707013418630693601041476568594986448123729387077643515811960411020482474294659386532350316053903539988147515390538730103863099146708934871245522941906322189870389962117919361028202071764176745980651257550452869590472617231874558907485685927367574648809115885947602724023790934518369995350619469561613808778207297256942426414559305648709312602649150614261853439607537507462932895730385881610561381979306213956956954155371387764484350419237234585750558467856203620817475676959043251863760768656792160668177150351045377597021414213264417090418226523925105259413550636485086184257591644591589393199898495538890080330871093821347753938084388897294966205185738762080099421245687443300643061380644532328158133536192948933806592507527238139734445474775820534266432764308034618758576637009643867006811192758495822265172889202823244282947775986251889156602254569864288788917095347237435709225746335486741183724272646028951741973332877875405120448636089315222389626215827597972845678291201404256024264704,
    3583: 38947040667281689382254353725954299317181937896273053110495640486022545056571878123675414026837261387202082953137189972896247458774155287031623920822040964948589318773064700632107807079976295030781077460207726198293417869742491045883812644379740779924235838722056404143528353491961302515100905739180945234463749117814971371854735149297618231771895205448047581869036739990701238939123227617556414594513884852829118611297418625205298301228523706879215075014925865791460771763221122763958612427913913908310742775528968700838474469171501116935712407241634951353918086503727521537313584321336354300702090755194042828426528834180836453047850210518827101272970172368515183289183178786399796991077780160661742187642695507876168777794589932410371477524160198842491374886601286122761289064656316267072385897867613185015054476279468890949551641068532865528616069237517153274019287734013622385516991644530345778405646488565895551972503778313204509139728577577834190694474871418451492670973482367448545292057903483946665755750810240897272178630444779252431655195945691356582402808512048529408,
    3584: 77894081334563378764508707451908598634363875792546106220991280972045090113143756247350828053674522774404165906274379945792494917548310574063247841644081929897178637546129401264215614159952590061562154920415452396586835739484982091767625288759481559848471677444112808287056706983922605030201811478361890468927498235629942743709470298595236463543790410896095163738073479981402477878246455235112829189027769705658237222594837250410596602457047413758430150029851731582921543526442245527917224855827827816621485551057937401676948938343002233871424814483269902707836173007455043074627168642672708601404181510388085656853057668361672906095700421037654202545940344737030366578366357572799593982155560321323484375285391015752337555589179864820742955048320397684982749773202572245522578129312632534144771795735226370030108952558937781899103282137065731057232138475034306548038575468027244771033983289060691556811292977131791103945007556626409018279457155155668381388949742836902985341946964734897090584115806967893331511501620481794544357260889558504863310391891382713164805617024097058816,
    3585: 155788162669126757529017414903817197268727751585092212441982561944090180226287512494701656107349045548808331812548759891584989835096621148126495683288163859794357275092258802528431228319905180123124309840830904793173671478969964183535250577518963119696943354888225616574113413967845210060403622956723780937854996471259885487418940597190472927087580821792190327476146959962804955756492910470225658378055539411316474445189674500821193204914094827516860300059703463165843087052884491055834449711655655633242971102115874803353897876686004467742849628966539805415672346014910086149254337285345417202808363020776171313706115336723345812191400842075308405091880689474060733156732715145599187964311120642646968750570782031504675111178359729641485910096640795369965499546405144491045156258625265068289543591470452740060217905117875563798206564274131462114464276950068613096077150936054489542067966578121383113622585954263582207890015113252818036558914310311336762777899485673805970683893929469794181168231613935786663023003240963589088714521779117009726620783782765426329611234048194117632,
    3586: 311576325338253515058034829807634394537455503170184424883965123888180360452575024989403312214698091097616663625097519783169979670193242296252991366576327719588714550184517605056862456639810360246248619681661809586347342957939928367070501155037926239393886709776451233148226827935690420120807245913447561875709992942519770974837881194380945854175161643584380654952293919925609911512985820940451316756111078822632948890379349001642386409828189655033720600119406926331686174105768982111668899423311311266485942204231749606707795753372008935485699257933079610831344692029820172298508674570690834405616726041552342627412230673446691624382801684150616810183761378948121466313465430291198375928622241285293937501141564063009350222356719459282971820193281590739930999092810288982090312517250530136579087182940905480120435810235751127596413128548262924228928553900137226192154301872108979084135933156242766227245171908527164415780030226505636073117828620622673525555798971347611941367787858939588362336463227871573326046006481927178177429043558234019453241567565530852659222468096388235264,
    4094: 261097220353288126672938177679156095644991062261845945096058370820988476992889364212206702983749389585222526678609815709496893359546448401815809021962841319486489244135927499585090397533595929578607017502963986556594079709849428186418083671086146654374201977176450926017821012185029652278616994445899507251671734744220446946486726407547565235149894863358205867325756674110764756253993099966928553885423458889971322871579559478608624183521952968159874118775047260337252104265418773417083462637758243022067387692495904092352983253803449206459297022958414187805329623211592031387556499575103086196215648918623048654255951626478311402706432958845021902155525708567549424550578292254419501668798871269980409104842571343781196003726789783864995697628349902887948567776707783522646068221069947888712445738580883629266305817265348726496923250530740848921945719737110154001853236418729955762642910594288704080345157761475729034231677085714110182611974992975445366440868305962566813264974948999022699867300443656204429612466863914812544582267618279858291387701892055461642936593324221228204880079364250610231654227718537096269602982451130745464334744412025781521475750325603366797431668304122877782900730195434508359022560951177085100788547584,
    4095: 522194440706576253345876355358312191289982124523691890192116741641976953985778728424413405967498779170445053357219631418993786719092896803631618043925682638972978488271854999170180795067191859157214035005927973113188159419698856372836167342172293308748403954352901852035642024370059304557233988891799014503343469488440893892973452815095130470299789726716411734651513348221529512507986199933857107770846917779942645743159118957217248367043905936319748237550094520674504208530837546834166925275516486044134775384991808184705966507606898412918594045916828375610659246423184062775112999150206172392431297837246097308511903252956622805412865917690043804311051417135098849101156584508839003337597742539960818209685142687562392007453579567729991395256699805775897135553415567045292136442139895777424891477161767258532611634530697452993846501061481697843891439474220308003706472837459911525285821188577408160690315522951458068463354171428220365223949985950890732881736611925133626529949897998045399734600887312408859224933727829625089164535236559716582775403784110923285873186648442456409760158728501220463308455437074192539205964902261490928669488824051563042951500651206733594863336608245755565801460390869016718045121902354170201577095168,
    4096: 1044388881413152506691752710716624382579964249047383780384233483283953907971557456848826811934997558340890106714439262837987573438185793607263236087851365277945956976543709998340361590134383718314428070011855946226376318839397712745672334684344586617496807908705803704071284048740118609114467977783598029006686938976881787785946905630190260940599579453432823469303026696443059025015972399867714215541693835559885291486318237914434496734087811872639496475100189041349008417061675093668333850551032972088269550769983616369411933015213796825837188091833656751221318492846368125550225998300412344784862595674492194617023806505913245610825731835380087608622102834270197698202313169017678006675195485079921636419370285375124784014907159135459982790513399611551794271106831134090584272884279791554849782954323534517065223269061394905987693002122963395687782878948440616007412945674919823050571642377154816321380631045902916136926708342856440730447899971901781465763473223850267253059899795996090799469201774624817718449867455659250178329070473119433165550807568221846571746373296884912819520317457002440926616910874148385078411929804522981857338977648103126085903001302413467189726673216491511131602920781738033436090243804708340403154190336,
    4097: 2088777762826305013383505421433248765159928498094767560768466966567907815943114913697653623869995116681780213428878525675975146876371587214526472175702730555891913953087419996680723180268767436628856140023711892452752637678795425491344669368689173234993615817411607408142568097480237218228935955567196058013373877953763575571893811260380521881199158906865646938606053392886118050031944799735428431083387671119770582972636475828868993468175623745278992950200378082698016834123350187336667701102065944176539101539967232738823866030427593651674376183667313502442636985692736251100451996600824689569725191348984389234047613011826491221651463670760175217244205668540395396404626338035356013350390970159843272838740570750249568029814318270919965581026799223103588542213662268181168545768559583109699565908647069034130446538122789811975386004245926791375565757896881232014825891349839646101143284754309632642761262091805832273853416685712881460895799943803562931526946447700534506119799591992181598938403549249635436899734911318500356658140946238866331101615136443693143492746593769825639040634914004881853233821748296770156823859609045963714677955296206252171806002604826934379453346432983022263205841563476066872180487609416680806308380672,
    4098: 4177555525652610026767010842866497530319856996189535121536933933135815631886229827395307247739990233363560426857757051351950293752743174429052944351405461111783827906174839993361446360537534873257712280047423784905505275357590850982689338737378346469987231634823214816285136194960474436457871911134392116026747755907527151143787622520761043762398317813731293877212106785772236100063889599470856862166775342239541165945272951657737986936351247490557985900400756165396033668246700374673335402204131888353078203079934465477647732060855187303348752367334627004885273971385472502200903993201649379139450382697968778468095226023652982443302927341520350434488411337080790792809252676070712026700781940319686545677481141500499136059628636541839931162053598446207177084427324536362337091537119166219399131817294138068260893076245579623950772008491853582751131515793762464029651782699679292202286569508619265285522524183611664547706833371425762921791599887607125863053892895401069012239599183984363197876807098499270873799469822637000713316281892477732662203230272887386286985493187539651278081269828009763706467643496593540313647719218091927429355910592412504343612005209653868758906692865966044526411683126952133744360975218833361612616761344,
}


primes = {
    # A static table of primes for efficient and/or deterministic
    # functionality requiring prime numbers. The primes are organized
    # where by for each group of primes, the minimum number of bits is
    # given by the key, and the exlusive maximum is bits + 1.
    1: [2, 3],
    2: [5, 7],
    3: [11, 13],
    4: [19, 17, 23, 29, 31],
    5: [37, 41, 43, 47, 53, 59, 61],
    6: [67, 83, 89, 71, 109, 73, 97, 113, 107, 127],
    7: [131, 173, 139, 179, 191, 167, 211, 223, 157, 251],
    8: [257, 269, 317, 439, 409, 419, 431, 503, 347, 509],
    9: [521, 541, 563, 919, 863, 631, 607, 587, 719, 1021],
    10: [1031, 1151, 1931, 1399, 1733, 1867, 1129, 1277, 1087, 2039],
    11: [2053, 2833, 2309, 2729, 3407, 3203, 4051, 3877, 3359, 4093],
    12: [4099, 7573, 4993, 6547, 4229, 6113, 6521, 5639, 6469, 8191],
    13: [
        8209,
        13487,
        15349,
        15091,
        12569,
        10061,
        15259,
        10937,
        14447,
        16381,
    ],
    14: [
        16411,
        17747,
        22901,
        20231,
        19081,
        31567,
        19739,
        17317,
        23399,
        32749,
    ],
    15: [
        32771,
        60127,
        60937,
        61223,
        53939,
        34469,
        55763,
        54083,
        48847,
        65521,
    ],
    16: [
        65537,
        110129,
        71119,
        80527,
        129509,
        109211,
        85733,
        80513,
        125863,
        131071,
    ],
    17: [
        131101,
        223037,
        216259,
        256873,
        226937,
        185467,
        243769,
        218249,
        236917,
        262139,
    ],
    18: [
        262147,
        306239,
        439339,
        273269,
        494327,
        461917,
        345997,
        304739,
        394291,
        524287,
    ],
    19: [
        524309,
        662083,
        648719,
        885713,
        1039109,
        832063,
        1043723,
        529153,
        548903,
        1048573,
    ],
    20: [
        1048583,
        1612903,
        2060389,
        1481911,
        1807357,
        1754743,
        1760113,
        1182007,
        1788601,
        2097143,
    ],
    21: [
        2097169,
        4193549,
        3458999,
        2474863,
        3892571,
        2304931,
        3406147,
        2353639,
        3101171,
        4194301,
    ],
    22: [
        4194319,
        5963011,
        7645387,
        7794929,
        6196819,
        7253711,
        5409913,
        5234767,
        7467563,
        8388593,
    ],
    23: [
        8388617,
        13440269,
        11894683,
        11897051,
        13523933,
        8989369,
        12553553,
        12559543,
        12436211,
        16777213,
    ],
    24: [
        16777259,
        32392979,
        22427161,
        17475659,
        22348477,
        23990459,
        31364941,
        17926217,
        24135473,
        33554393,
    ],
    25: [
        33554467,
        55831469,
        64905457,
        39209281,
        37007209,
        66049043,
        44160559,
        62206499,
        52584431,
        67108859,
    ],
    26: [
        67108879,
        77334757,
        108814949,
        123435439,
        81649661,
        132795587,
        94584307,
        76277587,
        116429801,
        134217689,
    ],
    27: [
        134217757,
        221593213,
        191713673,
        262862183,
        245851523,
        192433979,
        150310637,
        223845151,
        143888279,
        268435399,
    ],
    28: [
        268435459,
        533086753,
        322547683,
        499697351,
        528904793,
        312082871,
        374207201,
        480774223,
        427803889,
        536870909,
    ],
    29: [
        536870923,
        792218387,
        560303071,
        618794041,
        671275973,
        834728057,
        674897117,
        962162653,
        551767477,
        1073741789,
    ],
    30: [
        1073741827,
        1372488911,
        1158325799,
        1290761299,
        1999385329,
        2118376279,
        2022720307,
        1835245409,
        1171574497,
        2147483647,
    ],
    31: [
        2147483659,
        3520203823,
        3836882171,
        2671478009,
        3666670261,
        2173022767,
        3598900937,
        2805725191,
        3028091107,
        4294967291,
    ],
    32: [
        4294967311,
        5236502177,
        5464775807,
        5408714821,
        6238479167,
        6209496569,
        6738696241,
        7750860443,
        7896672491,
        8589934583,
    ],
    33: [
        8589934609,
        16258971217,
        16344128369,
        15752345881,
        14006502529,
        13481341403,
        9272402411,
        12775068451,
        12971327141,
        17179869143,
    ],
    34: [
        17179869209,
        30839901329,
        25141201643,
        23824588841,
        27579138841,
        20668469719,
        26518295171,
        33519870871,
        26104523351,
        34359738337,
    ],
    35: [
        34359738421,
        59732858323,
        36931199083,
        46421944589,
        38006306927,
        61666310039,
        62995886711,
        58153036607,
        56497038541,
        68719476731,
    ],
    36: [
        68719476767,
        92085031613,
        130200928313,
        71330993249,
        90043809487,
        132513953879,
        75525215951,
        75369273191,
        92764770503,
        137438953447,
    ],
    37: [
        137438953481,
        160947274273,
        164620209671,
        212639759399,
        259846255111,
        158515777669,
        200623329299,
        205820780657,
        232777310153,
        274877906899,
    ],
    38: [
        274877906951,
        507202901789,
        382815023761,
        541977883123,
        531538175159,
        282075794071,
        496775261251,
        344180884207,
        284901910037,
        549755813881,
    ],
    39: [
        549755813911,
        847904778223,
        973145330867,
        810321980813,
        920277329429,
        1077715088423,
        597054775901,
        568679137307,
        796738116331,
        1099511627689,
    ],
    40: [
        1099511627791,
        1169256089479,
        2101243493329,
        2022179889703,
        2176001191799,
        1419484241291,
        1115984185237,
        1405808781257,
        1553694443557,
        2199023255531,
    ],
    41: [
        2199023255579,
        4395631723853,
        2368475367353,
        4162016212331,
        2687659289137,
        3148886973497,
        3020929379063,
        4001763593081,
        4250261175911,
        4398046511093,
    ],
    42: [
        4398046511119,
        7146798047801,
        4945763678749,
        7986757887077,
        6772309067891,
        6193245368657,
        6837211034077,
        4568604975469,
        5528983891999,
        8796093022151,
    ],
    43: [
        8796093022237,
        10588747478237,
        14134205823449,
        16559386514569,
        16714359957473,
        15956855211163,
        16686360421007,
        17557644642341,
        11968275616439,
        17592186044399,
    ],
    44: [
        17592186044423,
        19181687382607,
        24540270777601,
        31986597207737,
        24777903627007,
        21340599501707,
        30413655508153,
        30731386278199,
        24046846896991,
        35184372088777,
    ],
    45: [
        35184372088891,
        61292803848713,
        52339141300751,
        48568726974041,
        64831229084249,
        49350872294699,
        60358834410467,
        52932595483297,
        60319950327431,
        70368744177643,
    ],
    46: [
        70368744177679,
        89243657206267,
        112930281630109,
        76741717270571,
        73692034427833,
        96521439425899,
        89694211311413,
        93618218839643,
        78534928904219,
        140737488355213,
    ],
    47: [
        140737488355333,
        222971106159071,
        173941550240383,
        275288450976181,
        269809551120817,
        195011685326321,
        247893560506841,
        176448142777037,
        230358924995959,
        281474976710597,
    ],
    48: [
        281474976710677,
        550499688517589,
        514576055258339,
        450167656205473,
        535564911623543,
        394618348066109,
        443663779696183,
        553124233322987,
        290943772498129,
        562949953421231,
    ],
    49: [
        562949953421381,
        877945160112929,
        613000898742527,
        589235521672123,
        575706679502699,
        625383634777079,
        772680927488227,
        805991574815689,
        705957254479259,
        1125899906842597,
    ],
    50: [
        1125899906842679,
        1955004580432103,
        1292506631670671,
        2241578045602243,
        2003026948529059,
        2214392598229379,
        2102516733134767,
        1262799387116713,
        1159780904746223,
        2251799813685119,
    ],
    51: [
        2251799813685269,
        2339840235191579,
        3632936541624197,
        4102445093922827,
        4009805395437857,
        2685722292804757,
        2769942547561907,
        3625761134312059,
        3792062950917893,
        4503599627370449,
    ],
    52: [
        4503599627370517,
        7899520976748487,
        4706930100729541,
        6087041201203771,
        6612886316085787,
        8184178857725807,
        4910904795317387,
        7756131066022777,
        8561158680425479,
        9007199254740881,
    ],
    53: [
        9007199254740997,
        10839798247493029,
        13580544045046487,
        11340896293327847,
        10962925679072989,
        16245869149514413,
        12555271082871397,
        17491558201198469,
        13963643495664493,
        18014398509481951,
    ],
    54: [
        18014398509482143,
        21774797000354719,
        29574886089307151,
        29251137102248473,
        19681769314784443,
        27751001042176019,
        31972810273166027,
        31373207344236911,
        28209093734459201,
        36028797018963913,
    ],
    55: [
        36028797018963971,
        67099723030673467,
        54856578309863171,
        41198103902262653,
        60651117052835279,
        47228839982602813,
        58707462073792841,
        51282089935574317,
        56303745259461341,
        72057594037927931,
    ],
    56: [
        72057594037928017,
        106436069146865737,
        124859199223474043,
        143951191932784637,
        78840683020037933,
        115135582383234551,
        120712904912454509,
        141872699373627367,
        111041610822427601,
        144115188075855859,
    ],
    57: [
        144115188075855881,
        168126311817194057,
        176270426579569717,
        242365795523899969,
        225222823609835629,
        246092305778644867,
        245304238254863783,
        144455957013415823,
        209768447752589797,
        288230376151711717,
    ],
    58: [
        288230376151711813,
        515994027517381219,
        574091854413883921,
        571552245127138547,
        531584012787024221,
        510430703010778217,
        473720502563967809,
        521143533910985009,
        511215574004623217,
        576460752303423433,
    ],
    59: [
        576460752303423619,
        1019059327903847443,
        829126160918618807,
        992441053805814169,
        1118208159512172361,
        690450657912180461,
        825680374157528587,
        833105016837258709,
        803270072579873653,
        1152921504606846883,
    ],
    60: [
        1152921504606847009,
        1999094964650773159,
        1567145449806725807,
        1379946895548551797,
        1883632551403101839,
        1748803808325160357,
        2108591383429494497,
        1866252643494342661,
        1533460644851530631,
        2305843009213693951,
    ],
    61: [
        2305843009213693967,
        4389031522072778593,
        2626551424503387523,
        3195021135991565549,
        4263583823711992049,
        4524657339456900307,
        2816687563006658161,
        4466349357257312233,
        2317583723227261417,
        4611686018427387847,
    ],
    62: [
        4611686018427388039,
        5936909958010432493,
        8388232597670479583,
        4975741161188208779,
        7635360991994870227,
        6131544126621474409,
        9006016486528109341,
        5401691513406463601,
        6607434570247096513,
        9223372036854775783,
    ],
    63: [
        9223372036854775837,
        15444773685826721057,
        14900743811415075983,
        13102620751590272171,
        11947926220298983669,
        13864294195316278669,
        14426735385515531917,
        11228153666013187793,
        14932042361101972597,
        18446744073709551557,
    ],
    64: [
        18446744073709551629,
        20566147357895621239,
        26762299873007232089,
        26042692882112455463,
        31391895239095787663,
        32930914571457589307,
        22200752478504004681,
        19270860269602029017,
        22332742012157525887,
        36893488147419103183,
    ],
    65: [
        36893488147419103363,
        41910457699868656243,
        71036361035003466887,
        36949780838859465947,
        70995448380948559687,
        56507427809160145877,
        65585125765132337779,
        72153138111658614601,
        43135875721656815497,
        73786976294838206459,
    ],
    66: [
        73786976294838206473,
        85991570090445036287,
        78287497755224502887,
        104180872222175592677,
        121120511002861004147,
        97478869064286246377,
        82210325066696379803,
        124611699416079404261,
        137887808149963024271,
        147573952589676412909,
    ],
    67: [
        147573952589676412931,
        153125643776415667237,
        229612196819724498343,
        264680114616251240657,
        162533588512135692389,
        194253456104078940353,
        170952599148941794073,
        159401009901863989429,
        238536354070424701927,
        295147905179352825833,
    ],
    68: [
        295147905179352825889,
        307745392321805516081,
        362637155367582760853,
        505364073525809350337,
        426685126026136638343,
        465541733420596252337,
        476347347379821876271,
        465005886640787761873,
        322843526365068417767,
        590295810358705651693,
    ],
    69: [
        590295810358705651741,
        1055135553404354326501,
        591901570423008777403,
        708047120584938629581,
        658624443229895088391,
        615273068371653516193,
        767441942270910227963,
        1176479869122803824673,
        1004563067720742429017,
        1180591620717411303389,
    ],
    70: [
        1180591620717411303449,
        1433940713572851341267,
        1644868680608159216713,
        1721956326191583983629,
        1267837766922081528109,
        2254081642598951858767,
        1963516124052186320401,
        1618468870066684357999,
        2229138724291825817461,
        2361183241434822606617,
    ],
    71: [
        2361183241434822606859,
        2882562429047193894143,
        4004052174879509084671,
        3879567047398422718321,
        2431407344835892673269,
        4621346297042969537587,
        2778482048831175228953,
        2983423190809407270569,
        3147240271122533183989,
        4722366482869645213603,
    ],
    72: [
        4722366482869645213711,
        7226523209506089987649,
        6975902850239323720679,
        7867082305294443763061,
        6098697035021110031989,
        7485977384526903257761,
        6167825884462277150747,
        9206569188676335695183,
        7825769182377249043781,
        9444732965739290427323,
    ],
    73: [
        9444732965739290427421,
        11200813806358831207871,
        15575383847613318562241,
        17968970096488760648947,
        15865158302751774680681,
        13446430211620161578371,
        13320280052245697381231,
        9967009867193585843849,
        11577295363851987167089,
        18889465931478580854749,
    ],
    74: [
        18889465931478580854821,
        24279394537563206622551,
        19765528378179063828211,
        22034870756996004868423,
        33828870049627147005871,
        19503547664871698138311,
        29618528077630206060013,
        36727453295983976210491,
        28244287804863042610301,
        37778931862957161709471,
    ],
    75: [
        37778931862957161709601,
        63710471122195260581389,
        61848778788674019645161,
        49414961340897964867177,
        61328207889055481016917,
        39752095799945116827703,
        62982218506141003089001,
        72776594453208520199141,
        57264548530820728944883,
        75557863725914323419121,
    ],
    76: [
        75557863725914323419151,
        79292902445769183358589,
        92043184250038408217533,
        130964386144594132022147,
        135790078949497217323103,
        116275333818790191114779,
        102961017068328420870907,
        123738990255422924869763,
        139737691897305310705313,
        151115727451828646838239,
    ],
    77: [
        151115727451828646838283,
        199190384920272900763919,
        189847205462655124638641,
        223558699915718555255407,
        151894392725380049266919,
        268957400846514980978629,
        214437951962449726291993,
        208951374373808490962519,
        295993884563966450486711,
        302231454903657293676533,
    ],
    78: [
        302231454903657293676551,
        353521374654885847986481,
        457373944085720054092291,
        442154760774946729771763,
        351297882574820343377741,
        485069067008301845343541,
        345176580931579685382821,
        411756421677652394214481,
        535025837271627508660409,
        604462909807314587353021,
    ],
    79: [
        604462909807314587353111,
        1134792206676438049358233,
        1013261657091241201043909,
        835069594638291000903853,
        765561294304969047330101,
        959477636919983592765649,
        1192920552857188093451761,
        836411969616264000370163,
        1152165589788242708197609,
        1208925819614629174706111,
    ],
    80: [
        1208925819614629174706189,
        1284858317157347574691453,
        2186943884324157886108637,
        2321762097275733393675413,
        1553891677416134814660797,
        1583932747905595086016379,
        1395166810243468415853899,
        1836094662792845347610363,
        2322283709662846504945099,
        2417851639229258349412301,
    ],
    81: [
        2417851639229258349412369,
        2982124357910452604021371,
        2879565251164684361183117,
        3040570227362267302954913,
        3671382632330310107444879,
        3205610947859573165639273,
        4178467664528382082743841,
        3036662086695030898154563,
        3394703507678573198176207,
        4835703278458516698824647,
    ],
    82: [
        4835703278458516698824713,
        6067464562141872781400077,
        5913821300538335781338491,
        6610310700451845865711517,
        9507935507570918479771883,
        6397383010596445608165479,
        6359194710733470790719739,
        7447672520784655418678959,
        7075620123379262776797941,
        9671406556917033397649353,
    ],
    83: [
        9671406556917033397649483,
        12510887276021650009219049,
        10832613779469991826623499,
        13520886059392845349462613,
        16232825907344736398392199,
        16933365702139003727273921,
        13239964532429645805877441,
        16049894945430142252895651,
        12192429091891953692480503,
        19342813113834066795298781,
    ],
    84: [
        19342813113834066795298819,
        29618818819215527482426949,
        25408594734485161894331171,
        29838144269215230026336693,
        27745044180112007857424377,
        29403564802293158651667373,
        26725416985699782217331339,
        30960450745664508495166249,
        35091160069015645548699073,
        38685626227668133590597613,
    ],
    85: [
        38685626227668133590597803,
        59716738500133586177907767,
        63121439572027954594106339,
        68841835931964814384075309,
        50367608436910144089249653,
        61397764835982939719612501,
        71945837087527387195820723,
        46179662561498192555078561,
        43052877993979061763765347,
        77371252455336267181195229,
    ],
    86: [
        77371252455336267181195291,
        119345995482947315248236593,
        130375137863549318469381241,
        115785380347345820192978173,
        131014495607373444197858113,
        109872018062951481095029181,
        78350448790100969172118301,
        87194023124090221311560659,
        94278717892385189248902709,
        154742504910672534362390461,
    ],
    87: [
        154742504910672534362390567,
        280396847140451503570852819,
        290784636487191281822587229,
        291717351437213266200562141,
        173603078275235157959464391,
        232758552460098082713322823,
        173258769972902453012623283,
        180728774199105132283973999,
        247852314213455495506840217,
        309485009821345068724780757,
    ],
    88: [
        309485009821345068724781063,
        328744103239079703667590977,
        477240747537317366524002451,
        525965409739128230146341193,
        575360940749580857626700131,
        561923948893440752028212129,
        433186862571559275336945943,
        414889504367192068105683791,
        404337098604218812565055751,
        618970019642690137449562111,
    ],
    89: [
        618970019642690137449562141,
        1009439742254519820489562117,
        748466459952056595929932297,
        846930580793079425681098001,
        1227544156733647779116713981,
        688703353839782649006305321,
        1219425241641645604216579003,
        728893807219692320325097387,
        636031234631143029580663609,
        1237940039285380274899124191,
    ],
    90: [
        1237940039285380274899124357,
        2055767790566632641958439359,
        1949197714456050482641058207,
        2054283576359072650141850537,
        1323233140077999360563599457,
        1618256546155945226767325963,
        2351693790710909863273939619,
        1339914141898494630863061047,
        1601915709065715198184533209,
        2475880078570760549798248403,
    ],
    91: [
        2475880078570760549798248507,
        3963089962626491400546325451,
        3984037342949427046157605319,
        3233304683362462696615303861,
        4719912740264842887191669287,
        3123314834711064136864888241,
        4318297372656102264675486437,
        3199092611505731319172186793,
        3501779746649089045720615391,
        4951760157141521099596496813,
    ],
    92: [
        4951760157141521099596496921,
        7118191818801380286282536521,
        7856454488511699932423354953,
        8233977757558531463101285007,
        5879461794019315149369493753,
        7677904692429499427855526481,
        6278365934502211900902430981,
        5372600107700413649285860861,
        7412780683558049012443638347,
        9903520314283042199192993767,
    ],
    93: [
        9903520314283042199192993897,
        13767624298575116468461139029,
        14666707978147927387126881431,
        16104449036647088360568379841,
        16739016283643875569230758259,
        14501724744900354394383877027,
        13102293285929362228090489369,
        16073427531293460907775954581,
        14263937061427006913176743287,
        19807040628566084398385987581,
    ],
    94: [
        19807040628566084398385987713,
        34899814123051857201638904107,
        29150772324390002720902227181,
        20372400981515825903452669957,
        33807957305568512394732867607,
        27876297402441099905757656051,
        24393076576552332967905709511,
        26799289104010360464971972837,
        29580554164792197916286082031,
        39614081257132168796771975153,
    ],
    95: [
        39614081257132168796771975177,
        47246277685789784474730197267,
        60205636628695399448913058897,
        40454181277423822878407688311,
        59587535142898658936492589869,
        43259655487686040867499270899,
        49097612901907611532580475439,
        71104340243903594815029661129,
        50472989819277160282745458513,
        79228162514264337593543950319,
    ],
    96: [
        79228162514264337593543950397,
        109333931018470921496106020227,
        86474937178582161988650578519,
        141298449941337375725506356877,
        141641105724742308191566689503,
        128898623899963798402170675391,
        127271445959285988090260396849,
        126824805202891401040655973349,
        127124831968874901219767110477,
        158456325028528675187087900531,
    ],
    97: [
        158456325028528675187087900777,
        290153256132232687602113297923,
        297887419417080921394390490279,
        264862498468756177635073453241,
        276338850324847104494165933009,
        256901727860899643541100191259,
        260085912796029101170459557131,
        182871395456489094313830415277,
        213269902378583842103049010283,
        316912650057057350374175801293,
    ],
    98: [
        316912650057057350374175801351,
        424332000777749502818082697517,
        373835595660892229218216848523,
        391966989758940024702142302911,
        329505443645468259754308380051,
        610720172349401338400601490231,
        556829676178423854663640583627,
        555721274933313614181532606937,
        619596334250186405803090814003,
        633825300114114700748351602573,
    ],
    99: [
        633825300114114700748351602943,
        1128841349620806275026585430983,
        1128197158583177780346570714937,
        752590749538768058984836404917,
        761171580592141329712463944873,
        860358938883153197660933373521,
        641188246256199919537719436403,
        748323260853873378796578313519,
        1040422855141554564001488222587,
        1267650600228229401496703205361,
    ],
    100: [
        1267650600228229401496703205653,
        1747605427910277257558761579867,
        1727236328253425974140916650283,
        2488551343683732378047918872927,
        1512186048776285219868607387573,
        2133860623865069087930255236721,
        2081150985985169964792370566637,
        1899517729795030498394342393629,
        1719071755160821313504809859153,
        2535301200456458802993406410683,
    ],
    101: [
        2535301200456458802993406410833,
        3364169022770657908895705549759,
        3393076701895113339634636962277,
        3804299359470831299799204035579,
        4985686414925916787971114061541,
        4975390447708244760646368535681,
        4523964876485578092970697758057,
        3212544477632892132043808861489,
        3023578425789003923960723432951,
        5070602400912917605986812821471,
    ],
    102: [
        5070602400912917605986812821771,
        5515455829413670667969521249609,
        8674758808466236342857349063163,
        7794482445633085112976346042961,
        9747955876369972022122381662269,
        6741979900165460131539018857821,
        9965279471091255406426640356343,
        7621074237533397921985509451291,
        9731448916361449693961605961419,
        10141204801825835211973625642911,
    ],
    103: [
        10141204801825835211973625643089,
        11261903656676972507227341685711,
        12795160831599582807358843733791,
        15332356323264629351074144285703,
        14072491236825867065403760658033,
        13832700743596787205531441866449,
        13684353892129908346867772651911,
        14230491120011897481552569002973,
        14200826557244352566979058116539,
        20282409603651670423947251285999,
    ],
    104: [
        20282409603651670423947251286127,
        23922742530911457057971548265527,
        22569701408928966342115923988357,
        29171769851573006234964435630403,
        27067836256912995174529429595137,
        33010950731422905213381976986409,
        34740799625318515131241101883387,
        28690666437524087997616174726313,
        29335580495930079251823174978443,
        40564819207303340847894502572019,
    ],
    105: [
        40564819207303340847894502572071,
        77734421914110330260330798649503,
        58099091318020911181047971932847,
        68487085819048938836350153419803,
        70662166347648562300631092022033,
        46250831699438707676779774275251,
        44501699513767089966867027570491,
        75496199281774889753123914049323,
        67159293781762463566300241160667,
        81129638414606681695789005143947,
    ],
    106: [
        81129638414606681695789005144163,
        149420992162026344653282405617197,
        118269332898648963184217382408683,
        87030042872386510991309534122747,
        94101835875087534796638031595617,
        105023730867591832707768020188633,
        102791959959372118149565973484899,
        133816627977969349341472250585393,
        106751958900473219166929425281173,
        162259276829213363391578010288127,
    ],
    107: [
        162259276829213363391578010288167,
        227846577137897235430492810646147,
        213804208137461038111478610432569,
        171302579201566646001865838840989,
        193536267478868192983270133613353,
        287375922078123327233795600329169,
        324272726871832799651956893794627,
        316950671371357949790609766691959,
        264951738612735091881776090428919,
        324518553658426726783156020576197,
    ],
    108: [
        324518553658426726783156020576289,
        589747601171433039478997748428419,
        641947911738617893965653098673873,
        335431544959399909204595197975667,
        628641712811936420454643948133869,
        398006585069108834224923615341801,
        559748930664380985354051754473863,
        499949726748333562964385186614591,
        499590401499091372346867758195891,
        649037107316853453566312041152481,
    ],
    109: [
        649037107316853453566312041152659,
        1221845071833122568133787637625549,
        724374244373754845737221913775501,
        947033227572443748068321918470481,
        1209952365061321660849097416287907,
        1037623612988771762322661583110843,
        913087667029569644539330818628219,
        870967419927089147821721890476187,
        1186545784389756865745983503717329,
        1298074214633706907132624082305003,
    ],
    110: [
        1298074214633706907132624082305051,
        1586196340171319154485437686822671,
        2293157484966483694318530356045771,
        2199010498241425562934455219951153,
        2535191442160403953760077640685767,
        1338474158153158125882079647162541,
        2377630180439625419490102365322299,
        2529009481369208667761174270665333,
        2278863000831301792979400651672127,
        2596148429267413814265248164610011,
    ],
    111: [
        2596148429267413814265248164610099,
        4300987213019330388708995645206999,
        3329179944162798520468704875179733,
        3382878291722500291990200646634567,
        4317040656978490345650555379306379,
        5113688067021362981342247431202319,
        4953441325888008894185344545773669,
        3714389110535965772927865021589393,
        2647750804847541241460750878991843,
        5192296858534827628530496329220021,
    ],
    112: [
        5192296858534827628530496329220121,
        8913064732165463834654108198497819,
        9403076292923194371175743352232893,
        5710398787614029183966173016173783,
        9277323489469745969834488060197821,
        9164827022139546719598131347835413,
        5675582894150887083638163195681677,
        8347111436713518480068445038329387,
        6588417579890967155194208105141633,
        10384593717069655257060992658440059,
    ],
    113: [
        10384593717069655257060992658440473,
        20112622815273259439142508388278733,
        12667320392182747666757433300664543,
        17127120444789094040211012834329947,
        14663356879256776516927413616554121,
        12516951235735691323458030593966833,
        16570405777289438639427124764460897,
        11259569199712664757023023748727463,
        19234947976341388526319184100391739,
        20769187434139310514121985316880373,
    ],
    114: [
        20769187434139310514121985316880427,
        40562235335418511651028934306879919,
        37615607832589348223004574931878193,
        29790006795656338188726301152392441,
        36604361146278936090302651611520887,
        40852114933319068908919350305575199,
        22320752671858185666403955338968557,
        28778072952249658744338104105885849,
        22656664260165911331407152223767063,
        41538374868278621028243970633760701,
    ],
    115: [
        41538374868278621028243970633760839,
        76812308752509591647837263593773539,
        80695465469881217926331615857716629,
        60385137632414781775170427068668449,
        61983001978582809132131647209790037,
        76968464948532093225676746262098673,
        66528753980583237333747905696569297,
        78890013944676444543417788488209791,
        63169324265993973857428276653360113,
        83076749736557242056487941267521533,
    ],
    116: [
        83076749736557242056487941267521569,
        110727031792490686165236291283782779,
        114702740448755271161383189608093989,
        154791970167202711912163550689501291,
        99562210778317263309872223689160089,
        156115947125050620488445133512467429,
        112903497978774240734184776713588523,
        155213571457762317992294092934680187,
        118048321905209592128662496850343327,
        166153499473114484112975882535042793,
    ],
    117: [
        166153499473114484112975882535043101,
        280808038606977915738696490360029989,
        328505639092658494079657385951799853,
        327186438304565600919666452752427591,
        170172414064267737813529783458790621,
        196017501575886166671890184338329559,
        167581100480421025168061013635698999,
        307143312679385314029871114637995111,
        289348071477226018193110096038249079,
        332306998946228968225951765070086139,
    ],
    118: [
        332306998946228968225951765070086169,
        638833798713048707926782343515747479,
        537417034431897002203866604524108901,
        349797331324412614635406985892741463,
        364791740671165048543058248389870757,
        586557191769335768261898183339819733,
        579318676993304971695052065304078091,
        417031642899994821671502478741564117,
        386138340491031992541053287526055743,
        664613997892457936451903530140172219,
    ],
    119: [
        664613997892457936451903530140172297,
        823878054923588092679769411922505663,
        1126591703837360629795439661798904211,
        1148232297260681156144378363624500939,
        790782299761034757786277448955820931,
        935753471990275028053777225446237589,
        1009764084926781893673363232164037477,
        903221893483117241754227480030618233,
        1149002700036431616896857356527434469,
        1329227995784915872903807060280344457,
    ],
    120: [
        1329227995784915872903807060280345027,
        1855168937756768902221188642363253109,
        2572891672470156168635828200773800441,
        2571021298784469582118709736166853993,
        2075159165120611520445557088120846061,
        2464767012510772978959174644860579751,
        2597925591653798357365660282166210317,
        1532986209016815931231394125753177297,
        2212765237366709453664657950482686631,
        2658455991569831745807614120560689079,
    ],
    121: [
        2658455991569831745807614120560689193,
        4986949814791944743850267194028011839,
        3538421285360261974129540152669261889,
        4899812496491011335035871361406569483,
        4900004829445685349775581331762581527,
        4027251992240170999257256676756285779,
        4885373843016032982178110886902419123,
        5179808239719258735766513580446878767,
        5292543887983746623619259167789627659,
        5316911983139663491615228241121378301,
    ],
    122: [
        5316911983139663491615228241121378581,
        10342064550786288556337161791594667229,
        6077401418856959652857475848274845809,
        7335410387197809415538965589355610507,
        8614551423685570317386584535504830867,
        9594683159950084084433797147318213207,
        10133456544368165154218112553369951337,
        6057934193572231081349828249511729247,
        5662634199258107679631395814888012993,
        10633823966279326983230456482242756541,
    ],
    123: [
        10633823966279326983230456482242756773,
        20503519695167126772470715863172910807,
        15696763895331385338814439479293747593,
        15188036772818868491214498460972897183,
        19484396790021713052984780805797536471,
        19105236069384024254528964729870125161,
        18269041556021362374254543214006115493,
        12416472586684242196302774942600953719,
        17341412637584400960787474782622490231,
        21267647932558653966460912964485513157,
    ],
    124: [
        21267647932558653966460912964485513283,
        23591714108757133399915801134864774809,
        21751700878795978809208570542539590853,
        40915496346015955653204082715513341133,
        40449763740014471126100844789434788981,
        26978946955308974768858549751997522481,
        30157267697930536492217185198882991929,
        33344895340702715409949930082768337641,
        35818621199628711018709602578469218347,
        42535295865117307932921825928971026423,
    ],
    125: [
        42535295865117307932921825928971026459,
        83809668740505829239673266707849165503,
        70061044498781905395371522419818408581,
        47348425332578367965900139604532479811,
        59002609277278730913716873176053709351,
        51797810069357801900454585240074131223,
        69229308578816663115904524950488521919,
        59094946300339110541792289453243787727,
        58250543626475616629927106458963580833,
        85070591730234615865843651857942052727,
    ],
    126: [
        85070591730234615865843651857942052871,
        117204392106712037057266920445993284863,
        162531449188841708891037725009452060913,
        105877320394079040940787319998403629923,
        137866093105103473783195336586513858641,
        149207394209294994949324579559927175377,
        158518505404669850993438904163851219413,
        124061720627379418752348635842737682979,
        155750906397067743927810782576387809057,
        170141183460469231731687303715884105727,
    ],
    127: [
        170141183460469231731687303715884105757,
        211805524932367681821000289071319651463,
        234370070659398471060881259047045201363,
        182342519415028088055097751048004195811,
        182932179573541113600822054014463745811,
        314191146427124174042196538829354107313,
        234903868274083375127192694164486127701,
        264154415716579339439426024334232057163,
        235457942758419908045471369046609976331,
        340282366920938463463374607431768211297,
    ],
    128: [
        340282366920938463463374607431768211507,
        414900172690044496627047835955845204483,
        422870083432583018765408203043549290319,
        671492070891937774071117531666755976481,
        340784120733551135801392931189207858879,
        423374529250592761381055058617533041707,
        676308929370435094887674127252063318647,
        366080071282361518669998382984152935761,
        676584813886584900474345239156465308319,
        526242855184940269224852324132389757173,
        562779849628509236203790620662961205501,
        549524471914852838125005133341556932083,
        653811644530405980621043466425647069937,
        359833328010099226064125049800641180869,
        429796332996041063629170864723389699999,
        509729250954162783209775558680921382689,
        671962887327296830294383357710211348121,
        575587167576678625018580919290326533793,
        573316335860549074965463291075642546381,
        436845055764555497614455295554210025991,
        564602728982790250308445844126935411823,
        463081887166320291459135492419207996179,
        646706693021697263421185441992519252961,
        559744122733760107282646549564555535347,
        368962604767440865855201755805842872431,
        606351184473789235716352876959309370519,
        510864508244980288925704462024806589177,
        400073565680020744569920306024096380429,
        659758256445339920845764325396123935119,
        358038649045748478813252373202261257339,
        392388333694356587410881753857181792671,
        490523695037713159530215807889933719423,
        558900507369001995710044735425380595649,
        571956655950137928316799510650450048259,
        481172022387640501859305844045588792849,
        388579845250505693717838759442107276871,
        431136118724895174986130135629548249943,
        603506315489935586034571686005104652263,
        387009904063603667392793975992321499173,
        380545305573270743890402262250873587807,
        412371292561289017052367348762315817223,
        565153471957214713125433533092841711187,
        546094892348778915980001972981102903301,
        609576581627777263017783033817046414291,
        651413736561286161258592062908590485973,
        358310789127087403691078079637110996263,
        555173975060856382674471835693242548201,
        402889305335314179211820862868548130109,
        426744961843243430145235865737320223121,
        393137287405117421026400394863715527147,
        641332035994049930891299685386759506853,
        504246181525702735446144321952648360189,
        515707232282372485286947805473923729811,
        519457677992360794681604915255734511977,
        374969937358367912595950912038216073071,
        633399787110616090761255179995770051067,
        395599090776635171490061997383286434283,
        472100726536452940385271234629035712857,
        514151173058476968808179973149664257979,
        480929254407158960159817975856083981851,
        411242459798867274896034264960546205411,
        673912541125023864450367497564037717343,
        636116717256170638896819606617732056361,
        464161899465387613239210565524559558931,
        350422470812663734799492220323099582459,
        649399152628470274319281153316700762787,
        624293188948052989200516188509483709977,
        517818994052011033600273528459374761281,
        425089635251181806496977036971697781197,
        356477608730817092308287500372499440581,
        573868048061992897702738556717549912299,
        404284580081419598215831280344575745031,
        477087547054394377469181496827551257259,
        612242978924056426775793280468048400869,
        526041286071272507062874529784251978023,
        446419508873786452878009395319760787861,
        376863283623568222121114750824100169139,
        432616198144458673932973299501142024213,
        363589243193585008816921437450144610969,
        469081006144278507260636437632139521133,
        388131489523052129497913119914281672747,
        561293623692732958701725800193948088163,
        652103613597140601906684777098382064517,
        462441607947758407589011261527524384903,
        657026649790990972408197658317318507469,
        438216076594579201027899854428874941447,
        598562028413104212268834619675278153241,
        645371979015605016826448309434450837469,
        554370699182579676427138102943243559493,
        345880447097877386027557671516328719353,
        479181568631525357242104150454490209201,
        478494202071105431041430200578879753223,
        560285570712598271091312943144937667263,
        484485201130988504491220217006995459893,
        450426814643835671166806136917485082921,
        357930703779658302245244568842555047453,
        603828299309580705180245569353573115267,
        585909879512343443559813113074105541471,
        407516884355758345630301418906419352863,
        680564733841876926926749214863536422887,
    ],
    129: [
        680564733841876926926749214863536422929,
        797977495444694559342492734088574933597,
        786168561268965204916961989406101601203,
        1342584667030453943161198291399260827917,
        739618837417980559478265858119624473699,
        952603229678638804660067326649326274881,
        1267834137465176489527295306628659387867,
        1251775077128307955110394319414858809621,
        782233702132328474667388562624231597227,
        1361129467683753853853498429727072845819,
    ],
    130: [
        1361129467683753853853498429727072845993,
        1590225099137603991839758170322831151117,
        2568834193127832045683350470613323809711,
        1546332279354515393186862979614227926979,
        2189968649615148749325160664250521724869,
        1981012280812974046663550155767989840357,
        1818860661798858775563303745570723797829,
        1838803315179401882442489886077773468747,
        1457207451996668580631136473736247169399,
        2722258935367507707706996859454145691579,
    ],
    131: [
        2722258935367507707706996859454145691687,
        5286698528814260368912539980251276197383,
        3557406978953574961038985301983343327009,
        4535659839994071252606198882614498352413,
        2914509871030106138825367198520532153263,
        3138760870097262505231994157316371179857,
        3083567858564054412748137697217567297333,
        3391450705223562520250513697869941413239,
        3273498614639655441596238739036668509633,
        5444517870735015415413993718908291382949,
    ],
    132: [
        5444517870735015415413993718908291383363,
        10521464189329721889731720266397986792379,
        10398455106286344127246745758201077511481,
        5511853670579987405928303457902166581059,
        6667951332932335762800298954509983374057,
        7151916619706476948519511740870128225911,
        10542621958160493848894384447665375004317,
        5689500358316533282828926811083760823129,
        7177364482186438855582980454660980463601,
        10889035741470030830827987437816582766493,
    ],
    133: [
        10889035741470030830827987437816582766619,
        20935856131445994582392760519960632435843,
        16986305222268761530270207612012155354241,
        19142016439623460498961287573485505871017,
        21688418325764663235177219489865487031271,
        10984784003609670107618104229688903196493,
        21317917520701834356299855746596142913957,
        19108276063202584767613516751269099946233,
        14569793735999080707842295390183740074439,
        21778071482940061661655974875633165533139,
    ],
    134: [
        21778071482940061661655974875633165533211,
        33420044758364316823705953665966559546809,
        40675601172657930382134186562463308179583,
        39257820693177752507515449593992742832709,
        30333427951023301520181439100567100429283,
        38833060056206061420568482455071476877501,
        31715730740225412875042306554744723486427,
        23799242390573708149679727471033749699969,
        43261916413727755144135951009622677389901,
        43556142965880123323311949751266331066323,
    ],
    135: [
        43556142965880123323311949751266331066401,
        79420512934626112879621800839053200976921,
        72550337278800407707162731069114328982551,
        82137299774616800755569970858104150544981,
        76324700008045437127490354653461641404579,
        73475905238894042240988389144665615577089,
        54021621533983216274200587232779862897201,
        72272397024666452186066118754277998882957,
        49155427815751688246271493171162071710881,
        87112285931760246646623899502532662132623,
    ],
    136: [
        87112285931760246646623899502532662132821,
        143126272051386053155938597887203250422583,
        152088517977740626071138008000419544372323,
        115810718000146199979307107217370877724249,
        100750772539203219852452223388114690779701,
        95192011328980489556416912372429196164583,
        164087209455736363122577948519430126542357,
        92386914540697333684057924134463557880247,
        163597764948186920568451247778082956141773,
        174224571863520493293247799005065324265459,
    ],
    137: [
        174224571863520493293247799005065324265627,
        307812547004143067308598088649855962602999,
        340231981552947197146299279689573637084919,
        234409160300211549051090420143931875565937,
        180275526961568433340588125448592415030707,
        310591225876461875851062649058226266191139,
        331688953705173660575277353412339847999751,
        302270282921252723971571642249536521578279,
        326583255538730860303471854714605012771431,
        348449143727040986586495598010130648530839,
    ],
    138: [
        348449143727040986586495598010130648531031,
        353935947416189908535109573527027952975553,
        412190784779520200126010205843302853901351,
        659772341021525083881739580492706616255261,
        429779903926831888623558876398518719638383,
        361379255891778406336300854423407329064477,
        660348229764801667089723943682241822417211,
        399938615439179620424926849306782749684681,
        505890236760735566460325399898661386685289,
        696898287454081973172991196020261297061701,
    ],
    139: [
        696898287454081973172991196020261297062043,
        1214166517612050565158635229063279722038651,
        812364129584786599898339522066518440138961,
        1018612286971529048429709880285176039650773,
        800522364849442278263801379025446542462507,
        1386231966121214296791670170120064904407619,
        1379414396028350014894312832760982513418747,
        859015090860221333473490929840891026442699,
        1069014616394444603125869264037698646521401,
        1393796574908163946345982392040522594123749,
    ],
    140: [
        1393796574908163946345982392040522594123813,
        2118108629631766369455357403660722488965081,
        2156593418495762810433704176143276944505059,
        1917250173321088008822102249137087659910639,
        2528146451902869175604696628843657394442929,
        1632759542768827550383792430383932248686081,
        1669782315832143409434134911232308147825889,
        1407522468440622256189251533998218458699257,
        2513325952710870409421607427513850341978939,
        2787593149816327892691964784081045188247543,
    ],
    141: [
        2787593149816327892691964784081045188247557,
        4368643528209742399175261078822152670036641,
        3993615471345511313758768232120766319697569,
        4679221410057171194677921599325263770916149,
        4096543937439347795126875266530217521938883,
        3456016747832060369010588849849421856216927,
        5352519482659980413143574542517136444858311,
        3875156258136271492971015851879803529255467,
        5186146147523969358431361602598392033818103,
        5575186299632655785383929568162090376494993,
    ],
    142: [
        5575186299632655785383929568162090376495321,
        7866029386360633673591697373074101704002437,
        7210470016056407915261917230656956582377857,
        8779825965967730147337193675592973199489297,
        9326792719421808366695488937786860474475383,
        7609253851357823360369350322238672024144439,
        5999434814476231919115591954670744909934863,
        5928628818421293587760958586211170080839989,
        10910808684386630833485423563283835334910997,
        11150372599265311570767859136324180752990139,
    ],
    143: [
        11150372599265311570767859136324180752990213,
        11977188536446159971144792683231674861291717,
        17607960115221569485197572389502225269524011,
        21719570445688207158552477320683353677550007,
        16791262377724140146200551155320920637556159,
        17459876793356368644094976630194418365125697,
        20976592158580918516779322598321419009279009,
        13554180810546046132574689008965550031663067,
        18905547139271845990121614223940816785154959,
        22300745198530623141535718272648361505980333,
    ],
    144: [
        22300745198530623141535718272648361505980591,
        23871862150481193249872861062463157337025323,
        31103915727042883768035391718549622663148061,
        32157712232879726530012155776499562885209491,
        29503266093626924436553118526620690465522753,
        30743635952818796514935362819883946243218737,
        35945402874067007600200561868982855923757293,
        24720794363266263682307386473015647000648153,
        27609229731692030141270489953978613844698041,
        44601490397061246283071436545296723011960681,
    ],
    145: [
        44601490397061246283071436545296723011960859,
        64290064042069591688993739193566555145256911,
        56403855081735306734516373086168189919684131,
        79060884037499013535351053724162516860457981,
        81431587051889435162249123288651807335066333,
        48324006897892992461171084753234643354111071,
        61814955494536451245459078515778469933867671,
        87817083019820879354624139761088670397771671,
        86960710092568506347011148532101178174466001,
        89202980794122492566142873090593446023921511,
    ],
    146: [
        89202980794122492566142873090593446023921749,
        158909119525226522410738948218886590249236101,
        94657829604773174946447669946363060819370951,
        94492854579663973442733963152655125979572749,
        142488199224086756596785803063167159423123349,
        109349309860713874265301151787459119824632101,
        128027530324422257398751019990386836660441871,
        118394846045488734386365606980791885601094547,
        141928740787718722689956138941553307585609281,
        178405961588244985132285746181186892047843183,
    ],
    147: [
        178405961588244985132285746181186892047843379,
        201691920955666098072108874844072709272323361,
        255301376638051191904174502670524549963739419,
        224717908378814536894149745878090179459963047,
        272054139979655062626928109322501475694918597,
        300473935115741405633695064844983281064567303,
        249396435714252309086551725028855538919569677,
        342529488845151173705168637901897579008849611,
        283838325294834604610664075071846443770100229,
        356811923176489970264571492362373784095686489,
    ],
    148: [
        356811923176489970264571492362373784095686747,
        501999105762958889162442840770756677326547001,
        381720591673398908256438833985236921976493181,
        448683439747145888419541837137830070061393221,
        665910705828973240979662203371872219630378567,
        368683016738143656818975383298118483887366089,
        509224803909543198116264163952622667664121921,
        440228932743480497656292658893511933839480767,
        477224472974564501939711835328157169881970167,
        713623846352979940529142984724747568191373281,
    ],
    149: [
        713623846352979940529142984724747568191373381,
        1091105912037848035276965351698599187981573983,
        1418046107028809915398730880578724536548644671,
        1035434611615284564079294435740017571809653439,
        1192283333221351759468844924169844461926358929,
        900692498460720753952429062940743198081852941,
        1370660568059833894115691737872040787232629623,
        863808075146207858377356333766857790531795001,
        1393867948154905429849126052860078679906789987,
        1427247692705959881058285969449495136382746621,
    ],
    150: [
        1427247692705959881058285969449495136382746771,
        2346406596328272536429438826538010967684778009,
        2583788475926948696079896563139574267061597403,
        1623896194202602958505756273637804796058602309,
        1753423681115212787205031015639897553525350783,
        2174283778775929889396649467592959648612882767,
        1947251510418880470454281914163078680540444627,
        1980916851271852130232158897954869653511071347,
        1988703247253459718721338039268340554633811489,
        2854495385411919762116571938898990272765493053,
    ],
    151: [
        2854495385411919762116571938898990272765493293,
        4052962042686421810344193765115344996114393661,
        5014062132806039683876213555265243444149715713,
        5575293765236322359772583246027879669656108427,
        4871549259459795529412310063947859345311246993,
        5106230819406305689410856276515378788539533983,
        3337880269021411076341777779944771373718854959,
        4350957641238008320153125454845389143050643981,
        2898349254383415081625438412938442971397654251,
        5708990770823839524233143877797980545530986479,
    ],
    152: [
        5708990770823839524233143877797980545530986749,
        7939789241494497984787293556163480616730432481,
        6187390830073215588083993120403585742114732339,
        7143575193554614434349179620511586646463362539,
        6971191530358368366026142896253328318791518869,
        8979397736109058717587749472482886116071412563,
        5782399388350292193514444559140648172970030221,
        7177073476819540003191340965699422548452178541,
        10836396510465305997716379735683684413541972059,
        11417981541647679048466287755595961091061972923,
    ],
    153: [
        11417981541647679048466287755595961091061973087,
        12724105275832967969603759334398000564453833123,
        17106579593495095010930162410631025179863625987,
        15604721142653756905175934832546162500296623189,
        12275396007201319250988394112598376224834846611,
        11837693749203184940125460707560547383596952973,
        21373966799871324012857170702827034151031433283,
        19147440759308073896447106752649298538111030177,
        19748821405950062878075816720435375032910499767,
        22835963083295358096932575511191922182123945741,
    ],
    154: [
        22835963083295358096932575511191922182123946011,
        23655976817335259606082150782065745402189047171,
        44866904357521554775546369829499829549813944367,
        42347276653129950323053506197948093905366966703,
        36906616878429874636900526777873134612561901917,
        40917934360867780203985580418912343403664139991,
        26637982988879515605935486709175807653957271733,
        38081854729316360785103686351881079146121797679,
        31071623209288447303887298764309323744969407253,
        45671926166590716193865151022383844364247891937,
    ],
    155: [
        45671926166590716193865151022383844364247891983,
        55447562605795818428471794819735507744340256613,
        65204360234178027982756830786937015116923763281,
        86434614155810422395105796624958648287045723891,
        81671607421766732747820969017156399439883085927,
        77488216033466824565119229705335931124339132569,
        90652434442299720174744036484073422105473950033,
        61308582970464320474636528320927877469943345601,
        68364975700914294584661180702543878942507833847,
        91343852333181432387730302044767688728495783793,
    ],
    156: [
        91343852333181432387730302044767688728495783981,
        140967008309461358258096108157777135047132949731,
        172114872520254211244660616348820109390215858499,
        106612181496502078858102025867027856258526152187,
        106581613832443032016599092371053448390618241551,
        182558154201511015472036663041377741715902126731,
        117238615602140872287969032486930270713136241917,
        104098458615559942791439991912709980812476445963,
        111879027901010056129640097221806822379572592521,
        182687704666362864775460604089535377456991567853,
    ],
    157: [
        182687704666362864775460604089535377456991567941,
        278714304114649456152812246676582676723077609199,
        222598226213040642352791314262282251624044893931,
        192505557532247641268315648324415333040679036363,
        247647607135353821450638911305313378257140773481,
        299984997929784531795204984318462932706105752561,
        225476317020870408356645197965397285042914134369,
        198640444561677856194019693782552336980850719213,
        222196836793195190398600553905445658363513605899,
        365375409332725729550921208179070754913983135729,
    ],
    158: [
        365375409332725729550921208179070754913983135841,
        545399080871065801814778592415593705033156797457,
        696700297607881239914290996745692801691947700531,
        377189504564359268358892283904780544936715353099,
        679364285286266410796804477197015870050127003979,
        708216261318708767600560147946818617658352834257,
        607682883105620008862822337844420185495620798693,
        662156099331143835427144612343750616764936411621,
        391283311165743475310293644902211717265659157621,
        730750818665451459101842416358141509827966271397,
    ],
    159: [
        730750818665451459101842416358141509827966271787,
        1298773034750164259634544826803524961629273601337,
        1456549073941197493148742419377711491815258185663,
        1260296313763410917887351775808098593287314417893,
        1039812156021877478922530649558846577613548895047,
        896684956941966435012746828917826520548635143989,
        1339220595387653706113627552208411798875639940013,
        944358309421786422256126935427759877348574314047,
        779098102424412483059061654467910300048773803313,
        1461501637330902918203684832716283019655932542929,
    ],
    160: [
        1461501637330902918203684832716283019655932542983,
        2921141533141175597126559574724817895425320885617,
        2861022417311194330160881800518196180153047254391,
        1610674686769146771484547447203987242022548248263,
        1608237008533474803502742404357995192754021233109,
        1594974929299208122002307339342431291887428863629,
        2541647556070084674087057774521942832605608842049,
        2039380120377775547403492706986799007334487155623,
        1603648910243974042493189480106511356894785589379,
        2923003274661805836407369665432566039311865085793,
    ],
    161: [
        2923003274661805836407369665432566039311865086059,
        2958423527130399203616164080356530937473976935771,
        3572704939703397185125208432302849142987275946267,
        5759455257527786868996335578263253295671459412227,
        3890780296930909919087110316917512143479156642571,
        4797650997072352942666783506534071254653971451743,
        4856331889279169746653433555216443922751293642807,
        4029292147059673439478212331233898466946160080957,
        4993289055662984249217539008448486558318027856839,
        5846006549323611672814739330865132078623730171803,
    ],
    162: [
        5846006549323611672814739330865132078623730171923,
        10433023607360921896231600106680885970980687842931,
        9076583464057602347070724418481753236082307260929,
        10159101709904180156766830963188964125083243779311,
        10221122566320916538822681469913889668347685442627,
        9195184333857738878372357124689222222732652836239,
        8038251424948752675748583650497701030181853251127,
        6769164922284364510684217032678866578013153940847,
        9971562631370422348390212815765833140632819273903,
        11692013098647223345629478661730264157247460343753,
    ],
    163: [
        11692013098647223345629478661730264157247460343829,
        21844990712550636273949578517041838076721080693393,
        13339975280858752506277420120272910365459188315879,
        17185564172859149763403749235048699825950435503129,
        20743248442227110894882908003157473557378227640253,
        22404761415023859015147332485929439908348814531619,
        14549626363539930288602585173406350921680692174207,
        20172440354646751588242324300329948661020454925279,
        18038744772428692915736298717269354915772310259269,
        23384026197294446691258957323460528314494920687553,
    ],
    164: [
        23384026197294446691258957323460528314494920687733,
        24814476104953287972779516959310564621856894825629,
        42699400042730458594291156056964538811283358883641,
        40600019585596451348567031495589037719876988771881,
        30854204678935231392477237575599166319040560666023,
        38188927967938569187983586142019761238748695318631,
        45592018565884501351731888100269469000100239711933,
        25411020357741288438376781611664853163626364813507,
        35501690986888821874426889408883676872456197245921,
        46768052394588893382517914646921056628989841375207,
    ],
    165: [
        46768052394588893382517914646921056628989841375373,
        87335651469103490958975158996910554418594108046391,
        71391669332449501552535888846320963389962646421399,
        53387781464856957231770486618025870001430339050897,
        84672608977592535372436861789351141731433225338853,
        53553428529138070941630256192205446560122699112367,
        51892404965388549814827261595784794072987326325709,
        92305364766736698907916263878012904991010148099493,
        66228982223200115155959103533925190487706128949699,
        93536104789177786765035829293842113257979682750459,
    ],
    166: [
        93536104789177786765035829293842113257979682750549,
        148760778204607855652753377402626679115367097978687,
        180301412908894746587453778593841085084550679284131,
        118823275012075083997006126278621919120859125716701,
        118942123054447040613171852794823772586377424455427,
        96762280833647153814109426821485192913101915231227,
        159991618986823082392038298600817148689075544935507,
        146295089687688818951009219339749121734469308300933,
        122213154193888198715840049798189589178126343069767,
        187072209578355573530071658587684226515959365500793,
    ],
    167: [
        187072209578355573530071658587684226515959365501011,
        242801330931883339138232713072659842918780158432249,
        277961573062832182713954282186551065615365561959533,
        307486466999474446607649395172284634686236357901159,
        370742837269714069499604368187294435665471193123979,
        269634314915290385288836956943699703503835841461539,
        268093829483062837612895761414355929685579007365023,
        190154919475072948300893439902035497852879326289499,
        372973961140343186897352620967871480248030733060609,
        374144419156711147060143317175368453031918731001599,
    ],
    168: [
        374144419156711147060143317175368453031918731001943,
        734585227289965044297182064438552376682032634940713,
        479332990778753971489695924191881150259169902678743,
        610277904831346037770272583905550032793558736806039,
        387493745449240580726278140826593434937802648833341,
        746378348790953720475453951182008436338819947189197,
        732825141362708354935664975732331996097711752781517,
        505898318182078243414230245025305817998159444541097,
        587592792505965756248376945497663635214073995022641,
        748288838313422294120286634350736906063837462003069,
    ],
    169: [
        748288838313422294120286634350736906063837462003859,
        1461730843314672414092712145284868395603832738190587,
        794001456248334010810700430811756134002954083525727,
        769904294156245351753428282721936786730573091732853,
        908228511190475399278501055314792541752252505819533,
        850642271368294710535139796111038468405446405136759,
        1423853474112345382331543283137422512390218843611967,
        1090579479589039914145673715395794084223099369072177,
        899170272141851452939699122372445753000044648495097,
        1496577676626844588240573268701473812127674924007281,
    ],
    170: [
        1496577676626844588240573268701473812127674924007473,
        1923051223055437095087847650505183453797347635024103,
        1818072563088325650799613577672387994046282142891709,
        1831337001505578598456256202716193582874976469258773,
        2887853376946179896298572448096422826914919470921579,
        2876477698230270279477595242040065416080116552027967,
        1722336646133800854487236215858784167207734491665593,
        2162008614709879722264195045429942256727793112066519,
        2175943259106066063047851948351939163439791569600949,
        2993155353253689176481146537402947624255349848014829,
    ],
    171: [
        2993155353253689176481146537402947624255349848014977,
        3123420578219893298874667464124032026105434363748413,
        5902359186027664695564166024321737106285648060144277,
        3986309812297410911250865373854005846447381102706067,
        3924728733141125793118754744047328281223038340372143,
        4259937376280455249843480977816699256987803148340077,
        4251656242862384977802295327499444646161440559077053,
        5344405701841322799269426453061979114868570554637771,
        5129535688847878911449905887786322703914471036879963,
        5986310706507378352962293074805895248510699696029601,
    ],
    172: [
        5986310706507378352962293074805895248510699696029801,
        9390062014060825455099566187346349226192645421120393,
        9210871213663665536127514321464086999353834763252417,
        6733049769176947446653478730292150766074590535926303,
        9163754934765647116356074251915794931902802747271057,
        7957194960708770019528333756062460844846992410145079,
        11877738386064791078736159018520114712961240699745223,
        5999857333799288241452545935151251404762199269847889,
        11354801103256215649288824475959126789101902957419643,
        11972621413014756705924586149611790497021399392059337,
    ],
    173: [
        11972621413014756705924586149611790497021399392059469,
        16576904829829717634353271080636603767425537086672619,
        18809183282710457768833229035215928836517978116904813,
        12798742240936683425024431788295706029978994327750843,
        14888353852102062247830947914997704276950500878141417,
        23566143785988972023807510719137036365055978404274701,
        21909530054003414341147915441861328613157299470667143,
        15288815117935944553397389256013059310334454184604951,
        13314279884517300955442316646898535086117989617350809,
        23945242826029513411849172299223580994042798784118781,
    ],
    174: [
        23945242826029513411849172299223580994042798784118791,
        47288225392845935690155431190355429031987465006252451,
        47431312856663855415509263556754733329118733579046347,
        43691094345593019676137430166523914214967350614637761,
        29536949969739498496971884278422705539290659096101639,
        38677792432965004656551990143702767165058553927548543,
        28018500072740776110855771506278767996931074703511273,
        43866371236414045653501304960805658130687365812759459,
        34794798625126949510887678947108242037234516589159109,
        47890485652059026823698344598447161988085597568237339,
    ],
    175: [
        47890485652059026823698344598447161988085597568237577,
        58121333620041636174030099241116176632241327189636497,
        66969380678250136577526675366005374764656181200488921,
        87368639672225591365354040906962703732749457629096429,
        55844590461276463572066934325666421925375450570336039,
        64617469132641349504869451665616752501710833977446087,
        72014866533232352079065363204224499026494795259110317,
        62694988549727526602032800115477191543424598205793531,
        90493238105222780693144458098701495637067819876150769,
        95780971304118053647396689196894323976171195136474903,
    ],
    176: [
        95780971304118053647396689196894323976171195136475563,
        174376758017772392666405700063642753928062015676982263,
        178690249302664901128653600379838794017554262827738699,
        133991310113530742597018596489982103977299849525932653,
        171714338560422732846063294769128896768548362721107577,
        175334126886400062089020849915413434244027347808448817,
        187740998436305251622193751328596523674646212573522621,
        154528179764454372349387852162887164590924839858820273,
        116559602615238086039741474739807160256092369962801443,
        191561942608236107294793378393788647952342390272949933,
    ],
    177: [
        191561942608236107294793378393788647952342390272950347,
        251680889621337554700501287790524468475889554378221599,
        207150044906891639346369815871839851807937178709979617,
        251746392985614788726605990614257077244974185946689911,
        244391204643507736124983463921566546941239390976829753,
        321734006388481037410235692465372013440674947493682027,
        234008262672814920709368278395489229321679367723437839,
        244001788949323439971922171657822824104407829776951741,
        220625533984466450156092781115818460151677054136597049,
        383123885216472214589586756787577295904684780545900503,
    ],
    178: [
        383123885216472214589586756787577295904684780545900631,
        418425228439134929553609364439371748532524567138079769,
        635861188301027330913359820388548603280569221464194047,
        465804355038044670280578236966511533270007046031419639,
        527878733649368662075408748442563390471825952902649971,
        486900444918578689350496958532514451831367784423856093,
        399539109505286684736535001276112203035898608260631157,
        415963612358664224483914964304287367181684207406296381,
        443852655413144765669809039484426110441165442337077947,
        766247770432944429179173513575154591809369561091801039,
    ],
    179: [
        766247770432944429179173513575154591809369561091801397,
        875699542763977912553837065880770623869133385827370399,
        1244027187872573191463903696015472309512406494278787669,
        987186170274521681515717680836429801505464315390589253,
        972738163755044937451882408746190048391207490957071527,
        887681421058936135146468293955626565152794345615095991,
        992555866319122968376791636787436464304262085666446547,
        1403744159317402251180196918750611311176151994136419751,
        1117573317941728399656499137087952776611771512504556207,
        1532495540865888858358347027150309183618739122183602129,
    ],
    180: [
        1532495540865888858358347027150309183618739122183602191,
        1571717706014316588787457932157769623967472315217963471,
        2358818962652674554321076634417311563442014568554114457,
        2710710597266626833277011925009756925796749641254795463,
        1651632535738201189613993513337364088603502295894264489,
        1600677967397188662387263102042786154396615211367612311,
        2104479855126830782616204581171184091038130763925643763,
        2256986668754557309973248618254991233446298900701722153,
        2881346997997565362354000530780253399842802438497810697,
        3064991081731777716716694054300618367237478244367204187,
    ],
    181: [
        3064991081731777716716694054300618367237478244367204517,
        3640215513197800021520083298265373800741774059688209471,
        4327099365594904606353725663442396147977936380860031043,
        3992171684562684197291642681582199791237690008769318603,
        5341390420612489239815719544077122428218347347284203133,
        5713599995033988097183683558276257203771955421239353781,
        5066731938699102622292980685098119730756078275094728907,
        4539450855809305867437494111161158880270604518634964221,
        3315988156439757081493259071650717178672687632339754667,
        6129982163463555433433388108601236734474956488734408543,
    ],
    182: [
        6129982163463555433433388108601236734474956488734408753,
        6933853573218656549546390302668417923583997427990770819,
        9685693867740863861526241792498534319301339726700424567,
        10155730898270113198953787614216981921279487962729842009,
        10308815521493501793804860713635481650384652700099443133,
        11859125531832985751223768414600573649546937259053973557,
        8581210809295905020769420629562446610547978823655172007,
        10021045740303536920266852406662407398686596945449605463,
        9344458728593344599987081953176293022548224327462059723,
        12259964326927110866866776217202473468949912977468817261,
    ],
    183: [
        12259964326927110866866776217202473468949912977468817623,
        15824985914618047162106009176561734081081628417830122627,
        13575059362273918164998048609801415363490662652730318969,
        20779970156770333452539345322653847388203784176059319007,
        23113810684604850702132097706532257605320533058172580573,
        22554776560711295163259818861814136070399458964428628239,
        15646358520922061337493882460567572452669800952450462763,
        20540016208217089753447814031377155079698357631896148087,
        17622054176747508532567560191788726477414306280109985843,
        24519928653854221733733552434404946937899825954937634783,
    ],
    184: [
        24519928653854221733733552434404946937899825954937634843,
        46747518030624852646852153109406169534967234402495557799,
        31786969572006367922426822531879790124813459474960325789,
        36132451289984769365926512309424489367570289775036217623,
        38295463442433285550411055394571885997254163613333695239,
        30360867838433090665421786603480218737379419169174891063,
        33262795715016300894693535681166640112304753382988278889,
        27975687860589437539714210431140417618556603998493174797,
        46700619246953882662622080137485817195715466113501642777,
        49039857307708443467467104868809893875799651909875269329,
    ],
    185: [
        49039857307708443467467104868809893875799651909875269791,
        74817153343105426294084388828938051212403161059397075937,
        83928164224130891866641330959519731305940865416030200007,
        62823735833067314916920761877893552776671762747856959191,
        80286794466213999455917538798091143071200122204204289979,
        75684440474512870164323685575302808752176092058272303497,
        68598245545824467516549227774143016780825843291966080097,
        94162604954902275650271739099490937761762351587478062823,
        62132075000460049829755708017669809670961508533268008573,
        98079714615416886934934209737619787751599303819750538893,
    ],
    186: [
        98079714615416886934934209737619787751599303819750539469,
        155199318108852279932642085758738710700308326846526756993,
        144320599325885980921280119256151388020006801947979366967,
        149419425229977826459792207220195984007457972448256788689,
        162637443785856115224634563303002474741430078068911440631,
        101646547872941420757022833970409403710135057525489115247,
        99801181934147255099441120784176987725110629038739051033,
        151204829035484551342800632180621989880878720493709402611,
        140753883597934054352604126446107938343811078417948273167,
        196159429230833773869868419475239575503198607639501078443,
    ],
    187: [
        196159429230833773869868419475239575503198607639501078831,
        202175311162555335816404352471817740365157644646528301447,
        289181950991524317583902138370569225243374268182223834899,
        339759844626534701486454834019969108917472249045663895419,
        298469579973492468529183264388181145708124253907423001777,
        224476515323424502918833216226303634345463071033344554461,
        255499243323844026424968597065493233336912472671542143821,
        261833596694692329816822037041614740816410093012126418433,
        347333235699177558563459866159687366751162957504160556987,
        392318858461667547739736838950479151006397215279002156931,
    ],
    188: [
        392318858461667547739736838950479151006397215279002157113,
        517867897939427249611732965062641894853967438719397170879,
        444342276118006555000273283568064387359759732338450158451,
        464033647307740610692659631207626506849635003163696592563,
        510387031098040407283392928062180427179466137160432318757,
        720746947833761915921100832536974774026827585459308826821,
        760273250624196007547650024840050149116209542867447089561,
        709076734813676154067029689520483770791387911024899749261,
        527798332914722887639397031623445213861762942940157481739,
        784637716923335095479473677900958302012794430558004314087,
    ],
    189: [
        784637716923335095479473677900958302012794430558004314147,
        1246283628945369339625024681220378341579119449982972345959,
        1094326016500028353123616787304088354256651069134637586057,
        1345713610864376212562440551062751230856707234578905622063,
        1165780866477352541460970544538472295162186055908724115117,
        969755387955541675976840782719234127998314260090564400267,
        1326325977925750137191059685524066958896658308601632848643,
        1061595861086109190074064976565001702002858543427806478069,
        1259377560349960314874632787775765550375496088767647158803,
        1569275433846670190958947355801916604025588861116008628213,
    ],
    190: [
        1569275433846670190958947355801916604025588861116008628353,
        2985801013821427868290256091219620871168656279049273112499,
        3053408732001113923416401537623786770687009019427991849901,
        2071047273744382070655603053962386775965659633707925181941,
        2812843533076057660521871792548327835097881831754931681397,
        2221412709215620530540641193586729818150327052775387243977,
        2685791160871221861817645485826938775880512404132817896571,
        2948919474813103207496074624871250161881104511202617628087,
        2524490373505589309066132539909510934028890442977822805739,
        3138550867693340381917894711603833208051177722232017256429,
    ],
    191: [
        3138550867693340381917894711603833208051177722232017256453,
        3794324253944536306635521654759516986347057638031589374457,
        4458860803318703957336903401679359595821305281445600915937,
        4607559003621392483435425288459913536667450398194383562187,
        3692303414231513784426467613727124448525211132404712382413,
        5222602312702465732115352766608449261477969598671193986143,
        4814222871624175370612753721273966033507327357642096369463,
        4944674570441055752525539096325533891024782148203942728201,
        5807883347316055687202304941473422327634274148374511311023,
        6277101735386680763835789423207666416102355444464034512659,
    ],
    192: [
        6277101735386680763835789423207666416102355444464034513029,
        9496655422848045606841688904762911175213092479794625331209,
        6281549985594920717200580594489233520684542447811858399003,
        7220682373899313444571090729120267653083358421008611770273,
        11577350651534526577094124998240151739982801582237325895897,
        7313746819552891009151121422323371199552573046704309643539,
        11159059441989714896853980657031027639842352277068943235171,
        12439302328365324542995159001326947122613132065132510405917,
        6875137967605590127970145366803087463409256718296631098297,
        12554203470773361527671578846415332832204710888928069025761,
    ],
    193: [
        12554203470773361527671578846415332832204710888928069025857,
        24376547027961397809127317558599448268643827473318638159431,
        21446492555878184698692288893229351829677865341965701014653,
        16029684870104077594812860078730443881213141088553137802013,
        16329172454410047134044852265899752621058618423978280038549,
        13198320238414962543920106834368678086650751715241803462039,
        23404154187621869136728322626754044926681371887653827278101,
        19183636106048053154752431221228397724039170564946845562867,
        12794780580849388927131517586602386403884195703680568920899,
        25108406941546723055343157692830665664409421777856138051551,
    ],
    194: [
        25108406941546723055343157692830665664409421777856138051611,
        37766504595141917098144990691131107990600384078254640972869,
        40306443501103666959707313838771109497779506742338937233447,
        28218699959768650268680021685734904354168497795522937313263,
        30282465071391094948943991366990358320828813463721182191199,
        35470875360432596301684064870110617579001524314624065904187,
        47763920745388499050233779300414492368928953377367296489319,
        31496456692719022690759078148837970282775636049148878106691,
        43322270430894040203139011716391221682345063448667627130347,
        50216813883093446110686315385661331328818843555712276103033,
    ],
    195: [
        50216813883093446110686315385661331328818843555712276103203,
        67577525201441567607293506205372991380382308600979023486591,
        94007248140790864112749203593151765254050357059007115328443,
        79972368510403195946750586589403717400394577042900613042667,
        60696675308434298503772068008281434555196111236308429259219,
        70608693047647708673483516499137836285822504152304944943441,
        77217531906825197472390935532116115048098429440737722553367,
        97494822901787830637654430530292477876062985137617671234667,
        73690381755225164554594717830813366632149718790648628309603,
        100433627766186892221372630771322662657637687111424552206321,
    ],
    196: [
        100433627766186892221372630771322662657637687111424552206357,
        100577724329064701855388648426613507242181207958090716215643,
        111706951161739128999664120927170352657190086730269931778541,
        170632186639662863037589376834073709474735127070797030202347,
        200521651930158863990143125268855778991437772961971709868041,
        133029162115567416731245046172214402055067845745435282776071,
        143798594615944603319047940166714525139716821605598182088407,
        176770996506898906409132313465665341443099332585880620603993,
        193917645249621292790547808724955330677197831385259344576503,
        200867255532373784442745261542645325315275374222849104412597,
    ],
    197: [
        200867255532373784442745261542645325315275374222849104412779,
        327822652969821500157353892243332022876194046359802807763753,
        387896832408482566198267278773212629247305386680558913000261,
        319005686781202965887026925130399806886563933015085795929323,
        354888872522535569699904665174210109553841315817971372640307,
        284486203405386637911253030432847952478274891636247052730519,
        270154141713664430685499571967140810861557836595615159886143,
        246573799723731914229078264752979314529552028509597775493801,
        225083480050203771194545218480584855888126040015287850579323,
        401734511064747568885490523085290650630550748445698208825327,
    ],
    198: [
        401734511064747568885490523085290650630550748445698208825359,
        539086367414942242826861842558912942943227392715654190368061,
        485277126959559259778513360696071754501755611409581138601301,
        427142094156572113959840228159122725908972760578025104062477,
        566955846258877443897336698320854547578065069164141071831109,
        438189042437123424449276829757886511978565241366051735177699,
        703746615660645632876294097534605473443055580045623251153529,
        582058934050184877100932177478960084140792272617205786206247,
        715449811628432429701393266436951747591394307161027637149323,
        803469022129495137770981046170581301261101496891396417650639,
    ],
    199: [
        803469022129495137770981046170581301261101496891396417650789,
        1444961869203589410553467620809248399204814951450176386017147,
        1056053639770116336672778821289292376729713126145930410116159,
        909874249759673443873947983579343707132910381491610952539763,
        1146860048035057629091525532624111263165538615046936855276193,
        1094616869696426064033717882618275502881877227159215761938041,
        936363443624904969931965767271758952991215400314782375605553,
        1578611017071970884326616132041924791144199507534796605446013,
        1442434768088775942433697312728003294942569349923671317239947,
        1606938044258990275541962092341162602522202993782792835301301,
    ],
    200: [
        1606938044258990275541962092341162602522202993782792835301611,
        2337084923318155098487967174383196881750830204545103875040623,
        1801174383033997283338873653466083890330610195775736817582653,
        2194085366272553904986224043934931366995045166683480106382009,
        2110385132409979828154379234147331097361392142781280529027841,
        1975027045534767580133104179674228238450307251867868217535253,
        2206482857574451773009591016618486756484042187471362001007409,
        2186103171138644841861792946245843717838781606890579722140197,
        2675352309735298661983515195254526001939468836741215438597437,
        3213876088517980551083924184682325205044405987565585670602697,
    ],
    201: [
        3213876088517980551083924184682325205044405987565585670603103,
        3506849019803082441977174344226956282879007646774743784203597,
        3794377589908421860303595357410621150282767389349514639306879,
        6276438471188369735830287896968997020062179663686407411590951,
        6006563360778426309056322361764058249102727301350493240015889,
        3484188003527563991273009866001010986075217660690360561772097,
        4802243715160843202293220591061242343683674514115367790000191,
        4423340859304756900031720201905935427048346434793723094093533,
        5953426782471145875618894996759509627161499117895470310855401,
        6427752177035961102167848369364650410088811975131171341205321,
    ],
    202: [
        6427752177035961102167848369364650410088811975131171341205571,
        9126768134201430915484580059154189024497664137262933166945781,
        10463652316261061389076452555119957003542249505569316468259901,
        10155674253063812964472057683041674342490038642451748698875873,
        9650474919931136693329508266831588905322857548239101284043247,
        8220109847683238338552406983576296231622821051452565125490767,
        7209158403662067233967292794275175474519343378945293063332017,
        9755515378675132941551550937475330193573365531302636615764631,
        7046995078577587600343170539038567806706000858088205121994161,
        12855504354071922204335696738729300820177623950262342682410849,
    ],
    203: [
        12855504354071922204335696738729300820177623950262342682411023,
        22632923302185613027496769081803077872567035775282735910609039,
        19894638587974682549600567606433984739164871436405222498169923,
        17551048890256782345973792047796268914682301282851110670396573,
        20645060918893465969956220146684670284081283850274548567669963,
        18745980188986797009894781186987765199620733990016557359676581,
        14563570380055400917477771880734354043217715831350376248857789,
        24223974118601643595271252650166146179984049880694139809828313,
        20768041951355265189992271542166224266427309502089234297222377,
        25711008708143844408671393477458601640355247900524685364821849,
    ],
    204: [
        25711008708143844408671393477458601640355247900524685364822023,
        44927162393210090543748978624429955969958779563742006941704867,
        32157358116333166497081680984727475724349752491453807018417627,
        46289994666041672286677367389897660399408405211405157392999167,
        30218620062981991231030108153160915032241511811397950378330129,
        34416742520061273825701268583360509291260573715941248563989779,
        32308621140382028587688793070877498789223263040228778183611199,
        40539535580025996268572323374438909724297851873123603724786981,
        42595608476469166407335304320918427263790885263736282573159503,
        51422017416287688817342786954917203280710495801049370729643951,
    ],
    205: [
        51422017416287688817342786954917203280710495801049370729644613,
        70202019761449000370187259042956567446107284153783144930280549,
        83726399226320091965381834426558756589318589226344100756367191,
        52358590655953465430699621437418485133460121445153953977528613,
        53330738568873279663937887691437461540388078910946786874886307,
        67942349672567660861162290109769055464564989023768800906593557,
        66518101569016196181546879649597080520148708962762804354537801,
        64613165020250140116882296254350259465763979974823985149661273,
        65771696093421394648458609106540413750087960217488929236636579,
        102844034832575377634685573909834406561420991602098741459288059,
    ],
    206: [
        102844034832575377634685573909834406561420991602098741459288097,
        174063790151364925356433532574053667521632359670045825207727359,
        117597493597334282884064586256356506504789145773694345682520797,
        125975947005425294180402545145169619041148715905858338563169679,
        133322830079676416758673507185123634013624478274052946859940757,
        197009902222727304041354524069536152065859385237717292052403961,
        203063929865472870471255226452405500442344766553088408148079483,
        131447417965205551964017659942880264044079528287764219779472389,
        116489709744622014751267889282115084889925248178783050132957879,
        205688069665150755269371147819668813122841983204197482918576037,
    ],
    207: [
        205688069665150755269371147819668813122841983204197482918576331,
        383672629808737990195838938698702148159860512831060494935434447,
        226748429236497594264430941149414977066122846427355191757714351,
        321769991511789950968134174588002426131070923787002670590173599,
        241369066929864619180683783068282712587730432852690875864764903,
        254887545238332868357969321129447964136392850178481419633859963,
        256154400847244118931720818098962350738565194863482322248693123,
        231632667793431757065092695224658732193269877024961032261520473,
        382489088663459986464679230349891734627865904971091179499867837,
        411376139330301510538742295639337626245683966408394965837151957,
    ],
    208: [
        411376139330301510538742295639337626245683966408394965837152631,
        800642762724731179969842652170038609907967583824487348287883101,
        573461260650319759872260178125300967508916073565774711519110439,
        471647082417804800231646533869374655479449754431707385039208349,
        572003676951965523349414365226830397978725554705319937024743901,
        565231607001030473567300535712524978783627833748908331144440897,
        611475579965971229941221395914585259045552138425155309755400691,
        687149733340307099688140324507103757085647570869448980476566081,
        644813632813781682549161236183739160957613638304404698118762979,
        822752278660603021077484591278675252491367932816789931674304479,
    ],
    209: [
        822752278660603021077484591278675252491367932816789931674304559,
        1472695466527541028286447011154649840289466898329678002183241199,
        1183264956942764198098646557144777852936209915772155582565577083,
        1004480425005884396452094136973021962872382330001329323054602133,
        1599061347843276870812556903681704741120891267103549333259861711,
        1238423025075139460154804028941443438471918053679039206964407541,
        947263853297744123180057820077391983326154186002084984294376743,
        1427873493402602633731768696301611775583919943419967168043830209,
        1355911026100435080057334769887579062176475023828766504790861427,
        1645504557321206042154969182557350504982735865633579863348608977,
    ],
    210: [
        1645504557321206042154969182557350504982735865633579863348609057,
        3117834802347700648662254181092499982184109863817050736539033381,
        2508861531032118448171210535146026574269847568341022851951566887,
        1742774328104553186576172363377557139291949479756192569179974449,
        2431457702089651530140710666880190641061166703668249830973036751,
        1723853529423825347634747038684740597020443572153651183836497279,
        1940103474959992063112154128095063534780547476676461466856041669,
        2428707753127840418522358523385330142971666488448195308853031023,
        3245883762394848074554495695965492939530280046867770486857704673,
        3291009114642412084309938365114701009965471731267159726697217873,
    ],
    211: [
        3291009114642412084309938365114701009965471731267159726697218119,
        6488122430690474302609817832923856132935828913605801047446757823,
        3478971757696507866753131836099769343349150218262207992404084183,
        5721865691295790152413526984432460931400179963606082547533592139,
        3886342797975943387226958765466748296541782927125284497524313159,
        6059092217919764806987436656428596781815037238134111296552851633,
        3990915121086567940774002200414661645479646953964246556713718853,
        3494059648474502330343046721539330527941625349352446902424770347,
        5386690556840804668631372229118974179178510416870814370015700069,
        6582018229284824168619876730229402019930943462534319453394436073,
    ],
    212: [
        6582018229284824168619876730229402019930943462534319453394436153,
        8331923149566210545125182570325264718138480941886480874419030771,
        6933763850213560665685186513954854905810768484231715485265269319,
        11872821842266330004126761666771546258177127266726792415104254623,
        9643526784366810801317142763401758169162986751873329114151089117,
        9484286483812779494334734972967753776066753938533253567837747819,
        9888633668045632962640364419504195247230229467178387788152233287,
        12221111182719578556350006832531460380522918099941399335278642791,
        11714493660784482136262697279718956559605118965752760262130483521,
        13164036458569648337239753460458804039861886925068638906788872189,
    ],
    213: [
        13164036458569648337239753460458804039861886925068638906788872267,
        13876205477144364322172205618161680536931213859785355851328251789,
        14489749248762609960464505873280172629093180730609513557027751537,
        22849832677197911524870087613501803971813276744037275161455002293,
        22502053205575757472977705516689812783737540695059540320096134969,
        25925489982864768956267027294429527324875030524172612618585138049,
        25429005357332311579398746217163116560333075610458049275191911193,
        14883593335366031753773793170718707640834108513832428602167226807,
        15177580641322311254378820261392903996735607192308373712996046467,
        26328072917139296674479506920917608079723773850137277813577744199,
    ],
    214: [
        26328072917139296674479506920917608079723773850137277813577744391,
        48152312162733328526403903754663966899751710926799614347294896227,
        28852728232276160906149018102278114630646860607378569682031807791,
        31485907918312656394337775905413677647497572299824273901303986997,
        45040408345234877356187814328977248267434907890572718366518810133,
        42851003822456529282344935312753632705768694905686895526290902257,
        26791876181446973187085689761675254284060517170723396579742367041,
        27766032408732574364903209864408902125714344347607202738857072639,
        49002526337663469750772501245113358194229476502027425397850609223,
        52656145834278593348959013841835216159447547700274555627155488611,
    ],
    215: [
        52656145834278593348959013841835216159447547700274555627155489019,
        92947537976305169115819490370064678524975055071070731749565199659,
        84169002817912667213875849521714751239688979349981996273320687299,
        88398104553932622205664956151230723152743478646688336166255820627,
        96611868994316824905573985403821931381127319360513165216998487081,
        61602924308981217730548655856248556542017674606004575834161961993,
        82430515064484051769128228085083557125608620599329317859029153291,
        61590485662362628875982127616905859119957854840315966534003886711,
        85420266132928939408457076327022881310742151654391230176990111093,
        105312291668557186697918027683670432318895095400549111254310977159,
    ],
    216: [
        105312291668557186697918027683670432318895095400549111254310977959,
        201609453533921568186967068364390913647742086099732230106100429639,
        143649412917453117682710410202407551559799865069757654962386629023,
        109735313779911443956598601010492803189102439211317140555827985749,
        146567480540619022715142416881224442883299246062690650562072440867,
        206266505958914338130593852855738788877713327463820009738901284057,
        143392440603310291775292774873173596434944373982355487779800406461,
        163745083827524779169262339738756640547280421547067964134176321819,
        169205453238126254497926081242383085203765682066360313907076789821,
        210624583337114373395836055367340864637790190801098222508621955011,
    ],
    217: [
        210624583337114373395836055367340864637790190801098222508621955201,
        250810710850258312427195667118751646734384078480567627207621245361,
        388056290107958017606540341786750755952483589435377240015139451363,
        411846271778723870738731816559964367420278551974495703298114899071,
        367697864333201551521519103674092031498345063809276738765714962651,
        249857836347465866907761781768354822920177586684326071868321763827,
        353500404650481711897683842327884085508881758815589969022843528741,
        221635265667770007152797340169949454844924933959970244972531748093,
        222442410427641395488039208769440864452178236974381447237643691549,
        421249166674228746791672110734681729275580381602196445017243910111,
    ],
    218: [
        421249166674228746791672110734681729275580381602196445017243910307,
        491891364780262021740717179082252421685306535696233419981712783503,
        748067235315705825702766502743895177454703902955317973009035044833,
        540354084135582770769840915777040426153580056481716216521309070547,
        835358351390911327707727463763700729409348504735279698801006086163,
        791765096936029987709641749338082673170605164373060691897198808811,
        566600424407661770688307250846496975911449405163183613253636826069,
        424668124824130663561417394413067832255739742591343811249688236529,
        796441435821859186546460867908929618578507325738272409717440214463,
        842498333348457493583344221469363458551160763204392890034487820167,
    ],
    219: [
        842498333348457493583344221469363458551160763204392890034487820473,
        1600366378972501267928802219940130950106972023345662800926790060369,
        1561142362349795003725828522028579931084280879866471525329706882713,
        1683792746301937159957258611650493849106218196928791985488743898787,
        942981956240742421850307783363506723406605462655656329641992060627,
        1593991031425097697551789674135000075247849462029344567481755145823,
        1057554832891860984418222397269585837197980575038910889405186038133,
        1608569215653870280105307995620226461813088191364944409756562033107,
        863598953515549383179181034020697961287576389484705159298468000953,
        1684996666696914987166688442938726917102321526408785780068975640499,
    ],
    220: [
        1684996666696914987166688442938726917102321526408785780068975640793,
        2218959886830228330937053395198881367653431321535009486015588919159,
        2020798103328164989992394794063479078098755295114681994187023179363,
        1913146423157219821336722316979560848785100766055568597100304469899,
        2703960802512199077375437069855056307319231589686559435212490541809,
        3330417985401472749792239492706986725201549866831609558492054398609,
        2708578641563232575714855955111270184157302263618659292689257698859,
        2531017081973456439565027343539481524737739073085101023082623558547,
        2524877510957220619723516386573825790931549080761658127380152128897,
        3369993333393829974333376885877453834204643052817571560137951281149,
    ],
    221: [
        3369993333393829974333376885877453834204643052817571560137951281233,
        5395064988528356227918972641791893083025699072295253998057373822197,
        4469278953444231018424210906143162135159828766348612421008024183189,
        5902457320048513229585146346824167458707632443782819727728856824031,
        3432322814398142314800971130150667526551232049323085304016474817977,
        4203801930606209841320352657496593931218005427003942928769956103411,
        6554261952429637345084646238889734519731566371673063715689913952361,
        5899022212827830912521488736353985391983083483265936025221224686063,
        4182260951959771511651000389950515087574099662008363114540111955533,
        6739986666787659948666753771754907668409286105635143120275902562187,
    ],
    222: [
        6739986666787659948666753771754907668409286105635143120275902562353,
        11009531189495460576068881535305831818864543157348479129972157915099,
        8118349026699728162503785930993768560804883260872037555325105797357,
        7108055180748426300623729528205445199442209935541871422971288008431,
        11380582515997061437482069827061645192857561583366177650595082014059,
        8912858859719740740457725878000703408863099663838974128098723478063,
        11897122211620058929020191221047591468085775508448818817583922472859,
        7919236071343893210196725869872815169813510785627452344791799470959,
        7959985351278668838189433581358414187689705797846333982033774948033,
        13479973333575319897333507543509815336818572211270286240551805124373,
    ],
    223: [
        13479973333575319897333507543509815336818572211270286240551805124797,
        26525294772163604325915470216839300843090699336904039832689245673731,
        23572535687371545076321459196960867806338936467935272068711005471093,
        17069726015838865658044729249774286738365608724200132640040573537293,
        16520737593813146578271062779716143963356040023157887295941629447333,
        23423431939713811166221150225373946490029166004413844858905913446451,
        14719432878078123232175774301482734662394790688563521589360097497839,
        14240771568055903630450707175120115367711386206491279386945155609903,
        16090992993287713994234347106967828861410048300780265931804062045019,
        26959946667150639794667015087019630673637144422540572481103610249153,
    ],
    224: [
        26959946667150639794667015087019630673637144422540572481103610249951,
        32034339431412790525035456718688887651515786560139162967492246372201,
        38669745791552318326834132427326582519347957137797005956622021515939,
        51582058119842620138342942143907780626162986603856440005383514207207,
        30575210518123986067528648212794790410563433818698629915966335212193,
        50932131592254525585435273451077895477232414309517455858337412696489,
        35600455823070931845569096563415239361141107121269752115795551606769,
        44806221629110969883989399094066218366802521649294280704812864349009,
        47465499915928676513882930771636708999421700490021184955405579812497,
        53919893334301279589334030174039261347274288845081144962207220498383,
    ],
    225: [
        53919893334301279589334030174039261347274288845081144962207220498551,
        74531544875537952625583100796509632880479926993256360124863027953231,
        91176676509479832132820897151814956543997554310796714584545274259283,
        104828621267427779148455786722737507906066458645861133786309622224473,
        81643452591851761657247651041600602938370961569906176251045901316221,
        86587080097511455570607888527159974676881650237628730482129213275593,
        104421333574016443553832484322159164995378072798745999802630450673497,
        71785244060240505329305133333960359428293405625730454656086252737021,
        65381267210299546136870050991054902889537203782816013050219485416673,
        107839786668602559178668060348078522694548577690162289924414440996859,
    ],
    226: [
        107839786668602559178668060348078522694548577690162289924414440997599,
        153733338258963400281595074406134172079697024433319901040239469245433,
        170631829284165645550984084656209174978871967017147822288390405975823,
        161858351245059824062755312146986838510549124684226901141834847120751,
        108519633652079061150939375494375109070814467571702960619426970384981,
        117011337732413307293659695182333469468565267015210298342186867378303,
        204802620598891545074390609824897538826685120219729099897450711395373,
        135534488800162308181740326743514070483356242877166895291111519340051,
        137649037478204265644116452430301698433713313551140217254663930841847,
        215679573337205118357336120696157045389097155380324579848828881993323,
    ],
    227: [
        215679573337205118357336120696157045389097155380324579848828881994211,
        346167954921222764093822186541180457565804625794852460866348240080507,
        304750684301020821922239504437291671929535538508234072056083710520313,
        365569819584176867134251011543825831961451208466558328340640541621349,
        355852308133463764772625057323375724200213324169319185853965196131349,
        246884568063502275748650036102432473469768404568424103698200653155057,
        317763046305893068543161121265537730053425399338929101381989523764983,
        334357957804753691619708248300382174748067174062221954903375861936809,
        281774753439459697235644743429708182687984523971107078832371422664919,
        431359146674410236714672241392314090778194310760649159697657763987363,
    ],
    228: [
        431359146674410236714672241392314090778194310760649159697657763987459,
        678751847078574067458837471457069821051729866852722490799384417358013,
        790158985467302695805285813329942617147626723279911735993367763418469,
        832291255495809035663973921091785847129467168405320063441519782887661,
        766398884015681461735302380631283126441153942423311344972456073156031,
        640558036438103177572207143899855398370276770666372279639031665707469,
        606830086204598946888934909587639614997160187860794358285278283736497,
        555962108887806368018988270910288949665950336259309118705289233700053,
        492907908084927024502210445809679314271963101480101541254073667076071,
        862718293348820473429344482784628181556388621521298319395315527974821,
    ],
    229: [
        862718293348820473429344482784628181556388621521298319395315527975161,
        1497089293851763312811327355216837472958549874827338241364351103804703,
        1642161406141717026066067364104010998893508350906353624087846192633141,
        999041581812446975619813362389637252484170886774148716443046344212583,
        883395162682723753884511247451141080443928105466084430637868120753433,
        1498490614750500081040574272733054797577325904693194403114375328538271,
        1495177163103391107170193202628569025960667798024159493889769609191683,
        1656826607242413408865618575878103220295432008747743859441441682572123,
        1653924411485904651170766133789330983911183092939799291735270547697963,
        1725436586697640946858688965569256363112777243042596638790631055949797,
    ],
    230: [
        1725436586697640946858688965569256363112777243042596638790631055949891,
        3357641572933027261086875285991053973855728514054569930435471798339623,
        2002480723675228463404811672811657144381581574994497072229978079598373,
        1976537813969464733167448629673789654472830926171876673151244672035457,
        3119828819860656588924503374951944716473154477691373866845161582453847,
        3370461510789062098807851140638672016207039760954975377155274344859849,
        3307534712975321351240220713279344781873032634846739796634357444989889,
        3135258496862301860842337929807342046348809971677641736766050279951933,
        2347041195734022444904502527598886243708821754714541268736564209859223,
        3450873173395281893717377931138512726225554486085193277581262111899483,
    ],
    231: [
        3450873173395281893717377931138512726225554486085193277581262111899753,
        4991102602357833215488592070270466840726736670759291917206886504796323,
        6507186500913403625282326189295746118974597275243721008222766403586337,
        3509385022707395536765304429922303819431410311442971913065776961598117,
        5135802580296917599951862561350755586188570082500211138719828200917831,
        4782436821540552446832216709665024310514858997449376591657051715478819,
        5385445107652325487583696256713360850398329863402626112465634426169493,
        3703163824970095865188773635200164621685483356445973012359764120143533,
        5888200219755773850467015128700741083945216816397083926401561862687709,
        6901746346790563787434755862277025452451108972170386555162524223798729,
    ],
    232: [
        6901746346790563787434755862277025452451108972170386555162524223799653,
        8028500361159736851580208536752418741528479035733566680132655333807603,
        7977141989195618451245335305865684083230861548042164415222443255061837,
        13533584580654418549487242680140660979787293377269043388910486015387771,
        9280802718034391194291368400711525597554173150782130109404988842645071,
        10896486990668146441079980299382315402607695207769658835747021755990901,
        7346415980747376115948726868604806964895041928982808051560595221296897,
        12467671696107148630868436701427525821054569961523411360183151945807459,
        11588673119162366847408547773413498700557431525918559517561461099250421,
        13803492693581127574869511724554050904902217944340773110325048447598589,
    ],
    233: [
        13803492693581127574869511724554050904902217944340773110325048447599023,
        18527354549018703496887149097935637838975308706630589098179161083705513,
        26054927203295352126483575968353642031253605122313392440326645957145729,
        26188726902065613384411245976885605382330613334431083687920852067881873,
        25891224285649422103102750244276993119621948986639950654522713554869713,
        27238956848418868235694137884490106100878894476605375143675814053211591,
        26066114471473172891375030345071710231809144346122582962239344745741571,
        26667247925405300512563012178683911120815266481171708938242256835497367,
        20241476835962246020619519119820785441872912380402025394201042272548369,
        27606985387162255149739023449108101809804435888681546220650096895197101,
    ],
    234: [
        27606985387162255149739023449108101809804435888681546220650096895197227,
        53646307352733702271142704156581838790090708905626986728956325789633783,
        31151658437453565178428495098811613068920128547788392007012465818801943,
        49981179426989235630426642821895070854941767419387088991974946516047939,
        44995753997714345551869772273699106431199823022066452586110266586699899,
        43699420466256839859594322011148225993834957334335543586847855252061571,
        47261269241409447564961697231224061846006338156391740248210704066223581,
        41596170238748241742662517709843559877421010156617007383556701268963569,
        37138894316913043918651833222259229785802489452226119282410356099332543,
        55213970774324510299478046898216203619608871777363092441300193790394353,
    ],
    235: [
        55213970774324510299478046898216203619608871777363092441300193790394449,
        90650902452795174507282199490744102823888125666093445584973210055351517,
        72767830777863716394118352929869680652626268113030082815159280792338551,
        55796549770298963029744596825176576730652445003485618633258937942836849,
        99217149180587800025706519207920813746553080614306169425026892352925141,
        96159900075320161299413536273444652889396309614968417177560493188829631,
        74761707484361489187448609424436842940608460034877200951277999790833591,
        59077121415985583528007611107535614284520595933470136338561850808584917,
        81824439759601773740096141355794196782618915430611158946487805684606423,
        110427941548649020598956093796432407239217743554726184882600387580788527,
    ],
    236: [
        110427941548649020598956093796432407239217743554726184882600387580788761,
        190785144198618196309397083332579472818207697900653688403549704142193149,
        170257106798369436172151188858632514876871271679566336503788780927635913,
        148729982298638281860452507681409599070892431706643256389535631480881157,
        163277430377893040381513816315406845508320696303686688816899965468958123,
        150819380255234817806262238966047095851469762302188931491252933617191343,
        185515053928180591984125639074645799436588458151309411160266772807531849,
        130314815353638343154185798983811934397293949623700148261319976896043773,
        144535697320032168936302930083042689224539361712041095684213418881683437,
        220855883097298041197912187592864814478435487109452369765200775161577291,
    ],
    237: [
        220855883097298041197912187592864814478435487109452369765200775161577721,
        260219261279631174022366003863337822980814737906640361380211334819896243,
        390572727835677836971961849674162791011892576983396726864463027616142119,
        291685032075881258510717682809331355597174372914248013253827001402917773,
        337363929366639098471381346317950081731956420227778382687071574013711487,
        391887473056002474912613231709680853542298889451783962748055162890409089,
        227252842273944444773353191184466656394120269088955467966188536860914553,
        310261938696059835745387784977715601434339380306990319461841802087650323,
        388647770188064822392338070884576443441503837738438330340125205970679067,
        441711766194596082395824375185729628956870974218904739530401550323154783,
    ],
    238: [
        441711766194596082395824375185729628956870974218904739530401550323155011,
        584004510149034809882831605696380382356901628224165789066925766674429593,
        641340607773247672581022037671062639468930996263244878117121270268820663,
        570372264841213713662952805990091693247328567514632859933237138313621643,
        621605226856899442475027891533645619551811927704822989134632800629732543,
        839363862624282103253134055865017436700412933674413218478240552484153433,
        816352780969170082691759635839044833217013789982097084446999562143817263,
        592581015519403881732333497053024973128970856752869179676466835860608717,
        858740687321023577907117815493213257979863561076150063599701013259357203,
        883423532389192164791648750371459257913741948437809479060803100646309801,
    ],
    239: [
        883423532389192164791648750371459257913741948437809479060803100646309917,
        1295327534128603366147297829331631737418427856068965829392783564445380259,
        1291526698381579985214543297391245168977182866163345256045904536851648133,
        1270338613598423172319888932025589164378322754882298509131396065779701677,
        1321747204420144071175183505640000593943529929286564313386959855406405511,
        1336873648705840476581616397140105435562778091676824289932421292821629731,
        917489286863397333972969291061691954345877501112656500881009433340693011,
        1598386725455205444549364770715630507981588167268661364735696378405057593,
        1486785194698164127209602794305793430765511025432086502201197975581342183,
        1766847064778384329583297500742918515827483896875618958121606201292619309,
    ],
    240: [
        1766847064778384329583297500742918515827483896875618958121606201292619891,
        2953473731377322806116494481661651696523504376425386214419351902973530137,
        2461554923456029062443923382704541330192203638635560474212654601752944959,
        2041647382991969875001776794009339074504096203824010009372726291570086053,
        1767079418636853644861462523085874251498891600250925675272494813815210409,
        3297480374562134771354982002027485368725311203289099037821275229700280317,
        2217426774954688336132391889636752943976564142044301082399562985433404081,
        1866214887732150583863924177165617669864711067318680461646607725004896387,
        2931775578952827662175531385264159056662092433137263547348399250700687103,
        3533694129556768659166595001485837031654967793751237916243212402585239513,
    ],
    241: [
        3533694129556768659166595001485837031654967793751237916243212402585239813,
        3900349030821093794866686569034125399313213989062449265379683355557052047,
        5113400962428343482249680480321019978007411538609089779422187688009664747,
        4410885882954886472057031452862490988162074283999128517384185628545030351,
        5634982118634684504911636819984064214178756259913667693613534358518780061,
        4776122404158461729106025620395135142602641906419637075427589406772176279,
        5801550203752828865651984554103288655859387952628698871032343874421987941,
        4573845342832221801467658984491388034979481753463640036867420139671821903,
        5471578467132107422699393672618759455712176217083969306555983962560552463,
        7067388259113537318333190002971674063309935587502475832486424805170479041,
    ],
    242: [
        7067388259113537318333190002971674063309935587502475832486424805170479173,
        12409504051279018528563430874482805777893075003951404471968886016235575357,
        11455407612688110506177782013352829573091821011022369091504754843424019141,
        10913323756099759799841942879037241194922216254683156538189361323420770583,
        7884738311606742694574701980179214362049160770204107115135531441780848459,
        11935412240882788733957816508415626878851820160481278906016296708865587383,
        11651270184124225597804294551389776363770610227516629875028811862288555231,
        11514466094272382789444962980028375579993148430897309104756154719439924673,
        9303891208100190109029014110870060418122795116379022190214094564784670627,
        14134776518227074636666380005943348126619871175004951664972849610340958199,
    ],
    243: [
        14134776518227074636666380005943348126619871175004951664972849610340958267,
        19959756895004361507891914754433141169126641056989738463792950612253464623,
        22462311533620625307322652512573894127152428542929672618692645216609488417,
        21385693316869758441161003243042922527816595299756837274431351320722618337,
        20157107654834036529260893643838326821252312480932777960319776637520556167,
        28027303602761456648528552137003034090283305683815935188463927329765768243,
        27887518604117156205128224239311722328213901575504206881873174412665855923,
        21485029119303468059819362655547716231723594343020784759135620668648637521,
        20666501082173441150805368153294387802210547531101566218616323442023837381,
        28269553036454149273332760011886696253239742350009903329945699220681916227,
    ],
    244: [
        28269553036454149273332760011886696253239742350009903329945699220681916549,
        52781246837885082534347153438464347821543044284401743454468208556797959671,
        34496615305854840981128563197221688791862706596045206487009389171199500167,
        40258216194889896790938160325297324806138355852412933049222130339202429383,
        43073020835670572097848037652703654858779465004419426927958602489836499187,
        39437449212543926242174073527354431574465809329847809400117163793404742479,
        54502925537231348250301207097208627981855342764901513128926644147909605843,
        31779606162864212415608388251036291635477957574355914619154247914810602529,
        32884475910808158889490609226249947647857587634053363716735378405048653911,
        56539106072908298546665520023773392506479484700019806659891398441363832669,
    ],
    245: [
        56539106072908298546665520023773392506479484700019806659891398441363833147,
        62067486289600831137177860860540168497323311731799330799038400972242222823,
        69292119693897160397379747948568891516948291628119969912311743662454427151,
        72718464003676961711560632632297644744738774171155578357353644994738322713,
        70378078716753279700202237497345051047251666616198429645930486748322737361,
        94338797477108619274075510555307884801354844807027432101744847154542226103,
        82158803933439751979815069750999105215274027379807333328221102282541355729,
        99469356952073197625564088853327136258082412325372605964645579306973216347,
        81838178486540102346853784161366144895608456228245736034708873734042475123,
        113078212145816597093331040047546785012958969400039613319782796882727665557,
    ],
    246: [
        113078212145816597093331040047546785012958969400039613319782796882727666001,
        153769906576280309929372529663346985945522450083292862957157469176208516313,
        177003414659146464753066757190765538711433705135484075328908089672257552653,
        142357536753419639093932920377362951664022863812765282799613522800299810241,
        131469078391846494662088075424605160062219037659172447707774947995068464113,
        212275676377757595053730374468624934363443946927141199882717862542138140373,
        200341468162027213326473420923317491917809151477338386631530292359818120943,
        205844948967423366170416266290960335766838212514113826760763144243433525797,
        189144850036155559317525631352350628326474794121107864845366357721521697937,
        226156424291633194186662080095093570025917938800079226639565593765455331247,
    ],
    247: [
        226156424291633194186662080095093570025917938800079226639565593765455331391,
        423362563902791113807527259551614413239701514616116049503353175113057596087,
        284172682338216013601384693444103694007658737458542069482831431264037742053,
        437270640796475021853827098348346573168035605621466843899130549409172762913,
        239761650215183137849715039104684757214364608094174174745959031514618995471,
        413544949637172795436634299127837873582551859571722494703709596451223661911,
        407281696599207738480923154226393543375870673657253465552064845709618206571,
        351609481582395725172611843969973545948017192752690376878751890244927538921,
        267800232838878448646384917413060986718954809660934700952527047811583815931,
        452312848583266388373324160190187140051835877600158453279131187530910662419,
    ],
    248: [
        452312848583266388373324160190187140051835877600158453279131187530910662737,
        672550558084687561808779710131738632314275824563530837202983660858083080371,
        497449356420176779434267712466474257519099748454263502750740111922483246409,
        502030820648717576617367612808501402511866122539106190795775436884188294659,
        554297082509962951511492339906878958187796228615548034648578297309925730089,
        840929013786509590559211712511197360862716737095095228144123795142683673209,
        462767566335990671892202521894150589839389428119912799670486912659481579779,
        572070165006139191532575652866344841250942975817061570521320152416345301343,
        524693871921178482777787634439121261326449309305519798019798379227158262269,
        904625697166532776746648320380374280103671755200316906558262375061821325237,
    ],
    249: [
        904625697166532776746648320380374280103671755200316906558262375061821325431,
        1650117679616907402054762538172370505693811067077539444830621553142457164449,
        1594090450976787707491677598632062746064308258172906939508316995225682912217,
        1648854386876973495952051647742650231908757433508036004511331686897360701367,
        1461077821177229901281401389857641457424203062040155758532161075278394646957,
        1540347670843794204994926457354513179143444168904446871339349703710981830899,
        1496303738608304483683723767529632924380338636129424941795814082274017045859,
        954580450977199321714173809168202806605200111144032207113974850542539169139,
        1454243247843605602655893404281212917244745905635449116435499708713022606807,
        1809251394333065553493296640760748560207343510400633813116524750123642650417,
    ],
    250: [
        1809251394333065553493296640760748560207343510400633813116524750123642650649,
        2558801388375803920920546081808619834141721560213956060306685519579490287173,
        2267116140982280539857968395359774987454679375251667167098615411957254165131,
        2664249585046850309271884239507233172825493751828804599401374869353163192813,
        3562659684373581868182307086794322599207531087086800838041633891561366955909,
        2769859034180409189539665532909802490502554275239545345440193080732157882709,
        2878416947550124960860451976697979920613962400642940256919258048499880582293,
        2274445350696972389795265986482403941991700402550737326071752004745011915229,
        3358703117523215837970185501602833811784584336565416383580165856211341939389,
        3618502788666131106986593281521497120414687020801267626233049500247285301239,
    ],
    251: [
        3618502788666131106986593281521497120414687020801267626233049500247285301313,
        6179688257974674876893537866715705018981645502830740348939859273748049521761,
        4424337187862339206495702129149754217243452939427813444417831012576205418567,
        3878205902103502399960912896892217300389063220167162360241670106528564878677,
        6038957682981624850527524448561026693049714654860458468249068715182459674053,
        5573022620992324201592096718142800292914363782256980334547321148725087180039,
        6837701942333507256625241534634645886563432781143029393860826653650813355621,
        6188035669302372954621168398161549894896605924572073111800803457846338344329,
        6421843166967286701285104992788995044943723629831511462069702345793521400821,
        7237005577332262213973186563042994240829374041602535252466099000494570602367,
    ],
    252: [
        7237005577332262213973186563042994240829374041602535252466099000494570602917,
        10259402302738730096307514750570873940417039447078284579584690125037267404111,
        11460290312412145703859854135157815637080661523141541656871811697187509278427,
        10283651449047404257141224440549648389758718832317037289514499186627360449433,
        8244456616594280944911999409707716839327415657795699426721670837787933256719,
        13413761682867443306380890548175611663529478553610340459352954060530703829937,
        13575685310173895783769735629562638020940781473149362968631730432622174247197,
        11138244147392927133321145056918473942426687525245163996450639075271757994309,
        7662682714215237812874352395051883724591963058315749336380951184207471153897,
        14474011154664524427946373126085988481658748083205070504932198000989141204719,
    ],
    253: [
        14474011154664524427946373126085988481658748083205070504932198000989141205031,
        19270021860742079592283799055133146166603242486138915754498319011198265829703,
        25160977663427649563969515979962025861650180026544537737540839757539190051887,
        20605370793950681032923797830643005989081919532549860057090390949280323282483,
        18966454724047247015434076152677764132086550501548250012807848039249417743989,
        23360002624514371267286396869705080803346967124006725372820568723167702541563,
        15085656147270488399938721438756746559831894719711846118442453962887198253747,
        16889053889367902415196941550518935621350586608659984247988580003055755032659,
        22165089477293494867115177959433224819278215459433663046008785475465222874817,
        28948022309329048855892746252171976963317496166410141009864396001978282409739,
    ],
    254: [
        28948022309329048855892746252171976963317496166410141009864396001978282410063,
        36314388535451454024231392537639502202326838233370421022566071322030186204297,
        46504650422318305122306170209665044001941452516760991989113722847153372133083,
        50648325020295935430298655954250247438991067044892141052130870270651868905857,
        44887967634374647012923740366923883193516094201975164719360045081178548358503,
        47513177994871022343646149586405278709560539881069686855591634717231747695697,
        42049409277665532391914781426239566868239352989474111285588790596418880898743,
        32783818012407326737372077904862658348622528786053776276838639623259535342493,
        56412863394877101318392711282159359878747787751556123967236303641562682476137,
        57896044618658097711785492504343953926634992332820282019728792003956564819949,
    ],
    255: [
        57896044618658097711785492504343953926634992332820282019728792003956564820063,
        108192776941495984197442366117162936596173087618522551838679816352425206642369,
        106444460999036018475338312038305707947073894854565265419299784221729414404029,
        65078621220733938271596446145351120075480823676866941493237477254686221795369,
        112271484438950839254527794425891253613169057112553533180253933794642384478407,
        85310446450950258901834993603488382080496932139895447550092152329032035387663,
        99071426112148403858401415242493680556893062983740118725494267060602896096579,
        66563939792155709829339375888567891934393026976832615977935708677037698890967,
        113305800245166016065929063781354124170533229481310597701392371695068044863907,
        115792089237316195423570985008687907853269984665640564039457584007913129639747,
    ],
    256: [
        115792089237316195423570985008687907853269984665640564039457584007913129640233,
        130382546584045903098770838824784802418415280442403435266444904256376372315701,
        173870414112597910391158346362624164277747451820005231952229768227853122918817,
        130156127194607769761299877203514424496780597886779484543852113627301751425401,
        182135917484067272204453509994741370756073230133721364399229581028379119729259,
        140125507503353332091127683299510619097034001548234057561114747202168635245083,
        184977484094105897424843781231024554864704276956206757984870081595435366511569,
        182344360597565877870922396214326279552984122744735508371951290232835882401391,
        168376725025965136460591256928058371674316372391328596558271275662000504276367,
        152107690741344238209118472792848271467785174908324613535064510840993294814823,
        216556221024918993443938799515950661313902915024104719619548591173993434105433,
        179692531720814815960945851986196907159621727758269444311542979171356542355201,
        146367186681091895424460177453780513758016351907911159562427848728217315720933,
        124505635238981208428028088578847666169476562717426056438433915777955428725703,
        226441804627626478915987606313312369696607947088924590853420695393496297658163,
        184931200117097320207262718048138699706384431352459514262528275953768928232199,
        130393662400082892059180845084884547061273019269772511202086600339378513079497,
        129478141946794568049977497572620652100489378584299543886797825444793612479573,
        215949727150887102075279740701231908987482961706222026766716742987873407628271,
        116113008526733713125609338269458310619523976085501801866806319848238931319103,
        115851103797073913131425453569966368101064184575310337566003166625294025464897,
        195950300724271588293025684159524708033277441051046386432808399228158953344737,
        189520897902546089804776204819298267927172604580184092939617051253256079970797,
        146416175233273053229926462380661724511477230336637294133238531149062367991537,
        118551995994334742236478892077042868013882048543603315678545084917365725886057,
        116803101551927478622613201179521216847123869630334231223402572094885791544047,
        129122302247659539807380583266513012241941704918133316850194104944956730388323,
        174087692152778801322636822576185042010297790204425959848983769571568811092991,
        129019357510133819674844944975389810046017407160461792817021787872849654828953,
        130994290823767495088684580354777335724527978095042543824160322399135025042479,
        121884676587109009554084468347717810583397068159732229533034591372937023898171,
        165009857367758843412181116807822640282096496905083381593418670134251748621019,
        219498896222257584035921635446351434096199169528862910349742499934694007812497,
        183026905962663806460109777676910216283613251297344697134057570332351172013703,
        226246197295186681536453726881395886152419587803395491718381974525324475012293,
        182517172081410993194460580211637006530467365995188658924501246237914692524381,
        179847403628348364452901566377565649986584941025373789730964891117012747032757,
        169471569282295742758195666487995067896711120617606470661035564308875139379359,
        196542988644824470573781435705306929022570004851323892294076455806469452332853,
        151212034439981807427614247413479787901700295339110824669321979180976208309737,
        222811168689106891033735802213315174435237721556797295809548053823741688902377,
        140531021627220408515664888670994058156216966443923402819276458030550018138063,
        210038542235602384839246257665499675359170093766526218578772976238436953611501,
        140439344368822602085936440485191512936831931390142626173912966898053211091881,
        229632389143954930468880996440437544117192539382904130330481943757413279519869,
        139745851036216495967868396157396639309171904861583713356663111354781986252723,
        175814589216242946587607103383475741986032245619592451011452126243049554382511,
        149060701612085065289458008853323118825857822633705385211758445938154907080429,
        197196223974592072488197118903929350930678823705469224089956857690712263605861,
        129322680649930504961328888432215320158213828830106380831138109312085973031751,
        132124690273889932595931434241530624191522571733404171516594459994850748529443,
        169264272454780401701418932877202582245157792806317868499081699157691365196209,
        182338570910783812207297402694162414865904044211009120808709890506856377645849,
        171943904985351167522665297137519854278005449654852479700316345611998092861127,
        225519312839971087729312261649468241942975525463380504791219119349862667014959,
        160032198660538536638281000566286561198163444849073975407879597119777996140241,
        200327578430986666478284072234949048524342566854996845777918310856150769037399,
        144397789231216844599576028713991409885301256798821071335926115316953049982693,
        195790465017483847412787441279796220056470160280531518091710862085178468224089,
        169844609115567972920096720625186452461403385394048394970957206926150863669049,
        147825317230292706166921444910745807570009240295226874088202989049436282195127,
        209388433764514765271439014459728144981882322700090187947006074424949331400379,
        173339691361361997412712428548796696204189741061452503937853754588141834715183,
        136895469333282934443225212070025320930013939742412592538319009675349525360643,
        148952435423952530178759995495461901752862035836962505145897756102323995566603,
        172290604302918147543853455328901490387217173546057564900568426747877033856557,
        214114539375435168234593299657791760698108697648743452254948420111873344710143,
        190175840944261651965833971573069032072505987097339469931810678423080090384413,
        199798478835063942243129021069217447065170858548390063943987587632390494416013,
        134846889176372807403399383183890397949893437826376808991021135097761811889063,
        173058050114235805202363289414118660304182338767556536023118888382996434865167,
        164686352168102794403318553328030730977187705045981863262767314028879858274617,
        174875734633142084714524751207897955708247479920797463034204187503059822403623,
        134214870446447003634507021288677371327355041091128947237803686723362486669031,
        150041287535816775764662761786956089478224690087478345597035012461573720838637,
        135500903221492786245408240910284524433142994388407765493640282296407445301463,
        184667420063096600252692522432702892131965943601651442637210351544947887595211,
        187794347454856443276565678510285572727130693056306030678088999793460833159203,
        178931525356057748976708611242790034269270282048510702788207932122667642978247,
        177835732065458841520873271911761062075806398154905983908590952781407395013577,
        156904308181150948437958839706898091289663029515021937232251449109399080695637,
        201282808113916508186253146242866947033306140512313080131780667435880279328687,
        192267346319294662613923830370629614342570258641097131919569278922229643087791,
        164542099422391425723383629551954955928723533826618528003753157869281006408069,
        227419599070596506591395147560312831178274547541377343594962725920175594415269,
        151106655098541727089542781345799929191491070595634440610340055804593052756373,
        227697296166041866741140195869905061931779418340993355937150393600480162764513,
        219211136246596957323842802028668725684773802195817103945203028853847214492253,
        208846110683153906512692096038032545998795623752896954644854973015556032644449,
        178230934866592600449153539823182588974623793103817922691226708871369949688439,
        157393833448745514567915844796790935277337774769749430250484740267240356189233,
        144383654656676840714777938834358404338048287496533105341221112309753518914689,
        127614071212901221780702935365512594701593192567870780465639110592557191143813,
        231110273063768191312476759926933978394507332453796402159090609630888689250757,
        182351308783882702151817144476533431921558211780263758484590845646037260043601,
        142578024443343811429936000559073887898833440575369468314697283218624429799327,
        219379950309051948972823016654630606670996164520573494992509161458376356406027,
        124899017461969268541768748239086958384521865832921325367462979455576872385977,
        192280512103569069992589314602400468097006551775658492368743047480364127880757,
        231584178474632390847141970017375815706539969331281128078915168015826259279779,
    ],
    257: [
        231584178474632390847141970017375815706539969331281128078915168015826259280027,
        463168356949264781694283940034751631413079938662562256157830336031652518559657,
    ],
    258: [
        463168356949264781694283940034751631413079938662562256157830336031652518559817,
        926336713898529563388567880069503262826159877325124512315660672063305037119127,
    ],
    510: [
        3351951982485649274893506249551461531869841455148098344430890360930441007518386744200468574541725856922507964546621512713438470702986642486608412251521039,
        6703903964971298549787012499102923063739682910296196688861780721860882015036773488400937149083451713845015929093243025426876941405973284973216824503041861,
    ],
    511: [
        6703903964971298549787012499102923063739682910296196688861780721860882015036773488400937149083451713845015929093243025426876941405973284973216824503042159,
        13407807929942597099574024998205846127479365820592393377723561443721764030073546976801874298166903427690031858186486050853753882811946569946433649006083527,
    ],
    512: [
        13407807929942597099574024998205846127479365820592393377723561443721764030073546976801874298166903427690031858186486050853753882811946569946433649006084171,
        14769462158109957300193764810864140004631754424080076515911724332508542195725908021001592861007913770505186501019030112662353300710621777171849751890410187,
        18447904336699165446673190044744295836029097395365068924500292552801866700899660940538947601139799824399283794196810633906053986785305869096987457411111661,
        18456687190628538911898832249637861910880235098928404443828178741523672811426813542630871434725116301202514151245699743190904848201090813937171615081276627,
        16645293360702852449823785136063698878004113650770851006538153846546116658448988783123071291888559670060030955409086115075730986010472813509325576489545287,
        23094241729325109390866965514610968193734284760355190060617383737087948799616819173624051081023180196575653314646886132738144251014711764388302032046121411,
        16694288874746172105583867292516065619980422200481554426531909280636308534296127257515113925794247429263231789267263706226035213638185492026624431403363539,
        13879887679265375517262744650933262478389328894282407856319148861467433773873706012504716658492037682940101356972544930052481198104693437737346393943391839,
        23216576722925882110182405935091319982927272111998193244039644978750106754911342401667259694970661448446065168155781875359018213771375618264618530273851397,
        15136697503692074215382840061524928139022492164012394512179285144140569572481392427055635032404669267000573602035986996616421107190753141385662538126740013,
        16533549035928702654393278049146006114014911422513602541690079558723814223722852787597083592466207211215341611241894012944077705836124742586108199939168799,
        14832306579780866616518290939732647619958471645800253067854084904650387710341626770212892333849566018370707840436150169758501624472828275848390273714003331,
        16866590150365609756346000419998086964026259810600107073468865376420804844133776281234034745572886986793831349729556857322970995433660341785160672744603619,
        22120305914492956246803574725423083987172082983265599029476151208224998278817678964576921798711293062241119666999541141754361343073882071943169292695428677,
        23332058364303112880543596076332158344955153911269189738167636030237940117526867838212886285612858081534208586518151354122725718066238277974853181772956613,
        21855249269662326662973098751520079573721186474041753385919939655320406481759398028286445898917792974095422074658439811705621706731303103118877107104114297,
        17650133326244844844021959020575951700477173910620345632563093064436033217899135308365496572752791303667144750178453083377122447347826770856315291849113219,
        23594843484099634118350189632315625505458736273022852229536621602149626594200225027733963806801321328670043105184688221156468521567856833814148961491694467,
        24633653013793164198238513241941442738582361443545155782652282901074235453631372886522788866320346215082305547515989844361035993926511451584005825792297501,
        17037566328619735873229165036121584933710385889852815001576430885201780652678812353236072256102204459826344618163347681236361373497842968695252217005162707,
        17711791731624901652187150238489955651283220286262835186328017951456096420772923086154549054621178475579805088656786595703510404240732035995631542438248153,
        15104919226110163822315516338897341788265113948091533520747195254464797025701417973245081875027647051961640882930550274447928778244732751475043018157638543,
        15381075350734217568147001373330147479103498385690053160025961628551010373215471176619084995721069437643766243143752154977757775471251832276711309868710259,
        19943063742568622092833576796461408201264384134045424158612868611987028767206478164207124539709962595013853622730280717227817117722056272714737198753201127,
        15670251314647088818727368108621793405911691579857834391298132478818908181322648236959218431083675540338989709835960264026965721181971838314788949989003079,
        23201389817720989674622938350079256300706538876494902555533551890118410036033620770285402011879997532840491257255527922732107951375048805895468272923923543,
        23628279732471315320892345539552831568084782051321106267523928574499451003287266928278408555785450800776833100977011571441957599013937563131521514981833109,
        17692599456954194120086076411655472273932848691632124716777621817907967263001543123134520079427978766183094688917753066145765711317753944392040230658309639,
        15329145450143161000020310636916031310215774822060989621575127734877359320501208332682135439293374659577805573647442420928818469955176280337253927297460527,
        21213646040805459552075694124467696288802769000050178994507603608222963547871888917060148832914490564427598149448251046953432726728721188789822193847148457,
        21335949620064937873541601205429260140959938073539003171373261565507585254854200039061658199770813336914804461079458340531868807943489760663218218362701627,
        22705082265595921425824734883352794369212349306894509456931623146207684436579890060649286198868219224569740845454329916748848641973484905961822179939619129,
        19122974107077492791846543814976577130793385546782509951374328528689425490217189973503441062950313158284317690540914807850406596393985759942666508003324469,
        23316389113116173271378719273328313571395606622112631994702543888773975701173874583517375886896431664435290198987562128008794764407224465372637086907187703,
        18430390899350819155180950760311939743355552288925338801621982307502322378187082584023314413045744931806143781759476567656414267933856016234313917983119091,
        26588536041326373585117688485575229496658482354070221050442801846728406919243915036535699492041505889463490686931688609580968921087450580278628648694298387,
        15001980570169655182709492974579706490396183580892075738323315770378402202611765975175624619858668927010492703076186832864139176765488348108833044010265193,
        22049358771684620121119489051716067885165269206818530494400762627856707429144408807520836420975473530988455402737779970769421235546572828513968263673924341,
        21574857654919872823416763837415353782467169103280437675664353001014635213337089876639375087078792190439401723717004413425014349238063002737565791924172389,
        19966413182603524154258360689298161745973305038339940838160306482104851845907781319807914487248906428955656738876900170722098155585068472693471405237091903,
        18850522826772972000679226913876204570577669878028692585056542834046538461265497465520783792916802536349008141391268817687142620006029374561513386088114623,
        15474126930087426065001375052153827217801571644154989067700514000869002941532271599535343167941630780742537361068703179179713980015061569570623930341240741,
        15397133576163154495306780075727856527418327256432776327133881220780169730012544627823909317025586471205658814168000634847396691011659538639600408468757299,
        14062717147383492515363043151295096220590630736586705692755601330447308634944428158997031011817890797798442729812833526347213556662703795130888982900666911,
        26086772719730062571333774867553382157299880054722854229293774196593857801087390898910525603541960611987681402445073569975129809882582861110665474912694799,
        13760736393781427172881148647730154278583552706049256633416034164015804874188502061103715248572424852461188279521425971376705768350736211570795911199470851,
        20174420613948685938251976898086739064491717295013800225758241657306507908562913981555526048926749501772601381757792213087910130219495821886327832901070247,
        22172311844359395016225829772158733941771073305720712301330792978692555924158743378597414623106502182066220609207037576762138243775927325014558046897225561,
        16642803775372698762192135125469862573299672950413812183022434707498562168157988413697952608272640272022631259374041900323357353219857730483483544622742779,
        17237262685673273237356099202557476078172278615183372264893396450794324193685587522736664119552493256193656204702503325261432264863974372972545156739528637,
        24581853861017019894393721124779186617733852766674758368405914032421056533113332149521546261780589459266380979110706433322942650425618840889211239446290751,
        18754087861419944481212142232160828346823244298669185055070836224358897100467334192991095670162925914170148541427260721471717965767587936056881183558769187,
        25334291685953996159246424217982628106551968087013811730196233356288945259310977254883750056769672416268634318394317579277362482799491121914060486144131681,
        22099283361310837509520762847765069067227388256688994773759096170801476474181150198479167507161565488297950844050463280583779516691902618487235623486844799,
        19302292408176785658887495084344333924128034133882342925199427743897969294215530913376446908131428106333741640131037155367073878403500725805886119798535647,
        25377475370430845086814955045674476217818144700951330565720074665747765532831622064359548669371780098478173304099503275404665895095270042045532145434957001,
        25368863256896495377644032687843631875574217301466022621342270098662735833368696140754375057910312377826832897008897415752747931105936892621923176649781227,
        25687130313345433588658737932966532265993688591670449799022078409298969995319015866477292225167108363152315381429601400432937522678402762495523957343600357,
        23347399111089576482862870365574770061047423056008818109011151315234357233057113231874716867687309478216768307239885529298325233920363089233423613308555813,
        24411516998823937989974870187560533896253045510028237995576398024173097857081129162787848148289561608721525168534174470396639127054246110085585639995769567,
        22100986757896544029392349350417708455532398154702250418067735324952621144877644411186082470809766003808549367995278948734979543794089211754307098082037859,
        17907095907288424925920482605351542209085954107976140701295767419829391295965010127807068151619013236648148800605609082153404552205394603307264286964327973,
        14949477658116764720771078991749419565717645392211210676959889417225499228157081431690077413329066133775949426679960167962597206584372501302056146534200953,
        21285225730693745402085639051274394065535120754334584142731040921577035960711719325930379377139835953064661919360554994668906597609326415998317515841958139,
        15749248676493619818159100141312018226600795815745586809283553064040738776462191427973225834527625305087424491021997201944209978967729083245686001450279557,
        15922164987357585994812150608021530475721043280796438002203418134877578204843137526412782755653875815878759385253933741224032755725341182829729428495980107,
        17855207105556343096380965143650783894045976999943367463817046736785537266430899540488517015356485319447216050266547134284469185347087885968423637641121271,
        23464888381392207006078775246811253514722695467432763139910257628921020485781850017377117654632851685448887403564898660856395242633171656098560057975971963,
        17039057496247358256136620479999037623579707284710907318501822157333814340387020634705846518940627166968945979265306411901883801812246239693884993982223721,
        24660337968286841640561904211172536621174119613359997233299455652375612472241953987076469902800150121547043621701589216320682812018304017103659745807801291,
        22112967641396387029322717329160857557159389778825701111274159120564770099931738530901739945679946638258762343594148693291413998250690930638963074594230221,
        21304693234319419395926951110514053141417702327778804461351183963799614459363505293800912699863576782126978310224605772108883292358837679515988443200864089,
        14537471316031732495095256297445425798054242769256974074670632826966109027627638308384744075373683897697210308378607854210069685667098630862795000373819493,
        15542112961316830438545573067310384988393011738915352521595552643758156111674885685652057183347174696411072982968839144095226751993194494398900555358429411,
        25940609606175556844052910247074016496308856996975966195343051400268057012095171098944373310940187256539298738682855189437460486746299829374731076450003789,
        21903673448058639647851373985341553535717238116543139677697995345966768159044608264155290009410381377318878397026743475593962381462176282993641117614849531,
        13455570664275560933259588629288859200835263928596776703134523388499476578580397533104412420066778650026472977842357753260777192893226220721930334362761861,
        23496170134631896272639659823508499359300716212898647493330671055496672080747713061465415730460793571370914859788816653495436629099363864929257354121838777,
        24596771579071713422892931125296870832426058601326007453176135698316157278026831345174670611082050178104115730878401561924896125746381421295023279250204779,
        21539136337944558590653855544438384072170820620950992728287497139838465475622442218793247835737079407702114547747347395791135278361083775631219598159454097,
        23144646510982080262090412038335149807149305561151244885040462471218971160936103795997514760461983233701153022956837513003326714361173668673103963602235453,
        21060186507932246965489351068599420819148527187866544335389129333325813778676269788758368465439034541142393159986249717961826899456850862017970522268064017,
        17877480854901351249907334306154093363328759866839980573828693300772281932553580052062147968811172798097437134910914516476732748887549571116577963875421887,
        26421758106029744599202045332456830713099181256826235817460996784239576140343442478386016519630134438414775432328470452049499928944355790441133292214088473,
        17025341896386509854978385576201250593683253903200058575900547442524456668425055586575775640078845840813296404885965380174627461051811823870231450533785139,
        17245630768396658022531926383011731973740935050385473016268326188738397167952852137009058931746025282803245090044461803985347011681963099505812420676188227,
        19886163848075947536213756986055688930447759886064919337499712718711675605457225347796256051861407592523081248453666683897639550233249906286872390675926729,
        13488623103198076213264495823496625104022018827280348337547612532645592578315055860200201668070410276930180408248099083476396078763063869242400123029972159,
        23115913745859785555424460751642223311577426761926643068945345862709911410108629694311336213085938978927646364467384545053098527249618479698539540752358389,
        23789611101476111031653658405272004938706434798032134151393686782590661228817700463895150270881968128222117497708462045009393871897267186806992927901176459,
        19584424239245285184698543225213822353346828529423209138599702472390392102465780510296349093437076999684200533676176294701367592118167202031286895776136721,
        19578982548532995017773135235603973074055312876138853954409385772521053245774790404316254676413898080505348516084752952728189526349345447679353695326048063,
        25334004060656090882154818352935591587083962554715053931912489039085405967079909872134887181024210655538324633599542016908146453641973078107084924156435103,
        26433260917356586579730818339682456877990017919134078884865306496146797113319808894900654246145498661840007943347390861909751640922409165281477397418675957,
        18909506261467548735321679479525766796067955274375622111067123808735513318461349163132965845099175525253479303247124414291475214867553240321635524744461337,
        19365863454540913127558221792240006658915385463960055565203561758826769140491126474377369594227927679541904152934799206365100636098203829578474756564363613,
        23852828517321933893412255329450969511511198390192584101533861834837422782387825391484976129418970716598119493389983680497695585302580802679553041809709799,
        17544835128575753971161240981090858945419418487370283179487939461387348141180605966256958545838703340938240425497834093316350504532269892169693878585415519,
        26043389464279198395428549888371592649226345883427007111584100655487579695937301782274392254961927086582743292635742118973046436449352342143441275866965537,
        26815615859885194199148049996411692254958731641184786755447122887443528060147093953603748596333806855380063716372972101707507765623893139892867298012167747,
    ],
    513: [
        26815615859885194199148049996411692254958731641184786755447122887443528060147093953603748596333806855380063716372972101707507765623893139892867298012168351,
        53631231719770388398296099992823384509917463282369573510894245774887056120294187907207497192667613710760127432745944203415015531247786279785734596024335617,
    ],
    514: [
        53631231719770388398296099992823384509917463282369573510894245774887056120294187907207497192667613710760127432745944203415015531247786279785734596024336553,
        107262463439540776796592199985646769019834926564739147021788491549774112240588375814414994385335227421520254865491888406830031062495572559571469192048672543,
    ],
    1022: [
        44942328371557897693232629769725618340449424473557664318357520289433168951375240783177119330601884005280028469967848339414697442203604155623211857659868531094441973356216371319075554900311523529863270738021251442209537670585615720368478277635206809290837627671146574559986811484619929076208839082406056035747,
        89884656743115795386465259539451236680898848947115328636715040578866337902750481566354238661203768010560056939935696678829394884407208311246423715319737062188883946712432742638151109800623047059726541476042502884419075341171231440736956555270413618581675255342293149119973622969239858152417678164812112068247,
    ],
    1023: [
        89884656743115795386465259539451236680898848947115328636715040578866337902750481566354238661203768010560056939935696678829394884407208311246423715319737062188883946712432742638151109800623047059726541476042502884419075341171231440736956555270413618581675255342293149119973622969239858152417678164812112069763,
        179769313486231590772930519078902473361797697894230657273430081157732675805500963132708477322407536021120113879871393357658789768814416622492847430639474124377767893424865485276302219601246094119453082952085005768838150682342462881473913110540827237163350510684586298239947245938479716304835356329624224137111,
    ],
    1024: [
        179769313486231590772930519078902473361797697894230657273430081157732675805500963132708477322407536021120113879871393357658789768814416622492847430639474124377767893424865485276302219601246094119453082952085005768838150682342462881473913110540827237163350510684586298239947245938479716304835356329624224137859,
        207851648274873102857387371043426998709641968843458604638519515348786565641314571024181430673288983183507750016078880894458013480842133641260261474505339446043864824889601337392647308407750388700040345033007534853231994964927858751919079256732795667756182571832914110434058715218433696143944202887775121425411,
        295355846100411227247155348481181147691224322571147152707639809184738416712337361375418113539668047756431439434966745850247162645696698811111313709708399255557427796870207021036545321007093013736718702318588910370142213754120766829069878041254209558289715487185125407945018685866921042608318210760630920067319,
        237341398426957419109293660866855585227049365592213930810003503193209317643348106173529725102783377990696464428909964228650183045353480957254308021515548807868635596435362358011708902594786197359132495276449761875358854519790886829818970788852023215908148298324717417001667113208000430183769555829842839795769,
        270269160109399866113160211920631398650852843644183079556289337114521567483355644415359163711698046174783915548234572035368327662199267699722896998958763572360474763005165377463132484897475534608221021510022194907255332147195320125661271134611916215149166895330588656214791468249992656052990449835128670422787,
        184561660601736685123713708320454154405889302824808672531453101745395003914489861936528118212488404877158824431122653226992452287678473283255255238226859361351158853274067197659599096311097213065755822403400908559891214670883319890017813855102635748664153907677793950217850234901809786071013406656815208217191,
        338837763312188232780002463983013135254343459701654160649435691387017152726744787753983810237867978262984732002511398397477638442905187922133174049874156809485327519530024417106139076804354150613312486120625833162142657265069471406121571258337498275794549353330218061797697804165047786086804062322239348599789,
        249561063242668095236881295750362184651911996022758399056802101130590916943893781103567941677472782572046421849728515329685344009059739262772996129064053408628214777361474840290662411997702409542439493232451183808316852852781384684880085763878261590498392495105757394577121247466767696978933271243481100260171,
        302846514180015700977260244003535293748036878060757129618589161898169171537058982047104612062162489809676949830855787321855913586266565432851609803292613032355389529682910477755419781464009946960545790285373787187038798402207779479229048222322252374823638672845537808890954178048701163537554370618413235785883,
        287397610162538011718030601636761629930149545025428659344524352488270999317162721421809710657061290921377844894905780148247695668167525333372718146248745323793083201912697386781805636072429456472379506959722573581447258523364463434822375205870124316455743009718557598385187100275239425673690666967591135984157,
        340120601834662962106897037462148919194754333393732488217265761851623338495091846194302541835345188795851678337924831380069134007036198617068945375406455408980412240197193056278532550236832423903747813565096193872828752544089060097509272237151550499938086695306188329805424091131239228968216384637549335734079,
        263342841124715671033936178990972039791249413118525383931190458467944393864496904453598170122292291086439406003625294032192315296225329595043788228241884795656408357091614234380872286286941167574001239371580006079383898055657573686580454330386783124224095606095327944394273140969628067292969234126732891181963,
        188390096530891977548697460249047257974048246953403253463438757543576516698061603973705871882475198268531361549305080585258263026200164917702236450484078117135910681874653549571276504761628999949024481531006782048120364889802706250053906195509611867892801250655387188014486739383967133654710810588377015780443,
        238700123510139801096097132670929234915097953028453861132340593460956611159664146762181953532280133928974115951044967667266217152620845226661020995953105174148090937260496403941506978608800349108959341860965212819019390641815161856497866789222887087120457729596216467260249570743375701007385234982966344516679,
        226754832040628902673840714314725267944374305621720321091476380798141333202066932602081897108618483633727094845672361303156307753199512927421886901716400842399163543184589722509669309920658412452482523271298001563148596678983882825257441263994151581977381728320874421898519393211020875433255381704350827473821,
        349418536474189495786541848198401117459725952951047259665443861819543886086255637810116518271206540754007084111076773915191837367322164858064236364583933728732568869757809519275497929750276657903511214356902084983776109865957554167965392144397640729724582658886880396024080745258020670118273541356456700770899,
        350016535800663524333329018003741985780412178836065712198401880651582978963656109270453952290468105413036519908163420381910692334464755163486477762090618446247367671714525801028846154701774478287956173271474714516361747453913813242188538382483913728005412872878219991716528529038597562792402880941075172096553,
        269014876414928066580120318137313021493463435581469733301029767851078406000545364432209573667672745757201065184541025857285775038231097926739171171017345337352301997901380527560539796402926518589845336034699594472031690584632077599260794488441254326750307650608690295365042168340912460472406485103464916101441,
        291982368660337621519742029693764662740095603149647119345608351694066212645369093141174113096017971089298501732647255571223303079099655698809398392159367984023297619563542929873008851160381841562205491081384333894089874999999273021163387606372014334596056835813192752716878441550262102597618010240065621207107,
        246690865028560610583248789423558143179421945954058191848239736147301443167523943278924380348373449222463291092810926851999115556813845430531350216162846327467421620889221270897999173365932817983923979167347904666929639963045021438044132052535463122602623111316249349036798498662705613491146866518362050647019,
        239961568930743083612652939353157970817572839549378728047056536223328406524420453842188555051060807925163496716220446663558472050740266724193342770213452470763608913246589044007086108476507273240803445124233938065615658510406489948899284130261832778170112260144882597476594529153162015149483125494634553531449,
        190853580055991482865240204059395354590303786801498151605511664094232219721291566187488411064411399799404558742866146563893107617563142587612738520122177209200740401879883502783096060475068399659065523840736213435577621369709436994273882098011364861313278124656590513138264313851490655045523162389628042077583,
        285433686434120690791613342065197180093330038557455829601610968003814990619100314231755775764472820753730107989327938523466949465180203764114460890385069646021675746009582215088060707355358261301273762208167885975484878698918389051886065112500304886702913229528850277268553603608293162850443300455264014049489,
        354472044150512945892742581021411992863392029442762188372103322748762466406765993117714463308028751674536920077661087783668154817711623493478952580930539001863796812954066149438321646548290322169938599271657955638209981972565119903294276937740512784881084620297189422659639789548188014553936874387517487561051,
        208196861309261667239186333590245550481131752598016804834684812818022506836255775802358573764184588434313824667543532346494095504917955146201944619668697058658841963285708576487814525417428564933278272054573260771542003776389888460687520185794992539038379899210172333188852470356570930264898133694294301848911,
        205740509076443214889469490751984208657827596355937246967222472599376026783484444812915651145280302137824149644106998423423410639500903451829609266999513858680520987014139434391846514381737796247589780164554251981403780347657980750745627061506097211900116103115113121643006714391838865377992730536081100154013,
        244322194304329608716840682621525246250940339895398467931098476090212484954837639512458450188855034219054694116875267512248839867809568578676290053019394124770834763550760828260012487855690856692029693610017260617341544965163305373714098250421537643307261256531159104045132554770317134453333476209477210895933,
        327440577488848016111501730561789255479761508429767626402674893249892479405827097169129784793431524041986402736152566998760558165711613556926180346636533868564885308143128592637575635657959068185036969488715636003462945876802284838297567734912136480078617991797090826621046543835008343010845651226783863043999,
        219286221102520228386440786420244516939763907853198884660736536974261622679412060148711734134063032988174905937480087112423844579235470647285087984403373267046565504819110962374921578925366795644771070156150824259531743044859741766204855978935650653575113822399279878306376788112826066566430334634375334611091,
        309112543252176680273014777806556649199541474405477667313004760594737470459944315077292278743031090175507442806007312628386133527610112728800126745470588850480840482584226376766111371721744555645379862064768557126347817656013881355381750968381215201402973947049609449779895451772946972905781624468961960989287,
        268968598741497160105009852601718860004965636892427324304125198493560629851434267195589799100480895090478868403802917255701359622847985234156060710763017520778583714047828643230311303584415284421740530659272198836543975542389089926776431783349658249906501999757360690475775918073934290552265406589980138086357,
        342352945291870019505667700462380813207855390317762826774370218403937950182831280645671192377563728243994470091264379300005716063679649162901715473383655715216971190103929509187480765165735172989372598502132546920180307590956664666497010151091672174740935232545575614713416719724496635617618450921125044743013,
        224118388656726143302777237326652543529572630816182463485479657082572909608362585204602405669314076459536542024290631408147712467912950156544847029819890819234654311313041471127653679378349346019631382204556915063035252576527231908780428151318771628033310464022299774125990822337761920726540728557422692336683,
        293503580166178065868127493979023048893862563235807759519693822177734521525985845560565347323906359577686994053024054083667342820498971940852878597964462206860549122440742678127671308520493141302069518288836482625606613189238390614877383522837597974865025360260715682314881830800718221527843327822669322494171,
        227395059141125178713496035860778856657915425426002785231542301729589968641512622697638098843567306351698263332032428371608257116333919929059870728663271198756473639015602036932970475605937760536014416460015064596282889254583696154204161356681547550036782849351997840551349766347045397718167692131001539128393,
        235992523760075407076936509245216375835269409799602287150875089230352909117109437516504486714380919999150149823814049846299130863867371463021874580160776800136639668310501083633523515423370301129134149707763267910029928598847586171672630140436573062966853166613256352910569142982879815978335205420370644837031,
        187423084613392430688285972731875176693051701074200632407027278463410317535421253830589792141402487744893032115070775395496861256323870303528488934638975214564100554853431447272787656245323619047235726460363329980256154881818533216786728279143163176472331087284219675906801334860906316702553311921128808713939,
        182867187575317639099926956729652209538092411428732281920305976968333121577918008001252291842852014612389546973021822151853886799010229886152073371401591247189228430813984317096571519766607772346659118292005959529320095116545333529977748283989135644396078328485032277499438361631254853468493540283979348955679,
        232887894466479104117731526020996944507163656210213283011171537758900265563156060078839143836725891125422117379110680214619131157566835491994902698130868550666263968100348624062519076916717655239533230889855145334478530881043978409270841549428991581079375234074729795682380629786101998075808477721263315851149,
        218257234447575422652979175609592275892357805420515123136891826247963641014994915508159373831861893200874508442870973969513754612157417174459874347823177891936739870402523116167344240787064920952501220593620389617187927090602266937337415876161667984639504445757880415036417996025850157811624464207366214656961,
        249605573941214562462436999150783926785186643859247621534580927118325237268276470823821703646525845136755992285416214404068587852841441200659939801932104680935311330452512461054829238721423382846971461211003784210193484075317410993346670640082099447861776741490434703587110964858782524882423772605644778531201,
        252110271266888563483469359897274196364750736150002713564424238204281540376862084610840880720763737941883177521543095294202461619572235396447637920649392495786073271660115616686747702478781047932804720691584490227612019454863848918019207262493256187290567716467752981092658367580417780804020912603326614465999,
        187590147000667638956711302596160474744247723868015955914912539690005081926027857623739234452717061561198183045048381486292118606697810948525829003939913426347501450868309267085039955767698455813316464450819687894610606791638311991790297719508946919021647619046420428591310435865398538011741481275201493257803,
        241379176808109789897169363569527904331913946403934489633015285206933826867208663723857984345443671436422045334263505720596517649169110294395402720543708471765258333845114609154600726176587665631802061181450892412580599404513189322290564832016230311247405271262258666641447121856851786970775243603958696164419,
        308637164560633178651028050250040123084981757604891338184812074344275207288008609132634935574972281022063393198277072454570529454361263755805768205908456926993525777624087940559382304560125404215239683720664824383843367177181523853664481771648415699244924040668075384382824573688694117690488099437934305289909,
        205729944967293068900773865990772929320769021141923745046178140576178325706041888488203122143954635921184018371811438199391778166731238950143269481204766641227300172943773753677249644784552372254362063620805347580043039937832316078049420486108555318926500633700495903003029549415412533401800061328860870651341,
        238583557693399583167032024737639641010853019837253787586069054468270008995383100812517521516454255481768327932004862992773107878060206511380815831373206708456525328761556175636586789807106918487900174191318613080465747614768154937406169813048922755626274562681952394134801177901786216565474134111110235929157,
        334799816115777115583575826611268220146446661229006660308926882596037433922359886347189674335921820030967179174246929315322091255639516314196854221714861786549429135963409263930127236489254762527331623310648479016235883938023003352791554465169300820159127315610000801706657854385130925601514996235793257679977,
        337956255245291475814881784668187191912487372077772688877050262306877711509081717605130148108518771501564912221908312529822794349738476907049168468803314281943809510236456392585016426880866787483567844267189656097429258009032613804095527911041573135827064883293668536028980757342601159416430306027816833767291,
        354098126766508402556064013157319369631031534420603010297530417406320331473327254843904059775707129499528402038724837320072191947720383162864401916546203605898205939048647013202734762228360201785500420771649055478119555534713804987629014908260478151296979036410845899837892895484257765671708890902370860257557,
        344335335815111102438125755327908228776704315682454538614195175229116146837120613556967646727959400778363606323389038068940984364189723297670946194091638528017480401957225376493280832431242484039735147503110361445086474927422619490501429711715696469947819708008318338930475452294758668685884093707706374764103,
        350042698661918929511236422536249816893469936790067825989064221493985200597488535459163921490306800665070398029387813079334978551149334764340751916543387684641186015791728246408098051901984804296065255839650431546608071478660415918960517062373411660288428940947956673243249697871532441838416825193266175668697,
        284027584477420925919476363381726348468917421962750871720869519862450300464942728766241200641936542132549020644728827580313517957614616754091225092895067859300722153949578177059407425517719112138474038611282375055845370636457785163209500658471687386793340683357655863667218914943072671866967269971425254511851,
        181121258083177924787795361453851655877525689217329937450147740373369228375500938145862823361221928704108187253622939584773371943639496292627416724593672441940076682946909429419351704569187735151495550622227109699641312263754082225535996071189595830678269818932215586460494721855840690901045423084021295400577,
        314056479160348214680149142035917976559540759292570648200204426808829966004826569904640679483171226874171941621696413476202800858315923351866816007021901162591626505024529218556560924906463072339131564250262007781932627595714181723168631109059638133440861606952602659105112110952943773197411705476819698189213,
        185722536479108412976752400380633208549622973448525353716277420213258916782148272132108722995533753750910685633028136430506271789684785137386067904902203386467143320081870159991232692447074518415563215277041662727054847215896778317572980596402832166385837776120527468283482036372884652107925278117613313491587,
        250315780648143779870378720031071846257810551065241866120750796662780095547508674760824460194027197473254711280086871814669958078333263879636823229873391155812704395483386435176366211040034750018574321604525615645169203179298151278421047611424784335318716383811564443202647202860649363076335566075559373790181,
        330243739189689182569229573976548451825929644967247457537815794486511302329120839050448895360923533316751189378714394710508475897960764929628361602964160203918226689238894873043750188408943933691748096251061023315522428445645311993630419752865980191714354636039299867073540193329286714126627446716385314904953,
        208664459344100463789640888766964673560553035580541219990065487156230774875818078749707401520830652724953239088658435120409084565531090886697871630517743090130422978665954716204927398017871239077252373165538568781666449234693168120605843816161659443097084559261150881359673911995161430702745825786420335854091,
        266870237635343609559033053966699882384531379168754649845205748428651080896315676374189234262795787915356447603851788935110614636893173659330094918752228028059926120922754639667658084965089902249868476888302881302710535744611060674031193818926498425447954500079392235352248340557144886616323648384471821132123,
        339580671048244398719295491998108353045477797827642121552202937847014699926661797156702352144511004482200361836196269684681681105779975680038866814174330030940874277265565628917417784119429815416438571310371095750257252660443381786444841878049868261950789753846079217199173967786905076829823771914608664998007,
        231332750639911804809417396502432362512158669864273414821161420549969996849306956309782446591800457059681178398325740228786103634368051778336748711291828933855240048052497010956981392397019512412997950977327101778205676788080876186517406869954381927670541490409165282586112573082354617215592744487871389826001,
        315529815546905716140507863334301886927251648988315020189587044957605215068393784667874026370211563255251380013324575114059737053940934883114135813023554789906571318996348362515644761528848890305329754348699366127759085649993577469116364661290168642338046185251795035735124487384715660323182070411683663488287,
        351179767170562014773912694113366555671283070466336975783357061014777460342265095192061266126642632984058845960472099091701717109244554915677175037163489614762223823430857863233722034021013581324550312712401233052591332833148191384443049277626451871254193052554741793996602045802095260291724443518649535706779,
        211932440288490979467578452699050517875733076714592948292329339885575196669683108128405821682176959374693229843682654368040327485871675826086310237511421402959996560742398985319870673953747686765636973001557217732791983024772858966082621770871803358323529012178021469866366023981387317324000340605165868410349,
        261229469293725291846416778966065052671814003859559208338178296503248340955754229350924980506453645537628282145369359446765251546600011372708428547715467924716015381852598906598616873595723354778527920467574277553643713103648139771455271562213500978161759096795534036248683542756277025547278857423815807917091,
        238320677930601203518510192269415649223298679852225278606341243158635176887013491579367913046595852971732839628764580186789172739086220379851554049785810473794864493723573723478156349374773973348992850117731876220945074719873580396233331671171365866236479813098203089162845723673179358284354732641916613820159,
        351943569917470732657582825968445963148867048914971617875585017314008694188479593558434422447197530799263603573101591499647166334280841150772589053214249644649396508213528046272395493243915832719558304228823937178333815134112575062727819214123458966654250693020092087539083200940905402731621960427281507258597,
        258887658093716436667425769824584229018004166520195919005626326402829016965882776973465347916010872067609588663803039135081303163860898405047413234060292517869730837281408019396526185759409515448945822135071370511674767759537778870566012943818722969887251308428282220779682449479998131510321780729643332162051,
        301696679457512103579720512967366506666694464366773382175669413615312201051477793401443000336198879406857497534874274124241576597813327284613459141366413526220836628326412692963036030709943677233928773083836159741810789793452897869651239295091343515907409479846539616348412567213910327136042743190953977178531,
        328842721709132906148960985618957783895116047964585358726505239276551166114581139851001469794407474551493625532922329016106024621778607283108900629315241111164449943005264247890458889933694800545131202373303374091847594177708624326214271612626828575286290291075510421956467889075975207333137621783998507594367,
        357558909364727203774826874774785017825533153042582876466325999958102490608524872045259910879154012966257309956755181376794934092652669337588260100862687106947069571648556193444475527695623853601374390084056134315465399846525888948240889038782410879597106496776054960270861279041384640105115050166879585752183,
        274985936225232434152148517342706930949858969108515157341960096567652734402194766537656351347404136227456034089128454991402391298755977521290931138608745230951016675244530590960043634562812002740544510630676687319391036065066971180131114060836467568302153010474537519134985222988775230624151899288056323767657,
        321368635153701816628698803100313987392493388903573233023294951161693917604454040836335667430961376098378926158668819194290327527535394109770156990207468242764290941890636455191755015075732396973730270663269401183423110901210917498788682495070447423124395892731361264997179153112921274624919167940002409844067,
        349014642838926248342634173494205012687033131339787408619769526079151556275835409802054155781974153484944472998359835095908966297479351393488928567595583898715288911002046959295987159176587203229912508921512131763084399001553447295006815388085667275127169139930573469913694742240978128855790910015709055924251,
        245356875010108702695592888876486603360330645427936715234824124080694903014427604838258139427776547569765900064438648411514899509854922118002004574328772917673740792753742144368174723597530477472272105847312333533260586220228426575192549042454655925579512707324554846829148962388751634735774348008086122620627,
        247767090577152248214732370474853397288696981279293688066345745721189455699786381408127957917398882262524631332499514623024846659795963111665227244325622557749984725122275073573510420399973668608752968148697636657946770371219010462176126389938710695046869444055818429872622132722346941809565107161727185218069,
        270699419969239470605023309148624634844110314945425865191901013782782050617689978420193018466914369764870545475143998119794523594041111037860402419775576257458553766998810691679832146729784041345513699101639659930701771132908703410255888170586899500427843566821244188441372172701340239105443947094154100896023,
        188550889111554214451609465004130210905411605079635959597893610462738339414813826906983799422051930503075714306050020628250578525163314600200123374766643138669845849522941645510175582672489971114644184851824776080169921245081757605374725771517810311535196140157322298519113814257971729157961225779112453569709,
        188388853694379302208232195108519991822579910294413986120703118674229211893577290460344199572219003524268385637688249450221400484195630988963438405866604148983581981298938441345004712703719979255421133691160588216102852375928405574682079861773837504139790121161719422632277161940543356655016330179452980361087,
        244134201595095170158214574455221359375392321371449367356006077698933423463358111346579519353504333682843962178818944670039143511510967489987060132710627376717152367850266981746689459542501370597469357776148366183958378570007813107394554025756319949977493246545604833675730324065248765420057572279289357492921,
        191089298787618842822671951279206623812432540530087063416105180713641810268080447894296092876869383405594461682433076120647140280849796085752983598647062030438651584764272806695201673930311171909582340692837001894262186948443256454707345767258273699845485336745663474122471536226023778402068683099390403899997,
        222854657632096837298916897551529023030959624632726230997766066086698793616444975845484395834812044506221163398616000899564489817746085527287727802734280659345455491733395672344841475112997583240820249815964758649502600523312026741396990070676562806515341726469766999014374560736218139394885700952163228908653,
        344337085014786186920839987996262537291910189643518074371975598726917652769238605576585882706645806968059683248149632972005037221819897486420741065038887185236752496039566481594999406609180617590396545980824815720371542606850439161257904170611270881870889015560169258885020635044324233961279422201529155466351,
        181231031534799368391828073766263079375303124777293439516629061497051628027303193422169121352952357939460823909569308992806238972988367275356049067070492920136787978939025315746161195301141573731208190004766775172902445278839178945153502792294484813079352073184448323508647527946685353355481237394644574102173,
        257780268969648585571329862432930603276893775276214361196287961819948455312585653842829881635768937934739345129545935810520644628439029260431874288982879936318376291302648024755443131516190759912022197205506884786345216180838638487730036455325013702782796257092384193805406801197008896852551540689247217733967,
        282114578865798508741606648410661031715572109515849595923082886504148404361639624518202513025550019198901498421981480429814067859654838302863683170062804742816277879053592807393511660117181933735957935907878677662940325031055654759640781198288311617367768848674007338354702683668711717270587119093664337685769,
        317708630271784066067024599866036394844240056314245944223101002493040720647042235167460839272009184428293865902148897397170362944096160284206667238466218352774188580079413065710798081341075298043777950914244054475573040335238888826982036368327192491950074620892806673348847018831438332090494740228569040171069,
        339599367577449661620830299989796011744817290329469241492899796956018616505333507739645745862855522198184187744783702714907035574400030027709479262126079714508014053911010886949298325096885074303349159568100360400416097360961584951799328037513151532993793146998908876217757996969374584203328626221179924346559,
        226297368901286443528688778281786613326067276103872801074919257055694124604051046616612753666157931213275099243035557874241196600402608638188555939506002233551242335316026961409357648303093337450188895064476455349848509132667661215794666424020484792823102042920594363680972432950924614664152738010557972269927,
        231963235324767767422662708592649600294308861195066928652039364880470445437552185327054834373107201849183204338068444953987195985777773620751612215200587912238916952957947179058569260157608195382019665723693667149242423438635425422408688982933522140735125011043446373672063163504746701878052667119893890757117,
        232454341148961248351929958142180539027938647490449671477148515147204007491780919695408983146113238717789849186684720028761247944670692109908273259086589871853882873510210520747347407814065223922734532201360396981009511187071692214740743173652952388035434869011943671807003110467862964391218669672962942349493,
        244167120070229283225195569440094859312444533623465949668840604749693905404603052462550021378944336162785285267453967744847083252426042616037105201007531354289835617143930236056564601090644179265464330928262349450652482630525287531250738899549152454056341429240562668106443765955062168180667311687892060680971,
        328626216291398530941725223621027443974994129250008418881106995379506828380467859715230427863170481344459039665668421865715151407543243694284104360106483048516339725185762301902419786321506447787251959754892535424148115672307007332696591599557394608421007979777486612847596477694084985498053375991584261289013,
        192978701040072827968715036882904711030053971482633765495529332683645396660119664493951728667381010299056067676837973272484765366834668597707451758105301351279771660706769295858070253395066570422019285130585130949523049891029803643369905610874370473251449045605215723512929472377981824946918405212218080873793,
        216351410074849935998254202949612089946191216474071466660686027140137007393460793293150208046186752099523949766422900768704082438706624176597002004318583679240985551443379261738045094728088593008825670128540674145151356762599628858947490072497780408920070046484511993856885323854279713270420638904422728629903,
        209735332754024018902326379262956784261632735521566458078251593979756109497931233517398781258476150651327247355589953976651649249191448668116683617476502548698456447721255626187597017271188954504367061410009079809890939684773200943701165168821115869837393050454553825033016070881773744349692633656228026435341,
        354578231862459776939123413152425837276823149928859022175822746261600457441268006166075709150661993195742065085101218961248109747209120422557379442223499612386999660730273421242700176036140507280144412737235475699995191357117504994170184877007122644986367968101910170603056331136512441593982268733602408117927,
        237946624079075165181893324824475140770185993425895922888157561403774966153022672418817311615403044656240673063192192195705408843855635438539873230602022779703014516283152637354807817320889471175646773748462104464991195967879611518741682344953317963756720092279687891756036823013413903209383591246651346988247,
        359538626972463181545861038157804946723595395788461314546860162315465351611001926265416954644815072042240227759742786715317579537628833244985694861278948248755535786849730970552604439202492188238906165904170011537676301364684925762947826221081654474326701021369172596479894491876959432609670712659248448271759,
    ],
    1025: [
        359538626972463181545861038157804946723595395788461314546860162315465351611001926265416954644815072042240227759742786715317579537628833244985694861278948248755535786849730970552604439202492188238906165904170011537676301364684925762947826221081654474326701021369172596479894491876959432609670712659248448275913,
        719077253944926363091722076315609893447190791576922629093720324630930703222003852530833909289630144084480455519485573430635159075257666489971389722557896497511071573699461941105208878404984376477812331808340023075352602729369851525895652442163308948653402042738345192959788983753918865219341425318496896546333,
    ],
    1026: [
        719077253944926363091722076315609893447190791576922629093720324630930703222003852530833909289630144084480455519485573430635159075257666489971389722557896497511071573699461941105208878404984376477812331808340023075352602729369851525895652442163308948653402042738345192959788983753918865219341425318496896549401,
        1438154507889852726183444152631219786894381583153845258187440649261861406444007705061667818579260288168960911038971146861270318150515332979942779445115792995022143147398923882210417756809968752955624663616680046150705205458739703051791304884326617897306804085476690385919577967507837730438682850636993793092769,
    ],
    1534: [
        602578106730258147145029151507078528228023311986422237839918759766314347897950800167271256026836512415862191570222001196965604244698739581242403246972693662863803334845406306192695519479420374919211385784346955014399336464476149777365346780524876991249453910335575169407368338820404357102948540991946467592592242277305397985763558002890689612520144896962725248428723070869161657795378765951218343795565126561748209474676492753131460831100308246714251190084829449,
        1205156213460516294290058303014157056456046623972844475679837519532628695795901600334542512053673024831724383140444002393931208489397479162484806493945387325727606669690812612385391038958840749838422771568693910028798672928952299554730693561049753982498907820671150338814736677640808714205897081983892935185184484554610795971527116005781379225040289793925450496857446141738323315590757531902436687591130253123496418949352985506262921662200616493428502380169657051,
    ],
    1535: [
        1205156213460516294290058303014157056456046623972844475679837519532628695795901600334542512053673024831724383140444002393931208489397479162484806493945387325727606669690812612385391038958840749838422771568693910028798672928952299554730693561049753982498907820671150338814736677640808714205897081983892935185184484554610795971527116005781379225040289793925450496857446141738323315590757531902436687591130253123496418949352985506262921662200616493428502380169659067,
        2410312426921032588580116606028314112912093247945688951359675039065257391591803200669085024107346049663448766280888004787862416978794958324969612987890774651455213339381625224770782077917681499676845543137387820057597345857904599109461387122099507964997815641342300677629473355281617428411794163967785870370368969109221591943054232011562758450080579587850900993714892283476646631181515063804873375182260506246992837898705971012525843324401232986857004760339313283,
    ],
    1536: [
        2410312426921032588580116606028314112912093247945688951359675039065257391591803200669085024107346049663448766280888004787862416978794958324969612987890774651455213339381625224770782077917681499676845543137387820057597345857904599109461387122099507964997815641342300677629473355281617428411794163967785870370368969109221591943054232011562758450080579587850900993714892283476646631181515063804873375182260506246992837898705971012525843324401232986857004760339316811,
        4820624853842065177160233212056628225824186495891377902719350078130514783183606401338170048214692099326897532561776009575724833957589916649939225975781549302910426678763250449541564155835362999353691086274775640115194691715809198218922774244199015929995631282684601355258946710563234856823588327935571740740737938218443183886108464023125516900161159175701801987429784566953293262363030127609746750364521012493985675797411942025051686648802465973714009520678633297,
    ],
    1537: [
        4820624853842065177160233212056628225824186495891377902719350078130514783183606401338170048214692099326897532561776009575724833957589916649939225975781549302910426678763250449541564155835362999353691086274775640115194691715809198218922774244199015929995631282684601355258946710563234856823588327935571740740737938218443183886108464023125516900161159175701801987429784566953293262363030127609746750364521012493985675797411942025051686648802465973714009520678635013,
        9641249707684130354320466424113256451648372991782755805438700156261029566367212802676340096429384198653795065123552019151449667915179833299878451951563098605820853357526500899083128311670725998707382172549551280230389383431618396437845548488398031859991262565369202710517893421126469713647176655871143481481475876436886367772216928046251033800322318351403603974859569133906586524726060255219493500729042024987971351594823884050103373297604931947428019041357266293,
    ],
    1538: [
        9641249707684130354320466424113256451648372991782755805438700156261029566367212802676340096429384198653795065123552019151449667915179833299878451951563098605820853357526500899083128311670725998707382172549551280230389383431618396437845548488398031859991262565369202710517893421126469713647176655871143481481475876436886367772216928046251033800322318351403603974859569133906586524726060255219493500729042024987971351594823884050103373297604931947428019041357267523,
        19282499415368260708640932848226512903296745983565511610877400312522059132734425605352680192858768397307590130247104038302899335830359666599756903903126197211641706715053001798166256623341451997414764345099102560460778766863236792875691096976796063719982525130738405421035786842252939427294353311742286962962951752873772735544433856092502067600644636702807207949719138267813173049452120510438987001458084049975942703189647768100206746595209863894856038082714533653,
    ],
    2046: [
        8079251517827751825178719172167487990111025667428871008032586356881163784716972723299300352880728365922179490230474504873529889787622730273772038096612070780157719341825249022937549437597413026699014409596016892069198054660654939040459523584619042617645411463009076260721893972885266452151888099780982596380478583347417085605171243696641142373714044008831580514519451414832756548177115078537564648216044279181485900929615464339399587788075411476100924403308321807806781421177705052431289275431732830867419635645164174483761499317088249659553881291597359333885900533858307401161329619651238037048388963402764899061811,
        16158503035655503650357438344334975980222051334857742016065172713762327569433945446598600705761456731844358980460949009747059779575245460547544076193224141560315438683650498045875098875194826053398028819192033784138396109321309878080919047169238085235290822926018152521443787945770532904303776199561965192760957166694834171210342487393282284747428088017663161029038902829665513096354230157075129296432088558362971801859230928678799175576150822952201848806616643615613562842355410104862578550863465661734839271290328348967522998634176499319107762583194718667771801067716614802322659239302476074096777926805529798115243,
    ],
    2047: [
        16158503035655503650357438344334975980222051334857742016065172713762327569433945446598600705761456731844358980460949009747059779575245460547544076193224141560315438683650498045875098875194826053398028819192033784138396109321309878080919047169238085235290822926018152521443787945770532904303776199561965192760957166694834171210342487393282284747428088017663161029038902829665513096354230157075129296432088558362971801859230928678799175576150822952201848806616643615613562842355410104862578550863465661734839271290328348967522998634176499319107762583194718667771801067716614802322659239302476074096777926805529798117247,
        32317006071311007300714876688669951960444102669715484032130345427524655138867890893197201411522913463688717960921898019494119559150490921095088152386448283120630877367300996091750197750389652106796057638384067568276792218642619756161838094338476170470581645852036305042887575891541065808607552399123930385521914333389668342420684974786564569494856176035326322058077805659331026192708460314150258592864177116725943603718461857357598351152301645904403697613233287231227125684710820209725157101726931323469678542580656697935045997268352998638215525166389437335543602135433229604645318478604952148193555853611059596229099,
    ],
    2048: [
        32317006071311007300714876688669951960444102669715484032130345427524655138867890893197201411522913463688717960921898019494119559150490921095088152386448283120630877367300996091750197750389652106796057638384067568276792218642619756161838094338476170470581645852036305042887575891541065808607552399123930385521914333389668342420684974786564569494856176035326322058077805659331026192708460314150258592864177116725943603718461857357598351152301645904403697613233287231227125684710820209725157101726931323469678542580656697935045997268352998638215525166389437335543602135433229604645318478604952148193555853611059596231637,
        33583848209916090116113673594171537759379678579998573034329298114251048064481885204368061718261940154477194238246417607985352746295442379996090382474284229135833115752139617645816221076501650935362310705885021093153082884632361374052556355195614630979492776654760341126941377570375808046816405500087636675773640920458549485313697097189320661269592920796143633604392800386955566455510925271821904075591004484485324041908107070778492917704235918544170788454094810048342598938579771342774969124076309095659765414098010130295289712174571251470880881995301840384406282010363794721232322990213953718018176008896972966595997,
        63386740462401508241549821818625868050335969796467600501047915909338966762898251998931741474659025370922529354396223081895578116461318128690073900902208672563957930673220718774649428362769436313806033931677005474925071239452900577316640956876598221988489187195835693072871609259810363284362627427570210356804626734985675864878606132561525482342360953048854289421558705300389630313657838118723021490919707118638903183696387173171548301120479250826747361605461359822882015696817397417567441231171430773305743931476068914652912898678641262619895186895363726140794407197054781631502681678388059587002561351122071516149359,
        33548505321562962371406614862086077378552698015070946278040650492020113735252806739920497266737186054277025499144736162445317522210687904664506569113816704314678396559075206599160131777198569814484479981207924324856270838511014929771606657091968778393020661264880892269537793658442939255890557985349318865250225566626684924137948613827209579375679581567075373335603085533908279503517983397330764083241105723683751190836381266573753833431121936358167724479779174679584376412198569686662022843102934130350469704687403774505183052212233223423879115526669186875733034904719673277154087754354230702257748724584529387695443,
        44804493591454795088823692452536089312964083809788438444580069688472974115489483639268858114388506217542411679953624389223107873988588514620584802969609666261795847820832962824955485757624125816865725445577699917302891482854156132949983962057994292142218633948217132422366443564597375594773514552739660973084767827845691512763596671617607618694515203330070640256847855054352589019715230672627169338723226688099442357830142595126390958390019351172286056778815656450926885567624262819320690509488748400793943316630601919468586958594523289379425824863117533313032964258188656986016480122229284994223289731767982247848529,
        57312579792017797018927955066819457174385485691511879872251807419633610917285999550727862815097499816111136863382823608609961784587325711353046886140628396271299354832760495914074773152880714598428301317846820218387202716291408909977037909959086712001191666341608031287557902649638475381185013652990934336974705247070217805083812207311531930514899519040737651179358308735547438086373889921021475988692979570924125377000687801831677228302079927192040963669739244738380829875308622207786061504271699814570928421590658472976097422800715778420406221307070274903934026366056764981040091048670181426942021727947177105845629,
        47637841416091075046076610904216611995915103786603993196732744351651597024502002324859462779456661133987505783790607924888445870876312472963937402311830664333961994310064163318310343204265924944127893492231294756872732794780908539546238190480878119372319449217528527222149322789885636755619897156472157356407283506565324628248335368052445871621663012646282096527465029511230637518662950804757483705801468054930945935280723620114571624272071128361434147880897419860945549018951041408190264945746813005004909683549766981130066475032607378869261018248825437283084191190789153888914910090995921485931189280394537223070357,
        56749109078915221238254365417976261286163711685525129383166464047984257128618444459321674157081442597055044083416579785878830795012212646631009064795865879565206719987903171329709540668001701866699977109895767484107938232380152366132113839436440433864503515199612925109210439887608945364274401839389217293050728793172084450191168391333819706736274788723281458629892882995963490118645367237046742976797183171855705336967768555937833641689794192080088962054602423811571974856518830422005430313283392873766311933086505413350135745676800544675022468578593988560734560362305308816532473533212845793808198560226521947534633,
        46619597188202077158404258853076891735451438527456339565535702630277864314973696333702653042016421087657938844021100511427514573795499409443982179051737741115495106785135893442714965884698705097302810811948540546694458763053298096622049756719844806447538011939593789960060649773727579873994441292143382984168920221153217689038588468308014579404653173614789294063707771525700677297179217114304737378087260616345499464012379131824965834077512926072571115433754460397014441205367408025680244086936868636819734987027686186178800894714362863736819198791018131596903301758710398541355813325552885574461228720524498396636087,
        45361454557799357838210691903470795867462033538806319497651725763167781113402296570635219776185201366133544963044957798109973018846654796456526404085226876534334036431113939466833448039548215421950868558540032748333609310477197054121610184411723666767348479641865946904241119064816270324052546635933287442952202923466969267645229188404927922129171999373744387098947319187884665938559068354102002517562999399012032958846604510768135237268417079204199295435515049313432088113826534027131953601420434374262639064368399954622469430828053994519049190811157736611881037771106343757601142035038070176292880303425505345913887,
        62032088827938372435353341705291555767091605540076818426419729969913334670994551764147184062144684581721960800638514393853802872743834044128228887989496330920407225822423463986803813222935632302173538792493217723538608781392736754092093177232674852867978480972281708337922015258757372890513070457342184426831141380583622613097998060130625290403784368993922318691535414376843563597450882022195480793278225238699730382769261287336308296235818746242924396683243393155638937162619426640044805826506265580803711391247160565019736667095833228790854847346708413872399221091550147239920464704879743485346611167657814527498567,
        41439708138132172106873188772844827438326734175881127384682849945427323541220337169690494553447783206813437030107627879151460430116455038865007608647895919355482869174310726035342255806289120000712866350041328172055647631167775373720955836388744714840282009844667357946659580819435113870229568168379114322553045435944145424217135319465713383421452019616331660280711792652185707738673512036342580374521936265500001659969420522754181010799306600047690321577226728486469620051710886688584472493709704112633825131927765383314109429503180614055216137875097904133517389905243741370964950523785472312344367562809005942798483,
        33509482846139114055839463839566035282750660068718954617645483940207668243553615778223525623374329732546461493046412922445300944913558254767390182216410839702284166518972219923725692712951167875908354022001011985819561050805843700646350673420873388590828342719592392174409508651811183220583532534356439428010146116937281879689813507526873492960260477161378865794858436024716299346785138241768204039636329964468895754394387781362574285125409956404026135805034570913424912512581747089770277755631383671595441338876656144335519905351531173760751478031864420603276943352784059493363441501978276634450241794269447177778739,
        35199974209316898343585067579490476953380075777018987076626863009186266743927730971381827479638041085547388722745741059835582290774825136960169871935004423264989916141173161094695070514855277615545252638959034666701324751981971730562282281239502046990132135948761790977474579423129634297689192964103677276621955159762291683573574723862356554410911921047626911558059310035918953176399943570012927988700583292883422976556888744738481815011214200571742901014167305026217210813187522255094732278680847651363478779048545543260669649415676497074143016142931098269091803146735456295374531500194840812946622191929548318607627,
        39170406580740032411496651603928952559707200659049701782231263094260031669957449970487434668467510939477971456821220149404766328161983515714240761186645811727293565615543594190622851337794310037485427990195449843812906468793879511996847707740218325856059866034313372606753492098966754686672439051960526863368509814265755518276011861982751959654232044259313908101093408414864047853296352972231127984186757976562532489878600642758281722298182010635398656757700816967167172371651156018324652107077204327977516740576520698137004769569078228044612840680931849247403634607713557954954987863431754635264542464007745157365649,
        57893111658768028220916793141241179645975560190226249359387658838808324787747861787257444415977188549247922001496907268733302371531883094135063484215692979156616152724180747497348708599773502325964156018621392816575295915136886985735702710889170485190142979585396845175004554055315036705984963767357579105135280799870998265412744167861300348946962122541668854806361049227754249818506084356655583663168448839691726265723197278760965275831934643798965611678978915050123581796922126186002733115224680222646175082760123895096607095976011450968469103540984952618120838587326904118887466990646662135783892847587413339685847,
        52599343648230240903901541831430015895328412661048973788046850369845485301665619476698434951289207041173036058647633801544273144287653528406311070114369148911169397145614645114735483789229061891738133268670072993978440972911089141171909966637386721837700431122895993458074930665106649331252041687720456990954529038019139759262976625501841957977822247624933390152327977347699156784282433779957071390559248587698554262467562071869029147130110453582018832406954718693389458447219724380899312931839199666692342974705183773650805527154304256891447951897458683948207452231682269185111895462962713939185580844270715092039653,
        35223808991214194074142925787339613626734733466590867543948273332108535615105203571300996055449737899698445303425009481982306439047088771282693694886967165728555266134982525037294668768409005924735039131225931288596023185793757330747400648708754289447883643062501461317611929581424293278034678123658554995496300028908037855156220216046901349364858785965182717475539108387019041649988391548273078285886869761333756069484708034664547693163384348975914208034191352483707461276343392543119087985007185541220060410980879925395451089368681337226285722137312245056618291390056549788661295279134533382424303773245702161279231,
        38099314691683336974348914448889182444680726454585574515406565186861731758257208177282804266065408053922192875722420081381252222085571785716642882230671051053102000289528294958299629240772629327988973763788936402356794423079527410797456222540249900152204303371124746932103027352540798352038951496104616204694410584007232504004017955485159257503922021959481730520149321360797478009729865521031267844957666196882850908154519544522957617416016479777649749592986956454473136365097045032798692617868843525288002208394475055220031817088914374882014525222169281837686466162477674351892191582198462108000491225488929763648617,
        33364236929959006301708274385693745385280567371913083926326746442217823444669608872533307466768981422421735052836839589141543517867912584483869646092778319348512730288797037681238623909255884927895452434527368234159921928080766785863085460744932317898490046739082114089580844588170307248924119365114106045365645610572233130436026442219943461616179571747783716849865959516027246126476004165958377889536581147907595962849966129290036837390093551908912764936926329297551715543699339707273714183005816266497892263116771159686554845460244839254346333376467200831063382682582749395035182863188605844960758393927245942172727,
        60130752388087692781436856034685743750461345928124190071525453470647613444003465842094336710964847557870476016317791016882727974690084307694248857932231697267203795310106397612336046158040144701594782746849578135897032877911888611677236966155020089487378855386824096543881906304391644015282030353793843138560022030367409505328886754140699080319417065362395206754821313167842370755829443565763399019907244571859891391592477066297154690053447959301459566944594949887353138842318661118342988535909498369454593338163141443161419009739907018677986505061809556700329167848882761734579844356972852943899783922358522070946929,
        36411331461203952443643853269155470309364418411250326396878957977703548177131830208722996786953935409676398677774058158294849493371100015310648029394617720775143033516556426941052454698280136811695644283351836990174708770469149085628675775004583462602113745917087656920763246579341525646372440358503471708084546518449632843052125789174505260715592476531753440379373011390148927128697571567894859372044744017072400067224407294173873869929182804994373866167012002045986939030707684926577387827854513732627015284830908363515535505732348742693548559007770363735380352145209492081022541155498935416784539106527612695433431,
        49980331064542919787794858081351425128351638719648324144644223773023989509196361925112273267663648220225907220457158419710111671984993182324436640052430499892102505002105438164702166979087142283191558478561289035148649314438931644743666164814756679003243942023714820706213828270466897845550293663159754758938156092036358343450412784960377240027332244424883321132148837654942657099292085562150515129985147733031223876573116992035580040809024848186051582433717872157372818020278979713546667166277469200051735547415148079425154477877947059288918099086544878269444479824903478090380214335990413316346107044319181157133263,
        61630850862055597070956795320744251044950491424642234920423437320868869409441404945399330720071446982595315876422552974934153031590263760067906779223327075151332335086395205918210101045147324668759588569686934353186975351467449080258998489717854669112235454551240658647572379150318571584121007089760076456378014417854710833135521042786664275587839091499809355457665320979512229774622151781166302595022269869374031991712589741966511345039077083634985459888242821251485702505333984683513514854483911102793411388681244299603099259572260600830143388238841137911408274121262243139186575114338936829795839031938588000123441,
        56216644227254455637848868530530303615871940329061065528672225680779125304373304154630885978731860595213178160689173676858467011112964619360992805200768495384697316225498595652729304041895220980185557834557640137033849815001928337816313878574431819224020903233628381897255680747750288540694016223345324735826959191412131164517737444371004149581842909740099035720352884421826821037505742596676671199066707322091233951840733187392459348955321544081468501957648526399763032588893476137805250264292011237781022873510955348707637686701555446866089032718460660553452909187822325363561997022637036110457248198444138004318823,
        63449735929807399066291809640389629553299975764162915818307637071350633717872351908877358289484441288659772330393389389026924199804925130041970352440770135954974795433932280791114485687708825496639503079268856956903301178279367318522975608521309861337083438255610869324186718761917636845375713036941566153191327953778056283578382188540864842163855260514331189778838231239681852311196362313937620259104026363729520955674248015465349430005761854853773262339524837853163488577911050785195039720602892377385652156871575397421187168891637781600377472181523971306978604819551298454568428558046827283465969861313421056685727,
        41178637431535723322802575673514042645082401273466534615332411227793800882246458797348372830047542614121874451735143111877615915278738944357043350759983404810939897711843188546026011601119109687506620493435262591262134685534475908359343091895752986290229365580715207997454474893221563960265887612589989187630417774814965004307961605860248930464706083375779496241672918073407719149654444314026439520058393630345784329815420865000436012343258738483076559075776395295170940348631271683305242915915489520604874183525701689711059382840081625226069214802801202707296300245773481035424871188026997354565017831250214968051261,
        56712665062294956419372667035543106311930953839132085060234989594133944108759443752153623090532159876021604883014196962968306032815932608965652953164562652376632649669622803644841254434882051912642310625219198715439095045145682018097437997407140813231154314927244420468173163708665037576518137090385651142456017631821721664656481531364941815653969576587111919366359705763806526392668532507553119420849830073484001546205652698802601899752310700686820484783845954104648149285718261080827264593872288902331398227265633723268400164907125073057786183961967015696572008910235541545735555156090287048516124318966068593299191,
        53265951595680144714749166892752357249060464757295829026425859216184054540582869187942167553360995828333810808167105277965653399607562069906048698485970583277281766937406961570455868506751284137866768794995868855837446481472498916177577136040517442201872335277647138170231795811230478150607074558922805847494670041303355186000307328251400025009121490965818968626860779236511519905884661884778654292737480361633034945957663640578391731219826870383502375463636081985042861768552870377294742386347995649293049644842587361704307684902755808796688309818491254857659233326122056655471181996016371018858055301255967301737197,
        43266527512220271410956804447518378699568486754568159223145394164719599067814050552562102202506002002028910730318314965726792587453778175763027047647401259274773263790689610739668216813370084360130041271998586560960574247805538729472674463824836071342577379842467704275111577913995519257609538975642814416521405360515735567690669133227023930198054959912649301762673343440711678178970402194203074457496114186252360806813176464699226008166006961123279719248067984931059618380202248504343715170837089926853018113656873594871670291409080272301217924317545604586674297818200625202984628546068345877116007447055432762456711,
        32601744850196290217515760945170576314008738715852113762417723945828111200128151768503934546104645947005770580538247046767247322579098107674356098586232853183113520793712906064275825565029813078949963403690466705733830890360688242482083982226600946430774955658525188671628719224863322375291245122300571216416451528540384524298260743153935678060310345335383445812422819186533466218837495677004038762196352884693849952996075163675852178569473051664386296433007079697364552480151142556224685429067107688560900690001495106957634958966260276664656738306851619937467494110294627454222261737686701315506320363292797308510323,
        59252380508488773963532369662732427336485559063565024836220956852660393901797781407359689563997475562702437510312780952514190743538566154754115455658285203888619324039949249783153170142738572902861322847398808386046087087444522422190087263838539556760643736881103823046646007788030651613321232837704439396725882924560779053231843677252815174934833346240652521217977074641855462845037034301581277618062603040576747956593317404083171942059402193273697360154987251728426679827123655331618794872424783945511118626697628676788590690983731986666085904484138799683963154915634600359179917328125587205323416891661082480507481,
        62157543839803886130647552525611372830586518506370205382624762825626807600630229538855850986219687723603864316176672852623689733205765971867005410127086409214680368013186778842183527458843368975334648777218190077549869728006784728434316565163629015231698486360569120605251423902506078729000865570521909666083124194072876657560492280264520733125697451605007103915544126588716963301179499512498713366356390973915404622536802172183484394425949149849326895448842116184523991372063917373631542776855646180949979292630402555575574874184810613277284941973154429474526597790922491219600136148257047281480845927700041738883557,
        53345723554594169372172824564609431165534146482394616848450949007701414413005703063822684248867766233796450495879450715635550359023955317867544595531818533653811896763627630438988578079195727160809290060380682478439072498552216520314043112759763892421978065323612660937310779752906259091412609691187479791231320789741974558083800403850077825652039546478775407802790858283783226296590719743766320369420578351394793699116684702740905614749000924454348905859995114553402219710576125665466211196617563615373787741883379781696493218364636323274300753389350513105046233840059678819329036272729444220069983960334468316083601,
        41646848225539654486915098091269776503864424914125199625559503029329425050308042171271978264140649106139470398607809869693169174763204099624207512259694422295490361207566700586585437875677053369644842327645859514047623764091390043576004173809532221299804133004999450368338834474268830045474424511662396535923050331677225459161831603142370040697261513189633195207213586263694049219116030760256285910065708870354480179594259272049054275917965822893240328250932833939076993603682530227933458600193195389392756088494725272416908667847619652559090730340349100031599693805096140363551146619330616872486428383792452902546413,
        58875337892554871069384825101344476685319643590485917490732109593148036221006914777480513479542825097443450349206981915178242229636850322901633408903180608047288190396713159370678761014870859208847281966677267921316723965864997845875996912875221516309579579477780323332500704245441165119392040858307016836388621424440090681162203834826048255402385721326461525975407950600956116502387510050941825000058296931873908239829300038410776029319133551409993988875543072766826004128825247319492956586302617813684359119616300413472499393212841787998175492163139424997924880142337397754089789266366539935421821682810836087537213,
        43229777761892479805699690334134678254440613027212149484479861466033114499005907331975870918720493392889286298246856812284752244266880813675857157940970256257614849425152042465205238155304930077313955944222236281215309640468588483117421237815419297153507929053987971465628824901295300074233615581559199187499690885788941742572414302866162384844138058545485022351304511634801245544552507757946718225045206389919293133378216228286061582606027123862093646651053595558050080014068293722586363011604175347105013791352831941550403519720736006995665960087236325716657667527063570227251824652784154910066385093063231704584103,
        60303993824768891957182679579092574493428784626845634948000388237265088545889907157298571480000124914035452567577343835453696320287089009320862225608399559613648633970737412615409754285743700361202363701946141612617092518779885352541396145955319439790823228704649552410584039752881486886016107133961521741183541600194292215781441773285329030818739660166121818016952998825164555519217794219367995038325616578130382515472749699179528147311053026140747193147538839970006573564274186505870953574429031522189815532541694305635335847970550445964975189640612440246260559146511773261904109562889521234502971624334961567039241,
        35284020385614201299376786612732807271603800316310483853175356292265647262478059092776703982480357942065733000900846398393105237573986478044072173052708221648126022454127355157350712914693350738699644878018647053510280905851933842802270964089035536941070494015825271178045386650718792393012433945993395810094400443877683562675114701625438820514339518146248935164090477931772715080960442322486203612518232863217551723628791344432779258496691739039213384741866885778137829965470263919893889537312265458754661214929684087962453486466738089834754953109937767366252097547320574714445078259866751964481903802257706807570129,
        41286283075418393382405308162674019835635043309583182794113056548808023176671552939145714688112250233439672618716085603528613364188883929697589160844287144119318091678272175564712535589137677405285512582073282184382991814137513470624268714970244480670615112500642639771791574579078489239949983276684296814907732502239369993465343088270218762346806579568425116264249383435506166337545189711400778603159800263074276856026078177018095767555499559884445950365288219295164821484945459265101713272750406791510489842852161746218886385136480352155591019110242070391503158577267044480795592507274122629557623931593065502753861,
        40608094115533400879108030056257606943039659916399232278769408107258848095502646220255830950626295956965526973034857265959019309344374577781892335513371937578777374037704762435002658638050643838842944398539297045287043868322958920011030128338786746732217353675589609442633876317198903116106978461916563851471402538979739455408793854474894544105844247236673924767109502768155338092302448238772568663891160119360874069336036051221302322707361323442843233661868519283337690209070265550360318514435064552795174741185968768556568570111080738742905378446903993140961311675899876161058727674331189125322506548985272921670327,
        37573643764962482238354077844977368206206907501899911540309611096475553664633309769170593920439003000448626990668735630691176995057396166959818241833414159394209685367304847220024867227733448161782905206968668618196606300400825634327131615764016544661562152123347843911878606622580603578336544966373702204800692196963368920874821275124341245528547137454408355520313000738323808791467991064553026975135483922779421452638625323546539952969695739364076873529501979876513810587393874687957788121347762944931016691084650675198056058104190638195359015099549288799866539946087764703684045585154117321137208755951966018027653,
        47022157119938267459622451044287132289343673175460386420563656147229764096666461097545131228019786175131764579103439570521762173085668643743691019369980995642351546411825795602517280140747912520973735143002928292730193791431728402690286079820416963539027793573627990844342984418613533243675238893030554097031474043013442057972789435950332517199953997931139753062932103198621339867612915993490251481656444773149079760433436802722707008726004144947428033726590922018898531477887563835197975655831490472936072345465009185083113013339020104803112433941979745196139526441447500506933557503259920008546747723068502634781471,
        33265286097385944883927754392698978975031784793353397507653082986236959180101575499046790376184823799442746456045186569785763746747539408802092859863623599906846815884370550586647718418306512658391938921118500545073692431261725565707675751291191588384082618735781807370395679996494887629270277599821416259639963599913393848601925601055207159217063577019689744788167955347226096998191828676371625927855321032457287391029147576167566508917706694185214026713659240901251180480191090333294314479664560003783790291429757837222797110364998878738468679949690085304751305593837200775268130536042845757656398474652369424816011,
        64131662960438236967674182155638077941337311533896816524034200463144574911163315397316903019845083167155795816134538328856264881299275416585753031936127302798166560586919189637553729420185484217051380236845188789260009212647079486621306376294052353170070394940937000578840826532536080662627660732546001390044677682520325774339802879914044951014744265828047713142352596780321113419698031891862562174926385879768546933025848632311287025678869278856036482480341192380793939549704704604793083839403112156305736595474657922883344983051542067973836933698980525377453861226873235036925722754307432804416938251753642329532181,
        48481448782564846881271818286483825030760573773315329957324549888761783909157474837906718786122050107504878390559833311313155290732337356850284316066431037775076656486998277042515173873993287758790802045064504358887479276653103025017223824977660047189595234775763498917833386107238584048568786736498283279881462393516469228440743375577373450538760064153183093344797706436644572395613514076101645899131659270038086171577767372449227868691160036853882578942772035746213651307190410826193384862700738611482822481036737942028300932077563939975912871818590206459745750701451330099808124812169149767850516750870883647555161,
        32943660642665620495444750327304085087028454673436420147157113107928146549038892535619686234091164472724370128006408498107361987265974944014849423979046379924145346171251853433399963059508643411380089796914202579196340948785963079602589377036271664190150831712615206632387850950907195693341378609874180463756213667298713865369609516102595686115528168280625868661962540254036081007020356596530623428817243988865844054601846673577138787300767033369871433161111776773926146427573417572309944274310093663142916042767893542123422843767701513398755822318038875687293956234685985381405516919233815205332447794099431832982941,
        45242573828239747619976691360774747172056387512037312539789889997863853537118099911674727724293047515051255496698149575499946695208620984754225466094889413634941959819343106407949341514575280236310083813531780934753406980034869981026339137936631709037740036856220628838977556086529522816655933798536256209557138890592266943743785330490706675499553159039767155051034652461738903409835216572094396032950578555097596086128400259514538623656378930949290669032368288355131115713336321486088089951127360034112946306951332356411968378629782451233236280982640526261951162884856221601169651772195242830330804099065089049371597,
        40936381473740574331591021713766467659581388931839638019096482883794080377902151756570493718640931285559891589811332674433957903432877358217419051971135810748601727454325219395673164151269428888225979955463794194490038577839430307154694940166317876514150738981650627625059066523586520547839857265561892161291388124704987800208589826530414246819602081641920840368614699843382939744184274389352714875942018542955344478032433404911015411242804752647060691841816318160872124393597638276417090444193015672880803788575043511290108878448928668991857519163733314544531799861217975388411998370823391119909123827433379673508771,
        56936852061114780046634316192481828081239298845618314696227996039137796260016394782170823574904540678076849862344579507498723768721010400820022665860593340358381297258132289740216788570971341194608800006013916755011665469999447566701805617991651160105704238368001096988290833739673212584312851486001399089092285341507390582955571288795203526543077964386082127741496004748476934164675971977734587515058917521569598314278644991706007893431627549622316721041395775045390600801001538971527660743266823901571759395055732689159248431013613751881231227872969588778442033915194355484603166107120484801336846481372827659318183,
        50478652050930357212872705430871029186384686404843676474671695208409611093317864211806065229066488331838402323019951668353898400734606657069516763085003146265689113557179357687220252806977896767440297278484113145505559999163717017502268199697798569159474540259478786512664301481077222937492046893897604992803533858934221797509604055028578155242788647510227172674901080005795009238709340836035924448180656063361161290927598941212217905610365388140582276273581585415129756955066948408846488769626251880423848688398329664418010547161482560602622276936393562022504319824954637391876034672259568446358700834527404148469197,
        49358124232301512962683522855359836224527032886900457166743242937245751349860291699349006785992157574712690340530170132399616329025459535372587274441538270113535039806040717489850370680882613095534736237847909540803374202099701385811830785452607144448466727633657461415182927030313811420814509372188002963160726314833717705741029437902774354109037534517166381397887341480384611471505216281048148796500259093783130574130461472551579094278088618100889948950675909962459329213227468919920221644849053276990039408032484461153496120882854423723515209927854274319093953792302407783934489436087921995388958259003250705724717,
        63592058795366660150919358889271105658902992292459624221402069053533250701673492793509059723132593396611093797105444441221927390427090110942040316397377479289467410117415355101315228824451411646960019696207164246208715332538925036894449890498084885190468964547247034858613665772225916007058710558198049989823212801543279079020325936769262060981642241202012951158246820361693288194344856768867650298238481524705582174189164470273655259730365366251931711992081003603337160186504803611988082684761062876367916058609439863839814012123363091423139728155667129620480192440414113475390908313635366597623063425386730409831989,
        35186897218249648782104241701376485790890203451466391823422110981161186862878059274666754491863413813795187049710677659348099043510792747512255467020219223834533929231035315770109826000113393714276042554240086041776376997889088713926551080055458758085257968423423726294479243275845724290194337275761180903760101006010802211863250197722547305667138305110763864681859495292292672835308503987687983140750471288273928797545227635755086648149879656463489268307648743117966384100741430454209329152643081372655014550620781463054138253087842545323050381776174964154241017281209029882890681881351786921769231058882247444818329,
        60235735879525648037226222890028716109571238618667349276801248216060639790316844544244403614628218739622533463210682726059265988985135175985601266329641227960958956140246703773128597940989785766821950075258798855028485356201381312478338393783608434350322768823120630308226630784668755725358645091265076859025586623754284458999300887313145405775336123162782667175098659567173915251278629261431711687074987136564930244313715926069363696845971835310355746425742118066840993319830162903036823887321125295892198833913501249826139081120491362777186921192691788935082479338947852080742156559614537572625586270920913000987711,
        55375819360342213431190044173560319657444563984866019442096135952636718685045857587960118159496488556253198622999980105983926965631214384612976107461993069184072325720075421766039317307722280211080487861823751360614606293763738148970416014574381316392541390933416990801245077291146150243500095344927011007361211559105317510726825395174897345310189699283229953378870240792747044121120854985846481079232699754697865128735447866178913846986697514766219277030087845038600796188974859883039728694568636797007979579191077095165607703511186337271003810498922405925393248133564003171792916076175458941656889152882272797564713,
        46249967171609813747278766094155157271210781056581740833601897567645874877936280795816790075054629288002464268471609706975175949538864194750561276674191712870067035431587595643071287786030249731576127114700379582447082262262307936415399150033498992863541290326529776006906396472653857259866474425305885558561462960011590322138895881447035072923461636689190860310866388983253109851341626386530212511250801720879631878854881190684236800223232944183641950406184033352429277619483423987683149336275766207395378616625350076588348327811260209663699561994425319900066135592034119781765497122500512760464224710551222355567787,
        53739553243052797064467303755284596819900021122890584668124725158980843140742548781618999314064071960419272847490276718824334471297781742551019039223186879129563278218624758187045351327042733824834450899169397653428093881843350543746790079878038226485763561757251762623400607331173957848822486053951675525852169824962487780479938445744629808825386138777654853186418222553309288910035539009588523226465173060631675551333440100388122299587679563834707858614995875958096022100602456597870745773474788881615773088096066643804741556479084526333508412089734654046595298026355845109570554030564795887490989155977654411424301,
        33021188325026335282525901045417076507415976744402944931660341577914960619535737051159979584596455297949634495347518352751362493598745834952371489407203750736069032082586446461477160152126582809283341917098432895403689192810399122254579317934649365917749710977306248823840419188552951067130935284896142643163302535206059437601660150134678717966940096186781810016834621727148680800698043868586824462682241103738405505135073681268431548704697194165227203286799708268272630479401763998502600646508309086414529141771298849486399388045557347250051873366445389794080174570016764686595843675339099892369403176056516884301231,
        42900492764839240139709528460139737124263733647077212652903994573646034340152321659680973348325086397551382000912997216337743435670392954965327972414916089787423893762580429038672009535019487511992751773832742881350817980325633837389434708887520545991535051504331011068753945925189260634510890367871180709329428794960273825740286068622428610873931417465046636552013926298828830101542835575139448340764410771180659978827784814079821817506093625818155506422381901943604053227678398338958365721463401028396357225333295707272228427284020341345325284822522990980238803041886439238863070381133647322054762461129082508178947,
        48418258318542604740651608252639730140454967511770743050153795943748625894511256479390326588337509404315593881265970725704752461381447264346002197993088403314295483255450243225168145753334741582086953962011824595181928726986032243068387380964897820141982952150240698807855078567796389572025863951864475941512447586759166134380677216035809208095382245046012013200325694999486174311627239682615841272786820907233417002378256588839620545324928582151186846273514972105026233179783776464966264238756636003262983377687258295621982698668304521586144421124691360759857492819265924578420427338919918614229564098883878103021319,
        57195200251717004777460639390645199376489842308936182244673617793739959427799214628058169952208969327590771350627568702508859220670040191627601798001752319700819294984421115781391137724878649222667890729342560207796343901381983960789781753800513685212784795414821052385523860837328901994521811436707452946148808799179140105626176645817554724444438915163566110709667517067517221494882149677236169810953807408126860361706877691021375295103995551340086474277756442497843423822613937217482363236333933399097489053314970664859398253156106648291501485828421399810044964903119039521383039050022375896326146099258071398012803,
        58417012124143186433636246816860452349715115852599755512466126449269926475091807646812393919314742350008886730699443355515015191051160490009725361744153521859709663349700596331945846647404969246682647654147309615413796749235489737203214192121677797826522915086843965853265583818637532955892370624137483096215237887096978015361200963293999350166135467518803731444326866935461056106200516221594073934450400149394043842859326211682029966182873888787052539129742286670303324969168027069726584162974537393607145968668365385462042935826220400139508530269196713553788307399315041244479812443173820663832803587814908859168787,
        45549333896063550099786845665340461983075116806388705361858907433013322755968580625146013519502308231454816307198590105450711230290380587219988608330126802637564231517883972564126485614362716460349986560796102043919927721736260028899116800497534781822401405138918174793392325654557999044442899703625218453729979959523325681262972887193330120377271713907691138321372195668373568950648943869655914256889399908424561579914801274264064525208591851442967564169704984745034004510131964966752646115471456990316243512384679598256624974536116943361525143171268030613033408193717146451385483648251681728719981418565917072699371,
        38279639294013843886380676066423079522295905483127638710757537205055994489739922742649641338132316396857607445870759156397246287431968461983625223326363784901685926169298134285450533155793923564434832992832698496401645059234088189745458253777108051027856713885557873046972563731770862993381915411623099819822946704571125553022362660366115695754440895044210677809302293674539686521437688386052982766403607960069935271043935770712182716751037490617641581558974881536917067335271772377136153600246838645170324967795238322734072765330009649610477413446410547744149037624104665264712807893760070123914257582101511286342507,
        52047520339456823702250674594685795093335507399264289474231699954134176934000042684824712568256073749829766863134006037264390450794915783868232047711016178455459383259763644425633582569071497022412296379730278256709205518181706114442148700959119395050859134109735071762781333172847768160096789490390239917860978040633374723693154965653237336618819710963034142131464867570724541390690635959578484480705299711306544633166826866728862881415494906884369943287889063517269019925637133384684541508954634287416449262960559191483189483352840229259288482226797478761646117489600276181243652783666674953187479195917503545692689,
        56877071421978343819857882782798467599867525026699794279302545084963372855175367377492594166630583346218266007767322931768038279032169007013141213216701740309763319401275813377862332862929500920713166273803829333786307915783048132158281165659887735154783831378658945338369703730737471090714039273175940139449631699538295895214491263120783434433417552183665606907174819395457066146453906051512197616103085912165561979017825448002586725852467343629842767583300850460071297878809802313616953371289373468946847961922921315958630811428288992878143190698945424183863752056730867633231539131746696995428356926307485599808289,
        46584513042873128138963065498886371349431267333865363953146233543431726318569651912781645992425658108856497672690998523132931037894345190025625399788280663152141173899134646477355819642846949079898515153517075490072365328241696518149463716452152889407497499761812675630529827683965058021600175872026900771567534053931681270953329271950949139236720798108432989118770320166412593672251954015070043020523012976833020974471204659048392649490063738239452422234790791600902925462600524520641948774383465530672854231688321657185982145185373540646404116450670679491457305900560793241558963477308711700982033387411139194327463,
        46159324130771153865974885557994206616248020813765637497593689149053171024248218195682006689018608473656947439918337790520908482417107208284492768132185969709337327055676068027787047148628502924987772698508709406704777089905364746286123547555576035788122877319661242203940764731521702186972061258680311299740692264748347816564573636647149095572894648064696354469125444119057702031907760996709957799059828646292757578801251169710404127357164810607333612783604646278420450591448821757506099141269996456787481957799013906100385262114385553268879028107697677599199163973748280740466736011689369960605525538954955052252883,
        58229258439488282251339104578736116522992673888741545973265108592710313407837546395485635267753161061441003152948237366437784422682219727287886724354865262324811567678016565658074334162334628932654367318992503253885745639627847131273991261580775273541159636347114862011988240170196887002024437399815815257637309099548679298706809699748304571896255818101873075902764171075590983394245115319397589548676234257933598546274259096051118829449187102690396526116647297025808540297213076822744021372886946845149199924144710758488670309713196626710553913859593423279212253037463895560288096536013332046480455056531520321257279,
        33340896892113424372667056538308471619111597311402064246502063766713614663797659348162305674437707026286059445655628650829605476869330223579817245309162727526062692802435721112424472281658768547740974175693170642649540823083790999725257523961200266747301017330308471058205804009868631655845770195009797507853170569068205888345344067878774270612704355470037973007428815382865928544081039965857094973347099632392273220421358553087090750769556181064541093321788891583122905051412840731051455468885272349434743049004306360697055412821261522818249866799513839838794692930010666842992564478631661345557587010142586901710677,
        58227721932618309503853333330166597681283193189440061178092018863883919585819066505895132246307663695846689895238329204852255116049431954991169468608295648343565351878259904939901867566114714814190797696958021626379716370296462196147950431524609562905186824210574382105478776431636514191001374079263933203192480936159952080526690830109845701070041177359082262896858955565918673752174926890291713035826129308969572353113000598755540101674019605035871967753397893907611124009186209123013849688954625083610562772233180086373345753668547210694555331739746242163331420617477054304970757427027055654831862512435208570093841,
        46493643301275896482988018075045198567511290738647174614216690594486923320877083565175701809078788759900794791117204109925365085990582899240902490288038438367039681548605465574364333874616676958941199517050844857885562235265243033715068578723858435286874853820442008910201403108621971898120975738612788111304115010023508531922802808777728796069633927306248510175979605939342838268554983277180731752384771188579722455846188139546451724943939973551518879893484210725829509495627706502964552516242528729323723926857463166552174143214705030744903416109446227115310415159663320592191332663575198205750351960120617416059199,
        36451001434503437324120574132266113634967691146005979405057845741554984096886627714591162187556906275823362494895965910128718851112915375251193792617752526081845938761825781334949353457178460350205049035437224562897460852646471255307375367945276687375914150167342821731358942001881049016282427305712059670227514408696923077948042801011383398299601671340917545983003126518617890526949059398008760743264330267923583690623736466673322678178505630108214042823841830805377376678102110699227138753042575261975454394561259478275830041327057602617013203333079397061122472323912796380247984811279778854122241579499514558588891,
        53716644863258406131509448999564964253822856445548435200258474410859827798180520194435744633881607322103376718680456320386598732941579861243633852925680682796975869664842876242739151371125002631064312667301428088041319937470104478070433518978221773789288090308008580699023034244143871243512171187689719270686163378518999879167279451746254512645437219182970420716712264958165162870175407283808370709913712709102680946965273620522305871181559470929997346879218007232941523658067445503716079913144554471587742883290447829814415112502573859037343425137998728456209055792857024004615677693247467776999889209953427605893109,
        57426438657877599046273282185596431590708195665858939378380653151635907799801753372180173521229379110099651843330782708937760597179053162246910626237091064868803716385405448948313522286332581058121177211077136478938770551436737763682563472514849470354383647575060879397116664542093554699035967342817904414431873265784466264026760521177893645506985574194745736022151896814330936579381303031921783034288354012350091020476123797775025801399836470531391698726132099172831916193684295650541844866587455377976569091650530500803461646640982565367469255594361398518431823292535429851263069561767552771613739129807977279619123,
        61485190677651187886272271321717943137992525109087436629532956805592747272092436446903131850331830023191705247218735350473982753684086052297409649063970729551749017499134326609595772755036462148607499457387064941514111299715009532864487545304049139454508277514320684087814243406844537420650647385823345409486338683764367355054210858573143820635389116350459815989600901620720693834595116487078011112312870617000078270137349421423910227709348452836075747042872478399806374635075293551192201633679764535813131911082416544605444427717417679459602049168586942017945559605379376862699275718779769177468821184196642284283179,
        33228558271005937309096445583086957724874267096009208859460881444944919538327945953498296186041056343338785583343324555989665819118152672247903668048998226472613217054730853620550866115359309566210853394580099911752322421750505581819816964986475843843997894563271905163836764147385805119333735222631439104665630026851759121492795526824175970871579435209449898044214514204470432508875957028328840240259878393908659326541307520523848908161125885195284975919983506280158670233203414385459087144287263582512122616185677470395903758671015098865772469488876065952804955991374880058419980865419715183922497257538821247592941,
        34657420323227308606233607690226247560771614136277431914046803023785839419716391281211523943550890423202172945296937312063538277373487533104750743676862292254271515976642470822401147818638452964686738153700761331482431586753204306594473290495597199208838692182027110805396212080791835899143652318431713769797584418291697645108793804144998951439732014336313043895358019389918758090463828842931470402554550343365513591411734040891159393454865921158606780307704622059115110602405145708147485175832876427301195350017351421367899204686589308281020517373751972723539967246538254322030655559625198690461965955390530596573917,
        32404207225037984909104517775537010113224807644595350445383775206497525908127459883157204683170867941872403989187034965832063954864011606758002111573457448240889185449439688237898355292525330658146851682304181618107183471666862949215642651300428631760395221911040433732815533665679477145473189987365706887721371013987738263579002990278123755499417396094682432465884362400740537080192232736055679310795610145623834450403110094383216363075614459852187913230561801754554493572269250208984649376734080389890535897002399284988161588780875716001552977276807882345593363898779752227595857878812272137494109028545495666669883,
        59317264751663460831013961901224116697491308643083299011856798860003659493438255170274452081210733360516745810511543185747895799427312944089466789378928893134895852267532064168958205869204440771453954976809088353562974716893060437190593575059331511208370884412660853240571817828676900772771939440358685705451744172322653228265027000328477728435996426126797286852516616778804540345882918795136758818543938926898946931772720688770666526767711875315068532754826360304120645723994849322829647017703045835048316011257580561206794045384170794485629056977344121204459188063756970594817523995825830310875474959229370138428857,
        41792013091463622845416815411087859688682536041361534826877803541892069766384491933283536336932679852049169743258638540156307797445606328574629056877613756065996611243374322881754262765030264500832395515526591841860544103755227724167919570084613206995162865508365419110542610500132320226571794176305295248870930220875419884212617574808997718967927243158505667382933690454767707479566217298406724443653948680735622183632792207196325534768172221920846142286628359482153297490555020294437229696663049287445680318905448685947106088174814389027270217300702853417008546633798143232244362145318798020564732917851096162344521,
        41609596984005762559473445628829306853697524113601678321961642450267407332324715196728101481694323888764981523023615751701572662194207735854201903277829610896860299804671167852409058331758024929633358890482769444114171153606140598669206702058601232562123719136448195277651928142446146632802843729805323817026315512411261206860224060065662217803479811522376485462454357000791916608691499309233485130089152782080998806672598711243937026160718697423106881639076754586431160719904985732400982201688314302837495220627160257521987121180268442439824005461227514184593760707027373770797892151032106980669362101366127915529339,
        32327652654350244023567659366267849173714119303014868121342689484178421909423392542680599343142840822497524759492305087876595516174450233464524802529296317530688501178882675043003655450791751365178215358847563388577761464309134929849120986976996160456316803919631031651871711731788937116873519762783420695508388814110941169570079500921436916236707345757726378023893697620028274972468774921249795619181427203333587909808995070719414378468349250510530310163159608344369548782484860227178829007910560435071065200134092649604564685991126594767043503293336948146298417761044860940182027617991346443618567425339547320366809,
        54507308855503425900757577579729757975890325998398374762264228324038693136529224666305494403119402568437702246876487854500011844410240696718551566980254665667060609947323486313913308775454948181399476993272937299856766264565709198656462400707631687575309128572898509449275364525536685015897358235146568716504155350360778375074911637978652881226073873655581204432971254613125312933074324868196355918089310426076099060996145542847686998993408708330799200830198232890818633534713237494044382883471461398439829873043838323651209397378888830350431654132765464645792849023866878612109440159116212566536067085402280659122787,
        56151772085219258421751941956046390894446946218320012179708828066509325218004024685597745804335809169132493287092527176863682208651235043835701605820632185901687379338004537139334794280689045672453742348544836791335671736248808772412705334658072672949006259342673652314382548043168033658431471113753627907734890388123697728847017938300289299473700549975613970854628348790656656089538533125144736603140967504080822854856912589399104010205941437622729697681031629745003502091598726599432768205370973420710723868382909194685907691646142204568135170628300835079702458362504537919350938781442645705127182269943629540822659,
        49588293656763735278154338741189609039509791491881849965922817983080668836587264497957277906163053201082535791098849459705559884390048885833081998404707947881012526980426588073096500620632292034870086255974817314850510572230015440235189429510314615883182879047622540922087213304805409946941666117482570565502987189943199021670578443580134290747615421005960023307472574594151864983482040027512820177198746753542603432583802890036765644727267302919026275417004682914457553581015535826695153131408545545154674514547620766903398444277453287077193643023133384517419362835984443262888531531904890959655980019199678890846153,
        37726245489853420289409567589695590257180413901253169427367187426543853795974362205987955264425256263412156157838315951736404103011679888693676528888248577786405108720519157705136627983803854637077488318719140971518751926723529617537536066818909579598593409572807956711567867411721414939234896010860173557683683071798921064556755269891659042999383338364409155716398539026801893472436805672804640052342780737895306427638302971340038031609009457720638765993621547283200372019449601290125785194343010954380916649199615302962109640247669184615959572341281089850714028892912415439188533808594686668125217857324524968873421,
        51470570587033762495055661263533239093240024568284111688428089607477151923862049241561209778397019185369264433405645519642545233633811437687288525704658095178996896220128586663631892318405206269824961113749315266670691565833059264658352733903834649253290136324396141274545176720795326423126593581850542272451430310354236056229396809548359649874177673986034831188966196915727040032916583105402696328157323414201631906426222357211190039447130231820985672207709938284935413340762669396517466795611574205106659822406134446034730340395242671775258128144744556789269160452596263933525518216775919648415492615027756229115481,
        33244242778647263658519814075772881920665796383469309829785222077337367368884655299586451899194443308777955034292310115100163957648494800884993694383219821027872247920577506453672593695097099652489533128276555132120352584441032304839685883072856831024569752847814669823659859255965418135087162105594232811341536460223303244966859155633511214952931833375593172897128991687026875965595232236664544243917653707127561855229570909339280198292801154843283435511341041269177114088284387511978882199578322368509494677422508556779233191479989530783822342902425267780603739759132099839632430167074120745665051097068350393831549,
        46431438570795388873200246547128044908225409700058450340765494828865318927658339333828996064421361193894592664626656274449445021344564297135519758212263171523445799332969009720400993590257035798720955307530113248439032284914916962666619656198059693947829065614619929844384451348788804782392453957512952754069108086304285418739216917790973918386854066115304424425044140062949486763883879057610864721523846684960802760307560971925970309644177286685761809277585107405705266857959355869532937366087046251842381224014072020367451130606130677598588190574429657837099729257766820117054905954522137233365381365411032045135791,
        36853978887196920839277904699664436045892322281656543817321900681738773825004523082021142268137267813206738171515314735075676744781175067799425961991182364832821746510821597245368659748864450594747717330644977048559668573631755900192003100826175795235280472609811915759152121496202601957709507546725584806503975749770530794589370537449101977690195175028605758042714430928796168132325455237519733797568624152472539057225018861821688262885998799986952066593580424817905911826148695706145259716940118631092504106915382186839080800256978905767144962238643161571392882799375407661881197331322542727364331904143951205006917,
        45612969136998790049589191933376912496377142240201717635270384689203478775113541185646121951274913972672945993258663733648986892844427396271787343524861048446078075458698841832287586744306160029193508477513217135197296420333416063287702958387321981675391119253863227658012935571985701436864848873032343934900217237132228787888470327463673302442112339328693103745917278812137748617738105408080182709595505785419097978571830116217198927960266824501764151323131214540990362916163227156886384437731052753781934977722540439128438306128166882143087246047746870763519600181186373435072402927436318833255464570494853133572381,
        32591189340238972718627537400894990865211876730496867538738053143950276203552000346680229228216845233552667843158991172280858846380647071662634488237513131665190417106666810297489048496725217330416481767990988298082612811574235899935032285500244485090345882299987635691967709542131928945022713063045374146190327654759340227628919775406824569301834421815909689682829836689481486034043270180232204752522706324848078384408678792134441009094254090956382768619341328272493597468307728025510655358839288739633911371013544039436185946075662291824881833319539449605727416710176621006460056882062509170374270456545242314978469,
        54589651511197224977586595909410600715137821282582885524452447765989504115573956529277913238140036672118348498382279782229460090008343735889340000440681967319403272192947782324090676294680832233915618146949530322288002036180674540975740149602001317429931286075105616544268373057543464943147876409993343336795892941147184712219892218760093645482228625139131750995410816385796094860905640016885727579484442822331768556953714366322863656083052290067515427124836760598915447385436693860190851628523077373361735259603642589755638379458365878453931127635786922805090577899317185473401230136125468438664706717779443276432043,
        42264346717996417895264576735778852955217489482102570691228635011029332342707888867165732100599175537230513800899864096122440051801620755339953789472723865854711972656213035196450165720917539364784292384029788784188711475297708788498761884753057268745110367438479821116545599534732793567961698311046546455887015684677356074276032519644083670250842906522875454195880022859824354721630875546265540591064177230299635389204495042786364245629768669721863872643478162882412029561950729603997197514059934046225017798429175642671286095204484481513845757187403938321066079052852509329490849091366481761247886928765658314875689,
        39713488858842613274350548537339100806529524255920580668556544933026766618709641761257457339780513978616194977858457913066106208058274365147608565108257721220666007708714300184611388912804279557804540279818463471381587511736529302356844057970655455390247976943288299632281228703531430182720482880294932124345515884748225624664612210897495934006823540133781105794690544998574832924166456109022356032880689673668269254924456854163264299305097340782006394959871743401813279128555347771026425181128114031067170250422155242685146455722907305855972490829257207917050793457869371530977275792967454176425561333107580254191409,
        45293487980268509889755852043005880838095634240875025074671623819042622566963485098135129897256982985826342237135372834102677628593262830076884514183348145227269949156342818044811917339649111705301136432435821393549256126717942811192353098318602889843799575312776972687592136948284981969333607595361557558947701994291712249693269749140678981827731583066503073018205647223064815396222350079480601289306215719739556188766602204357219461014858986044126711739622375861179357885434767090933874018863834800066905186091369231225071952358632219938216997643725849028432793791862134270690744459111301181564438406216089357121981,
        35159099602458247027218113859385607953620201440821418303196974852332815987303471887708706966700104775378823538919230587147023393965124384168252485095827401211499958624152170842582983628694117668173744909904471432303077791685123534305231373375088165715449528380842809013550562261963092154892463057209111122231146317541626515598313045602426221233661624449955579634738490822322296641836622565703891464079890722817716302298236559731039002545684940691891399560963176456854507569043148607857440868932560667646342601907119651701004780829994842589097902924742986805349669707010339013772388548530093580797328728435872130283857,
        64634012142622014601429753377339903920888205339430968064260690855049310277735781786394402823045826927377435921843796038988239118300981842190176304772896566241261754734601992183500395500779304213592115276768135136553584437285239512323676188676952340941163291704072610085775151783082131617215104798247860771043828666779336684841369949573129138989712352070652644116155611318662052385416920628300517185728354233451887207436923714715196702304603291808807395226466574462454251369421640419450314203453862646939357085161313395870091994536705997276431050332778874671087204270866459209290636957209904296387111707222119192459863,
    ],
    2049: [
        64634012142622014601429753377339903920888205339430968064260690855049310277735781786394402823045826927377435921843796038988239118300981842190176304772896566241261754734601992183500395500779304213592115276768135136553584437285239512323676188676952340941163291704072610085775151783082131617215104798247860771043828666779336684841369949573129138989712352070652644116155611318662052385416920628300517185728354233451887207436923714715196702304603291808807395226466574462454251369421640419450314203453862646939357085161313395870091994536705997276431050332778874671087204270866459209290636957209904296387111707222119192461539,
        129268024285244029202859506754679807841776410678861936128521381710098620555471563572788805646091653854754871843687592077976478236601963684380352609545793132482523509469203984367000791001558608427184230553536270273107168874570479024647352377353904681882326583408145220171550303566164263234430209596495721542087657333558673369682739899146258277979424704141305288232311222637324104770833841256601034371456708466903774414873847429430393404609206583617614790452933148924908502738843280838900628406907725293878714170322626791740183989073411994552862100665557749342174408541732918418581273914419808592774223414444238384915301,
    ],
    2050: [
        129268024285244029202859506754679807841776410678861936128521381710098620555471563572788805646091653854754871843687592077976478236601963684380352609545793132482523509469203984367000791001558608427184230553536270273107168874570479024647352377353904681882326583408145220171550303566164263234430209596495721542087657333558673369682739899146258277979424704141305288232311222637324104770833841256601034371456708466903774414873847429430393404609206583617614790452933148924908502738843280838900628406907725293878714170322626791740183989073411994552862100665557749342174408541732918418581273914419808592774223414444238384924059,
        258536048570488058405719013509359615683552821357723872257042763420197241110943127145577611292183307709509743687375184155952956473203927368760705219091586264965047018938407968734001582003117216854368461107072540546214337749140958049294704754707809363764653166816290440343100607132328526468860419192991443084175314667117346739365479798292516555958849408282610576464622445274648209541667682513202068742913416933807548829747694858860786809218413167235229580905866297849817005477686561677801256813815450587757428340645253583480367978146823989105724201331115498684348817083465836837162547828839617185548446828888476769844959,
    ],
    2558: [
        108325052568731694825308930748782632281712981078063391569207841636774413988317069718397999842113439843838114780160527292318560027655210879492525577806114606891011654056790278950415538089848862989723458870226252561675809860925481363435920931734697441985144381138931090599259839646862062185248488927095579270882962783439632883211173576184295773354642797513323249429103453928604435108563578917566833888302401636347475239663385425554691915718237277499865149249781429788942116694610807429979794933972744634256644012526875217335078547221775273815834966475270196786442978930592180211130462760093895572818706143611115604960479046718764593601082250812674643708058963967792099785020570725179607529143904274264672933816729426335346542904613168265881696009813157760509247233137312647,
        216650105137463389650617861497565264563425962156126783138415683273548827976634139436795999684226879687676229560321054584637120055310421758985051155612229213782023308113580557900831076179697725979446917740452505123351619721850962726871841863469394883970288762277862181198519679293724124370496977854191158541765925566879265766422347152368591546709285595026646498858206907857208870217127157835133667776604803272694950479326770851109383831436474554999730298499562859577884233389221614859959589867945489268513288025053750434670157094443550547631669932950540393572885957861184360422260925520187791145637412287222231209920958093437529187202164501625349287416117927935584199570041141450359215058287808548529345867633458852670693085809226336531763392019626315521018494466274622779,
    ],
    2559: [
        216650105137463389650617861497565264563425962156126783138415683273548827976634139436795999684226879687676229560321054584637120055310421758985051155612229213782023308113580557900831076179697725979446917740452505123351619721850962726871841863469394883970288762277862181198519679293724124370496977854191158541765925566879265766422347152368591546709285595026646498858206907857208870217127157835133667776604803272694950479326770851109383831436474554999730298499562859577884233389221614859959589867945489268513288025053750434670157094443550547631669932950540393572885957861184360422260925520187791145637412287222231209920958093437529187202164501625349287416117927935584199570041141450359215058287808548529345867633458852670693085809226336531763392019626315521018494466274625771,
        433300210274926779301235722995130529126851924312253566276831366547097655953268278873591999368453759375352459120642109169274240110620843517970102311224458427564046616227161115801662152359395451958893835480905010246703239443701925453743683726938789767940577524555724362397039358587448248740993955708382317083531851133758531532844694304737183093418571190053292997716413815714417740434254315670267335553209606545389900958653541702218767662872949109999460596999125719155768466778443229719919179735890978537026576050107500869340314188887101095263339865901080787145771915722368720844521851040375582291274824574444462419841916186875058374404329003250698574832235855871168399140082282900718430116575617097058691735266917705341386171618452673063526784039252631042036988932549246901,
    ],
    2560: [
        433300210274926779301235722995130529126851924312253566276831366547097655953268278873591999368453759375352459120642109169274240110620843517970102311224458427564046616227161115801662152359395451958893835480905010246703239443701925453743683726938789767940577524555724362397039358587448248740993955708382317083531851133758531532844694304737183093418571190053292997716413815714417740434254315670267335553209606545389900958653541702218767662872949109999460596999125719155768466778443229719919179735890978537026576050107500869340314188887101095263339865901080787145771915722368720844521851040375582291274824574444462419841916186875058374404329003250698574832235855871168399140082282900718430116575617097058691735266917705341386171618452673063526784039252631042036988932549247879,
        866600420549853558602471445990261058253703848624507132553662733094195311906536557747183998736907518750704918241284218338548480221241687035940204622448916855128093232454322231603324304718790903917787670961810020493406478887403850907487367453877579535881155049111448724794078717174896497481987911416764634167063702267517063065689388609474366186837142380106585995432827631428835480868508631340534671106419213090779801917307083404437535325745898219998921193998251438311536933556886459439838359471781957074053152100215001738680628377774202190526679731802161574291543831444737441689043702080751164582549649148888924839683832373750116748808658006501397149664471711742336798280164565801436860233151234194117383470533835410682772343236905346127053568078505262084073977865098493337,
    ],
    2561: [
        866600420549853558602471445990261058253703848624507132553662733094195311906536557747183998736907518750704918241284218338548480221241687035940204622448916855128093232454322231603324304718790903917787670961810020493406478887403850907487367453877579535881155049111448724794078717174896497481987911416764634167063702267517063065689388609474366186837142380106585995432827631428835480868508631340534671106419213090779801917307083404437535325745898219998921193998251438311536933556886459439838359471781957074053152100215001738680628377774202190526679731802161574291543831444737441689043702080751164582549649148888924839683832373750116748808658006501397149664471711742336798280164565801436860233151234194117383470533835410682772343236905346127053568078505262084073977865098495563,
        1733200841099707117204942891980522116507407697249014265107325466188390623813073115494367997473815037501409836482568436677096960442483374071880409244897833710256186464908644463206648609437581807835575341923620040986812957774807701814974734907755159071762310098222897449588157434349792994963975822833529268334127404535034126131378777218948732373674284760213171990865655262857670961737017262681069342212838426181559603834614166808875070651491796439997842387996502876623073867113772918879676718943563914148106304200430003477361256755548404381053359463604323148583087662889474883378087404161502329165099298297777849679367664747500233497617316013002794299328943423484673596560329131602873720466302468388234766941067670821365544686473810692254107136157010524168147955730196984943,
    ],
    2562: [
        1733200841099707117204942891980522116507407697249014265107325466188390623813073115494367997473815037501409836482568436677096960442483374071880409244897833710256186464908644463206648609437581807835575341923620040986812957774807701814974734907755159071762310098222897449588157434349792994963975822833529268334127404535034126131378777218948732373674284760213171990865655262857670961737017262681069342212838426181559603834614166808875070651491796439997842387996502876623073867113772918879676718943563914148106304200430003477361256755548404381053359463604323148583087662889474883378087404161502329165099298297777849679367664747500233497617316013002794299328943423484673596560329131602873720466302468388234766941067670821365544686473810692254107136157010524168147955730196988721,
        3466401682199414234409885783961044233014815394498028530214650932376781247626146230988735994947630075002819672965136873354193920884966748143760818489795667420512372929817288926413297218875163615671150683847240081973625915549615403629949469815510318143524620196445794899176314868699585989927951645667058536668254809070068252262757554437897464747348569520426343981731310525715341923474034525362138684425676852363119207669228333617750141302983592879995684775993005753246147734227545837759353437887127828296212608400860006954722513511096808762106718927208646297166175325778949766756174808323004658330198596595555699358735329495000466995234632026005588598657886846969347193120658263205747440932604936776469533882135341642731089372947621384508214272314021048336295911460393974451,
    ],
    3070: [
        1452401498842489515714875633326143592671743794090723809165371538071800932749277556434334011133279601812831539438745129360997632398635011780415721418046758100258027909926610124711012462747262906800061191451760453098682420135006026206994146092345380573090302194761192473185806437934519244892202827394781377833273310879888446204076595395040465050061873142112037560628826112394296901034107184645247543137893483536563957591601478750217410933013304641708136322776975930707908534649896601672581489931296861792264885201253077552409752937687190004273840183558736439354068248714003327154239632489576169409254795398522132086265321465974567940864323720886659719888577903861611582549813595585004073014272687793883472040479746823897882884174675323066921366379359478947705788711158695065025722929508123849018760474871378452781744326869742268714260927679037530328980506139189810309753288229927739117101594860728735403589276978615641832423619,
        2904802997684979031429751266652287185343487588181447618330743076143601865498555112868668022266559203625663078877490258721995264797270023560831442836093516200516055819853220249422024925494525813600122382903520906197364840270012052413988292184690761146180604389522384946371612875869038489784405654789562755666546621759776892408153190790080930100123746284224075121257652224788593802068214369290495086275786967073127915183202957500434821866026609283416272645553951861415817069299793203345162979862593723584529770402506155104819505875374380008547680367117472878708136497428006654308479264979152338818509590797044264172530642931949135881728647441773319439777155807723223165099627191170008146028545375587766944080959493647795765768349350646133842732758718957895411577422317390130051445859016247698037520949742756905563488653739484537428521855358075060657961012278379620619506576459855478234203189721457470807178553957231283664846661,
    ],
    3071: [
        2904802997684979031429751266652287185343487588181447618330743076143601865498555112868668022266559203625663078877490258721995264797270023560831442836093516200516055819853220249422024925494525813600122382903520906197364840270012052413988292184690761146180604389522384946371612875869038489784405654789562755666546621759776892408153190790080930100123746284224075121257652224788593802068214369290495086275786967073127915183202957500434821866026609283416272645553951861415817069299793203345162979862593723584529770402506155104819505875374380008547680367117472878708136497428006654308479264979152338818509590797044264172530642931949135881728647441773319439777155807723223165099627191170008146028545375587766944080959493647795765768349350646133842732758718957895411577422317390130051445859016247698037520949742756905563488653739484537428521855358075060657961012278379620619506576459855478234203189721457470807178553957231283664849139,
        5809605995369958062859502533304574370686975176362895236661486152287203730997110225737336044533118407251326157754980517443990529594540047121662885672187032401032111639706440498844049850989051627200244765807041812394729680540024104827976584369381522292361208779044769892743225751738076979568811309579125511333093243519553784816306381580161860200247492568448150242515304449577187604136428738580990172551573934146255830366405915000869643732053218566832545291107903722831634138599586406690325959725187447169059540805012310209639011750748760017095360734234945757416272994856013308616958529958304677637019181594088528345061285863898271763457294883546638879554311615446446330199254382340016292057090751175533888161918987295591531536698701292267685465517437915790823154844634780260102891718032495396075041899485513811126977307478969074857043710716150121315922024556759241239013152919710956468406379442914941614357107914462567329693649,
    ],
    3072: [
        5809605995369958062859502533304574370686975176362895236661486152287203730997110225737336044533118407251326157754980517443990529594540047121662885672187032401032111639706440498844049850989051627200244765807041812394729680540024104827976584369381522292361208779044769892743225751738076979568811309579125511333093243519553784816306381580161860200247492568448150242515304449577187604136428738580990172551573934146255830366405915000869643732053218566832545291107903722831634138599586406690325959725187447169059540805012310209639011750748760017095360734234945757416272994856013308616958529958304677637019181594088528345061285863898271763457294883546638879554311615446446330199254382340016292057090751175533888161918987295591531536698701292267685465517437915790823154844634780260102891718032495396075041899485513811126977307478969074857043710716150121315922024556759241239013152919710956468406379442914941614357107914462567329694509,
        11619211990739916125719005066609148741373950352725790473322972304574407461994220451474672089066236814502652315509961034887981059189080094243325771344374064802064223279412880997688099701978103254400489531614083624789459361080048209655953168738763044584722417558089539785486451503476153959137622619158251022666186487039107569632612763160323720400494985136896300485030608899154375208272857477161980345103147868292511660732811830001739287464106437133665090582215807445663268277199172813380651919450374894338119081610024620419278023501497520034190721468469891514832545989712026617233917059916609355274038363188177056690122571727796543526914589767093277759108623230892892660398508764680032584114181502351067776323837974591183063073397402584535370931034875831581646309689269560520205783436064990792150083798971027622253954614957938149714087421432300242631844049113518482478026305839421912936812758885829883228714215828925134659386551,
    ],
    3073: [
        11619211990739916125719005066609148741373950352725790473322972304574407461994220451474672089066236814502652315509961034887981059189080094243325771344374064802064223279412880997688099701978103254400489531614083624789459361080048209655953168738763044584722417558089539785486451503476153959137622619158251022666186487039107569632612763160323720400494985136896300485030608899154375208272857477161980345103147868292511660732811830001739287464106437133665090582215807445663268277199172813380651919450374894338119081610024620419278023501497520034190721468469891514832545989712026617233917059916609355274038363188177056690122571727796543526914589767093277759108623230892892660398508764680032584114181502351067776323837974591183063073397402584535370931034875831581646309689269560520205783436064990792150083798971027622253954614957938149714087421432300242631844049113518482478026305839421912936812758885829883228714215828925134659388543,
        23238423981479832251438010133218297482747900705451580946645944609148814923988440902949344178132473629005304631019922069775962118378160188486651542688748129604128446558825761995376199403956206508800979063228167249578918722160096419311906337477526089169444835116179079570972903006952307918275245238316502045332372974078215139265225526320647440800989970273792600970061217798308750416545714954323960690206295736585023321465623660003478574928212874267330181164431614891326536554398345626761303838900749788676238163220049240838556047002995040068381442936939783029665091979424053234467834119833218710548076726376354113380245143455593087053829179534186555518217246461785785320797017529360065168228363004702135552647675949182366126146794805169070741862069751663163292619378539121040411566872129981584300167597942055244507909229915876299428174842864600485263688098227036964956052611678843825873625517771659766457428431657850269318774263,
    ],
    3074: [
        23238423981479832251438010133218297482747900705451580946645944609148814923988440902949344178132473629005304631019922069775962118378160188486651542688748129604128446558825761995376199403956206508800979063228167249578918722160096419311906337477526089169444835116179079570972903006952307918275245238316502045332372974078215139265225526320647440800989970273792600970061217798308750416545714954323960690206295736585023321465623660003478574928212874267330181164431614891326536554398345626761303838900749788676238163220049240838556047002995040068381442936939783029665091979424053234467834119833218710548076726376354113380245143455593087053829179534186555518217246461785785320797017529360065168228363004702135552647675949182366126146794805169070741862069751663163292619378539121040411566872129981584300167597942055244507909229915876299428174842864600485263688098227036964956052611678843825873625517771659766457428431657850269318775093,
        46476847962959664502876020266436594965495801410903161893291889218297629847976881805898688356264947258010609262039844139551924236756320376973303085377496259208256893117651523990752398807912413017601958126456334499157837444320192838623812674955052178338889670232358159141945806013904615836550490476633004090664745948156430278530451052641294881601979940547585201940122435596617500833091429908647921380412591473170046642931247320006957149856425748534660362328863229782653073108796691253522607677801499577352476326440098481677112094005990080136762885873879566059330183958848106468935668239666437421096153452752708226760490286911186174107658359068373111036434492923571570641594035058720130336456726009404271105295351898364732252293589610338141483724139503326326585238757078242080823133744259963168600335195884110489015818459831752598856349685729200970527376196454073929912105223357687651747251035543319532914856863315700538637547881,
    ],
    3582: [
        19473520333640844691127176862977149658590968948136526555247820243011272528285939061837707013418630693601041476568594986448123729387077643515811960411020482474294659386532350316053903539988147515390538730103863099146708934871245522941906322189870389962117919361028202071764176745980651257550452869590472617231874558907485685927367574648809115885947602724023790934518369995350619469561613808778207297256942426414559305648709312602649150614261853439607537507462932895730385881610561381979306213956956954155371387764484350419237234585750558467856203620817475676959043251863760768656792160668177150351045377597021414213264417090418226523925105259413550636485086184257591644591589393199898495538890080330871093821347753938084388897294966205185738762080099421245687443300643061380644532328158133536192948933806592507527238139734445474775820534266432764308034618758576637009643867006811192758495822265172889202823244282947775986251889156602254569864288788917095347237435709225746335486741183724272646028951741973332877875405120448636089315222389626215827597972845678291201404256024267047,
        38947040667281689382254353725954299317181937896273053110495640486022545056571878123675414026837261387202082953137189972896247458774155287031623920822040964948589318773064700632107807079976295030781077460207726198293417869742491045883812644379740779924235838722056404143528353491961302515100905739180945234463749117814971371854735149297618231771895205448047581869036739990701238939123227617556414594513884852829118611297418625205298301228523706879215075014925865791460771763221122763958612427913913908310742775528968700838474469171501116935712407241634951353918086503727521537313584321336354300702090755194042828426528834180836453047850210518827101272970172368515183289183178786399796991077780160661742187642695507876168777794589932410371477524160198842491374886601286122761289064656316267072385897867613185015054476279468890949551641068532865528616069237517153274019287734013622385516991644530345778405646488565895551972503778313204509139728577577834190694474871418451492670973482367448545292057903483946665755750810240897272178630444779252431655195945691356582402808512048526311,
    ],
    3583: [
        38947040667281689382254353725954299317181937896273053110495640486022545056571878123675414026837261387202082953137189972896247458774155287031623920822040964948589318773064700632107807079976295030781077460207726198293417869742491045883812644379740779924235838722056404143528353491961302515100905739180945234463749117814971371854735149297618231771895205448047581869036739990701238939123227617556414594513884852829118611297418625205298301228523706879215075014925865791460771763221122763958612427913913908310742775528968700838474469171501116935712407241634951353918086503727521537313584321336354300702090755194042828426528834180836453047850210518827101272970172368515183289183178786399796991077780160661742187642695507876168777794589932410371477524160198842491374886601286122761289064656316267072385897867613185015054476279468890949551641068532865528616069237517153274019287734013622385516991644530345778405646488565895551972503778313204509139728577577834190694474871418451492670973482367448545292057903483946665755750810240897272178630444779252431655195945691356582402808512048533667,
        77894081334563378764508707451908598634363875792546106220991280972045090113143756247350828053674522774404165906274379945792494917548310574063247841644081929897178637546129401264215614159952590061562154920415452396586835739484982091767625288759481559848471677444112808287056706983922605030201811478361890468927498235629942743709470298595236463543790410896095163738073479981402477878246455235112829189027769705658237222594837250410596602457047413758430150029851731582921543526442245527917224855827827816621485551057937401676948938343002233871424814483269902707836173007455043074627168642672708601404181510388085656853057668361672906095700421037654202545940344737030366578366357572799593982155560321323484375285391015752337555589179864820742955048320397684982749773202572245522578129312632534144771795735226370030108952558937781899103282137065731057232138475034306548038575468027244771033983289060691556811292977131791103945007556626409018279457155155668381388949742836902985341946964734897090584115806967893331511501620481794544357260889558504863310391891382713164805617024097058387,
    ],
    3584: [
        77894081334563378764508707451908598634363875792546106220991280972045090113143756247350828053674522774404165906274379945792494917548310574063247841644081929897178637546129401264215614159952590061562154920415452396586835739484982091767625288759481559848471677444112808287056706983922605030201811478361890468927498235629942743709470298595236463543790410896095163738073479981402477878246455235112829189027769705658237222594837250410596602457047413758430150029851731582921543526442245527917224855827827816621485551057937401676948938343002233871424814483269902707836173007455043074627168642672708601404181510388085656853057668361672906095700421037654202545940344737030366578366357572799593982155560321323484375285391015752337555589179864820742955048320397684982749773202572245522578129312632534144771795735226370030108952558937781899103282137065731057232138475034306548038575468027244771033983289060691556811292977131791103945007556626409018279457155155668381388949742836902985341946964734897090584115806967893331511501620481794544357260889558504863310391891382713164805617024097058837,
        155788162669126757529017414903817197268727751585092212441982561944090180226287512494701656107349045548808331812548759891584989835096621148126495683288163859794357275092258802528431228319905180123124309840830904793173671478969964183535250577518963119696943354888225616574113413967845210060403622956723780937854996471259885487418940597190472927087580821792190327476146959962804955756492910470225658378055539411316474445189674500821193204914094827516860300059703463165843087052884491055834449711655655633242971102115874803353897876686004467742849628966539805415672346014910086149254337285345417202808363020776171313706115336723345812191400842075308405091880689474060733156732715145599187964311120642646968750570782031504675111178359729641485910096640795369965499546405144491045156258625265068289543591470452740060217905117875563798206564274131462114464276950068613096077150936054489542067966578121383113622585954263582207890015113252818036558914310311336762777899485673805970683893929469794181168231613935786663023003240963589088714521779117009726620783782765426329611234048194117221,
    ],
    3585: [
        155788162669126757529017414903817197268727751585092212441982561944090180226287512494701656107349045548808331812548759891584989835096621148126495683288163859794357275092258802528431228319905180123124309840830904793173671478969964183535250577518963119696943354888225616574113413967845210060403622956723780937854996471259885487418940597190472927087580821792190327476146959962804955756492910470225658378055539411316474445189674500821193204914094827516860300059703463165843087052884491055834449711655655633242971102115874803353897876686004467742849628966539805415672346014910086149254337285345417202808363020776171313706115336723345812191400842075308405091880689474060733156732715145599187964311120642646968750570782031504675111178359729641485910096640795369965499546405144491045156258625265068289543591470452740060217905117875563798206564274131462114464276950068613096077150936054489542067966578121383113622585954263582207890015113252818036558914310311336762777899485673805970683893929469794181168231613935786663023003240963589088714521779117009726620783782765426329611234048194120833,
        311576325338253515058034829807634394537455503170184424883965123888180360452575024989403312214698091097616663625097519783169979670193242296252991366576327719588714550184517605056862456639810360246248619681661809586347342957939928367070501155037926239393886709776451233148226827935690420120807245913447561875709992942519770974837881194380945854175161643584380654952293919925609911512985820940451316756111078822632948890379349001642386409828189655033720600119406926331686174105768982111668899423311311266485942204231749606707795753372008935485699257933079610831344692029820172298508674570690834405616726041552342627412230673446691624382801684150616810183761378948121466313465430291198375928622241285293937501141564063009350222356719459282971820193281590739930999092810288982090312517250530136579087182940905480120435810235751127596413128548262924228928553900137226192154301872108979084135933156242766227245171908527164415780030226505636073117828620622673525555798971347611941367787858939588362336463227871573326046006481927178177429043558234019453241567565530852659222468096388233353,
    ],
    3586: [
        311576325338253515058034829807634394537455503170184424883965123888180360452575024989403312214698091097616663625097519783169979670193242296252991366576327719588714550184517605056862456639810360246248619681661809586347342957939928367070501155037926239393886709776451233148226827935690420120807245913447561875709992942519770974837881194380945854175161643584380654952293919925609911512985820940451316756111078822632948890379349001642386409828189655033720600119406926331686174105768982111668899423311311266485942204231749606707795753372008935485699257933079610831344692029820172298508674570690834405616726041552342627412230673446691624382801684150616810183761378948121466313465430291198375928622241285293937501141564063009350222356719459282971820193281590739930999092810288982090312517250530136579087182940905480120435810235751127596413128548262924228928553900137226192154301872108979084135933156242766227245171908527164415780030226505636073117828620622673525555798971347611941367787858939588362336463227871573326046006481927178177429043558234019453241567565530852659222468096388236009,
        623152650676507030116069659615268789074911006340368849767930247776360720905150049978806624429396182195233327250195039566339959340386484592505982733152655439177429100369035210113724913279620720492497239363323619172694685915879856734141002310075852478787773419552902466296453655871380840241614491826895123751419985885039541949675762388761891708350323287168761309904587839851219823025971641880902633512222157645265897780758698003284772819656379310067441200238813852663372348211537964223337798846622622532971884408463499213415591506744017870971398515866159221662689384059640344597017349141381668811233452083104685254824461346893383248765603368301233620367522757896242932626930860582396751857244482570587875002283128126018700444713438918565943640386563181479861998185620577964180625034501060273158174365881810960240871620471502255192826257096525848457857107800274452384308603744217958168271866312485532454490343817054328831560060453011272146235657241245347051111597942695223882735575717879176724672926455743146652092012963854356354858087116468038906483135131061705318444936192776470347,
    ],
    4094: [
        261097220353288126672938177679156095644991062261845945096058370820988476992889364212206702983749389585222526678609815709496893359546448401815809021962841319486489244135927499585090397533595929578607017502963986556594079709849428186418083671086146654374201977176450926017821012185029652278616994445899507251671734744220446946486726407547565235149894863358205867325756674110764756253993099966928553885423458889971322871579559478608624183521952968159874118775047260337252104265418773417083462637758243022067387692495904092352983253803449206459297022958414187805329623211592031387556499575103086196215648918623048654255951626478311402706432958845021902155525708567549424550578292254419501668798871269980409104842571343781196003726789783864995697628349902887948567776707783522646068221069947888712445738580883629266305817265348726496923250530740848921945719737110154001853236418729955762642910594288704080345157761475729034231677085714110182611974992975445366440868305962566813264974948999022699867300443656204429612466863914812544582267618279858291387701892055461642936593324221228204880079364250610231654227718537096269602982451130745464334744412025781521475750325603366797431668304122877782900730195434508359022560951177085100788548073,
        522194440706576253345876355358312191289982124523691890192116741641976953985778728424413405967498779170445053357219631418993786719092896803631618043925682638972978488271854999170180795067191859157214035005927973113188159419698856372836167342172293308748403954352901852035642024370059304557233988891799014503343469488440893892973452815095130470299789726716411734651513348221529512507986199933857107770846917779942645743159118957217248367043905936319748237550094520674504208530837546834166925275516486044134775384991808184705966507606898412918594045916828375610659246423184062775112999150206172392431297837246097308511903252956622805412865917690043804311051417135098849101156584508839003337597742539960818209685142687562392007453579567729991395256699805775897135553415567045292136442139895777424891477161767258532611634530697452993846501061481697843891439474220308003706472837459911525285821188577408160690315522951458068463354171428220365223949985950890732881736611925133626529949897998045399734600887312408859224933727829625089164535236559716582775403784110923285873186648442456409760158728501220463308455437074192539205964902261490928669488824051563042951500651206733594863336608245755565801460390869016718045121902354170201577093553,
    ],
    4095: [
        522194440706576253345876355358312191289982124523691890192116741641976953985778728424413405967498779170445053357219631418993786719092896803631618043925682638972978488271854999170180795067191859157214035005927973113188159419698856372836167342172293308748403954352901852035642024370059304557233988891799014503343469488440893892973452815095130470299789726716411734651513348221529512507986199933857107770846917779942645743159118957217248367043905936319748237550094520674504208530837546834166925275516486044134775384991808184705966507606898412918594045916828375610659246423184062775112999150206172392431297837246097308511903252956622805412865917690043804311051417135098849101156584508839003337597742539960818209685142687562392007453579567729991395256699805775897135553415567045292136442139895777424891477161767258532611634530697452993846501061481697843891439474220308003706472837459911525285821188577408160690315522951458068463354171428220365223949985950890732881736611925133626529949897998045399734600887312408859224933727829625089164535236559716582775403784110923285873186648442456409760158728501220463308455437074192539205964902261490928669488824051563042951500651206733594863336608245755565801460390869016718045121902354170201577095747,
        1044388881413152506691752710716624382579964249047383780384233483283953907971557456848826811934997558340890106714439262837987573438185793607263236087851365277945956976543709998340361590134383718314428070011855946226376318839397712745672334684344586617496807908705803704071284048740118609114467977783598029006686938976881787785946905630190260940599579453432823469303026696443059025015972399867714215541693835559885291486318237914434496734087811872639496475100189041349008417061675093668333850551032972088269550769983616369411933015213796825837188091833656751221318492846368125550225998300412344784862595674492194617023806505913245610825731835380087608622102834270197698202313169017678006675195485079921636419370285375124784014907159135459982790513399611551794271106831134090584272884279791554849782954323534517065223269061394905987693002122963395687782878948440616007412945674919823050571642377154816321380631045902916136926708342856440730447899971901781465763473223850267253059899795996090799469201774624817718449867455659250178329070473119433165550807568221846571746373296884912819520317457002440926616910874148385078411929804522981857338977648103126085903001302413467189726673216491511131602920781738033436090243804708340403154187787,
    ],
    4096: [
        1044388881413152506691752710716624382579964249047383780384233483283953907971557456848826811934997558340890106714439262837987573438185793607263236087851365277945956976543709998340361590134383718314428070011855946226376318839397712745672334684344586617496807908705803704071284048740118609114467977783598029006686938976881787785946905630190260940599579453432823469303026696443059025015972399867714215541693835559885291486318237914434496734087811872639496475100189041349008417061675093668333850551032972088269550769983616369411933015213796825837188091833656751221318492846368125550225998300412344784862595674492194617023806505913245610825731835380087608622102834270197698202313169017678006675195485079921636419370285375124784014907159135459982790513399611551794271106831134090584272884279791554849782954323534517065223269061394905987693002122963395687782878948440616007412945674919823050571642377154816321380631045902916136926708342856440730447899971901781465763473223850267253059899795996090799469201774624817718449867455659250178329070473119433165550807568221846571746373296884912819520317457002440926616910874148385078411929804522981857338977648103126085903001302413467189726673216491511131602920781738033436090243804708340403154192097,
        1249887821238696188054856946536389539245318247874931024995681389154243482743443331304167229314392482768422382743567861130033657206226912517281615024579918572265111117186841967849289663682218197379310449407120234100952565100607906509961253157258349098071402964359029329244461108488150912509316340150957200188733758963594093842836189933228542588992687051501163159061894375024877860070866542001866936838898580458635031039441171379276933630301931355227994105661580936611601937172458548341231154811708205718676794029453413372018088142674672676095986805843136702764784648495886801559910579137553586641407547616346281233950980903629620521563069596240293484968917988685507226500072225346341778022863327979915729768706292195776187697118404675479530725996553853675430069826739715960042129373210964284921108921054065469428466766083184463434580349595387348023718010269685089882938630560757985329348943480750288712432754957181918364857556505799169890716189150414039874160884687887070426179051127170649575077464503611904133077599787099709327096483680234219191353616798939010435200384268049516721753246820725398373515693267496804577264824569935011942041680470349338306275810936734022458073008099395118160144938117910870128497290531223477783647582277,
        1219107193102526091230647379488406319282746915221955734449804349759672004457615422056042184801310370456508581012557257726409879255128284373221397011880749805368097314594511933634776796564508225827695859055089682517186404483718778010511858677461107676004571165044515975536901379305795589455677875838931926665098598884645254367686271026192264832875681080728292613541976209142265864928924557197149247751888557620136413220909039808123511671445929048842123615454632040861574331728060460590990201673514590241699068495729410197106330223951685762730421337154372981898805792716236607912762664897577321358607393680491087776326442616507350129284912436950183750277964750584017752112442703593146422935602140064788259395184825668949472170819309709402028929498580565916505061880000776622071218843614396242588144481964393209348924868113540597283090497864869664309422800114186898498526179443209003773399442094040007940747119209757294796356101049615863034039134965037991390144260852859538246903083626272681443389583955574566032549744788631731627255200693934011405856504380231233263978021111683798382068984589614044230699927478472079123351694884333591060070020195593111457837720913771400497972475708269223626675113397576191033038498203677939390705464443,
        1078164948402699932247838905434090720243729254843310461383658221555198301272197383486129981735286772053039037616432874019231330684016815380059224194000749883683599356874117794784158979494044375755055708704411888384088580829452138316987473495078588331996299767811885731034882876326037108029338248063878272294779455560148201787485215127437847518419369056416037449709746568578895619555543530019602246598449028241169166907179737026648115906282303628193506118270662039981230494228022723491738809883954620853610225552646087168021203235240356591991396924047763922929341181572424020834134036815615758700367461702217419116571475913459928724950418767211283892815285275145661657504713865664731157894521790353831353723462869884622246281391681956815766178365486905822586576494762038866383519545705335455797982881202353347363068704795401961716522140736119383671657671910156719029955036598382865185962020069912160366194158179413276843518585882539036090213056544917150670125106882674504403320770873834728817169388712251992461542296239742927329385109608886654946657670763436305438637354121083516674756747853733043486420527392545224001055724051950298505611627766180901742672206594190785308416771061276827200791838759930165186543584952749645557853274503,
        1296914840387257212239681863373767631974593923255211831236752304249906895215076921567541473093844746194841514649027959774932290887540823667572578387266234555978881808174782449013077540837320046553146422056327387270641111998758347534742231027813791148107221575452670422978759715882243703025322301268775122785480476193077172552575879260731571391735830585455503125326290335116852242065730535890760055439694278050639943795689296901817143884281763492188334389262468890516045696208344924051001321187412044865925903767396273748185593591083940940932007732018260692084031641510373044912686650754149153396975221282467613667392082536856795390960824534822081145175103901629809010051966271647895826802192855933255894358040330747639994357378131150530612666835057996178346797609867622321723240155363236895083227676881527926558477136303808410868997773482356764308464996979394903649874329274415840539291604079119389269511496385387872132714451072214981499599400333506702588094227890879596044905752779018831873315152278244753260953824764741820868274009808702654905900304866681444832795096931254429562043112666549068135563198878408086616746244508953525669886829874126184332462438488602819446651040374035459705853799629571810167255496287361616293185104949,
        1918761282679460384696266738061445148879521766967461093887490839812548387506563474668336481989522393073480734817276684292578410292732384768306666147054772494595136162744576341030335267706632595218541250021801266105107738032610962969604841556726823413679832294718473736969935053541494454569739298649377038399237650660269476645950862480484698842688702219344382646393666031786145813836325723796352738342224976656536877579604342557488012776854680172533226384768358077041840247242073128578283755767414818747049245728091065634299599944184891384853102858562673831321941148717006068124220319785219487928852778406734090903530978547049922931403888208204192009735363274720101578559510710776589877710823475371114773334219430212046664166042699887213394479088850599558546281693586470728697067821153757495333873248716042671213240392074768421597531567352813352319316095706695999965462942136907508786977976287514814823444745909791083604835869067134331583120008282936973969643994173781612943202873766456362144096129080113600372810476958930350717206915168470683675009856680492054328845529506311429394569083725665453463688190857444677517879219584353533680868291695329700517696907722971920494342820913065496572974628597568828704441654630761183512909880051,
        1257669833198270489026172275585330247591803350592910883227555705420590574617013408239696086127962205799847666521281710464487293646410223599281151199632854314858009007362732074936228349320944175303149161540579712836709757971004992543613444350295467617773483041024949794406136428052614938019166770803298936072946891176857684095550929298213591997298714565760037587612377078389590884597791551926544390891884653904141776950584661417480274514796379901545923067477035031802075926637140622858606194117474945034135752225874818361480586109620828941787736174772239875497059129115700421400656430316272222135020593286652110915356537905317743289808547385254490990342984466979545508183853358078376621211561465181552160685739433491236095993195675324438530486866194277070165189664768798909831221558904030553855556994944025963262700917266480875720188856728576865942007710788891324062210939166668816461890257733050910821870126878876155065405472341879988296379325673275182563823054793800511731877219882439830234156085848709944122171766342904979614748304749536476390587894419288746112443017807483976748008773458156618962621501523278870442987410851804159339777936625418787747280351750490251679181157207778079870966474482135354541831059879219261725031611429,
        1738769345672906683682973491194098029994259404141510401686509570078061189146475743345028610223348968725266546235333584202357924456153211647279872980493624589111994969975614034164569988596425233181361110670667956870038744088219608869511751363198496925035070348438364921764685328625553779836627841428821143787773027545448973685469421202260858941569734678738639592080861429525765397835186878441085488843745732699474823312434732132630403430784398063188588567560448805284328879635129441067857753073788700971801320548193015132481552671114209119146675223481929813245248104762915543502119157855424898971327646345768161528487103192271033923306999400557709782481478781924349281221458977089214317522635888600666905139808095367897277026457925528726002358713009300797353013684587150911300292632008102175429792764287409728852326242868288941581465887958449088136530165955538495863255413699037525955426556771863834586123106130516661604121774495231253351505324881361118780861121060561248056141055709465202397144295541401909340509618990800649498628511515783301616098751653977795563938420730493647637500029368155352251978647056469812550942981789620954195697577840462943653785969038208901528912766504860847863672686567953812947171715658076995682420249451,
        1423205010577638552906066854994256503337408481835861973576904323975080725506136707573533144696659548325809915535698304775438304695969624363389123556923015732561721756202772076745827262916264699310329373406971146900081679410526526109538093969456734650383078052465790462002151440107722229261190614675790785558011927683915904435708548177880582929445553543057001604139077822245837406747825198003589401154842840114129458468045866812459703598099390000719892770927090319435932999110721901118086682890010090967110357160943452217274477109866324816361884550019835172231720008969625671634708089376846333788337791675893287671088348370109080756084745063117013345651794890682158750714805185531584213718670863410049750871162746389158779498772096701726516903801355745330597061292045214319714523434429015202502674987869425551712054107598126328216252389146969033101834710990274453817906963281652732508470603410653819557352120231523383593428185442990998504436739660578335082095335522199481639861962218542571741618653807348868887550329808801280508973120138724832552324458617182079126498358473438338810091472947671035848489288065490074244597584624330694955842860976830519358998035043795521129911636663738279501835390747277121724412898113910037359869545889,
        1256912880023188937717364040742703287665271347796347151086042433968726408419392139883914271907439075202606620508379610875216325692001069772933197065319950424578508965137450461196778777923325713943189014032940449573812679647151392719335641123145431561223557058702936708014445116660936864039085643197574582774035240773996160556004008483920862580790752363052267308121351424908952995359215953017525148960637257242376465614648616237790206367008446652804896675525429956159490835495236081113646271667736118431888799844740338056980396749422350004316487264580158458598426906865264124284088497718165352778631249720596833833925204504858737812208896242226611040399080771509926781117122999675215912345167020616642450562005590062072554968140267710865318187762454718862683717112356877740766941161028097832907391720093983061705175900180959713189387732402983822883751452030790992609849457762034259923193338423577795596789344591338225659582701236834626369352301579746464525978308267909333715750918612721331153244776555366556862835626534058672019278695435256943334173718298838317629816455232025263989890970470234197483905949584981977056328220691333251195381211351539608668456693603333994480063255736408189256649329243914598321775252380072360322221201143,
        1684559512167292846525959587361966291368368461330733437961045217126743140448317880697375011326841457950471192198172444301584841719100321650532398724301137122253087141207952842704728251117772140659972291373975744933668211984580880868149626204180756028194922363504529869966521610481064167682437406937787310224732554326925690522438642921892504742098169645231036429515894775159874526856673676322538426221042592092107220124448511176594296675320940475800330090743618149468311570769269674251831924218061106526258616520235332251411186109716074935037716209057486566668757467077975431998521483592923138011502584245689981327693775887335209951333070603312431137297221447328469009702363508598302254430699268228929799749936804024702584590706787628385885595829892513927947719641490496946850682003783657858979815151603625025923044813402947309676595333766372186425826622005048239840882331310328425839806345555712581981706936906665633543803014383384004661250207264526641979981297494338271637872361543869658505698939288540470749015622108185430279956949787786400588978000787299504562377438247273286112782347847885303571832069940172532724689560134196462053897435362051643882226564186330630515156784198040261986637884696745240407303315004160928049883952973,
        1442499600001739628610400831893852263484607733273323716569370216264899531108656825301159484882966093016223379337038532739383070137178744055400277690756949412267042686847902865981296279946837021570218026802064947808044423323497900054922317603931032672234057670805683000146031331313687534372255620006448740309266635973914751960153700488357967627634719355663578643302448226725065413449022400361552074868611670304988733542777338034535093308575498817012190673031028905780300051568264703525281639166507973146049761895108790176386617956840174591835359055745827622539726584174334167777507601619465378102856597421226867454738888676692972663625433748637748281159111542708388523812051323889453619023022049847923357253499578729553929329631109355683429218058461391349078002383530481334983890458118308660348835732391469203918428641010632534279662263036358942536279487029468535442244336803810870097646208326305467560046004963873510566993802499706989100458270939308176309977854359660454724001238389457211829609509957208869551801388237006303338184110644901263868992211108975938949704686978558605134816261428159146901292205276211596116038465664502752296682527463669903988628653471931581391063983040801767137478775724260026673064293546692868368945465183,
        1225721285075539322028375416125823376750778396699511680240840064772940326387983632596493128837894976406827580887852449854065814016697620192374667171622379037123055753635790094108403533213402572617366343047361340218510879856947408812560020102059772280695930266371923516099846498638927337148060831094887057024667577704889550336590054368622887395146653332756742274012938997841957181920268275685282590857052948109412060567298191544757613496692591776011323623772951840107934585638141383025206015630839988383822732548868228359219418602025171482768318767491765458536331936243473519448333291493946187860908755512909403980439851315827031387993530468890359787786161279957020782173065400541764429153860052360410634960983691018154969320001261971741820956207123661782917114962417354302317561495969569921828280985031520634770837403916563859919701700677496569011804328612083478892916459034878625486570980191564358869050155308284876841587861439272299197845204579458308986167848024019211541597811987546114434989009178060165854267647845778877886524576431207579666020029106048475367516677712278910440749034966691463874626168474528562813958057667566281834151272170531047028659718190874664305550256799042321103179944887897455271634590293467854458127077503,
        1496634482720638885237085845139353151479207563434850560003510875587275224666949424930886333609424691434860433971711551642052230361018657389949664448508842588631310972257048103792459612228451504365238860876998353458005607856187185941338353665395497289512608252485915970622104540619905060568845912512166845155987311862220613807440190850549205886215041538965371062886975050156760288161367976858375482717949454274108402780756647683408246923303852109625868312290659254893444578729669576117347978247454349966520049761578841918381675029919015517705458905802403995248652692851842083910456222018476696295537318431933690004750102657431788323090705516312223215290635889045021337610858690914965898205508946581448276083783467670006826470771355155205463035223675519963179230093324270645970531747222626496972699082473100626403998321379382015542420248773759338938811527149465423661993967703817434051634078202964191473803662753918449167994858381723282047029664493144775614924967123837390785834652749018236526360481174537061170892283858080690354755736959522081633729138772835931758624674092958098775060426365245892731085764786201172457290881214740896800208521904877401796097920397103871585443700182248928818241945462008583946350463347581827788305952659,
        1933859678512141761518499098627750004009574661496017980849050666155103895284446403072799532548745661691719693880784829260250372462006895169531505360576949861918868132166866236269554226470545010190030691062246609469766441178611343309210978349949426082378331526435638842922633437614059445603264314554622705735246431391349342766344528974918233643612300196718587301125157303795538697146438170378813960517071158017506513939971422182761079163155913759894431738650413416824457213003398003797680568005391915640613313393838831122353479915920194117881685824559374504032150657111836245527049080560052298837631276247800132479834320669996169180024609661302765064933170895338184073458933122043755481824409443688887634243158557998005238459257522687326109494727115071831640282242701869473039466903698841178594693326578720562391777469849153235266847608442952179719065492100312286293450992453261632799703735829631408315545180617433634569861381224745216483252422894993577274703160487417488755500150666425501592387881817680028729019009811607890514857890667239664123449452604599559507474892121945452697034666581415652723068287922449293918382416708831211469779493802826967784640957619167791279822736232793172151781764865847746308033688045063183661107950159,
        1158791989747560216474009487477743888133407254163613988317023127364913172643006769745658077762632467404205040052042071589181843953285255212822745666370912286928820748361463917082844085572124907950252195468059740948364637286079408223018635733937671013821940507005041109806933731662817528921772252335857890797440239117613739412944983605984587674896469571246980112925131086398979541005372634957817639102191121905836853232573024311449775938279607855774731342359871074103800065597408642058610470449948116678978574264106871249316635959775953073988929677687855601381967314545094130670266161136522797127659545427577939181063027012744958472821148600796436163794594176018276191130298212997445643335653618801196044208806850318060307851124589911041859569201510809893868289909757936421257220879873125752501874509673765836138448155979372992089209878203353190290436238296380126998877895631671668321142163685541856930650167485808456348950104971253155605801352841120983960675583801314703452232915902138457378025675350071046264656395246689000603886831682875998702375733229290766864929098530014876183604692907045410236062426518607343665662827974570553295129207308679861420450012370972449382855246996802056959492374569491661441388042429902101164619888303,
        1999769070819637325681119630279776972949765112875764174546539128193099283637934803192942780720960856643023388182146470774522879836268822882340345412418673992868948015086134852358564718347330296664738681451509597682379193766888095777172405349093511308489660621647143275751638724737675696256097072603960944228481774911992452057389659613435419656099326002520960052566740691761740636864287770970277512295686674815124863080382290283098846369541657169412719017995825875222026520787590808662253091043799393577227431912431106960696797370701109922820320565762993535440062217476891471176356576273502962726725435474510044027413633950086413101223931064384703161120062426259900262291789783787262040813557376944203294015706249783394393118217819748111426562338100114757015007341499090473037828079354122753403655657085567866805934549384877701492676619882973242345482293942282544211200155645976046209187599038004278852821679880878186169492353224038076336619025470171308980231158511214635513892001215975625722551958776597591454761172521680659104025185680557800690552745511581804405584868275322311778579724652269507748046411180618398177693900990758342695813612560075537553870010134043906279126398538204324470666105734353184784024214768815213106382681071,
        2059617007972303640386939564042520040329059557380977893695518228777823287752265475240754743583473268489869418683565423625717914478035024707243418941245029933591069408174064015001829784698296622579388103926237111491919439670359284057056616537847566033135006849534643704611931192441118243398390457454096274830705052874649295212695638394430064729410330135379324857021254681423953470955727659792967165828157821872034050350441630481041040033483420707194429975279691366013957251092847915858568860879103370622597886054675846054933636650554082893490360584621688887584349653458428481112450158627231181658984208360949434922928223844723235052514533397364665952769780437193697551439701628633060683906124741527848595819597008345159507418663897478963406264536796440008552375045118822182432289715680332941625788558191589314300330626141728770429616916861220510713766026918146148374893647979131821596871168236672168082777535684717002952056008298454772585558372255732145643369069053438678294698235801723219781414470140675704936291847400796352514535043092402973150738002177107405286386786529472900800286136346023786947139063549728265021488732837673714703206971091823559928657029388454698796869920772301811004404719552668679809073241093457122594787008273,
        1623004036196320564864684643880036929840652655728809608887305384501016990111826968322109219301757581563837106578475900831969304488341282768344211858750162977563060095837245514287166371679525997101631121951147817669359239345314320392162870133545956855654142426836148717187542923563823758223930064686381389051580158810848101848742447691414290155178133217575800917260219507107213486555526626848623159481737402403580366622179198575556756236737386992964465980678273322626095797816255790293967644519548263217420639629348002576721641499361452618884629236391821323428442521285643113480217042347584319793670661117187230596336995287537861530550993461497939784344464800769613487551089948582996548190341207707438574884899067016765867268095706151062751604021824229183219211599478609501829817638543849017957886672339484139874872130540174490496656874589937026349758582432954172281336754256242930166706635254665299368525045435613198200524960594109363502076853037918566445546803739475962897946131608845334329763784190649524408789182022150235576471779283150914441708893325589394154163647769322311463600593013930005398619687996177970223428784135265450350679309855233179770523664267812753049204941944299784232509228733427935013955683353131786507335758351,
        1547760668480302337598876644611690443331025174923360209564321118704015948168187454688174259966654110149637766736231789525898004255676296430812745767644537584599696212140591077596880081687988664126246878788360141945731550012740664037418010926467699701884371662824575474998134301151728984768219630693816943043294062012482494309720372651969695091543066974622904049054268717825382499564416752114844980614235984470516288003006231956748353070775631452101467755262814278360065628875532528353557700155242456312068827649222030726584869518249004193453482406314073395582763082047404532056767107724636634635296246764620825212451584464832071372438124969042095285706607761870738712828637306245956926670462493060337387550645795347164311155020863054688877366758667778856967634215282124924884866997569205618477830683097800377733909095591431646591600077386350269393719253601134628556311911029454076304452721467274280281417239501904504191833881970450105260683766887946641282614030994002888123063060231583982581356020957527115380508298954208393931807549220921033889436639604322921117064960578017904465221897941941450825307142176405767647414648791907848063491540179972158247251813454823958909805081621723207733457836313306296606816149062116554351287425189,
        1048632582467180923047689931573527598708066904766611555404041298707848667188166061840219563335504212768607770286876614898749638125440114544878618762080306690560513070280697384797915118921319939928900043101581304242231344573406520599393417103391552853263779560168971036172771425963918125477401787175514248958332021050223992160188030744622622451767449623760325675456288411012488058481330954704669515467476409276707712892436937515078519667763407535649076854230539794910197493217848159056362675065563177440770426429700487546030289054551196236463645165857070128099986754379487069434167136540905950399000244518508176440342673112504823442124636002253659646405117909485386686566246301707830250797908701164407561218455242587775851629060223148767646368255385893710104843054377431517109379796879253493173411080572932346640355838026468797463247183536498929148876401237426245138282322795148352426650927109426483880725230480474118901450909300450163562613576090767490092690960613456383766127818233130008194819993740146988335972919892586554287653530768797711565800310165710244586034554196544527835536785818120638553097027297723374700234913956642265032395169713558722678175141283351044753237205165436284320609354055724723940848303796885833118183733653,
        1792137987043658609199312775868570215980060830851969395856927645871797747030512401972517520477556402658575443756683913512970395483850949282957986421407911998682131371002998499052218010803226804995190728341255077283498354444848878769346232157428465602875712225747730950180313490008160470744006160928244199966474833487041263838245344257028308205725776041545192157668534989036602804716368088743748408599991450399122629356630061510456585586126227504901701821726029478482174669263858953342693905232652727636833200360343515258846384336114760732044737224932632507740695585907120465375059230566890454852301730412765177105675690726319304895864098370276817344245718347206807123694881871692166616608513290103432534947821290319734081815668735924805634973960916999218423897805837701668183728868930780586766930172990930805794722980667712256884703096330790596045417144914274826841087475052511794160617844515278956877864621615682162815244031402181636901245036843817524905048119601753152728753292951613769889777842932183195527700704724075211222640612563735017354366448241689886958780249183773722696246677659831401157147911191337586367019724050805756897274073766986560010783634208996195707611110740841189696919044403883887144106812624743183200871568697,
        1059160139216007910544275222847967715031055681378995674988601049135702716395960410170691996221647224347587152773033345577870848273761654705660978078768084214825202644269255288052510677900611510961896317192447530625167169006597650343777641932346836967445978265952802248444336133065858461189197105201795989510109991389277198783910264987965272676948237599915079523220019781019632979792252621502954778374859572221721301286204213653627823344970672575352679684414634249831579706827205678513972551832766711308773721096256837634350241801928470178879200386361369379312713221485588837647904553786310161433388424524160499578030271816906435827620645198627064352515710621875986329904952208159832862752061126088121532646433041296211618315388416149293040949089652896855576471411305142571204454544706096791535668990118160234537219461376477794904089622823350163370379355369436075644505970030259739764848846074132070972710713134492959049374746265804383475386781207935404422600061534476384371698080982066627102566129736808793477246557694080915079969873107433234081746948061683628025384890675583430979763046422496515100971703089969070089529067748484073445741614193777289316097311856958339490127424156261599234542290802489490142281569048503216608383133367,
        1293643825330848762501890361449835692147036392983260801152850035039202251146628397165678797391308571466508148336799963688378828336734721769595863090763317076841612669767204250894726839600640523842909061023744844397458202863595815288022400259277967991381107868282776322484500049478338835750500274224083382042673129794922969796497734712429375869319268234746958460977832512161398587326014807392238945595737102919581762447888753549591194595907263402909541916982490488385295320268522331738983878822661504602724947697046396177191100013056025949119154983914320885913330425278907414031850438330590629284355896913618281469686206517280300399468376042561453978424881589016828737099450695774312955412096673907597901281166944938345421965718636182572175432116346002725129427855562939977890874959257594015372371447289225979185351922724778646724059780520606388096598313746154172639781725015916226130316579406623382059841582646996911352228969223810442493140224898597717159259347629736955745176010363417634825763610869537870488358248421372775083670083230906323706351224388920018687885966088029528910000378579338833287066021422182154111334695986356314228079085837942749573931545795978748813914966980737662045606284191795863452249877051639190323705966801,
        1757051269123668488350269350946526259283725995850392369772237797482024407981196186053773613029571463111398129869412773089656982129475451603087915199468387050158926086656098719117097352523234279960053497930997227263076099423791336383251241974369421093188072636310166292320877696655122437792471427392738817913453408621376697598406691438128849903853147629532826824373478095381324759131818812162424521173185174771019421171027914283935470084637791896931822223797721780091642041620575962002495207144099693559140137533229887553901964835024437693412886536862282991909502801476885622239304328251770166240884960407600102832823529544802831659781974521463314576227998031742756624170258579015184636410985957189725924593128349683526096218031986268435532521189788563005361187941619655453110610168367627849620360572812727384181536164897160698680444099487703914741658013182277592524173572902276495574184994911022167089442510505796691784178851797274545916279190844470449697092048647044382571592885018408045076253506260747236933650112552318533790414272129113321734957585785180856073172465783319064073529930588314078060643561048606834052790157386731672273243526277858321525094669555404420051240037753667130905866592211691838291058032250844405656273632603,
        1156253142831009641453993314068742006275478436821070031600945428796389996386611727568056224764828247971276624586498863630688002164902905418103951979947226202822815577264013938208995364785580865948115291117433443994501340815938477408613965983445461764301308982425938227057003728126109710559994119526580561332593928084558596919673722577750850918832257347982044369443160477572945518121383272043993445423564109077749704953940839506538344379220988024345326486728809989866614360672709945316267500438021145710956541401089350421017425361488253438554077129592949654074741126014176763747242190866878893242738885407280320696836444784765965084841638755966270911307867625149082455672734335463176824799291016774925793329436747084025116495962147392419050464520553493302565671000413717179041064213455513616314422591182330535249659945970813293067397949355671735985684486875237763747953761043108345804300554697406175149100505689867923847744292705816997871057719438661552281986406576615238662727002176732912722419663788575805451702764101510380195596540043806349877571302709668794077656034330403171858786952952323413841810718839138940993609788305068541283439878019973335952232673246142647342951679884782467148182879386454062659744516893730413342248412823,
        1574565969724450417975346344834882759534237074875141985574397625278773126153620200663344154989242787019548361260099013975841194177728236743402889577394142883617871823372005476159770434619534233303493901765491750500920233453231983341312004501992092543723999117276448805744351952180246557221509141966259342331635732266699912139333311208103525423948717634222427810824020737209851079911726529708100763855939566528214871740884874093912319117629184667006045638963091031847873636096804395540094585390791051691966094030609350229444553443078667718592876039418130574367619578330649359834439954737212464712613557743653024833708788845357368393593760992121805044369818037552537156383583840011272264269962057785895920304244703857779732975665177001579705312822517671849460625334228958476074102735986286532842455734144819619850559149413923682348863184943557613570087439382367630028201824451913293526553444420794290938907248489157070233390706159370023131040841970510391825787250608209660739084316672020550131509587250286885479929850853734735465313833843339827637228274512181566192307575334061158920652077559727335863544021979357546795345187629023848838625200141030738525134355940424921519744009928321581541295490932250803965002567724126147768772814703,
        1814309935553066527853993416336745683818709359606011253197869278407828460671353239320113761169641169503177033606860490703820984970816107623449343032345676382025424619599020023991463271575737615472190461839681570342678990532552774736693359620748532117055742464979863552657796960765460099741652641513159335446954988369570308040286523991128525203634017727593438365995484156107733017454247871906689558162275509263410651921159415712987310189722463722129706716365416645495957615636953536297779685462752417251525706938881984547283370789987310912640358678273435682794507077375894869491617954620438313063624692321047432364404279714420664622990371461932724151716291235329348691750161272006212785699656589654317986069406920919461735255010823533036995856337052011526831901511712473389965397291098587898430584655977472062373273002669160295079911202504511102535902032016230720854218308341062423821295749061197179038488329951802352736994188172098384187446847103546881101701611932510356577630488315327412425572970545233739438921054875915873617257975299772942017135511293115200808386046177666203137956172232185608346511457381576201513122733188820185064845322205950907848309318996799667272861385309720185330343817769993061820971655200354191721161279019,
        1784770034036947650680090702433234653364419653049014653637935403985557700962161683995064941807323304667300433099904206012148565158598252204761644195966977110454930756790973676801729512548449530393266856520449519638587171010209861309434514955005635922756444691593485158611355207200254274702495998206354560416447273508789257025088336817906329406035409174033750866876084551607112245508362839921996210061110178609141385973234281695809599050802894719578455799996503403602578044410125422383437776172434361578101603381248586142781930234355524590236552548832997492242026323522257670109713629328484270702192863243303515309285490001095059918614524201992474785169179903190750494768683194356430878784021370645597673833635862988495266004411453130681762082074158114420959427000028912162298306838140956326605246782834097869243366929008893347702368756538952649616954193645106492457187511718941184799176238924738139573420055406427194339149773927793976163490946314670790063874986794817199552078285020885347736997565837048807668287372086816531591258614019193737212445332822387297856392673715936108566863911890595670792046166817644908728125950616281155552274686925204711203595268206795263823389597180818966937743802165586794809917725761402360040205258601,
        1782166042192462426913756761944301234760255332391725794959937475884029315408863484500076403596144893014247956276802207446625494534594994866122164871147665681789986658967003148865661986932336919734408974234030722685865379928501471369087617502630989422001892509553491854013294831028765428722396360656380526900631859387714223138145192944003478891598824994171704029976422937132750736778645509489353238117007830933652237626972308940509086745706645442477592384331656660129060011060808413313541584874288661977417247780501420088046066814381264807924980126404295249157442212504724592291279441053641458767827506627862497109086390753463277966954738159133582075020966099622556836053193122665437792206983756989236181189665903389541955258780074692084799480277430475873453940334184334216721746338656395064468510599823187777902618682710571633875146993902497287640929868944854035449647406326567133232022352113759572060333289048924678441081683250862691279664823000684680626532813664619543636992573372901170274706132351738806552452192932625220728782437123987903183328271814558966989653925877918190195631536409131778443105993275919191419980251169071927968624003626523133433646067681418837221329321650127126946926872547429075762912971616228562844464573579,
        1873189077210427787985937179879991291801585745588377623287278285270647922608635294491689121741110911570290100326699654251504631244900645254043567064936090390648888992765064509478495967263434600806348968813140095467662235314100608983363833236096665825119970584708493365169295147551160876272265391636620189644795442943654032662117359289452171997557205983048516603116587351103406197621283671446732467193453685035323244295920001022121832460724039201568000723781511725090765717089987873355689350799125480792848632117466921036181979316191736636317908899080473322205445400454254706695237022789339009148388786601190572704414833318545100746697856471124879793252466421857630791825893952811415914264019003780214500286118173707081348363933632322340972318444800735492892242500188481571756332300052533884083423648326580010517463269125317638726716977185199558918746843749173731501888936359044841922703768740639737085591305636906310926506729277644638609846851513595405034630995228527055009411213227819578571921752140787635580254701809261033864032317539253538609224481365272739387923343133302261099537647897088757447618951488325671176263803246680498366213627625103574012065354975773879139464191284940223003295613974074301132791465730959772675604563407,
        1220747414586641637453951316728020328238448297391891903588768063325667046225226450707904494814009833497838321913751927148753350493016700995747840175811045250813235836623364051690327630084245947394440480825998241026916682952810426321272572780495732771858483660424049847783276929198696233867542939172610423403370085995410894445751498498625821420737548282524236200618111823008259916172080697456690241475489164387731219547165512010694222686049008728022160436965182808521357951607033166508928611993754601710150083364190604429951911101738568438928092516958791817419986623022021311396522880047942119206117656633454963814760960746927246471399078157455865631607373247376985800498151254734160563377016836121326645955787985317207709468784330186992543497617650017273181022837394886164688184018626480080621144875368500006210934359662639564809063465201048190168397036737599549658567667393812446349990707150201207150995740013777252041881830701076140951007367686719566008017902567992252327293835949401870228025474784801778165315314899882822827744770897997902649102975321505091031825732728435901530212805327408023661415644852060677930447778922346663539635883868284417280511911686485558609127555511878514351659310578709390692215318344628060332511165501,
        1384896779643445398753424321863551169549929015990298117117107177124920111165844879465316440201173193578338106149833866305357082532517976731166769938520903363243645214172857790138574284596096473176817413483688623722832209400816300412911126098029506323993982817994019384191789504536782843311394961632334680308292085680187436387621476819308457238919421958615581369695510626980761509854369984060799487194834458084898983432659743790044075715764775322063318195007630709219534953646104322241928236642564319547048282108173320620248656431333269896402753520520099500274015122273411685141242440787859497627542477595033217851231135567463623548332807206862682824842476647065633694942681732591558492486737750878045508378483181084835120919526229864974385657895536503588358708781215430130511543188554167021745582636897125170230468020262027632845621970605797153414978305351289470412534689424712685692330061690265653586794873627452179983908000574300899943546875697909502792398045579698720565830729083412052603320135640662878860622552157613167777647693020362188724271000126717614352338811028756088999444393342478134825051667817549175763405586608596064959835221045456285504227020311845727953993023225011494129680763999173411619776097553194470575309640133,
        1184890781235227270158206514360372110695619648068335976256128174381389856150284774414997091326242690405875980395965557705800245732786105269786284130012147782856233476294128569015553593552510049470717692013964075276584864872738705477316578013542224431953881661662754503964504446380756105777228190024699228148670922695946563447064473769199102433337301332169140141220100240116358031634968161112490285739230829698157024542966448094225841938521077933765334053556108451918892431109991252745613299272925203056869720719354239712928760910670272440141549116759740945237958441747569371552435872259432582085089286555367587237410164570021346122305053131150713320781881673089733187146946229076884158858756658283265913515853249847518074928038625402458698870982067614281075699413553805868954022869767000898212370149011743986966160004766690658301498266330728293259353461824916078146389553456068674812674834510588374886063005885854128792021988870441079422796154934681800365615931420591157405890658545897498237595036912810010810725065242449744514168491205159442711273938559761714150503959777906929054099229733211605154815186856322077332841370995533852125964601455627811365219010489395557851321632904191138369042876506173925365945959190563000515440220139,
        1997206343215807695645642206741480155005975015188462372037245409328711471370527353137102335578412500176275689882772413627718210735200311205642274441509331924965887344685102746719947529740962913254972008311441085909569786642078314450982179541882108775783155474416045868289014240141609742394060801198565314649244815630119833427235902509864486663684586543237891760829880975586998632909087486420761395798468973612275578099730638088832268606001375859383995987812552339385830337497202038684190845194386744411349893506399635286891055693835296939239938672853077195844907559278235792811502117148152630500299803908784950779693586511430606225584391601390676589763856464252258708869449483682430647489238760423182583358772368410338099584736545385553336835605423746410946475824758925532094291060586231116878236087562208664227677139776946740180083033372346114647242841404461999828603327875968574617903252559291031179890745678462621098189022095906975247881595201405957174692562123249433369763845226528884070825043194331590909333291101922312897476850683935821977011917103007553530154433606126387141566586928339399815052043720097402153845992316404615004735400324692642624308593662602353174819251261229518523814445630194608007660763121115589836591404147,
        2040650593737182103149090991248068655798821251871430784001430014456807800261486139469496061350402914422410462560734655115642676917910351162884660604620374394879031966462281538388362968926992069497864242736290914185597044758335641614609309615197299341656414780728780512214620009520758979823631184002244970102760885634540005610036919311804114953130793227123298717694965197735107569344669828933678806596667187290283093502201973252324359116894789689539892293195593272942885558555668075321419163271771274114945044195888181567998037619710560711021018365244277718880522234327620691800628131559850751092660259190263827600576195129740305296785981222411032434309710661049871045899072800815871939848527276260352280865874056888457688367457765814930184594602212593710089844847416788700585247140620214308839247973942693398887401861788466106391856097557349696095859011512740900147507111988413495241964518765101198240424249973794397493783039749536850594895852165406771583048915313348127206297923268924859399685871099513530143604792138778429373659917123949045767107237854219964900317306537768212864858019778557598128744540778356349993887538622910278709048678948650333958629631378407560908137399587273371806540908035161100163485489573273915804146913047,
        1958709414656797462176240957054568408728862259222844263364372152722584095977802622267567031316261027052450554806310635734070057578616940206962153254968238467033595071617037591347506989736126479057724970919931927219690828209958703855698590312467666798227531355749109723433837506493687616035818281422439394878256243809299853372349953116646088159762099332218967878172576515597648880175509627012586106465176087023255487307658631580241223467598887248872301115164391661544554998802721539195216272180286434084946365199609938355761160283081259010287389543368028596097463375905238909357978120510610837361336602734643721299145847373358771756002486395376021584447562506713261562253123658145535893433201346189645205098189777021025039810982754330018333094137382970894167101735337988238322855844458118200252461330433776239588135592616471999877663691709550784908667457004523095894476497256361283863103996766480267987165974829657292022196393647947029560860449796173418655843813358297182219794339023917870645770126420436521267751069644278930074722323429111148338075355697529935566695721122869021522560305098951153885968569411859580251314051622785686509340330936064417625037948024262484764781588080985441306096660622178043648018567521592869380816444477,
        1978226922168892251105246568763232690139330335900689648076215113673836031423216011042251521666736452604115855795263062122199151211556872415897649360001756697663554866119269027569654344975855896677948343003636066934551599992444713343301944015779154025529505893459820147808078070709620596214453163722581742925800677237546786239132474332741821419681312336753204295919779171418190477590944424933677947809954144407962925587419866032546248999223213760308753430913625338614002109425711013067987345407618144207898122696168275643195315500649877808781392433817824732517086546986690672304604735883379619351318651828159797286910474105315601743571470819548948224895264666008198019984900801081136989397434385685155320121657868279073040489769275569747640710329390002835237407800851357486822927945408861776288811095560175386101496635573728604579280494735756196152145122962331234304026314863677833600932846346720726711179398373774346066225275608435378806465771829872402765829341930825072580266414789789741134744926029370364043969476018804777813638145334334380363700901200432570836423977261954477737948656681312569456468869736389927415994865878608494752933062171205093852686897436028570059245120463463844961609075487371656038325769722271152992646678511,
        1861250084966800196060951577392275368935436772847604261436740455279618441509828552815657879220187359513815345058756510544028632526022275289856813709678227826985138510645553455858407827922952878902326186036543570613855011762390949418000110794517639972872842903400313496741040153303979073110816980300173845953179548644660259779849641045917972337218903509192883353362550495552845095493102617495769462539054655437726465598374325109154596411996688462266211050580670139626842778274905915248123790592480773215128979900715843607782799451111397203532066587831183933780181622399511740660441847231337160568418923683755266462306378092857027759871959005087238286134043141108881834551209451504039188130302271243873389706814764482236185695895560987165992155283079656018230698375403697454424411991887903390726048144834928606490656503081874435755974317559119430370294385196735903262632718675712749126752013143170162708072799093061829111357886639305643255116934108515545904858448828238972441836272241044512532860234729908018855278942431021905409482636422582688534091995187439150256191466697803894749322285825957207042850883931861729386072271620075563872446686673263188987522496466106340408943263535064985280853215523882311388392100636068654048199896541,
        1711907184539997637346702184853574372718661200915339387117776225773854126228304597959215356462110107533636122367841046598933540283718447071892560523022379300355841277824761511118084791083017103823728311045597078653311082572620921655233704083486491908163911339709032393958893942431093467433311888772611234799235848911983493603034841219669532230600211851516954026781903906140885038467982500477424012280609166951224372498344236656734427067511254399896936113079363162755649587510532874473555914404009395197453527605780061204045262300381009875973271587809292938306374309511058472035121614228663696569840253318666144010615579674761812417277652435059749465499872999910573581713410349409194481334440977470688371569081389459859581295465697057113952110593753663900811966207651417655363785779669181589840704353798701621786880754940366437041190724983543547993537206535965236210606231146614975878569446683006414356847632648108445475796089014565034497296671075249300488562630817748134573572416929541286801827685353687872041521176055061315186152827785146236791991457157013421799404466385996630120203264961964584018051724737703274536854001989708165592663349450342305811410164198370397292173962086972430424355614226050932765690416074925810974158814873,
        1546032314263117861273109058192456209528912694122494782093414523565418771636956771987457536439452987505978213724124610860498275911398676115993073845390393388822851657255507750311490222643668740659721277314758733472487571809068250009153514513632095281576598789917950799908610663852877899732818329831016165365052363627431236219299363958801987318099511103820853501340161206481507492485058270450349764386304564240297890775966276488386338597628806078243975895704312888767820000925486986274129424110373444246302276935529337138900589235592715205065763170840694647189514586879086910470512564995565412158645313505534896212089490339298761333871955448399294604862212479456833800906009925340393306458717054760732630590867345781617810558018396034175891468058665419601110692436152578087983358892365478417791826618274819081906592515317989044868338196157974945229506306390874978745231192898171940414408721873983589844591853475390235219735828237984898270651296242169190811078101520956656770101652435766596451397146159712248462223274755278461638920828362435983946359831387941370302657253815401492314084963730620032470486160509600560579169479671234069460078207800140282602411355886200083532044098005275496296809543801453292582384377239964032084978666957,
        1995287526697101700748568153886583381194919897023746149580649210471555075008327683170471714112325110508874316782469311640432811027429472543255501613743717775673454345222371327089391426304985291220639555363603565057684200187562410370717664567989237781066492324358989598832263873665964653421636401717973153425597453669729965032729527953556007637599157079230844247079611919854585563777112029461207887324499045464544540770224359121354173530748784567777572166823838087678234553152209831631684212130106127101114867483019017243437522351906942915374985116987298066687915959896373967788764115652074545122930009489044896611533115779550615329409593697123605351404494395399998452054841732917568704107925587930197128314815196811905757478368436011800742804446781100398826815531581206502451603497580070313696609599048428318540135093874881734582114945864104818241437702595740307998990516937619391049693573835758763537853507855521016336435054767304825657118691843825071887877115631251991124547242935330608104689930977097634574359635387888038910319220648514349248048391558284128913328691096674025283313033379460930606750196577211914015507638773150850391567025497145766462917903905834505385505605113826298432238082988380378524487121192736258192414637019,
        1130317539638613439636811127059706402422011880760133360712968250544373898498544647039734733544277761336761458497301721786109931439692734229891781965408354123552456700649849862974754262203475466774052975642139547061027173955716937725817827785626501609403919762800610503312997970376637801086572807832458707319975981185007750262442064296618524464173796901199933357521077567821608383601143162238439830833196663007903215048087500605170302574667702379599545705522582883507323089470111536697902429060670628637835713942916102255199862630377915789426863857692043074199968733171292007066419371762110787686563065470469009703774512385214662577209675552622661545652741477857816592010692064999184390695899422083423556158234331568040199472702738139650435819811739820861683027950341750665753537793471608120451747599927633054657423096748430667095282923722617210938042970392756267964807484737161026256628054018163911071517753079631293447028578228472966733495974142243567892112445610623161712033039831601119108962652479260083599425268195204426419638746991996075307809390564513439254657960192782786491085031146971966286919467540948753030725559536435950456368541980828718765936966287945695316637309912082181644822069382142927084339670610240942254923160889,
        1638866539876264349138531743325887529233610333653085273083440131996074846428830363091752608916433565558577165357718800110782393409507002567303850632968437782828034484080904407543262739169481525711882644042939795026905638079821978514249637945959322206901222271300021037456085449568452516753724727861773255542166401079946637793729975078372710549824253029926024529694773298501470254075588601651917605202183263810256920554776026392724062736621060472323664008216191136714141433441676201211411846633514460911779380097328119049660140964859970585503637466525893985123464954927161052913874768493263954420470662827064390632652746673587896032463826687467945810564327509780838021258527730458664816831963795056392924309134222547993700800535518791500845072651292811115568468464936107102740121073626837041078027444326268148919496271479733385451147182919564855901293457970921293031083713274003775414118500233576708976799604235136116427239697958276815465816861367423262834938342692875759717573767175166633155723083446227022169048180657992966053082658783251767156513783786373737715060649466058602476597553070922080679149046188647201170657495061123120417173838528208251557676218338905452256901887975692580721901215185024395652463007037054412173359105181,
        2019148311557509100459027271918876113090281892281488330174807354080101544376905987547115184505744599232279666396866309301345294189818666344299274253378740112168353971696265315360803520134823136098460740026926305693876838374109975517331120326438224371638018379059620122851155783874256600040377950428597056245237768210855328124356918413958370253112693333530806739066638663244393520537450635643036081154453466264521913002990782672238108850091288112092150968758269934607291153747673293921544119696349232683126300713736821287262995622561028609060664535699144073241663120084745528828600349794131124028536328441386681017408453848124439380509705704940432479465307892336791057187118850229647175424673262195248234144483965512304341468000105517387026380830654965994313124964025004630416852183111188717448267594905231188282453476966669932101202571898112635731934382436162397370094193491874135941454833423762567459211318883428976422268819847478363268486318598783329883246237184046801018204214364322641561457039643750929124734617613097336064573889791432191137928630194972387506560884041895189439751033278291480381635881145478048666441315588692655126611411730579128003285778905509595911161749279787739488432063612970622773513242235178371264850281357,
        1048877303849741187388108747241528246949494103132059846652086954782581214507799682199154425265291498217331531762310982575037289040526127434929599008916891484221326677452110294498601734172629606814067710199426846733159588702069188937433852649490819376613676201371108308336087049722067744206028805346223483416621498429367367779772869236280416032091221380081518211739261902935685141047980432570085592526632815601064847832100837628121598629105305185780638550732438781618604835945487784065816618942100680277861656336343774459407515837574737406416814635963702562706181945704532992002042779669213895651737673330027252280396504949513234696542351246026465839576497541923045283633028176239986623314193728853581625829836145972709251508424169852965380442589176284648557582210859235173219456957754553363657946001136887289867209659719742609272771734017101320643403184906410532437664106755383000044203178685388320838949978814408268590336378376876073360570818027399473274111077375880238665704155631850182628598093596678726323406204824192293663158551624956806153062796538555085177139396275087192985862050638152337022015433174000393271952700966300948563010618286901700535589052748729373832160425061018750268323206016345960599969423143276479689347140077,
        2004853191112439237063152205218212101806014089627585326247744478548665030860514285097247617474580634694186320174645323258792384963342868520682049676418840204653783719631974769029541625491604053596826116684502621209251113420748046152736862216174168888504915036291708136391082469925703157799742224010973824971518051611292144695495596294306436890242821657208615009222228623741281375412071633100719693877347100399444737867415988732738308938402761672007020266228574168596877459949517979316580241284103076429393361427808330843371372681133484991845731518363464765630908331967232553403568590979361745180032745158710121297268451571307161159702942521053979896671254159350565832572484836386808963802149370244253604741789719980908564291854916048653523051855109448730903461842115985420506615697743382691909729868180558471983852538126516503665648471039409439118914786523039736126340951278017198054305316995888943832021231075709832296014406634487699319883492179368362517914410852435394447734131367483365220483376116029793644246824765420101701502442792096557756557762808941283492939540174374197829113650717205174979984259834896972338690578324354909325654471380120729288168292153135081316013000123238478211479610562935565553604375214226793640283597469,
        1410514234774910607039029470839167612641442963081197476177493066408775786613289284524265089842473625530208708703043396766878217979470703629521858116298772632225750815819612120014064673475208886991450308415375890325942474082563473094110943683504094869594640714945083100080461336291194818331354987867698009548158338659786773828730129828519512811826876508634707933900676549711944900986048648405993622939989962992320438255346310610139011887333269133643451769525783628357943978882778097004942201952592028192606882701782985351181073041707385558464176668105704038468372549240034764326427548689601684528151033096346768972509688629744123319498951667634269337574687661072279401691253910032743320684448396221050887537264236464886689097607707486082084449917729577991160381611217292238017142942253655222442200505706270598285116981359703774480883570779513704996849463165725315060935245689728567522260864702537764026652997367801152931157389800106927847759403200221563507274249279427467734655010654403102632226404725392700138255531639049718885010078415094270912260668774345930069068164792778312856321819928916587941075605003972249044528097695900821275574760760290646823200935212127666029071194800283392437461048298151524954130652706149095295144053121,
        1061177650137666780322549270826729208298451225613006324756743731968734916866069970797066503853723454260479403577699743378968205547910531208414431189219222251469180910567276922158035692176110182699661309276169001143669557032176672059283942070799888313919826821677218272306346356450208599513600656019889311869008150672909348491433543391587905265278438352914857299420146078339013708276517537154052765144548452023878559415056131787223674164951606426932877049948618318457583630472216086081200195400013433792409399052614162292147395894662301224180488277971595435301717549565524743941926796348485409759366011336989156569653122569142890035274111956563640621008556785173929894632002478312905351393849015961317260580266247852063578584022568441120825646827658679880002733999576908898731711586546562286547530796874262285490256227570531068304368868934816990752839912099506549049246470939142864227917682498054740392006792924835882400548767487961839124655852525100212975584135689549664337059953851233232446248453815640259124175195581399290019921500541302202605705899212998880770017969681400853336752887635092052820272607719852815435086063365119419788619990810627357147668699317736798720176587962937714170020070214609170294335102225806038774636067627,
        1961736404938240854903473711215684515159532773594659874933439366347140675376042397249563031472799292177255535487704272539031725216001793532918437670184016342279804026821597918978906609870747695914423800050791524166200948531270483897123706447241742802329110395549354616521038110919003290863216247329158542817267415047193150426536003161981010221529338149583932526735359448855699147413115378061900508797431341427064511919488818711228074514378145439158067231353181559387234710035661526963070393664724799061673561515845136659676342675349325858708078962024710839751325716522200693829861280778305287083107179380895278965622745164218766092300158460942286223873439337697414379057946284193444927522327614414666788509503053056023380812283268958371463674700415423676387431550590970331726442805848779692782145166900288456504292413091140936971667831447442709621354444248454734146097886997934864938182374880990281252154294691843593285950632338382135342630696027532951291055680562136803877065343753022745773423694381447318417507014947065625129584797832499017139199348160750762905029206571426814124897416559013825805694450111296957644608822800305904087820693518550287104280476582975483100385714621534002999723202999862260384767347788404301532650027119,
        1185392104429443460803023388612560510332661396014987280875275998323529741973066772432453930753008401661549751517694626435774533975868735228490066548948943959938221078498902994436245181427236064374695580609871459298538237328500577144003657796086689885267103385257310106817292389075911459783677767739439656429097195822475369950893879953933443848110872436548689742215601642628351564548036824671103098314453788695210176945040305048766646970112967708949627893603259768924608248526311697935864077212815013594021010651774919694755656079676456791211783008212159802990244985672088903486250836465212994725750362268412410103790618238831425248926790783496913694615357480151023476160892068308955654995515835699444619357817730207798286581615523991062882096034811293368804113161174857487756860311551729771795441417847550357246230759990500994523904878015071338535858641144177636378988854517469809364579570538195855335184923426251187557168825062689086477935478382202523533461733513503907657041116858202220711578248022322083059574741139164492885075248674191190088864182962613325868065617752583686396483754159917288080731187251350050780096511647399071432177345148366776103422121482900767520207126141782868475550348465811673598870604132488558674547325119,
        1885454140572777227571397034794184992683547153013802157374734228259076609029021612886962097278861384204545579946001124530872659965298509287772909679954046098883978468432979583858266977024493635542881307566146765399032392283943025647794308184517038287297483155907339109872531264642581171501056444727624715723841152968035840566623658447086820341297558005132144310635771691444958736057362936204572058933203597068470795987559711428109041602987876338068285311131071199960544289989329610265917553257969375985168171260274915033000927626139724832790693583607446507451359895479761414640056695013499612861772904282866303611612897981852562242430349704144170792272458198187592554689513909043911614365590971259627177900149574362813537375432730025064345962055959098483828604480087369107311320185188419649424396322845364264799184192950007921832162952757769515109026076093421467101129465320689184369422878543706997492467643677824781513849502342103502916062909035466287682331943629488282797630826686232666510215443542915844546433844452471173016945664038386840064765257479960728797002281352326350537938278787743150054178971060106074277597176210058434889081292109665823042839287003793101805049797540484450061421564423710765634729355496021632960709647083,
        2078763438715712487401239964071930239652189419439311328007207491393393146683006503471758783734874692174739903757480323025161519094310924439954468479209076619845595001317464457454080604171078653107336703317067163429818283413495699813880946001258985980430583729793330235358124857213843059160574555596807365600310318891851462141019228070623911122762911648762271504443666923951323763716250027977153993957418156184508580686541527989543746843563775860249759146793417492385857176771621780705043476957768331453837431819369254736374202451371394899105626928689022439143581587302242874962444700699478969428196386125345835863678036380133973482209200203405354311951855463909865323752685303954796889175535713743454841243432679664194476658969839359493601013432838292655022003876325836215999034188903157974819430770593847072460612772164724037191522902896061593044963245390224609208153099443669686940769954103759935625207912047743014997630660544001386167814856136977198776082767781236631887425874713825632087682879337615238746934238557617233065715957293390120045836027262924802581798696978274773312191535034026375599286112530794022080491584968953714076416921489462804612271184217520797323138501464039221701942929716069767803037863785233639825000947651,
        1916037520466988555168376970409576693414816494952621039670372323581539852345817055622670317216582039063617932261646689635691652083014358658294542014735311246170159462789592220133104589241134932495394237461705634893136726994012458106476550484679160848782920394344983052851698204518306916159119202410961746161954019147297240089313753761263199634537776164236285988028183652656971504173502165066666673741095036782896062588058991174406533793706152758434847292058709701144344079604804198541085991478973420019906666798062961017674381251874304735700822481595352685081483415624179842467593797317634224610098801379079536241122822370897827873021272031834655052246116042167145712061261201079321737662648408499058516043617819396590493290767432491923793432352134534880661434933941400864314575419236160090733380357936594551666306180945835518235498291589391554472170928472490864139599944677486508643165776447589409081817962858028631093609197288211123333539746853735062137961334428133560459716846254848584783009690704355173455827294789867389767645272298071262542666500715000325220983980088156636815991220511708431797385311854472238444094558228655245143604906985396438824085226446145556678100744360701579393219501849922689798178614728115073714834920499,
        1617805276070214994227222499033657294785908805199190218038606707006597518571575534645172498593764272965352412173917436258088275861570828345743776114702432986964815693656478313833191137601215407207802829562715394348552599859466612727573734023275953854092855963204212126647865746437820145795400080844511087177452815902441420242198313970996143595558566862757794500490939593695716189894359304063142236682286850758038071306041117953103746221836652860528067817683830118930681379989325305660657767126554432335496847477185388472613440410897895427977329413160668712597234711518081332616919868872721800599272431508260867961129226951323756273854323990664223314707360329372476774697177885209917774679560781733456759052491397459818301949945074781041748169986678508471268317909064988707715760535816353112454175940457820496552841016526808712835435373204415492725661920854771875135557710503966444500892585214447746755264166965152186014828976106172779373838921994421663593546589706881953366766510509129052270279961862080398364896787499628944681000162772330791656636360265737820462826313334829744032997602171644288391692340475114153945330492614592338670321510245661477466178439479908646456241065122466155824934213590169419872858963501480782084380581687,
        1501573409764364377335728517407324660028441379694418100240066503800169910002698244487613438838903561933061849288299654401076734101527517875880411328360547658387395023616521520047953899737020062037721467176710917142898976600332064663555123519520069181980381708403107145137311480262710907062200669051875763550249922477017211917674352986004551352979630979201870017166504056792665118744271532598905687382671835850090265053454044585414347096757673028145582417150350024692932426458167858150839882967403236384050349383194703272090978626661411188204608639988566445857032165228067286863540855667682074581662566593122825707564814625925701929638017405790378921476203783327257908478002492786149261968335610508849022054778233612252758136117534051448714005091767276672381884222556985962264780986988471696253394587916662381107992640050503162012575792082840953232431062824966036157624469105183646751987545043293865766564408402821941053708817466086078660827603866553027647021489426536062822821690971363507517329295471542885203224759167856712608721705445994332749623460397860583203837380131894061027740826886861030922305737895088539181619484629564489457595015603999195999293434394837874573953685606597151655665049869702911756965230696000152901574021211,
        1878283837983283232878346795502101741892466421545211429606630469808442443160382462534704349850297847264314947753254597648664515897069412906194488613642329266209186527469685226152459966292372409565451008659440256450060541289358406619462007025299705541640030809671476623856443350228533804993312696395889653785427906749507126092871025345999315919614477811615687457975745552729766445219822574264216385234034303435185323210956275534575080263384699020079582548604685226771883593626942773343568312938952997095913910105438599976601701117486177909802878820950272507693014766963712908955753666999631729777134427786461427554945392095110313995891939674873310531683994862793149300775605834974006900406349757664358827932651440306246112022807568794222772359600030584086534919701931537773186609957193070907971142623900432846328990064612802371276242602227468257050252002204872837428952139883973701497245519727640802776846385956945305068073628828502940319073848798308538288919479790644294571350779135180665200900720036832829520858972485981646637963090045747870450551015762100849591466567197895533688110220718628824004556390268201694791690937685363946652856012018025678644311126791399260658041691956759203067532753134507567394779542307468761158573050201,
        1754146052800425981503567011975604234668820248507243488696063248243959092881819044804957914278672982131980208292934643733736574002751381709887853916938377030738572304879165394717608802713838018325439572723289558936411297778129616238891044278463137552306994034531500135670213345508037132815668808161709706966771054946234272520701727339095372808043957423663775942067933501540482555566653390069345073647085841414575367499521998325729182643367002715749415163587376661966998315663491379158144037513585608766250031576035092139992837770808155375057640082599358757003444190259564310847455392635802745494690713520298768671583415954533787515846478560522748390966971566445898714754109261676458456234152619511907606841741654474860268787414129319696229886561850693125089651321350617714855878643740688754456002618744183364442349575781358205859608884851233374059616977238323853631926023149339595089591440963277851791389669106208145737692033021677795755760706265160916431681811419743955509254933086460740280643665150009432318362685540720593194836980703748578871879554303055479125894806073089747095358751680256999372690263561548541451297533069048249933181917528103765495362898451591560996784790423387502969446824563334709747918950497225981049033741109,
        1792875486067928748930970894070986891233241654941402739329052621313430308979752587819233452619296644440014204419672940635995344763968888893310375823172373491388338716354898677892365565985579874024961982073095196610976078923686980024106166324783121327390079576381766200609545279751755007135940653971510482546528994781327666555552814632314782167819566004714420068551503431965730026496059535292591333996284741943889285367900681072241030160170222352440817065812535224410973742773579055261176053107636237992610142931779178542174367770857044221812389620245644767648422793643310564148937331946678521863663161751774862188671290560418585014427406580741447186908380274083089020382186939574442546990511797874504461151528825474633581489602170769823262916637347420668733915882015393282499597247473773997166194861360212664682445224920807860101126729527335492110105241497742856768282212267388095013383425679236171613265241785342626185884030074607161054852031391358445976401197445928961097464226137378246481588805364367726792812832309605410273024545671433285189698860935128883148849677852485220791036581883721513152440974248761705481507294552583261972920593549637003324131691518942279940943407421763223908420166187498708344989496455665179400029250087,
        1637276159000998169569281577237605191980047419159597310539008651868004216751918012144749547248768031086884926940794059781828366213077682154827016461722102245014432272929731827678934647351563739044363216441921039732775012974014320963562350392869360340613761440076456734205325674867000768306462385837760443027278937773234534207251664441154445966725032174193223489856767862624283668407998226179052912443411743198695406888534187653691646865111631573218379193221719739578916226355141193322150732272122081729420523262130660637111501323605743255965678198778864683603362468342149367570357747180017729403844656811659871325165306412184806447681670478147221152522420234826412583144357379031624364157505209506219667682899220673237246290903705623699914692311164847224638566277732141209095196784221430922194176283259484966843483352599950167136718405072375587594814507477580650250870765020075738362914402026858856258057007070877581617909662502070515681275647696057652192680267565273240576841440877320200632125172572553867652669640997712511936100613196983344941031896542896186215874702275240080940482718990771171969535281811985689604176729769478231330348071541729351763291473659888484335314518064572942631156291039349304944850462241445538646770548077,
        1233099817819584383823239508960215140756739495567400317340795380606099493037480111146014027951816163644954151426678658593732054141062100974795733627104736849267461438652394370731197301651764407771349987288685520231051388951504065205181483714742897595283856145835212465980904192596351305148973940639669152195366557228500250369333897595427828220664693796813174472771441593558052293342458382272055984314863127836294145941684669032688132183866135943141360760883507878685782323974225870505290213460800022034855921171203677791065245873371780679909548021467929322964964608536405687548608327694370953901171311250901040046986613136310455305708362722848222509444418834740195671384549945596474389115861201948577238220729035684990379110609590883536001385158953343267473293923708677587110922668399956147601938993063281579097321093953231675041931769946779227568318258208014499413419148306047406750600392446814633695008333902207266948146019964133691863518385670134042897871978982608515772003959458255427220904642832209700146743229543919107657353720462708220544711237919461105914861684031564461986906372235149367791326970914767749743292870484324520068560913017114002304131598113214668395560689861105860631731416932629871311936977486177369184631925081,
        1811782415756233773080952971859614095093053355053431453300823308134236803907980888553992889524278717295747934399118890751621458804566177552813864916550228998723950384848528650093600293414117369226121079995734828034626874679548177542820375451218107239039252563624203967838812246987938593899563354992832428156953918648542523401197824733324587872951811594017208230542995598241450752606874480166412396511201806182921640132480380659884900216070986074765277788343570265622003094688393483731197540795217343303323511143849480458498596367963855013319568589152966044387909464290752592522814732210485498868365157622712378056235752790321382333956379897904544526515414330524101142612353104060181376997687194321868102067262948281446720098338179710396964371550758801243658624411250327078508586253289826332238267230719941761417271214637521591343457042391921786058462685883051410780662145832898461781856048905758003157024438915195163264989866560779884517462166911747344188335312089983995904164301681091718808329311179923285757751364429504908254212392407745090422791832958684809301330465557068415315835316354312121731804023992265412445450468858770568545444678384154007209169796725932989419476915117833007725504596630069865162425391438397477332168439949,
        1130121830790662379891270077365655497090293571828870065551886459699799136540368183288086995058811617628857289415478260258939727752204615138960210985374156733691329394558302269414273961791376689106367536598059618205995085205996470007568377003587019061297640348071449856990231418960102954779387367315305914651890825746457077194380407884592415433175759812435641659939953795711421759065598240664897475731539199112408663684872924134189530715678808959683607964149204107454639649615578785796336022480901192565142278208598236004607140863020960091147973917554668849434901258659997792970035562477693609121437463086179608769464458623558656980799148775505591971220742042876931697984742585770901990696888977255112703656273664701361358802037377337877850759219148056153239426420823648115238054662204887842854102753927462406179846046982725556093150285028499883156042790472852895876478595533751622912619663696286780608261580118254019596045517765297909244288689402872142649874981993169414326925159065671111062083044331849300378583517597575137200289715478974580433054522211359322956911587569565963562151516455339674738107908152807607800897367249985556969232338421842437821230824977560108074483589562878104503950461860059488102776040603496259197030318393,
        1276354924351975326148812698459270627770270872561631625538317325305369547242976115483950162697183646904522379776952133605245702746336659342113828049462102814279205313058842339816943733409157759083049671441103235525598850885216230141065876495249822696320088716347878860508566859185541833237044026486648958049108202069155038603908347599648881539032678443015893201491208113341955796334866980352177471699384998709324156434507896426859971639587796082614416416273683845728157004783863859068013811073419886872258398228886937707394107928661910128994428080093969411065294255943943521403058593816239143468095439817480831344054866710280117017251795242685298968825923765377854717292059449933551964096923195564946015709960381210806491385743031519871398755081303568708508296784896154085067013632134735147278783957620001018434082067815105610461477101222230026248826844363175096203555364409448357654770874697297191905453633703022704952827388375149467636565991952607268094615830363971286287646647964731385202128044846539297773147135075350831961822663513547616187820895850661183133435954058664356973963448693074813360424796322818947981120480707152135739385013694786294090973921642019541150215981578016081848113468631953179229715373554377553886865596029,
        1564003663385071297154170209706847529768234146597372700148158118876463297149661795041108042475129807388798347445477866156839199172074954261132802575728812187454178103725344076326540023774304475205259271439685443548511468385000891014517930307973097223063072444945215860168004297057668689008518260173754427030810681148606502562504975276105119239026630252470343023981594530838143187366562777320969377176476725710689091291229413596759732506288681907906212994873551383719097398868080636245723076123042270390496056075706302811526802341485124017098382138404687906773315803230413978529313557025148763552034137747797401096730073590184654391865683111745427307954233527499574130374999875833276614771728325566449093951849548390486331808782595755330070030289931130488282329142142499409753527814853982524532306091619603007151139498163414917628536718272020668587992774792092232962827287347220760596235815248933931621735142811769758835336260283534788080786211664478460848458303907116929485021426952238733446504304021909501946273958107830131511363530417493182865645027303056394024365354720757137922854241236870949376865941609345622830379274444010806661711645914955596288787775089125933130216035790679881407905171682122596246068656232565647358995934867,
        1560655777446190249673836485045965555606290313424592992325836732609250399588685936998658716905849095918574167291342839503847258237014175460980933309986023002844474713841603696078118669088253535396131175603723173039324679842795132686054043555250352347529173765443905560837248184125886094821113289088968194415554788640576958475771171324676503155103082868003608258911929645311486037029539113868016182366497199619425149115042847423212450087053889225787253479292884187937108000840354608610442341596289770496289253775281951172510290535387712075035186360744138139998516655179695916594885767464013706759693182508995418482185262229183775153766552360709697906902294639130074183271103129340552372943998770958614344872006574611440001920884525627905041506419330521541636314247500096430040501413307543890700117388525270167197357862012246023215344052240867413916134711590836252403414748546849055620855445986256888259187645023683461952027053597761595804823667161703577686703441498551502262017851567907064298446657718571395158358782491600289043377602486809860865680486558855306362729056968695284340472301105504131277846199449420669180583741014057212700812586281971261966542618688316210368663961113162576332822521603326468382986512601039094410404406981,
        1394874827383076988668074740883902137120601509864322561619335454338576224223239207797667105635073511358347486453019390045989784765854098246274526120655599766010173009007587987815640061984309029184552936253940459280552673762835448669783206504086698992975796762774281006678496407047421336013783771298266550198264012431610238480066861314765693908978106061091481670963855508915497699567920246984872218550197341282152277602449798327208189223697854757545318295808558486138290375332435530387252432741819622565299381210164174362608546958580691862732394260896311015880072377375759538231116606624422642317672970726269059055554820654083175307584367655657422081331970547343489474942260465045863403292353879801746940931474156429601539746405484265378090614324562286351607432464450477439146469239772935465014048715417751670439612920768588536790709038265212566142642629874480415587415741274110859392500393665350253402116852245228243589452944415901836561082707232939906164044501901832537220627546396746796260242868840478057190084331967591797355671601848073382684604483776654324202863289776731453621843227300559731587601134887689229617564431847200553725906876621226915079434972292738909882154907071966086542612324924743942582919241595829162624528005307,
        1143256773432030189420479066939909059417529825064532044019347631514926580315162571628455328452940925586874356302952153950692858114737677005552580998489403064998622079336161908075465974663467272974256242504704578404429109530444994194316156220506464559207532108954237146612123724264149106901164746600214346234711554706762455776884653914842151529534417926377221888936383514047837793528516146576424203741406087456823634292563218704382191556010742820336711843717464900690126869103933694372312335794710178292266379281624999391538698987959416872857083881329491619097599857542998269573865550530468348957606013997957448499035138507819725798385520898631080412598604350079314076852749293542421580034717107805376761187278951734867623706239123563311988060544078807113182477572457404144596549512835298186744400803084082325381399382131141778283975634070132877853329618704057997188285160911582319145452184075617375560684898429991420999227946271227204430686658165960298596729450972814344198383322746973753528373192590229893810812174987497549446804092674055945802152394790127256845107467845282360033445858112915109585648378466390696245056507992779036895230209641416874032900933519766216673693904631889221378132060652486472129470152976177118834422149603,
        1326382038577119179225018152306940902377577566310914210508983652154877242964267882716571054183194115674845038672323439974825028199215471314006880463082955132943871327785761738934631088802994637789911302833004100553732497948159260106571053871609225450960657706563055700026239572705088986166165342486408207836064470120844842374876643088999296862914631033525119696319844019965170384543935680661491345876583179297480307248662072718855385378385621871110648541884333111841722151028510995211106437742259512814945334864076679421748258091963252533967997869409801395398289191339896586612106895486877394755049265112451077122179822989608767866233497892588872697807174016083245851065389912244715668913590244512157405688668777020818806139627988930064120539013565938575792231585498549451557381606424365835002871493403341236352849468819847596568075968299729524738395062858001643779196412594808354359141639570254855469547116991628291421801271433055762548880290970438568968970811563793331947745813712806906011122282031806115725346154444877497885846913035493563548447483322452701939143243669438081698629998131597040953211438187906997988599017942113410388217285236013995576180217437150071401744719412432950770050859128992694544632157868365356132031818601,
        1978499238875840910945444329286441389570447663150783261659558976316825591581993621216379064796021925332707084146500174214001106072254264402506079973872440229275609556021300865595015762658758361653844057591576546482654133274888208923922970449501406927622000826473294880633296793551236832031793881873428827832879363732582050322686216923032433814618155385053230642569728984338672019671331209468035114846444295544595437616672542562975095564662843775665324422149623265394869132996394337561936572730934855195578042839317510502267755170078450186699517886734991393969894356762957952493575448583463631381938966584555240586024859013518258598334664291863463563280249437198236063160778844549302705547905710837889908554281276104173778951386143621886967268608370580787942517931202732447963537082906062739763696521691063293138857206996812396740205709420323901449350554005984570460526719495862319605004649932238179232826125275703744080395982934565143258225989502486315059789056134139710408231162248911673235435235672806723808200906874139522371279434318615268624193477337997727234053394224742464287712765950812803986666066211027049502541894405313373476612298124265889563433097259615135573565058172738944894145569408848837325588607584463485626170660257,
        1212773099600292101911723139391612350202864574022951017829922136408958353538380592920585494341604324837215398462438195625520937432400830946851733314280622256615690692151563346047429925901010792993381344445186901212569549926644079624208991244928507080922446685678669448705851138373850836150898182718742030786546151540164624170690133572437961123791422389834762337864196334893589774083834610690365964587034771217591406422352887522935520105209885629816012016980613483601230598598654880233783434566349010811632185708500948615582515661310220115946020807734789495374290855945040630742612178891141645876851042562407219521931891858367170419403861050774693740609023649285268327868396222857563460911324839734851272268801783594999690702954961919644051805278986960532510957775572641992721698691882954321497676527135161033231535457850669532429771150838701229424543581415723420308069288305058285594291865965422269089462507686373852541035490858770581869579463433991468246414594236629254920961387759201408463041406915008473664518942985786907048789430375241684666523190441150086135213756500763550194098484030309981930903029824463155057237859798431323184758188511384060015184924217397794956402792338889592684625686233372428826691676245938283546217804211,
        1156506382405957522912677956295200444116122450657970617615906516154918048389500230689318148995489509244761944685924382288734654973746465725627170436616443031801163799253908849460118470602457524050128944868818046604901067753050506164553131494604343253197500580619114806965681610318998332141070904880338977053565877150015507693651186533956336545173451769842674462246894573727281594190149130050633300271751156793855868610999900783681459804325470719736244599024354317019171511101328708228662098090307209774703089180318061789592888015185517564560169959441686613534566578326137868314356355870557604891691706349647900475144584198845925490457766294899602093591120599247079638846051675698880750432766978748656787286278303044573580617362074008683552447314356776322886911040151242682060269607951688248495051459261289025816931969691948625264233490342559856915837849789692990347830681733047062667900016411175607251130068885517790472454792514185139825566110249846451696553063787092408351055949803942938936253565493449621333596089245083424607279287051951622662045862231904727155083927492380959409945622868926224412420683988716302910598417122242153353147214916091908382554441028290737838192776567457044231062791543702674692113384590297925005433761149,
        1270839203983908893419994792412749339676263894370282414836186776068131763837689507342627106354379510011219390464265897837773685313546792421864890226938865081876874674429059906277757309010456785961701772745231811417801353078148320095872633111930490191958735797952882977787677441575279928236322765577954114757233224070639868847620488908999895469417326376798845437971215794667700537126623509804384471637455316486451645684324433067073416943892144852522974092801177276732114036687187524736074600805392885834648326202086850148816995506792378863664245839016328624756371592917498420827892034855324763931293874157621806784127873826448217009138048702824648902023450494976490090903307706989824478812555288823025620292858238361033205391576294723358212130974157370903804352842930636958177866683350313207971906376438587333278879008324440388419486194676740624278982919119212036821742571187070438408302468676035141773350232681604817550778658529470520459016443134499302057359392624338023728759862619842730739564205720582902541947871046179823325018966651145647525902734937070219941465471858495739623454284306362396439035258997780389003035690768793725053517749709937212790806648060158791821678715306931200537683767742036710558580895892961630165264225451,
        1711170946455852949468847339205324628978109475380981302683888284653586868532868931876426931375102006636505166080395883331198500549403845786729925393451488191495881875622260244358310480218045720986643862529025674527894717264593979873334553378846210884781611478582099197067524030320260765921610652752349155536401583272334294697897286783625040550015955031440812192295766163357259393208779870166217218765114912244207123332428041359911463770603655959562508935686169255669729807702732182226024737742503444125508217069686601951972440223261176902897683648331341789616035581952909332577681302534239911656829095045828837382842152894400096053976367806250808198045761437195235636759144741439161795558760216300317018002656661676223709855069146191699243128367478955794461338842870735236121769732409531305851622796937306451468623190992068557702998711305385157499544155259968765241024801365700889649932166267463067572296022940644984446158642339316179539068257733686559712250862160098857090787800132983086651749990417263836328579988804152475248707431449982312506881678612182270073081689070375201504384554804271802561854370095782262656927823370083336672485850967847741394054086659284073615649187970428015503795950909171593560838984295739609452615870357,
        1458631286711772595063167052995003040509714046028259433967884116202632328467267185779008327791727748982566284720597823740423341500275655135264964917114063183437781573699248383464601462855637196913077789938776803094023474982072653717093159142893040514655537930514775890248531441986984747086800345108868093551153778498918636823512125134289622569467960495085462285904957924140702911210018791167950107881707877925020109395830795783232360575888383664887619856524420444232000373165736686783997553693501334966306935330953146335500921928840150022895822394633036347851232392805564006807169167217328825249696415615223196798251451985160228139817945032486942689309819291307391496928252634792667462037955209315609989387926045188514498919866165275789592954544179374336332934534655733376852917036055503293306309813774308514309562217019581421844446770085512896183600851964504509133099773596885205306274612329842837366375166972462131272983480523633329861215771714732295115014031965574008489540567119587044681888932866859216778298376484936740014622995903016159614671333526430489705640801150500179290966405182245894251126115736283741822726249827671667760376201418110621859894944305139180543785566272797025057510819546620180958708376317775671586736637411,
        1821707338964276883124565512040276624029571292877147355725887552302371351810280216470707618338757979494789276894768281076236657634319136281766297366398924734335560269147687844057504034268112816057223981674131395303058464202430021749457033670874009499283154798740999360579168712664839818382551233436958328124873873001987987112218284672886956743137638699915268283785354320403391657073974401683536034434125054596052096075329198234414429131370304722161619083589010504578342026630218944908328551798284756985081497322724944790807604182098515375106978330929351755477208176929290059718826803565429528108303850707849309357195559055458662593601491782497469612581317276796270488648033540728364066272824137649480316158544713415018878634970400939941911877898425130246940827109174364776690777720037723741109643974970298098286259274021218605112287982136410214262735404493119628866215077830406968394174515479144615398611990335121357773247087280810167645935826353666599361856408929069251297311469120436194811915419873539488129824802836690797632987274861163341542132810317108090784286086753249645923618941928062681162080673651455944836885509558755541457368393151810315907688162274131367605880152230794968036216635389143311575392038765993980633639904173,
        1388382700022882871607593208843165217611942217118926427359597119837170575767086161048809573466633768470107577923859644911439086573763274310606566845893938175982980346340306420570320338300594518970061531190973887265848746508797388216675759725354973417126283349793371941398530293815095357014485229213001355384948226067358621572398236948651855271799970388763442095562639512961902977282109020627648451317850577803405493350059710920801647328376026512920451664222432755187620301359533617744999677926704531430507850120508825010781081016827226225587669958892123090058137567653373700053307829447485092961583883371707915802063697656979242837300970315883070094447779216121851277715840660984464884139296351678781586786622572497955364588033444537593418294878646763492320820198322392456989575100209259659496141257893129778278322719940352623657592159378461840489257237385825638241660427207257647057237348830778636166619757043819477024395025253855012514985354311725283991261375467780989037352534186945646084326119883532694007795268003296550874640452991469222487958234215541990748241543578952923265310640694900928327642733025187501578126302735080426447347384134980367465587400574003777900706879965146350481862508062038860505291796042282089523609206569,
        1081898652294858147940001195083528874242424378553582608998935033143755923866415195591192722074552929286444747607281682863676788229915169847095835801352177631502279792632716888691018939931326827674873866784857187418887111631397858306078022374305839583279594602836930588343418258377289907142033676290629856938062727826613533568739795070087345651532222054097607463055239148899520414845246958704482577812176688921626345354004993268967775392315013923048371945372812426570660740379849352767276153340148427294087982299733040879407006612912199975239317670988731251496119054390638191185032790808526589575166503458188776824147799225136235631263307131678156985910956731620977267241183629021471140789504710533488864510083564106500291047570990665539290220145195307767859554738701689586236302380932065342604660698223566974848216041503313210727995844518197071237568649887025441963395031279525447875999763810577909843493788335079471215603893014654495825479592654319206363895130001933928331034616702751367131557958856064045786979148178164937966735118476022436449973724875024042313632038051566041560093311406316182477778447043882812350847948333222882694260442270992273371059223637198239786810080417984847374950334262068616697723272098567809181116538723,
        1738236211895357806201546700170416004075781256010479917926195117479247397237044059969704332078640035601520954188996082681650053395424011220467457026385285271639324483607403689408227669055740715824044407592767126735005355375828110597328689078114844519018513214306832703182904450793497776036314785328553350864304435324025254040568847853736444807021972263774287245152164615360302834839930444054471466528313613558571667186066361484694505731445962638965889736144831709634703332322348300134308118847036496160926073629513814685971194210342916486066082290658375350978121278520527804645686876382427072439571239179756919623146875052576350378546551878945391298647135296830219829736219687724171996874875741441838370460405785641483294098039753132469478853164223639031242057129088646478603399219463551962656788706355659981709231413800856731926038006330797810004567652707097643996130954446833847791756953438484100217451311871608006308408393421576561548809997172757983193542984567638223627339461065585783176199805447183484815185912090263850670258123153860096554696544902336832461172047623479017329320813709155596261686307011127144994181046297351961222954066794203063143537190989507240432366645340262902440847365859190936568054572266397656639433590023,
        1931820579221916690390596626559795856449857821579700983568997705526243550485950731861942179419099805245346560887969391342286964489893355951269976168324626359613174885423554683728009568209638124468493253008075102133186072642968161468218189712529086706895860307996452180197363792082285408693782266848184619739765330064020835916431268786239225337893362579923840724869565002037165156198526015293976484238228001053137549251235325767308181906772585990902755996306225964924198708010302505602880748251441450039666964722388034138808723506458983445515307532643896284682226115252249214247917772994622427094507787786742130348729636594592118502442655940293973061462508235370622508097959035350455713905568186711650916987165746914648595246900316249019316805266875574048554619605363282589328223639714662585213906809268842737773548983607358041670466280307909085446611937514764483922146477082000008061558772172777294968865385606971728524214422836497641259342631103800010836262558872674435431519547286659331098608158957776340289984283054785261538354689846748460113882660453084215706549630113322282716623204474197652704711269415993691742782607492421038418589917277134562054517693381987241232060686360661489368965958984346427128928238033060735740206049951,
        2069257194990596622793399652063944705040881534767154188831914460635868788320902722069419768858134440131674931244828529318407239352367118386048607666464002479989379801999092529818265612842321935803013913001538882687609494937865065753609101935023414815773460456020583063693802065986750756271254431081180360290583398870919150117438575966782601220889913227521522436289978186946520803733393540117878652995532618193620001595966976207583282174481180009491134542580620961878306527552538876860245552344469311592888520067345006544697069619160103162968706966217397578853878954980800373915541563996464967165624306933973255041438946170587638155179625097937265579857704809339422294144264513566257722331113250289622387709570220438181356105813617008002829196228399912019697555167038675845954359607266768630975985108685926680549646520268769285424728892230454885118610650687138034838845380742508923332458999559564313213147978021007563295240448370502883270090595049809110341502282925788511783715765580096792279772324290703737326240219346476247305934804994167549289989202305758941599403945335923898630140579037139217220232071085995765222459698917828511170731542585086807695701137617967420262771842712206025289360508836840465056758166406913818289701532473,
        1321036900149011445358831084709121046254525596687561330388656549808492012116094361181013392966029088852524820897837146428606229554545636993616558426405115968659913786432049797377633681629406518729406556281121627056344598096007270189420918646033061421021612413009896319724350691082344830601276144181630966112926614194423898485476235406010001769363818111258982066464465069708916307484153853478739274269415102348906194919084150983684911776689584620167188945934708947532048227525759143243371386388047328753897509409767026629036186848871727846435934742356276832923566892612089819056804106796218514555826281039523923267246329846553905022872298659117105008659279871522708928419084180953034215509923444072522789093608247747127770910331281693938082571851966097928724472994418867187719507061144712566057768521206790965876666078798814174896460774837389835198522283352503473980461796028364202346786564468833084194709782579924235827132478499126998782032936479708309028765088910954173950670092355773595243685485110500481137086866508145177945096358540087170421160726394638090283466614120978487724105204198454941792318993903746915174228452434251667894233005875839139526543184520355582296454149302546744164076490180834033321694202706321383064042752247,
        1423450057877554154722245957419443918366512824611319356087706813125773092555822308776853517582243521321710437120124609179654783940396397480137751366538110761607121793433663345022083475441468444997449145571256653158739532809195716802785920702841447817528494120284321974527086855942779950689128736384971215902659352613567490070057089492733095871009229137316824176997617898185779155563317234467880990981347468607154244852258706021811608223618991405573076556183728284805909239263781004206990350510107559101858464147569934297533707598174987109040947068563391088207057048443750928574605926747203975632565771060844575831684920256452492612934068571448721700666989389989312923627030585825173567967807853758782498972808804891581325536760934386477165200206055703257849042477391849348497498569864226109877814496286711212108876630946026114484852881093003761552325998366179904652943970787262453039306496509442632232745411861904818169724816275071310663871711975154334885886846840505629735976253708394797979083935314004806100326033680398401133562985105665700944297263019765808341096154397776426220407087335456340721664924348948458695170135119743852102396162706814517821617871988983037943137932189390662479763619418406692697135003875179022949286044029,
        1680514473640367702857966398056430382912451783802342215887867606529371208825595978389456389085353814215845862908610312403835968189922121862421794641943275781751409540971900879127059029538359097008532784096746480762257913579544090268579638778319064908439670391236304185813349970567469065493320749851736688615570266666687632656711256812627033951790821963834398755629615089593598034948365192038554487688749027016739064727734893108189297428712523065847925274627975384504938092806270430042200935367884560882889424419877201048459393204804332997622012472184754013194851316276196871968942085147784468343805445115713334995819888999858511852903169843677394748986919165761042615528748005333925874269607161485700433313314417844600633170327836334188362054722439875353499019800200559177344387863055277775312105553619146613561147182150866153163376706590845092637124235460317289258481776165811202553898868746850837115133796737651933096426257222404780386392084935492933009119628792623762799824180988401642719599022609110608343800722040503265859199427810650436152214331234973034275906890389382883484333957949243080941472283456528558749125876185203083440454987689619160831917392510407497339602446601929573348933534994813310465336971727581129136742817811,
        1374784421927588931076924707754691628777523674122152007399925592371455205935634618685953899564187362712457760171462230911198594377448751198209387147115507921168690368582602629132404378929343526775373563300239960124095936779164857769814693038402368910892871445892565982275707742398870092395882224724871983991312384585821074204728035707865970534730352102782334091408205436590344510740370542786372446180037961079400936057025238023342994247569225944499767455341641909228848783875347721173391918626934921483271381850000917770960701326265760646535900575439258328932803148382256357106539361058583652697794325944581876319408780676833213917400489692659053037774426103620395141294413448172259596881991166326546027162044780610166333857004986942087014817464797375675713117912609464510434870900548453997406658309816071788388004202524053755993399493368905259230435383294118419794829293646985388681608895758699525917233003901657109008853734835143279262773681024412171192804381429699473812478324066597532538173710444526245410443739422808006224662762267615253425488941538523467383587057085357626994793100907776262711513429462035748050089782231651848248239745429214503443142858659542191607993102931918319448372770139829649383217907855605514331593896321,
        2021542812766354824907164601031613975614699550556094426352104185908072580200842858918288506676835581654606245196595470036412945370749148621478901906870230863203604222633016451468949231909581628635989090247537539901437841475378593395761200900039607017915559451961463585625648384707811604428962474745631109512491529054388998797807218029983789998541524772667294002852136843908397450378123479863714122042289827899303250826816771142415753960586748821193555815258824281289345943051515194131652440928715654663337568416610569449485739859202485823252873913816686491898007055229490423445394293257311128255383506732026934341267527311551184783781215255551275099291369821600725694279221450201522424503503480312772725022921454471900481125234072821378250461490252440484025884767560344602876446741484028007918247916816471259216229089526958544646680301620882250901108089111966658626642607096337544843795662243125030871337520913460881306249674871422721913470570598939852249774143473057000602648549522830756176465020493707627126626362334635924163915973923102668699680684089987012070111164421698941840739330062578974117538121692812641588762601714868742751174888196307000160507503912976087812734018548571101661956280485119786446070352076573641405168676547,
        2051844253752798485806352126001654256491655224039668544892720811160543812633786598623212600674348166560103332298190005791396826728479074218987855550861568074237997782138368603714459532662589701310323423244543357982731681913742420246231288085333316552712925123237653761562459921368021165409103643577886118150250135341074062750614154438757063182278676746014631266266029925382464691407615149349172988717098772627155801771646820516899807634371402806410840767798445579408573123223672384832846551439052621907783400960754428050261891168812733244875366081657510680570243146313345559405964724289700796618030368515317018639692613534685320155482795467727719657010157461111240238122382519792342876950041390222528187475480982985134393166175400126337414692181080870927705299990170104881624849721045038231803229201265532014340072462476009252255943013512927104909023537326267882430390370737829445456243579106279494322337022632656653342560379342210967166794831635534922847258824834358792068534749445434242068615129692601186310825550297484889052490939764648400101874560905645638445183426996872446754677598900973820894068951138796140426275949148000914320807248487642174123569346841542803529720420418326509552468980011823608733104499169110128416626098249,
        1310316193262822000987227709304985567446145507679682418883828239641267914935104286887809460265807319154437745220028244921243637601727389779785028866354834271770761117494756985287174538494684294734246932766083787037448497191673300265293268732110123537375917411485708507970527842420031549996956068261261565258703111446956800966539638879894784117140329187397039982162684825056051021183860077910697936986892042914073781975374783602319846926253730053754855108208440808117053599831207870717064078148836628326064011332612711212938468987140654691611680366994032371082500007487212351170044117986349184937662327549007318471852475109904931965682108371807632217388132989210201374945959693914557575834209135961134704223190420050377959684189711162444408242420366317626505098482296098301152350291889531600424550145187825158226950937339142461423274318742652120522467110554345358803894822716607319493879556578637240556911237176969726498974294953539509975849609639648169658596905902707617986848610224978873113394958669171711009702543482894470567166781353422300086838547468099159842379263331679894590173167858239746831851977642183437865618584815187951734636413597495309474227731959742956778601785414792205956141618938191491953591698432733265990364320851,
        1311590934723021777528016777981847772672148475777313206643174830597158168790775724268499072021292043905299149889173872997736369327068295290524595555038160392349622060314057653037398685779659098298282253203289933292314096274984772944265208331143227438212234903895278764213991507153324985263988858406437747665136604273399392014670576868542747260154365062162923180074074332998727899510188717543636526090197143579936237033676203933565608844987260371686428191520125555401771809943673908988038665246268832594957931484496375795951783152784357698263419982914448656634741301171538217182314625541313020403631884697775446803940992179886203851255567873878816678634445221443617330657683563884484911611118264635448568775560813174744865072938770336573796602838704014952091721584596373111372444408715519670341237035120373975616645672943030591845644641304014012067224898956191997775817129762509654734658047088415961714124154996381287315485583024307271267292916626191134555758068969409158530433692090250299577074157626348105638759309240281087434182790579761212680618991489585608728103436407943450618364690398671298387085253670026942140927116683205586774437003103474606827928478906903246078511618574326937708497145663214444543508185094241410312681734127,
        1056708737751455913754132595390673367874521942866226725459904290775756073491728072995619071030457329375688449155273991025692782118199257540508459698321537003340564498325681977868482428090539318765079818937864050189446570671872141939904805097816539893553198732619763594760399217077796767321937129353836791006657756927763200786284527495241987672601480225432719738466479250136731679088384634075893797923468709919443255218957566423415535319125480953688570999469451108940843882628142502958651891293805107809788213623709049593097507732710214289554954550169138377078511586009558797880553061991090999637112645935496448055805633977542913401263375933409466371130373008582327301505250339304963101343676669923920228536585079750660430719770134473297314562685164360675142080486230616457777515034880804090894449927474446757457013625700920582430034403904252404622125262431277002067239032592962116537194871237940499951334826609183575163056175448084825041919897730428910024777962193703812182107405079344787122402260691674874745908739353781475656514088024615529675395127225159717517686071386701888829041915940312315370727724528335194497923160514432746538610073925329460135778721680812716068924018080258760373629049641604407841722573155867312938347608861,
        1800860677416919485419491229740309044374363746747313643130809637236787830675036733654281934824221204094206946821841628563223371797492280394751445509055157295292575826118472437466269752003474127885376750658849916011116579652999966080733015824957815014014804273485953501919861432303678222318055443384348892814909516595815737245174910177417471785264363939268513683336219233777533682958396286545505405881998284336138632406041715137921554399223750544393353488283337337186933481497070289354203873580258452377017588605145672126536286350348911733186695359205504155254427105601997526224972367524735399691959436961860506901763448261621425088167723081233851010128749004845392164758361692707098711157840217751290775499089688875565360722339167808168223302550745606272956471946029164915901627424544871085924201080001040138835446845782838054079182937944955614195698989052657800630555039590375735810506144568369870230309540548229306889539618747235613298112018743718776048752793025534759617348554587109450129726126417439186872173774191467712876442983719394835372554678956290550439001745306893382674594171843713757778047521337479586779152454300006884786516376447070044866051293341106995031597600371626312991477141125747168325574683392710837797520069341,
        1858416177832483443490456236287000387974759413313515837256979179379225058543224947086981742996181099720505976301951107075271859801243133245164012101098775144342945336791266601854207322682380719183076384621761243497117234991478324529751217121770848049105232297606454098549490684423773419432788890799759646180114217013334794533887437512825444961930345441719245696982309605859967112651198518627541434659485505644602637739110471790774467164682412546940141548633046739461853688680823437716536885210711087692868912823775655049951856244671633898481684552097631551042218075865921155977644002317001330582147863332047304656269693000837402668009646131723729604889982384551783114985232931705155108800057417950668579936328908447840027352452417693690776250423538391330000067774292433638053502650918774706091288844108995552355734296040035165801737345327741155261964388533863778134043401181138163586334890277234603778388666995568474810666375087789508184013281021500708389028472751282789806633790475871871003759318549731547560702454600844253202170429918996449258419488643598121516693407826238929217492398540900888967964846638163513399001517492457241987147556006772575621476409596117519560112055295505645454339181724193483343922176205820938127962711699,
        1376708488525539184801428220454730280974752475191190535469849985577371450638224093257438543881633192488153360886629433802805147641452676830144271829761463901456822669559536934910126814567674030015748901391815242587516331423445360370141221799843537917203951602270203483515872839274213178269603790937898005039886330016979069872185566510077517441015832747915229032536120832576077849719951647146246785695070235643253488883151062683185751133865987696133138084740663887347013587246295299900726334424749753807988994697277076338778119605167482706947542745641119840774690242513784864609109753424450937241012861642124476633679389689507785921196776156201276014181063251902304486790754483675207521633055270009739579986672894784791120003282527585023792969548603631597312680918660823257548252908904841625323947401106981702711302436480941401482535016649912280215109952171376646714226244572695856683421606504393199017603838139959789686673222914083841848693107018763971272036519812571841907849961586435425153847973103004367092306288422008856574515132088823079335076625882512170815319576937515605335613687117733788321223621443753476755519781024456833049542586941994745037751293948170810331793887646177956640159499924750262720230962255438688790737142141,
        1116316265289601942976492525294318777364035082900372113943448195756512047569113111652295478792139177414851383180531114879737009879538732949347091106586291807193421596488815619998078137622693680018992954464546332539993224050604656138590411494083781237968317267988786995368634747527638674836134034398375607644354758927542463246448163872131079846299475361976378412890725371894216245583158428009643957702178222893453244670793619737124352682841169334205212885427816383407847258089053748517437199319870667518210226658524812048721218816034152951794930350322815189559458566333713330325393663723889132853207236344431199773424805414320049141360097156336727701386622726937285230381669744214987965576114547497748544003910267900424345238042934513677870925184884183083905935335923120175210436792127557758650317425670712098630247247675108771182451091776574573646823426943780230981563007279843407333815851487162278122227232930663982690682622316547802770434223825267707828823542276329953418825903864976657997097780057586657932878058288375220139745539116773446873668511464330866572548332538235675619051477110701196061012721237327819262901489645239807692823691117433945068063637140962283478214627673854654246787468813759810004481676022762053305533913621,
        1622421803345624349711106873796160445597822163261201875763332442618255587500578555360331915181144497162877869753826319867538583903053208812788312616643044553517240449834612780667510699765117410067496047586853192390677398007585081095208560198030466437736276335989645394177747699369060357689408593038148548562719639248839165189785722094076465098415931115020042048063934075632030845227605608079613536045273134158322460907749436810391369758442576217194163882529421060246900314047536253772197582008863148755171774246322652542779770180710392941551425927620739428439775708461926672031419627427216503771366012073476627853919227105711758243674317929621397937451205995571267560902113504826993572859884973971244426966108323375713342425238312897371430788805109087669806166038798269592468173060951010334758891898172380804307350176662822734231599007639217840659519433405436212710624454734516732229258297661587599542545249311605114198095113777965185408072822126303904322019004171029519039874090497017166370691545747648783211396358644583470134950195402858588294148423081041971482144376704632001544404808078490469494828604452380461739686209307009382341855801155568347477948411432717421940965081784587299640791312675324017374735091966199725790515868733,
        1327635757397265504900473281689791938734240398445103375987744732776352231064280220160499822541732536805781562461290241143237663201911312493523377505286871313865712982501221934276972864960852227283224423238690303828309111042577281081077449059017745937742380200310862218185123387889536735683795088085360391350428815270898451514627877915961767848975531461486063276810422314199263896010167464286960607037767595461453752186654593755187884767327312975590656655124515769657791432988923433700623760386387058035682211236163723429430493150251802308909523496242430407673261255701675456515263547718218672455642682256778025815036182861855174258019447805437966769728023879649087130870320002636951899632313972654521136541117312207481406291985749938181830320499161060764014887576037599697599302126209350621413000716660711481081001433938756809044713148728540136428318748757056829776592692591516808586545315829760832011083620992855562388404647614474180288232710967394512133043247997156014219612272219967389868400819281506566125358940145487605004370972453160240538086255322872929286400489534172093694648127272091599308701294760052406346079337547572929017131218543536092860785501683212515553541309534716191607866522164554389562827612791727841255958950759,
        1883351351649146826564172860467787159895224017697943358988766633469229776049563048819691365390738796691866220294162266327303393675256511432402235103273268073034794686663190991581225479212528010819545705826582910006865480949132540002539404465271578868665953174479845540665257773831936896890772956509199571575729153747969832266763021311957188817102287482106593152149378045570652488014425366888640062791434882106982604029805033709429803071335955977288512709773559525154770214630034313395368887354665224597455490800453304953664215077498811085392890118016934849585909490961804843896321719910099850523527889902072076584556506461916615370300615626948382179250234858866391958908491161870533832188030233075188150016599660658582572501105188779756759278308391184225934164975705634364371049512264100006070951940644279759432404173566978343243559823326707364889231868992370383472136173259589202883571528010171741940049848831992405942592306539374533010298402572822800062642131605990963170918477913391270477417300062985432074825516732135834647714873654746301897486700313777718071552147271159646095547807899603482927406126631217129207325885361542545749127850178298664223248368998576201031377850057032338796130847784460550741609639902426087831297812593,
        1851568608856890004215507001333244849172921909102606323274251547219875295383551095212908311374461467267114908052957862257544971899669717780327442575201078112363907786143917687738939910410466895249071728003970819686530258431477893396293432144820463849345911647097918547958274450434347696101964558082921511734501996619707982463986631598375946943201767918097382987661336987222762732161914013167878745883291118535344587490474695332138948693835875267835182790198744318503798737248890961170648049330531085166024978370178912102567011246802688160994019176492045002398508809903121001597600589207722717206820081626145878221797568861530432700340550470716233588480763242718785905986843582538089102177207344317411715938884188537170133921072922736406031872575796142509840023252517676654702126565786816495477094571799676744389761995607960329084103908750069220962923196143190574417537674146312299385293440936903850938354051598473707551480066437692832787138874707529180124098670428151669721731210875316895047466799147071634963384013968595637137225801398910675441778032967962464876528092804138821820015799820240440030854107674458795136706945036936012016555167813135130061686114738370747118346694829381916858912712722138956703540447341840892371333713877,
        1125234966434123183724234258716694059610332185468979828554162354789442331481826356713244830948394948129028530563930915561308367959160324001450115066207547089295701896218073149661824323080875755021573091088087752793668075583008172807990886894074669805794435274684660935947070886826358566257320553687811809100849858375036005097429451847789731969737595022140754607197444534360190437386683707990252945025554019085282286600632573344547501983338975745942192000682586036186428779980335472806833729044424707075971556751299283624500982269790925923477802567536929022660502434254681674067464647027406462894672160393011669114096785835808842222522891170802249478819868674679323631317731985421764205512222256404509008178843814907612566692353513898037242006208735104446176025860036264788501042052077333577125807556587552491776845780888444468082387475385163027294163636201059668933610049162414291793218347091759927365658229349470924488603790902774708185482238032271874193513043484699283028291769661028538361044979403367700673102580194640189199686178313323710045680653091351920648281578772128942866879499518891052704897708654251377026076413523244970525187022143141535380868332098477977890502542787191934262140865691785539464863903097500114667390593507,
        1222460816751870249518203563775941265431166698554551581629904608610431181716352150127059963869467398303936850899142166167404643423923199895043069117909539820227452765687796644263864584426536813346798813358411368259515687005049124075720314102817658525007652732029039849207272052314151522867986534214198938871607187016880933094704944706178465809726529766419417995170719756293435371799931979844684680369365723978059069863886880178001340513773961931035402425085595444891556488855859077698219262725003423064644946511822463974715492688981940274554023685101781803088673257969080261359792462329744258010101829455110252381967053649499902462057771892635864628460416747225853667342355151545932269188685070244083542174126220318540063218971183709252856485671421379402465756163378328428584682430792082403067555622977769758286425020479869505727372746122645442709379078019246811407960992166390202247177896472380990304503811023322917058946774000176807272135926771182584990125828129979438089462411299811394652794867209560062566664471584927367995246584933909782892525986239217152078574633606234429233477964688300660616423807575470459468314033249824560978864793870330501369710080372425149302069966505658226154760736704873056329032556308343917175951443137,
        1589385719468658514329381854886095319510382576000892866418894413771638360919047288178881900849384035112050222439318082166417173626629840020071169369167734796248550429709929738596957994576280253853296424278133115146156792336395949047268842735428193978851514447122538555901930583639054804065677981896162315069094822047363604723292939701261261836192364029447200008429244933274212614429589623642602782675009408046662198541644750020429526275142033482239077278144369982326392610190334828047675627391078578184333739119026658894085653281806497909871083831562837262279533006929400675481539230554496436215482934166744329915287775897852219933206132374819783810948623660131530807398618153530256786102936906833624761633017878031189979082922324174701096303751729687538555361661665783289048510955835865789514934770241891666251317946254269740252581843071526456198123054456309151526918820622045365630982054468518101841224963655112890586409301570319991503217260276125217774682027285349697112830138773047183035821905717072901823384958946586175077501713350405336166709880256098810751533487653873224091215659166150728717322123764068344931009290913784827123285260288849311208564454677091754651435051685192629695419624591156255751961458328828459652855258371,
        2088777762826305013383505421433248765159928498094767560768466966567907815943114913697653623869995116681780213428878525675975146876371587214526472175702730555891913953087419996680723180268767436628856140023711892452752637678795425491344669368689173234993615817411607408142568097480237218228935955567196058013373877953763575571893811260380521881199158906865646938606053392886118050031944799735428431083387671119770582972636475828868993468175623745278992950200378082698016834123350187336667701102065944176539101539967232738823866030427593651674376183667313502442636985692736251100451996600824689569725191348984389234047613011826491221651463670760175217244205668540395396404626338035356013350390970159843272838740570750249568029814318270919965581026799223103588542213662268181168545768559583109699565908647069034130446538122789811975386004245926791375565757896881232014825891349839646101143284754309632642761262091805832273853416685712881460895799943803562931526946447700534506119799591992181598938403549249635436899734911318500356658140946238866331101615136443693143492746593769825639040634914004881853233821748296770156823859609045963714677955296206252171806002604826934379453346432983022263205841563476066872180487609416680806308379889,
    ],
    4097: [
        2088777762826305013383505421433248765159928498094767560768466966567907815943114913697653623869995116681780213428878525675975146876371587214526472175702730555891913953087419996680723180268767436628856140023711892452752637678795425491344669368689173234993615817411607408142568097480237218228935955567196058013373877953763575571893811260380521881199158906865646938606053392886118050031944799735428431083387671119770582972636475828868993468175623745278992950200378082698016834123350187336667701102065944176539101539967232738823866030427593651674376183667313502442636985692736251100451996600824689569725191348984389234047613011826491221651463670760175217244205668540395396404626338035356013350390970159843272838740570750249568029814318270919965581026799223103588542213662268181168545768559583109699565908647069034130446538122789811975386004245926791375565757896881232014825891349839646101143284754309632642761262091805832273853416685712881460895799943803562931526946447700534506119799591992181598938403549249635436899734911318500356658140946238866331101615136443693143492746593769825639040634914004881853233821748296770156823859609045963714677955296206252171806002604826934379453346432983022263205841563476066872180487609416680806308380723,
        4177555525652610026767010842866497530319856996189535121536933933135815631886229827395307247739990233363560426857757051351950293752743174429052944351405461111783827906174839993361446360537534873257712280047423784905505275357590850982689338737378346469987231634823214816285136194960474436457871911134392116026747755907527151143787622520761043762398317813731293877212106785772236100063889599470856862166775342239541165945272951657737986936351247490557985900400756165396033668246700374673335402204131888353078203079934465477647732060855187303348752367334627004885273971385472502200903993201649379139450382697968778468095226023652982443302927341520350434488411337080790792809252676070712026700781940319686545677481141500499136059628636541839931162053598446207177084427324536362337091537119166219399131817294138068260893076245579623950772008491853582751131515793762464029651782699679292202286569508619265285522524183611664547706833371425762921791599887607125863053892895401069012239599183984363197876807098499270873799469822637000713316281892477732662203230272887386286985493187539651278081269828009763706467643496593540313647719218091927429355910592412504343612005209653868758906692865966044526411683126952133744360975218833361612616760777,
    ],
    4098: [
        4177555525652610026767010842866497530319856996189535121536933933135815631886229827395307247739990233363560426857757051351950293752743174429052944351405461111783827906174839993361446360537534873257712280047423784905505275357590850982689338737378346469987231634823214816285136194960474436457871911134392116026747755907527151143787622520761043762398317813731293877212106785772236100063889599470856862166775342239541165945272951657737986936351247490557985900400756165396033668246700374673335402204131888353078203079934465477647732060855187303348752367334627004885273971385472502200903993201649379139450382697968778468095226023652982443302927341520350434488411337080790792809252676070712026700781940319686545677481141500499136059628636541839931162053598446207177084427324536362337091537119166219399131817294138068260893076245579623950772008491853582751131515793762464029651782699679292202286569508619265285522524183611664547706833371425762921791599887607125863053892895401069012239599183984363197876807098499270873799469822637000713316281892477732662203230272887386286985493187539651278081269828009763706467643496593540313647719218091927429355910592412504343612005209653868758906692865966044526411683126952133744360975218833361612616767701,
        8355111051305220053534021685732995060639713992379070243073867866271631263772459654790614495479980466727120853715514102703900587505486348858105888702810922223567655812349679986722892721075069746515424560094847569811010550715181701965378677474756692939974463269646429632570272389920948872915743822268784232053495511815054302287575245041522087524796635627462587754424213571544472200127779198941713724333550684479082331890545903315475973872702494981115971800801512330792067336493400749346670804408263776706156406159868930955295464121710374606697504734669254009770547942770945004401807986403298758278900765395937556936190452047305964886605854683040700868976822674161581585618505352141424053401563880639373091354962283000998272119257273083679862324107196892414354168854649072724674183074238332438798263634588276136521786152491159247901544016983707165502263031587524928059303565399358584404573139017238530571045048367223329095413666742851525843583199775214251726107785790802138024479198367968726395753614196998541747598939645274001426632563784955465324406460545774772573970986375079302556162539656019527412935286993187080627295438436183854858711821184825008687224010419307737517813385731932089052823366253904267488721950437666723225233522043,
    ],
}


NUM = primes[512][0]


NONE = hashlib.sha3_512(str(f"__NONE__{NUM}").encode("utf-8")).hexdigest()




