# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['cli_calc']

package_data = \
{'': ['*']}

install_requires = \
['ConfigArgParse>=1.5.3,<2.0.0', 'python-git-wrapper>=0.9.0,<0.10.0']

setup_kwargs = {
    'name': 'cli-calc',
    'version': '0.3.8',
    'description': 'Powerful yet easy command line calculator.',
    'long_description': '![Logo](https://raw.githubusercontent.com/cruisen/cli-calc/4986df3abb3f1871d6669dec27d5e37aba0d11a3/assets/images/Cli-Calc.png)\n\n# cli-calc\n\n[![test](https://github.com/cruisen/cli-calc/actions/workflows/test.yml/badge.svg)](https://github.com/cruisen/cli-calc/actions/workflows/test.yml)\n[![codecov](https://codecov.io/gh/cruisen/cli-calc/branch/main/graph/badge.svg?token=i9nYZL3MM3)](https://codecov.io/gh/cruisen/cli-calc)\n[![Python Version](https://img.shields.io/pypi/pyversions/cli-calc.svg)](https://pypi.org/project/cli-calc/)\n\n[![pypi](https://img.shields.io/pypi/v/cli-calc)](https://pypi.org/project/cli-calc/)\n[![github release](https://img.shields.io/github/release-date/cruisen/cli-calc)](https://github.com/cruisen/cli-calc/releases)\n[![pypi downloads](https://img.shields.io/pypi/dm/cli-calc?label=pypi%20downloads)](https://pypistats.org/packages/cli-calc)\n\n[![DEV](https://img.shields.io/badge/about-dev-green)](https://github.com/cruisen/cli-calc/blob/main/docs/extras/develop.md)\n\nPowerful yet easy command line calculator.\n\n## Introduction\n\nPlease note: Using plain python at the command line already does provide a pretty decent calculator:\n\n```\n$ python\nPython 3.8.5 (default, Aug  2 2020, 16:00:15)\n[Clang 11.0.0 (clang-1100.0.33.17)] on darwin\nType "help", "copyright", "credits" or "license" for more information.\n>>> 2**10\n1024\n>>> _ / 10\n102.4\n>>> import math\n>>> math.pi\n3.141592653589793\n>>> math.sin(math.pi / 2)\n1.0\n>>> exit()\n```\n\n[\nRead more about\n[Python as a Calculator](https://docs.python.org/3/tutorial/introduction.html#using-python-as-a-calculator).\n]\n\nBut not all is straight forward.\nFor example, if you want to calculate ```sin(pi/2)```:\n* First you need to ```import math```,\n* and then use it with ```math.sin( math.pi / 2 )```.\n\nBut\n[there must be a better way!](https://www.youtube.com/watch?v=UANN2Eu6ZnM)\nAnd there is...\n\n\n### cli-calc\n\n```\n$ cli-calc\nhex, int, float, : INPUT\n0x0, 0, 0.0, : 2**10\n2**10\n0x400, 1024, 1024.0, : _ / 10\n1024.0/10\n0x66, 102, 102.4, : pi\npi\n0x3, 3, 3.141592653589793, : sin(pi / 2)\nsin(pi/2)\n0x1, 1, 1.0, : q\n$\n```\n\n[Batteries included](https://www.python.org/dev/peps/pep-0206/#batteries-included-philosophy):\n\n* ```cli-calc``` adds the standard\n[math](https://docs.python.org/3/library/math.html)\nlibrary to the mix, as well as cmath and others.\n* Provides convenience functions for formatted output, like\n[fractions](https://docs.python.org/3.6/library/fractions.html)\nand\n[IEEE 754](https://en.wikipedia.org/wiki/IEEE_754).\n* Supports line input from files and Unix pipes.\n* And some more... :-)\n\n\n## More examples\n\n```\n$ cli-calc\nhex, int, float, : INPUT\n0x0, 0, 0.0, : cos(pi/2)\ncos(pi/2)\n0x0, 0, 6.123233995736766e-17, : 0xFF ^ 0b10\n0xFF^0b10\n0xfd, 253, 253.0, : 2**8-1\n2**8-1\n0xff, 255, 255.0, : log(e)\nlog(e)\n0x1, 1, 1.0, : comb(49,6)\ncomb(49,6)\n0xd56048, 13983816, 13983816.0, : factorial(42)\nfactorial(42)\n0x3c1581d491b28f523c23abdf35b689c908000000000, 1405006117752879898543142606244511569936384000000000, 1.40500611775288e+51, : random()\nrandom()\n0x0, 0, 0.24958817003921918, : cmath.phase(complex(-1.0, 0.0))\ncmath.phase(complex(-1.0,0.0))\n0x3, 3, 3.141592653589793, : q\n$\n```\n\n## Included Math Libraries\n\nReady to use out of the box:\n\n- [standard operators](https://www.w3schools.com/python/python_operators.asp)\n  ``` -, >>, ...```\n- [standard math library](https://docs.python.org/3/library/math.html)\n  ```cd, log, sin, sinh, gamma, pi, e, tau, inf, nan...```\n\n- [cmath](https://docs.python.org/3/library/cmath.html)\n  ```phase(complex(-1.0, 0.0)), and then most of the above with complex numbers.```\n- [random](https://docs.python.org/3/library/random.html#examples)\n  ```random, choice([\'win\', \'lose\', \'draw\']), mean, ...```\n\n- [built in functions](https://docs.python.org/3/library/functions.html)\n  ```max, help, sum, ...```\n\n\n# Installation\n\n```bash\npip install cli-calc\n```\n\n- [pypi cli-calc](https://pypi.org/project/cli-calc/)\n\n## Configuration\n\nFor convenience, add a shell script in ```~/bin```:\n\n```bash\ncd ~/bin\nvi cli-calc\n```\n\nwith the following lines:\n\n*Note*: Please adjust the path!\n\n```bash\npath=~/path/to/your/cli-calc/\ncd $path\npython3 -m cli_calc\n```\n\nMake it executable:\n\n```bash\nchmod a+x cli-calc\n```\n\nthen use it anywhere. :-)\n\n```bash\necho "7+8" | cli-calc\ncat foo.bar | cli-calc\ncli-calc\n```\n\n## Help\n\n```bash\ncli-calc\nh\n--------------------------------------------------\n\n    cli-calc 0.3.1: Powerful yet easy command line calculator.\n\n    INPUT:\n    "q" for quit, "h" for help\n\n    "_" for last float value\n    "_int_" for last int value\n\n    "sin(pi/2)" for sinus, ...\n\n    "pi", "tau" and "e" for pi, tau and Euler\n\n    "+f" to add display for fraction, "-f" to suppress display for fraction\n        Other letters are:\n        he(x), (o)ctal, (b)inary, (i)nteger,\n        (f)raction, (t)ruth, i(e)ee, ieee_bi(n), f(r)om_ieee\n        "float" is always visible\n\n    Also try "cos(pi/2)", "0xFF ^ 0b10", "2**8-1", "factorial(42)", "help(math)"\n\n    See https://docs.python.org/3/library/math.html, use without "math."\n        https://www.w3schools.com/python/python_operators.asp\n        https://github.com/cruisen/cli-calc\n\n    (c) 2022-2022 Nikolai von Krusenstiern, License: MIT\n    \n--------------------------------------------------\nhex, int, float, : INPUT\n```\n\n* Permalink to this document as a\n[github page](https://cruisen.github.io/cli-calc/)\n\n## Warning\n\n- Use of [```eval```](https://docs.python.org/3/library/functions.html#eval) is evil.\n  However precautions are taken.\n\n\n# Pull Request\n\nPR\'s are Welcome!\n\n* Please read more about\n  [Contributing](https://github.com/cruisen/cli-calc/blob/main/CONTRIBUTING.md)\n* and our\n  [development](https://github.com/cruisen/cli-calc/blob/main/docs/extras/develop.md)\n  environment and tool set.\n* Or just simply raise an [issue](https://github.com/cruisen/cli-calc/issues/new/choose).\n\n# License\n\n[MIT](https://github.com/cruisen/cli-calc/blob/master/LICENSE)\n\n## Credits\n\nThis project was generated with [`wemake-python-package`](https://github.com/wemake-services/wemake-python-package). Current template version is: [d06993f12e3ffad79652a2aec86189dee92d94dd](https://github.com/wemake-services/wemake-python-package/tree/d06993f12e3ffad79652a2aec86189dee92d94dd). See what is [updated](https://github.com/wemake-services/wemake-python-package/compare/d06993f12e3ffad79652a2aec86189dee92d94dd...master) since then.\n',
    'author': 'Nikolai von Krusenstiern',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/cruisen/cli-calc',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
