/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.data.model;

import ambit2.base.data.Template;
import ambit2.core.data.model.AlgorithmType;
import ambit2.core.data.model.Parameter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Algorithm<T extends Serializable>
implements Comparable<Algorithm<T>>,
Serializable {
    private static final long serialVersionUID = -6624262246346428281L;
    protected String id;
    protected String name;
    protected List<Parameter> parameters;
    protected T content;
    protected AlgorithmFormat format = AlgorithmFormat.JAVA_CLASS;
    protected String[] type;
    protected String endpoint = null;
    protected requires requirement;
    protected String implementationOf = null;
    protected String description;
    protected Template input;

    public String getImplementationOf() {
        return this.implementationOf;
    }

    public void setImplementationOf(String string) {
        this.implementationOf = string;
    }

    public requires getRequirement() {
        return this.requirement;
    }

    public void setRequirement(requires requires2) {
        this.requirement = requires2;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String string) {
        this.endpoint = string;
    }

    public boolean isSupervised() {
        return this.hasType(AlgorithmType.Classification.toString()) || this.hasType(AlgorithmType.Regression.toString());
    }

    public boolean isRequiresDataset() {
        return this.hasType(AlgorithmType.Clustering.toString()) || this.hasType(AlgorithmType.Classification.toString()) || this.hasType(AlgorithmType.Regression.toString()) || this.hasType(AlgorithmType.Learning.toString()) || this.hasType(AlgorithmType.LazyLearning.toString()) || this.hasType(AlgorithmType.EagerLearning.toString()) || this.hasType(AlgorithmType.DescriptorCalculation.toString()) || this.hasType(AlgorithmType.AppDomain.toString()) || this.hasType(AlgorithmType.Mockup.toString()) || this.hasType(AlgorithmType.SMSD.toString());
    }

    public boolean isDataProcessing() {
        return this.hasType(AlgorithmType.DescriptorCalculation.toString()) || this.hasType(AlgorithmType.Fingerprints.toString()) || this.hasType(AlgorithmType.Mockup.toString());
    }

    public String[] getType() {
        return this.type;
    }

    public void setType(String[] stringArray) {
        this.type = stringArray;
    }

    public boolean hasType(AlgorithmType algorithmType) {
        for (String string : this.type) {
            if (!string.equals(algorithmType.toString())) continue;
            return true;
        }
        return false;
    }

    public boolean hasType(String string) {
        for (String string2 : this.type) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public AlgorithmFormat getFormat() {
        return this.format;
    }

    public void setFormat(AlgorithmFormat algorithmFormat) {
        this.format = algorithmFormat;
    }

    public Template getInput() {
        return this.input;
    }

    public void setInput(Template template) {
        this.input = template;
    }

    public T getContent() {
        return this.content;
    }

    public void setContent(T t) {
        this.content = t;
    }

    public Algorithm() {
        this("Unknown");
    }

    public Algorithm(String string) {
        this.setName(string);
        this.setType(new String[]{AlgorithmType.AlgorithmType.toString()});
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> list) {
        this.parameters = list;
    }

    public void addParameter(Parameter parameter) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<Parameter>();
        }
        this.parameters.add(parameter);
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public int compareTo(Algorithm<T> algorithm) {
        return this.getId().compareTo(algorithm.getId());
    }

    public boolean equals(Object object) {
        if (object instanceof Algorithm) {
            return this.getId().equals(((Algorithm)object).getId());
        }
        return false;
    }

    public String[] getParametersAsArray() {
        if (this.getParameters() == null || this.getParameters().size() == 0) {
            return null;
        }
        String[] stringArray = new String[this.getParameters().size()];
        List<Parameter> list = this.getParameters();
        for (int i = 0; i < list.size(); ++i) {
            stringArray[i] = list.get(i).getValue().toString();
        }
        return stringArray;
    }

    public static enum AlgorithmFormat {
        JAVA_CLASS{

            @Override
            public String getMediaType() {
                return "application/java";
            }
        }
        ,
        PMML{

            @Override
            public String getMediaType() {
                return "application/pmml+xml";
            }
        }
        ,
        WEKA{

            @Override
            public String getMediaType() {
                return "application/x-java-serialized-object";
            }
        }
        ,
        MOPAC{

            @Override
            public String getMediaType() {
                return "mopac/java";
            }
        }
        ,
        WWW_FORM{

            @Override
            public String getMediaType() {
                return "application/x-www-form-urlencoded";
            }
        }
        ,
        SEARCH{

            @Override
            public String getMediaType() {
                return "text/plain";
            }
        }
        ,
        COVERAGE_SERIALIZED{

            @Override
            public String getMediaType() {
                return "application/x-coverage-serialized-object";
            }
        }
        ,
        PREFERRED_STRUC{

            @Override
            public String getMediaType() {
                return "text/plain";
            }
        };


        public abstract String getMediaType();
    }

    public static enum requires {
        structure,
        property;

    }
}

