/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import nu.xom.IllegalDataException;
import nu.xom.IllegalNameException;
import nu.xom.IllegalTargetException;
import nu.xom.Node;
import nu.xom.Text;
import nu.xom.Verifier;

public class ProcessingInstruction
extends Node {
    private String target;
    private String data;

    public ProcessingInstruction(String target, String data) {
        this._setTarget(target);
        this._setValue(data);
    }

    public ProcessingInstruction(ProcessingInstruction instruction) {
        this.target = instruction.target;
        this.data = instruction.data;
    }

    private ProcessingInstruction() {
    }

    static ProcessingInstruction build(String target, String data) {
        ProcessingInstruction result = new ProcessingInstruction();
        result.target = target;
        result.data = data;
        return result;
    }

    public final String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this._setTarget(target);
    }

    private void _setTarget(String target) {
        try {
            Verifier.checkNCName(target);
        }
        catch (IllegalNameException ex) {
            IllegalTargetException tex = new IllegalTargetException(ex.getMessage());
            tex.setData(target);
            throw tex;
        }
        if (target.equalsIgnoreCase("xml")) {
            IllegalTargetException tex = new IllegalTargetException(target + " is not a legal processing instruction target.");
            tex.setData(target);
            throw tex;
        }
        this.target = target;
    }

    public void setValue(String data) {
        this._setValue(data);
    }

    private void _setValue(String data) {
        Verifier.checkPCDATA(data);
        if (data.length() != 0) {
            if (data.indexOf("?>") >= 0) {
                IllegalDataException ex = new IllegalDataException("Processing instruction data must not contain \"?>\"");
                ex.setData(data);
                throw ex;
            }
            if (data.indexOf(13) >= 0) {
                IllegalDataException ex = new IllegalDataException("Processing instruction data cannot contain carriage returns");
                ex.setData(data);
                throw ex;
            }
            char first = data.charAt(0);
            if (first == ' ' || first == '\n' || first == '\t') {
                IllegalDataException ex = new IllegalDataException("Processing instruction data cannot contain leading white space");
                ex.setData(data);
                throw ex;
            }
        }
        this.data = data;
    }

    public final String getValue() {
        return this.data;
    }

    public final Node getChild(int position) {
        throw new IndexOutOfBoundsException("LeafNodes do not have children");
    }

    public final int getChildCount() {
        return 0;
    }

    public final String toXML() {
        StringBuffer result = new StringBuffer("<?");
        result.append(this.target);
        if (this.data.length() > 0) {
            result.append(' ');
            result.append(this.data);
        }
        result.append("?>");
        return result.toString();
    }

    public Node copy() {
        return new ProcessingInstruction(this.target, this.data);
    }

    boolean isProcessingInstruction() {
        return true;
    }

    public final String toString() {
        return "[" + this.getClass().getName() + ": target=\"" + this.target + "\"; data=\"" + Text.escapeLineBreaksAndTruncate(this.data) + "\"]";
    }
}

