import numpy as np

charges_per_asp_amber = {'Na': 0.0, 'N*': -0.0391, 'Li': 0.0, 'FE': 0.0, 'Rb': 0.0, 'O3': -0.06877, 'CQ': 0.1108,
                         'C*': 0.1108, 'NA': -0.0391, 'NB': -0.0391, 'NC': -0.0391, 'O2': -0.06877, 'NY': -0.0391,
                         'Br': 0.0, 'C0': 0.0, 'NT': -0.0391, 'K': 0.0, 'CK': 0.1108, 'Cs': 0.0, 'C': 0.01918,
                         'CN': 0.1108, 'CM': 0.1108, 'F': 0.0, 'CC': 0.1108, 'CB': 0.1108, 'CA': 0.1108, 'MG': 0.0,
                         'O': -0.03128, 'CD': 0.01918, 'CZ': 0.01918, 'CY': 0.01918, 'CR': 0.1108, 'N2': -0.0391,
                         'N3': -0.12604, 'CW': 0.1108, 'CV': 0.1108, 'CU': 0.0, 'CT': 0.01918, 'Zn': 0.0, 'I': 0.0,
                         'OH': -0.04255, 'Cl': 0.0, 'S': 0.00506, 'N': -0.0391, 'SH': 0.02576, 'OW': -0.04255,
                         'OS': -0.04255, 'P': 0.0}

radius_per_asp = {'Na': 0.0, 'N*': 1.7, 'Li': 0.0, 'FE': 0.0, 'Rb': 0.0, 'O3': 1.4, 'CQ': 1.8, 'C*': 1.8, 'NA': 1.7,
                  'NB': 1.7, 'NC': 1.7, 'O2': 1.4, 'NY': 1.7, 'Br': 0.0, 'C0': 0.0, 'NT': 1.7, 'K': 0.0, 'CK': 1.8,
                  'Cs': 0.0, 'C': 1.95, 'CN': 1.8, 'CM': 1.8, 'F': 0.0, 'CC': 1.8, 'CB': 1.8, 'CA': 1.8, 'MG': 0.0,
                  'O': 1.4, 'CD': 1.95, 'CZ': 1.95, 'CY': 1.95, 'CR': 1.8, 'N2': 1.7, 'N3': 1.7, 'CW': 1.8, 'CV': 1.8,
                  'CU': 0.0, 'CT': 1.95, 'Zn': 0.0, 'I': 0.0, 'OH': 1.6, 'Cl': 0.0, 'S': 1.85, 'N': 1.7, 'SH': 2.0,
                  'OW': 1.6, 'OS': 1.6, 'P': 0.0}

asp_type_charges = {0: 0.0, 1: 0.01918, 2: 0.1108, 3: -0.0391, 4: -0.12604, 5: -0.06256, 6: -0.04255, 7: -0.03128,
                     8: -0.06877, 9: 0.02576, 10: 0.00506}

asp_type_radius = {0: 0.0, 1: 1.95, 2: 1.8, 3: 1.7, 4: 1.7, 5: 1.7, 6: 1.6, 7: 1.4, 8: 1.4, 9: 2.0, 10: 1.85}

reference_area = {
    'ILE': {'C': 2.52, 'CB': 7.86, 'CA': 6.22, 'O': 22.93, 'N': 4.52, 'CD1': 69.96, 'CG1': 23.65, 'CG2': 51.08},
    'GLN': {'C': 3.5, 'CB': 18.83, 'CA': 6.97, 'CG': 28.65, 'O': 24.86, 'CD': 15.46, 'N': 5.66, 'NE2': 52.85,
            'OE1': 34.89}, 'GLY': {'CA': 40.04, 'C': 8.29, 'O': 27.15, 'N': 13.87},
    'GLU': {'C': 2.7, 'CB': 23.63, 'CA': 7.1, 'CG': 32.13, 'O': 25.99, 'CD': 23.66, 'OE2': 34.58, 'N': 2.9,
            'OE1': 29.9}, 'CYS': {'C': 3.61, 'CB': 33.83, 'CA': 7.23, 'O': 24.54, 'N': 4.49, 'SG': 64.53},
    'HSC': {'C': 4.77, 'CE1': 52.36, 'CB': 26.63, 'CA': 4.88, 'CG': 4.01, 'O': 25.71, 'N': 2.88, 'CD2': 37.62,
            'ND1': 19.57, 'NE2': 27.31},
    'ASP': {'C': 4.43, 'CB': 31.86, 'CA': 6.95, 'CG': 20.76, 'O': 23.38, 'N': 5.36, 'OD1': 23.23, 'OD2': 36.41},
    'SER': {'C': 4.94, 'OG': 31.08, 'CB': 46.15, 'CA': 9.06, 'O': 23.7, 'N': 6.44},
    'LYS': {'C': 2.11, 'CB': 23.8, 'CA': 9.32, 'CG': 21.55, 'CE': 42.83, 'CD': 28.36, 'NZ': 59.79, 'O': 23.7,
            'N': 6.55}, 'PRO': {'C': 1.27, 'CB': 37.06, 'CA': 11.0, 'CG': 41.44, 'O': 18.32, 'CD': 31.15, 'N': 0.53},
    'HID': {'C': 4.77, 'CE1': 52.36, 'CB': 26.63, 'CA': 4.88, 'CG': 4.01, 'O': 25.71, 'N': 2.88, 'CD2': 37.62,
            'ND1': 19.57, 'NE2': 27.31},
    'HIE': {'C': 4.77, 'CE1': 52.36, 'CB': 26.63, 'CA': 4.88, 'CG': 4.01, 'O': 25.71, 'N': 2.88, 'CD2': 37.62,
            'ND1': 19.57, 'NE2': 27.31},
    'ASN': {'C': 3.74, 'CB': 28.23, 'CA': 5.0, 'CG': 13.03, 'O': 25.02, 'N': 4.86, 'OD1': 30.66, 'ND2': 53.44},
    'HIP': {'C': 4.77, 'CE1': 52.36, 'CB': 26.63, 'CA': 4.88, 'CG': 4.01, 'O': 25.71, 'N': 2.88, 'CD2': 37.62,
            'ND1': 19.57, 'NE2': 27.31},
    'VAL': {'C': 1.68, 'CB': 9.17, 'CA': 5.8, 'O': 23.84, 'N': 3.04, 'CG1': 58.93, 'CG2': 59.67},
    'THR': {'C': 3.56, 'CB': 15.51, 'CA': 6.38, 'OG1': 30.13, 'O': 24.81, 'N': 4.58, 'CG2': 62.7},
    'HIS': {'C': 4.77, 'CE1': 52.36, 'CB': 26.63, 'CA': 4.88, 'CG': 4.01, 'O': 25.71, 'N': 2.88, 'CD2': 37.62,
            'ND1': 19.57, 'NE2': 27.31}, 'ABU': {'C': 1.68, 'CB': 9.17, 'CA': 5.8, 'CG': 59.67, 'O': 23.84, 'N': 3.04},
    'TRP': {'C': 4.13, 'CZ2': 37.81, 'CB': 25.13, 'CA': 2.3, 'CG': 3.01, 'CH2': 38.2, 'O': 24.82, 'N': 2.58,
            'CE2': 6.66, 'CE3': 21.85, 'CD1': 32.84, 'CD2': 2.78, 'CZ3': 37.25, 'NE1': 25.66},
    'HSE': {'C': 1.68, 'CB': 9.17, 'CA': 5.8, 'OD': 31.08, 'CG': 46.15, 'O': 23.84, 'N': 3.04},
    'PHE': {'C': 5.91, 'CE1': 38.82, 'CB': 24.25, 'CA': 6.21, 'CG': 2.98, 'O': 24.25, 'N': 3.95, 'CZ': 38.54,
            'CD1': 19.85, 'CD2': 18.66, 'CE2': 38.37},
    'ALA': {'CB': 68.93, 'CA': 12.17, 'C': 2.94, 'O': 26.66, 'N': 7.4},
    'MET': {'C': 3.97, 'CB': 23.44, 'CA': 5.87, 'CG': 26.11, 'CE': 75.41, 'N': 3.77, 'O': 24.14, 'SD': 40.5},
    'AHP': {'C': 1.68, 'CB': 9.17, 'CA': 5.8, 'CG': 9.17, 'CE': 9.17, 'CD': 9.17, 'CZ': 59.67, 'O': 23.84, 'N': 3.04},
    'LEU': {'C': 3.34, 'CB': 19.39, 'CA': 3.31, 'CG': 8.44, 'O': 24.34, 'N': 5.09, 'CD1': 65.35, 'CD2': 61.43},
    'ARG': {'C': 3.78, 'CB': 19.51, 'CA': 7.26, 'CG': 25.63, 'NE': 13.79, 'O': 25.28, 'CD': 29.56, 'CZ': 10.79,
            'NH1': 47.87, 'NH2': 59.06, 'N': 5.31},
    'AHX': {'C': 1.68, 'CB': 9.17, 'CA': 5.8, 'CG': 9.17, 'CE': 59.67, 'CD': 9.17, 'O': 23.84, 'N': 3.04},
    'TYR': {'C': 2.41, 'CE1': 36.79, 'OH': 38.76, 'CB': 25.23, 'CA': 4.23, 'CG': 3.3, 'O': 22.92, 'N': 4.15,
            'CZ': 12.24, 'CD1': 24.91, 'CD2': 21.82, 'CE2': 35.56},
    'APE': {'C': 1.68, 'CB': 9.17, 'CA': 5.8, 'CG': 9.17, 'O': 23.84, 'CD': 59.67, 'N': 3.04}}

asp_type = {'ILE': {'C': 1, 'CB': 1, 'CA': 1, 'O': 7, 'N': 3, 'CD1': 1, 'CG1': 1, 'CG2': 1},
            'GLN': {'C': 1, 'CB': 1, 'CA': 1, 'CG': 1, 'O': 7, 'CD': 1, 'N': 3, 'NE2': 3, 'OE1': 7},
            'GLY': {'CA': 1, 'C': 1, 'O': 7, 'N': 3},
            'GLU': {'C': 1, 'CB': 1, 'CA': 1, 'CG': 1, 'O': 7, 'CD': 1, 'OE2': 8, 'N': 3, 'OE1': 8},
            'CYS': {'C': 1, 'CB': 1, 'CA': 1, 'O': 7, 'N': 3, 'SG': 9},
            'HSC': {'C': 1, 'CE1': 2, 'CB': 1, 'CA': 1, 'CG': 2, 'O': 7, 'N': 3, 'CD2': 2, 'ND1': 4, 'NE2': 4},
            'ASP': {'C': 1, 'CB': 1, 'CA': 1, 'CG': 1, 'O': 7, 'N': 3, 'OD1': 8, 'OD2': 8},
            'SER': {'C': 1, 'OG': 6, 'CB': 1, 'CA': 1, 'O': 7, 'N': 3},
            'LYS': {'C': 1, 'CB': 1, 'CA': 1, 'CG': 1, 'CE': 1, 'CD': 1, 'NZ': 4, 'O': 7, 'N': 3},
            'PRO': {'C': 1, 'CB': 1, 'CA': 1, 'CG': 1, 'O': 7, 'CD': 1, 'N': 3},
            'HID': {'C': 1, 'CE1': 2, 'CB': 1, 'CA': 1, 'CG': 2, 'O': 7, 'N': 3, 'CD2': 2, 'ND1': 4, 'NE2': 3},
            'HIE': {'C': 1, 'CE1': 2, 'CB': 1, 'CA': 1, 'CG': 2, 'O': 7, 'N': 3, 'CD2': 2, 'ND1': 3, 'NE2': 4},
            'ASN': {'C': 1, 'CB': 1, 'CA': 1, 'CG': 1, 'O': 7, 'N': 3, 'OD1': 7, 'ND2': 3},
            'HIP': {'C': 1, 'CE1': 2, 'CB': 1, 'CA': 1, 'CG': 2, 'O': 7, 'N': 3, 'CD2': 2, 'ND1': 4, 'NE2': 4},
            'VAL': {'C': 1, 'CB': 1, 'CA': 1, 'O': 7, 'N': 3, 'CG1': 1, 'CG2': 1},
            'THR': {'C': 1, 'CB': 1, 'CA': 1, 'OG1': 6, 'O': 7, 'N': 3, 'CG2': 1},
            'HIS': {'C': 1, 'CE1': 2, 'CB': 1, 'CA': 1, 'CG': 2, 'O': 7, 'N': 3, 'CD2': 2, 'ND1': 4, 'NE2': 4},
            'ABU': {'C': 1, 'CB': 1, 'CA': 1, 'CG': 1, 'O': 7, 'N': 3},
            'TRP': {'C': 1, 'CZ2': 2, 'CB': 1, 'CA': 1, 'CG': 2, 'CH2': 2, 'O': 7, 'N': 3, 'CE2': 2, 'CE3': 2, 'CD1': 2,
                    'CD2': 2, 'CZ3': 2, 'NE1': 3}, 'HSE': {'C': 1, 'CB': 1, 'CA': 1, 'OD': 7, 'CG': 1, 'O': 7, 'N': 3},
            'PHE': {'C': 1, 'CE1': 2, 'CB': 1, 'CA': 1, 'CG': 2, 'O': 7, 'N': 3, 'CZ': 2, 'CD1': 2, 'CD2': 2, 'CE2': 2},
            'ALA': {'CB': 1, 'CA': 1, 'C': 1, 'O': 7, 'N': 3},
            'MET': {'C': 1, 'CB': 1, 'CA': 1, 'CG': 1, 'CE': 1, 'N': 3, 'O': 7, 'SD': 10},
            'AHP': {'C': 1, 'CB': 1, 'CA': 1, 'CG': 1, 'CE': 1, 'CD': 1, 'CZ': 1, 'O': 7, 'N': 3},
            'LEU': {'C': 1, 'CB': 1, 'CA': 1, 'CG': 1, 'O': 7, 'N': 3, 'CD1': 1, 'CD2': 1},
            'ARG': {'C': 1, 'CB': 1, 'CA': 1, 'CG': 1, 'NE': 3, 'O': 7, 'CD': 1, 'CZ': 1, 'NH1': 5, 'NH2': 5, 'N': 3},
            'AHX': {'C': 1, 'CB': 1, 'CA': 1, 'CG': 1, 'CE': 1, 'CD': 1, 'O': 7, 'N': 3},
            'TYR': {'C': 1, 'CE1': 2, 'OH': 6, 'CB': 1, 'CA': 1, 'CG': 2, 'O': 7, 'N': 3, 'CZ': 2, 'CD1': 2, 'CD2': 2,
                    'CE2': 2}, 'APE': {'C': 1, 'CB': 1, 'CA': 1, 'CG': 1, 'O': 7, 'CD': 1, 'N': 3}}


def get_solvation(protein):
    """Get the solvation score for a given molecule"""
    # Be careful with ASP types. There are defined in res.dat file. If the residue is not found
    # then use default charges_per_asp from asp_amber_Recio.dat file
    energy_per_atom = []
    atom_radius = []
    for atom in protein.atoms:
        if not atom.is_hydrogen():
            residue_name = atom.residue_name
            atom_name = atom.name
            amber_type = atom.amber_type

            # Special cases
            if atom_name == "OXT":
                residue_name = "ASP"
                atom_name = "OD1"
            if residue_name == 'CYX':
                residue_name = 'CYS'
            if residue_name == 'HSD':
                residue_name = 'HID'
            if residue_name == 'HSP':
                residue_name = 'HIP'
            if residue_name == 'HSE':
                residue_name = 'HIE'
            if residue_name == 'HID':
                residue_name = 'HIP'
            try:
                atom_asp_type = asp_type[residue_name][atom_name]
                energy_per_atom.append(asp_type_charges[atom_asp_type])
            except KeyError:
                energy_per_atom.append(charges_per_asp_amber[amber_type])
            try:
                atom_asp_type = asp_type[residue_name][atom_name]
                atom_radius.append(asp_type_radius[atom_asp_type])
            except KeyError:
                atom_radius.append(radius_per_asp[amber_type])
        else:
            energy_per_atom.append(0.0)
            atom_radius.append(0.0)

    return np.array(energy_per_atom), np.array(atom_radius)
