from collections import namedtuple
from typing import Dict, List, NamedTuple

from jarm.constants import ALPN, RARE_ALPN

Alpns = namedtuple("Alpns", "name values")

RARE: List[bytes] = [
    b"\x08\x68\x74\x74\x70\x2f\x30\x2e\x39",
    b"\x08\x68\x74\x74\x70\x2f\x31\x2e\x30",
    b"\x06\x73\x70\x64\x79\x2f\x31",
    b"\x06\x73\x70\x64\x79\x2f\x32",
    b"\x06\x73\x70\x64\x79\x2f\x33",
    b"\x03\x68\x32\x63",
    b"\x02\x68\x71",
]
ALL: List[bytes] = [
    b"\x08\x68\x74\x74\x70\x2f\x30\x2e\x39",
    b"\x08\x68\x74\x74\x70\x2f\x31\x2e\x30",
    b"\x08\x68\x74\x74\x70\x2f\x31\x2e\x31",
    b"\x06\x73\x70\x64\x79\x2f\x31",
    b"\x06\x73\x70\x64\x79\x2f\x32",
    b"\x06\x73\x70\x64\x79\x2f\x33" b"\x02\x68\x32",
    b"\x03\x68\x32\x63",
    b"\x02\x68\x71",
]

ALPNS = {
    ALPN: Alpns(ALPN, ALL),
    RARE_ALPN: Alpns(RARE_ALPN, RARE),
}
