import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::AuditManager::Assessment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html
 * @external
 */
export interface CfnAssessmentProps {
    /**
     * `AWS::AuditManager::Assessment.AssessmentReportsDestination`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-assessmentreportsdestination
     * @external
     */
    readonly assessmentReportsDestination?: CfnAssessment.AssessmentReportsDestinationProperty | cdk.IResolvable;
    /**
     * `AWS::AuditManager::Assessment.AwsAccount`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-awsaccount
     * @external
     */
    readonly awsAccount?: CfnAssessment.AWSAccountProperty | cdk.IResolvable;
    /**
     * `AWS::AuditManager::Assessment.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::AuditManager::Assessment.FrameworkId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-frameworkid
     * @external
     */
    readonly frameworkId?: string;
    /**
     * `AWS::AuditManager::Assessment.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::AuditManager::Assessment.Roles`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-roles
     * @external
     */
    readonly roles?: Array<CfnAssessment.RoleProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::AuditManager::Assessment.Scope`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-scope
     * @external
     */
    readonly scope?: CfnAssessment.ScopeProperty | cdk.IResolvable;
    /**
     * `AWS::AuditManager::Assessment.Status`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-status
     * @external
     */
    readonly status?: string;
    /**
     * `AWS::AuditManager::Assessment.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::AuditManager::Assessment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html
 * @external
 * @cloudformationResource AWS::AuditManager::Assessment
 */
export declare class CfnAssessment extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AuditManager::Assessment";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnAssessment;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute AssessmentId
     */
    readonly attrAssessmentId: string;
    /**
     * @external
     * @cloudformationAttribute CreationTime
     */
    readonly attrCreationTime: cdk.IResolvable;
    /**
     * @external
     * @cloudformationAttribute Delegations
     */
    readonly attrDelegations: cdk.IResolvable;
    /**
     * @external
     * @cloudformationAttribute FrameworkId
     */
    readonly attrFrameworkId: string;
    /**
     * `AWS::AuditManager::Assessment.AssessmentReportsDestination`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-assessmentreportsdestination
     * @external
     */
    assessmentReportsDestination: CfnAssessment.AssessmentReportsDestinationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AuditManager::Assessment.AwsAccount`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-awsaccount
     * @external
     */
    awsAccount: CfnAssessment.AWSAccountProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AuditManager::Assessment.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::AuditManager::Assessment.FrameworkId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-frameworkid
     * @external
     */
    frameworkId: string | undefined;
    /**
     * `AWS::AuditManager::Assessment.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::AuditManager::Assessment.Roles`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-roles
     * @external
     */
    roles: Array<CfnAssessment.RoleProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::AuditManager::Assessment.Scope`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-scope
     * @external
     */
    scope: CfnAssessment.ScopeProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AuditManager::Assessment.Status`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-status
     * @external
     */
    status: string | undefined;
    /**
     * `AWS::AuditManager::Assessment.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::AuditManager::Assessment`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnAssessmentProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::AuditManager::Assessment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html
 * @external
 * @cloudformationResource AWS::AuditManager::Assessment
 */
export declare namespace CfnAssessment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-awsaccount.html
     * @external
     */
    interface AWSAccountProperty {
        /**
         * `CfnAssessment.AWSAccountProperty.EmailAddress`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-awsaccount.html#cfn-auditmanager-assessment-awsaccount-emailaddress
         * @external
         */
        readonly emailAddress?: string;
        /**
         * `CfnAssessment.AWSAccountProperty.Id`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-awsaccount.html#cfn-auditmanager-assessment-awsaccount-id
         * @external
         */
        readonly id?: string;
        /**
         * `CfnAssessment.AWSAccountProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-awsaccount.html#cfn-auditmanager-assessment-awsaccount-name
         * @external
         */
        readonly name?: string;
    }
}
/**
 * A CloudFormation `AWS::AuditManager::Assessment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html
 * @external
 * @cloudformationResource AWS::AuditManager::Assessment
 */
export declare namespace CfnAssessment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-awsservice.html
     * @external
     */
    interface AWSServiceProperty {
        /**
         * `CfnAssessment.AWSServiceProperty.ServiceName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-awsservice.html#cfn-auditmanager-assessment-awsservice-servicename
         * @external
         */
        readonly serviceName?: string;
    }
}
/**
 * A CloudFormation `AWS::AuditManager::Assessment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html
 * @external
 * @cloudformationResource AWS::AuditManager::Assessment
 */
export declare namespace CfnAssessment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-assessmentreportsdestination.html
     * @external
     */
    interface AssessmentReportsDestinationProperty {
        /**
         * `CfnAssessment.AssessmentReportsDestinationProperty.Destination`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-assessmentreportsdestination.html#cfn-auditmanager-assessment-assessmentreportsdestination-destination
         * @external
         */
        readonly destination?: string;
        /**
         * `CfnAssessment.AssessmentReportsDestinationProperty.DestinationType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-assessmentreportsdestination.html#cfn-auditmanager-assessment-assessmentreportsdestination-destinationtype
         * @external
         */
        readonly destinationType?: string;
    }
}
/**
 * A CloudFormation `AWS::AuditManager::Assessment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html
 * @external
 * @cloudformationResource AWS::AuditManager::Assessment
 */
export declare namespace CfnAssessment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-delegation.html
     * @external
     */
    interface DelegationProperty {
        /**
         * `CfnAssessment.DelegationProperty.AssessmentId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-delegation.html#cfn-auditmanager-assessment-delegation-assessmentid
         * @external
         */
        readonly assessmentId?: string;
        /**
         * `CfnAssessment.DelegationProperty.AssessmentName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-delegation.html#cfn-auditmanager-assessment-delegation-assessmentname
         * @external
         */
        readonly assessmentName?: string;
        /**
         * `CfnAssessment.DelegationProperty.Comment`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-delegation.html#cfn-auditmanager-assessment-delegation-comment
         * @external
         */
        readonly comment?: string;
        /**
         * `CfnAssessment.DelegationProperty.ControlSetId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-delegation.html#cfn-auditmanager-assessment-delegation-controlsetid
         * @external
         */
        readonly controlSetId?: string;
        /**
         * `CfnAssessment.DelegationProperty.CreatedBy`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-delegation.html#cfn-auditmanager-assessment-delegation-createdby
         * @external
         */
        readonly createdBy?: string;
        /**
         * `CfnAssessment.DelegationProperty.CreationTime`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-delegation.html#cfn-auditmanager-assessment-delegation-creationtime
         * @external
         */
        readonly creationTime?: number;
        /**
         * `CfnAssessment.DelegationProperty.Id`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-delegation.html#cfn-auditmanager-assessment-delegation-id
         * @external
         */
        readonly id?: string;
        /**
         * `CfnAssessment.DelegationProperty.LastUpdated`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-delegation.html#cfn-auditmanager-assessment-delegation-lastupdated
         * @external
         */
        readonly lastUpdated?: number;
        /**
         * `CfnAssessment.DelegationProperty.RoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-delegation.html#cfn-auditmanager-assessment-delegation-rolearn
         * @external
         */
        readonly roleArn?: string;
        /**
         * `CfnAssessment.DelegationProperty.RoleType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-delegation.html#cfn-auditmanager-assessment-delegation-roletype
         * @external
         */
        readonly roleType?: string;
        /**
         * `CfnAssessment.DelegationProperty.Status`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-delegation.html#cfn-auditmanager-assessment-delegation-status
         * @external
         */
        readonly status?: string;
    }
}
/**
 * A CloudFormation `AWS::AuditManager::Assessment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html
 * @external
 * @cloudformationResource AWS::AuditManager::Assessment
 */
export declare namespace CfnAssessment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-role.html
     * @external
     */
    interface RoleProperty {
        /**
         * `CfnAssessment.RoleProperty.RoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-role.html#cfn-auditmanager-assessment-role-rolearn
         * @external
         */
        readonly roleArn?: string;
        /**
         * `CfnAssessment.RoleProperty.RoleType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-role.html#cfn-auditmanager-assessment-role-roletype
         * @external
         */
        readonly roleType?: string;
    }
}
/**
 * A CloudFormation `AWS::AuditManager::Assessment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html
 * @external
 * @cloudformationResource AWS::AuditManager::Assessment
 */
export declare namespace CfnAssessment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-scope.html
     * @external
     */
    interface ScopeProperty {
        /**
         * `CfnAssessment.ScopeProperty.AwsAccounts`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-scope.html#cfn-auditmanager-assessment-scope-awsaccounts
         * @external
         */
        readonly awsAccounts?: Array<CfnAssessment.AWSAccountProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnAssessment.ScopeProperty.AwsServices`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-scope.html#cfn-auditmanager-assessment-scope-awsservices
         * @external
         */
        readonly awsServices?: Array<CfnAssessment.AWSServiceProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
