Getting Started
================

<!-- WARNING: THIS FILE WAS AUTOGENERATED! DO NOT EDIT! -->

**Material for nbdev** is a nbdev extension that allows you to use
[Material for MkDocs](https://squidfunk.github.io/mkdocs-material/) to
generate documentation for nbdev projects.

## Workflow

Here’s a quick comparison of Quarto and Material for nbdev development
workflows:

| **Quarto workflow**                                                                                                       | **Material for nbdev workflow**                                                                                                                                                     |
|---------------------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Install:<br>\$ pip install notebook nbdev<br>\$ nbdev_install_quarto                                                      | Install:<br>\$ pip install notebook nbdev<br>\$ nbdev_install_quarto<br>**\$ pip install nbdev-mkdocs**                                                                             |
| Setup:<br>\$ nbdev_new<br>\$ nbdev_install_hooks<br>\$ vi settings.ini<br>\$ nbdev_export<br>\$ pip install -e ‘.\[dev\]’ | Setup:<br>\$ nbdev_new<br>\$ nbdev_install_hooks<br>\$ vi settings.ini<br>\$ nbdev_export<br>\$ pip install -e ‘.\[dev\]’<br>**\$ nbdev_mkdocs new**<br>**\$ vi mkdocs/mkdocs.yml** |
| Development:<br>\# Edit files<br>\$ nbdev_preview                                                                         | Development:<br>\# Edit files<br>**\$ nbdev_mkdocs preview**<br>                                                                                                                    |
| Commit changes:<br>\$ nbdev_prepare<br>\$ git commit -am “Commit message”<br>\$ git push                                  | Commit changes:<br>**\$ nbdev_mkdocs prepare**<br>\$ git commit -am “Commit message”<br>\$ git push                                                                                 |

## Quick start

The following quick start guide will walk you through installing and
configuring nbdev-mkdocs for an existing nbdev project. It also assumes
you’ve already initialized your project with nbdev and installed all of
the required libraries.

For detailed installation instructions, configuration options, and an
End-To-End Walkthrough, please see the
[documentation](https://nbdev-mkdocs.airt.ai/guides/Guide_01_End_To_End_Walkthrough/).

### Install

nbdev-mkdocs is published as a Python package and can be installed with
pip:

``` shell
pip install nbdev-mkdocs
```

Note that `nbdev-mkdocs` must be installed in the same Python
environment as nbdev.

If the installation was successful, you should now have the
**nbdev-mkdocs** installed on your system. Run the below command from
the terminal to see the full list of available commands:

``` shell
nbdev_mkdocs --help
```

                                                                                    
     Usage: nbdev_mkdocs [OPTIONS] COMMAND [ARGS]...                                
                                                                                    
    ╭─ Options ────────────────────────────────────────────────────────────────────╮
    │ --install-completion          Install completion for the current shell.      │
    │ --show-completion             Show completion for the current shell, to copy │
    │                               it or customize the installation.              │
    │ --help                        Show this message and exit.                    │
    ╰──────────────────────────────────────────────────────────────────────────────╯
    ╭─ Commands ───────────────────────────────────────────────────────────────────╮
    │ new      Creates files in **mkdocs** subdirectory needed for other           │
    │          **nbdev_mkdocs** subcommands                                        │
    │ prepare  Prepares files in **mkdocs/docs** and then runs **mkdocs build**    │
    │          command on them                                                     │
    │ preview  Prepares files in **mkdocs/docs** and then runs **mkdocs serve**    │
    │          command on them                                                     │
    ╰──────────────────────────────────────────────────────────────────────────────╯

### Setup

After installing nbdev-mkdocs, bootstrap your project documentation by
executing the following command from the project’s root directory:

``` shell
nbdev_mkdocs new
```

Using information from the project’s settings.ini file, the above
command creates files and directories required to build the
documentation and saves it in the **mkdocs** subdirectory.

Note: You should only run the **nbdev_mkdocs new** command once for the
project to initialise the files required for building Material for
MkDocs documentation.

### Build and prepare

Execute the following command to build the Python modules and install
the library locally:

``` shell
nbdev_export && pip install -e '.[dev]'
```

Then execute the following command to generate the Material for MkDocs
documentation.

``` shell
nbdev_mkdocs prepare
```

Running the above command will:

- Generate the markdown files from the notebooks and saves them to the
  **mkdocs/docs/** directory.
- Builds the documentation from the generated markdown files and saves
  the resulting files to the **mkdocs/site** directory.

### Preview

After the documentation has been successfully built, execute the
following command to start a local server and preview the documentation.

``` python
nbdev_mkdocs preview
```

## Copyright

Copyright © 2022 onwards airt technologies ltd, Inc.

## License

This project is licensed under the terms of the [Apache License
2.0](https://github.com/airtai/nbdev-mkdocs/blob/main/LICENSE)
