# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['gino_admin', 'gino_admin.orm', 'gino_admin.panel', 'gino_admin.routes']

package_data = \
{'': ['*'], 'gino_admin': ['static/*', 'templates/*', 'templates/modals/*']}

install_requires = \
['PyYAML>=5.3.1,<6.0.0',
 'Sanic-Jinja2>=0.9.0,<0.10.0',
 'aiofiles>=0.5.0,<0.6.0',
 'click>=7.1.2,<8.0.0',
 'dsnparse>=0.1.15,<0.2.0',
 'expiring-dict>=1.1.0,<2.0.0',
 'gino>=1.0.1,<2.0.0',
 'passlib>=1.7.4,<2.0.0',
 'pydantic>=1.5.1,<2.0.0',
 'sanic-jwt>=1.6.0,<2.0.0',
 'sqlalchemy_utils>=0.36.8,<0.37.0']

entry_points = \
{'console_scripts': ['gino-admin = gino_admin.cli:cli']}

setup_kwargs = {
    'name': 'gino-admin',
    'version': '0.2.4',
    'description': 'Admin Panel for PostgreSQL DB with Gino ORM',
    'long_description': '\nGino-Admin\n----------\n\n\n.. image:: img/logo/g_logo.svg\n   :target: img/logo/g_logo.svg\n   :alt: Gino-Admin Logo\n \n\nDocs (state: in process): `Gino-Admin docs <https://gino-admin.readthedocs.io/en/latest/ui_screens.html>`_\n\nPlay with Demo (current master 0.2.3) `>>>> Gino-Admin demo <<<< <http://www.xnu-im.space/gino_admin_demo/login>`_ (login: admin, pass: 1234)\n\n\n.. image:: https://img.shields.io/pypi/v/gino_admin\n   :target: https://img.shields.io/pypi/v/gino_admin\n   :alt: badge1\n \n.. image:: https://img.shields.io/pypi/l/gino_admin\n   :target: https://img.shields.io/pypi/l/gino_admin\n   :alt: badge2\n \n.. image:: https://img.shields.io/pypi/pyversions/gino_admin\n   :target: https://img.shields.io/pypi/pyversions/gino_admin\n   :alt: badge3\n \n\nAdmin Panel for PostgreSQL DB with Gino ORM and Sanic\n\n\n.. image:: img/table_view_new.png\n   :target: img/table_view_new.png\n   :alt: Table view\n\n\n.. image:: img/db_presets.png\n   :target: img/db_presets.png\n   :alt: Load Presets\n\n\nHow to install\n^^^^^^^^^^^^^^\n\n.. code-block:: bash\n\n\n       pip install gino-admin==0.2.4\n\nHow to use\n^^^^^^^^^^\n\nYou can find several code examples in `examples/ <examples/>`_ folder.\n\nSupported features\n^^^^^^^^^^^^^^^^^^\n\n\n* Auth by login/pass with cookie check\n* Create(Add new) item by one for the Model\n* Delete all rows/per element\n* Copy existed element (data table row)\n* Edit existed data (table row)\n* Search/sort in tables\n* Deepcopy element (recursive copy all rows/objects that depend on chosen as ForeignKey)\n* `Upload/export data from/to CSV <https://gino-admin.readthedocs.io/en/latest/csv_upload.html#upload-csv-files>`_\n* SQL-Runner (execute SQL-queries)\n* `Presets: Define order and Load to DB bunch of CSV-files <https://gino-admin.readthedocs.io/en/latest/presets.html>`_\n* Init DB (Full clean up behavior: Drop tables & Recreate)\n* `Composite CSV: Load multiple relative tables in one CSV-file <https://gino-admin.readthedocs.io/en/latest/csv_upload.html#composite-csv-to-upload>`_\n* History logs on changes (log for admin panel actions - edit, delete, add, init_db, load presets and etc)\n* Support multiple users for Admin panel (add, edit, remove users from \'Admin Users\' page)\n* UI Colors customizing\n\nTODO:\n^^^^^\n\n\n* Add possible to add new Presets from GUI\n* Select multiple rows for delete\n* Copy/deepcopy multiple items\n* Edit multiple items (?)\n* Roles for Admin Panel users (split accessess)\n* Filters in Table\'s columns\n* Other staff on `Gino Project Dashboard <https://github.com/xnuinside/gino-admin/projects/1>`_\n\nSupported Data Types\n^^^^^^^^^^^^^^^^^^^^\n\n\n* JSONB, JSON\n* Time, DateTime, Date\n* Boolean, String, Decimal, Numeric, Float and etc. \n\nTo see the full list of supported types take a look here: \n`gino_admin/types.py <gino_admin/types.py>`_ \n\nIf you don\'t see type that you need - open the github issue with request and I will add it https://github.com/xnuinside/gino-admin/issues. Or you can open PR by yourself and I will be glad to review it :) \n\nHow to run Gino-Admin\n^^^^^^^^^^^^^^^^^^^^^\n\nRun with Cli\n------------\n\n.. code-block:: bash\n\n\n       gino-admin run #module_name_with_models -d postgresql://%(DB_USER):%(DB_PASSWORD)@%(DB_HOST):%(DB_PORT)/%(DB)\n\n       gino-admin run --help # use to get cli help\n       Optional params:\n           -d --db\n               Expected format: postgresql://%(DB_USER):%(DB_PASSWORD)@%(DB_HOST):%(DB_PORT)/%(DB)\n               Example: postgresql://gino:gino@%gino:5432/gino (based on DB settings in examples/)\n               Notice: DB credentials can be set up as  env variables with \'SANIC_\' prefix\n           -h --host\n           -p --port\n           -c --config Example:  -c "presets_folder=examples/base_example/src/csv_to_upload;some_property=1"\n                       Notice: all fields that not supported in config will be ignored, like \'some_property\' in example\n           --no-auth  Run Admin Panel without Auth in UI\n           -u --user Admin User login & password\n               Expected format: login:password\n               Example: admin:1234\n               Notice: user also can be defined from env variable with \'SANIC_\' prefix - check Auth section example\n\nExample:\n\n.. code-block:: bash\n\n\n       gino-admin run examples/run_from_cli/src/db.py --db postgresql://gino:gino@localhost:5432/gino -u admin:1234\n\nRun Admin Panel as Standalone App (no matter that framework you use in main app)\n--------------------------------------------------------------------------------\n\nYou can use Gino Admin as stand alone web app. \nDoes not matter what Framework used for your main App and that Gino Ext used to init Gino().\n\nCode example in:  examples/fastapi_as_main_app\nHow to run example in: examples/fastapi_as_main_app/how_to_run_example.txt\n\nYou need to create **admin.py** (for example, you can use any name) to run admin panel:\n\n.. code-block:: python\n\n   import os\n\n   from gino_admin import create_admin_app\n   # import module with your models\n   import models \n\n   # gino admin uses Sanic as a framework, so you can define most params as environment variables with \'SANIC_\' prefix\n   # in example used this way to define DB credentials & login-password to admin panel\n\n   # but you can use \'db_uri\' in config to define creds for Database\n   # check examples/colored_ui/src/app.py as example \n\n   os.environ["SANIC_DB_HOST"] = os.getenv("DB_HOST", "localhost")\n   os.environ["SANIC_DB_DATABASE"] = "gino"\n   os.environ["SANIC_DB_USER"] = "gino"\n   os.environ["SANIC_DB_PASSWORD"] = "gino"\n\n\n   os.environ["SANIC_ADMIN_USER"] = "admin"\n   os.environ["SANIC_ADMIN_PASSWORD"] = "1234"\n\n   current_path = os.path.dirname(os.path.abspath(__file__))\n\n\n   if __name__ == "__main__":\n       # host & port - will be used to up on them admin app\n       # config - Gino Admin configuration - check docs to see all possible properties,\n       # that allow set path to presets folder or custom_hash_method, optional parameter\n       # db_models - list of db.Models classes (tables) that you want to see in Admin Panel\n       create_admin_app(\n           host="0.0.0.0",\n           port=os.getenv("PORT", 5000),\n           db=models.db,\n           db_models=[models.User, models.City, models.GiftCard, models.Country],\n           config={\n               "presets_folder": os.path.join(current_path, "csv_to_upload")},\n       )\n\nAll environment variables you can move to define in docker or .env files as you wish, they not needed to be define in \'.py\', this is just for example shortness.\n\nAdd Admin Panel to existed Sanic application as \'/admin\' route\n--------------------------------------------------------------\n\nCreate in your project \'admin.py\' file and use ``add_admin_panel`` from from gino_admin import add_admin_panel\n\nCode example in:  examples/base_example\nHow to run example in: examples/base_example/how_to_run_example.txt\n\nExample:\n\n.. code-block:: python\n\n\n       from from gino_admin import add_admin_panel\n\n\n       # your app code\n\n\n       add_admin_panel(\n           app, db, [User, Place, City, GiftCard], custom_hash_method=custom_hash_method\n       )\n\nWhere:\n\n\n* \'app\': your Sanic application\n* \'db\' : from gino.ext.sanic import Gino; db = Gino() and\n* [User, Place, City, GiftCard] - list of models that you want to add in Admin Panel to maintain\n* custom_hash_method - optional parameter to define you own hash method to encrypt all \'_hash\' columns of your Models.\n\nIn admin panel _hash fields will be displayed without \'_hash\' prefix and fields values will be  hidden like \'\\ ******\\ \'\n\nPresets\n^^^^^^^\n\nLoad multiple CSV to DB in order by one click. \nPresets described that CSV-s files and in that order need to be loaded in DB.\n\nRead the docs: `Presets <https://gino-admin.readthedocs.io/en/latest/presets.html>`_\n\nComposite CSV to Upload\n^^^^^^^^^^^^^^^^^^^^^^^\n\nComposite CSV - one file that contains data for several relative tables. \n\nRead the docs: `Composite CSV to Upload <https://gino-admin.readthedocs.io/en/latest/csv_upload.html#composite-csv-to-upload>`_\n\nConfig Gino Admin\n^^^^^^^^^^^^^^^^^\n\nRead the docs: `Config <https://gino-admin.readthedocs.io/en/latest/config.html>`_\n\nInit DB\n^^^^^^^\n\nInit DB feature used for doing full clean up DB - it drop all tables & create them after Drop for all models in Admin Panel.\n\nUpload from CSV\n^^^^^^^^^^^^^^^\n\nFiles-samples for example project can be found here: **examples/base_example/src/csv_to_upload**\n\nAuthorization\n^^^^^^^^^^^^^\n\nRead in docs: `Authorization <https://gino-admin.readthedocs.io/en/latest/authorization.html>`_\n\nLimitations\n^^^^^^^^^^^\n\nIn current version, for correct work of Deepcopy feature in Admin Panel model MUST contain at least one unique or primary_key Column (field).\n\nScreens:\n^^^^^^^^\n\nCheck in docs: `UI Screens <https://gino-admin.readthedocs.io/en/latest/ui_screens.html>`_\n\nChangelog\n---------\n\n**v0.2.4**\n\n\n#. Fixed issue with loop from https://github.com/xnuinside/gino-admin/issues/37\n',
    'author': 'xnuinside',
    'author_email': 'xnuinside@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/xnuinside/gino-admin',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
