# Distance Calculator

### Local time difference calculations.
1) The meridian difference between the two determined points is revealed.
      * If the meridians are located in the same hemisphere, they should be subtracted, if they are located in different hemispheres, they should be added.

2) The resulting meridian difference is multiplied by 4 minutes.

   * Additional information:
       * Because the Earth rotates from west to east, local time is always ahead in the east and behind in the west.
       * Local times of regions on the same meridian are always the same.
```python
# local_time_calculation(longitude1: int, longitude2: int)
print(local_time_calculation(3, 7))
# 16
```
### Anti-meridian Calculation
To find the anti-meridian of a meridian, it is necessary to subtract it from 180.
```python
# find_anti_meridian(longitude: int)
print(find_anti_meridian(34))
# 146
```
### Calculating the distance between meridians
To understand how many kilometers are between two meridians at our current point;
First, we must calculate the length of the parallel at that point, using the angle of the parallel at that point.
Then we have to divide by 360 since there are 360 meridians in the world.
```python
# distance_between_meridians(latitude: int)
distance_between_meridians(10)
```

### Calculating the distance between two points on Earth
Calculate the distance between two points on Earth with [Haversine](https://en.wikipedia.org/wiki/Haversine_formula#:~:text=The%20haversine%20formula%20determines%20the,given%20their%20longitudes%20and%20latitudes.&text=These%20names%20follow%20from%20the,sin2(%CE%B82).) formula.
```python
# distance_calculation(latitude: float, longitude: float, target_latitude: float, target_longitude: float, miles=False)
distance_calculation(13, 24, 42, 12)

```