"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RetrieveUserPoolClientSecret = void 0;
const core_1 = require("@aws-cdk/core");
const custom_resources_1 = require("@aws-cdk/custom-resources");
class RetrieveUserPoolClientSecret extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const clientSecret = new custom_resources_1.AwsCustomResource(this, 'Resource', {
            onUpdate: {
                service: 'CognitoIdentityServiceProvider',
                action: 'describeUserPoolClient',
                parameters: {
                    UserPoolId: props.userPool.userPoolId,
                    ClientId: props.userPoolClient.userPoolClientId,
                },
                physicalResourceId: custom_resources_1.PhysicalResourceId.of(`${props.userPool.userPoolId}-${props.userPoolClient.userPoolClientId}-retrieved-client-secret`),
            },
            policy: custom_resources_1.AwsCustomResourcePolicy.fromSdkCalls({
                resources: [props.userPool.userPoolArn],
            }),
        });
        this.clientSecret = clientSecret.getResponseField('UserPoolClient.ClientSecret');
    }
}
exports.RetrieveUserPoolClientSecret = RetrieveUserPoolClientSecret;
//# sourceMappingURL=data:application/json;base64,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