import os
from setuptools import find_packages, setup

with open(os.path.join(os.path.dirname(__file__), 'README.rst')) as readme:
    README = readme.read()

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))

setup(
    name='p1-activity',
    version='0.2.55044370',
    packages=find_packages(),
    include_package_data=True,
    license='MIT',
    description='A simple consumer Django app for Activity Service.',
    long_description=README,
    install_requires=['p1-queue == 0.3.55043541'],
    author='Yonas & Wisnu',
    author_email='yonazadielwiguna@gmail.com',
    classifiers=[
        'Environment :: Web Environment',
        'Framework :: Django',
        'Framework :: Django :: 1.11',
        'Intended Audience :: Developers',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Programming Language :: Python :: 2.7',
        'Topic :: Internet :: WWW/HTTP',
        'Topic :: Internet :: WWW/HTTP :: Dynamic Content',
    ],
)
