# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['juice_core',
 'juice_core_uplink_api_client',
 'juice_core_uplink_api_client.api',
 'juice_core_uplink_api_client.api.api_token_auth',
 'juice_core_uplink_api_client.api.api_token_refresh',
 'juice_core_uplink_api_client.api.rest_api',
 'juice_core_uplink_api_client.models']

package_data = \
{'': ['*']}

install_requires = \
['attrs>=21.3.0',
 'httpx>=0.15.4,<0.24.0',
 'merge-args>=0.1.5,<0.2.0',
 'pandas>=1.5.2,<2.0.0',
 'python-dateutil>=2.8.0,<3.0.0']

setup_kwargs = {
    'name': 'juice-core-uplink-api-client',
    'version': '0.2.1',
    'description': 'A client library for accessing Juice Core Uplink API',
    'long_description': '# SHT Rest Interface\n\nIt is made by two modules to interact with the Juice Core Uplink \nAPI.\n\n## Install\n\nThe module is now contributed to PyPI, just call\n\n```bash\npip install juice_core_uplink_api_client\n```\n\nto install the module. If you use poetry to build your package and you want to add it as a dependency use:\n\n```bash\npoetry add juice_core_uplink_api_client\n```\n\nif you need to test development version (the main branch in this repository):\n\n```bash\npip install "git+https://www.ict.inaf.it/gitlab/juice-janus/sht_rest_interface.git#egg=juice-core-uplink-api-client&subdirectory=juice-core-uplink-api-client"\n```\n\n## juice-core-uplink-api-client\n\nThis module is automatically generated using the command below. It must not be \nmodified manually.\n\n```bash \n openapi-python-client update --path openapi.json \n```\n\nor just using the makefile `make` shortcut. The command is expected to be runt \nfrom the root of the repository (where the makefile is located) and requires \n`openapi-python-client` to be installed in the host system.\n\nThe module is generated from the openapi definition available at \nhttps://juicesoc.esac.esa.int/docs/, but **notice** that the openapi.json definition is a modified version of the one \navailable at that link. The file was modified by:\n\n- updating the file to openapi 3.1\n- making several changes to fix inconsistencies in the definition\n\nThe original files are mantained here for simplicity:\n\n1. `openapi_source.json` -> as downloaded from [swagger](https://juicesoc.esac.esa.int/docs/)\n2. `openapi_converted.json` -> updated to version 3.x using [https://converter.swagger.io/#/Converter/convertByUrl](swagger converter service)\n3. `openapi.json` -> used to generate the module with openapi-python-client\n\nAlso note that only some issues were corrected in the openapi.json file,\nhence the generated module is not complete, and it is not granted to work.\nIf you find any additional inconsistency, please report it to the repo issue \ntracker.\n\n\n## juice_core \n\nthis module is a wrapper around the automatically generated module. It is made \nby a class with several methods to interact with the API. It is just a stub to \nstart disucssing the API interface. It is not complete and it is not guaranteed \nto work.\n\n## Usage example\n\nFirst, create a client:\n\n```python\nfrom juice_core import SHTRestInterface\ni = SHTRestInterface()\n```\n\nand access the list of available plans on the server:\n\n```python\ni.plans()\n```\n\nwill output a pandas dataframe with the list of plans (just some here):\n\n|    | trajectory   | name                       | mnemonic                   | is_public   | created                    |   id | author   | description                                                                                                                                                           | refine_log   | ptr_file                                                                |\n|---:|:-------------|:---------------------------|:---------------------------|:------------|:---------------------------|-----:|:---------|:----------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------|:------------------------------------------------------------------------|\n|  0 | CREMA_3_0    | CASE4                      | CASE4                      | True        | 2021-03-04 13:29:58.835199 |   17 | rlorente | Demonstration Case 4                                                                                                                                                  |              |                                                                         |\n|  1 | CREMA_5_0    | CREMA_5_0_OPPORTUNITIES_v0 | CREMA_5_0_OPPORTUNITIES_v0 | True        | 2021-08-26 09:12:06.767139 |   31 | cvallat  | 1st run opf opportunities generation (UC22), based on existing definitions of oppportunities (inherited from crema 3_0)                                               |              | https://juicesoc.esac.esa.int/rest_api/file/trajectory%23CREMA_5_0.ptx/ |\n|  2 | CREMA_5_0    | CREMA_5_0_OPPORTUNITIES_v1 | CREMA_5_0_OPPORTUNITIES_v1 | True        | 2021-10-04 13:49:49.262682 |   36 | cvallat  | Added two opportunities for JMAG_CALROL for the last 2 perijoves before JOI (PJ69 not considered since too clsoe to GoI for observations to take place --> MPAD rule) |              | https://juicesoc.esac.esa.int/rest_api/file/trajectory%23CREMA_5_0.ptx/ |\n|  3 | CREMA_5_0    | CREMA_5_0_OPPORTUNITIES_v2 | CREMA_5_0_OPPORTUNITIES_v2 | True        | 2021-10-05 07:24:07.742653 |   37 | cvallat  | Modified GANYMEDE_GM opportunity around 3G3 for WG3 prime allocation (1 hour centered at CA)                                                                          |              | https://juicesoc.esac.esa.int/rest_api/file/trajectory%23CREMA_5_0.ptx/ |\n\n\nYou can also directly interact with the underalying `juice-core-uplink-api-client` module:\n\n\n### juice-core-uplink-api-client\n\nA client library for accessing Juice Core Uplink API\n\ndocs at https://juicesoc.esac.esa.int/docs/\n\nbrowsable at https://juicesoc.esac.esa.int/readonly_admin/core/\n\n## Usage\n\nFirst, create a client:\n\n```python\nfrom juice_core_uplink_api_client import Client\n\nclient = Client(base_url="https://api.example.com")\n```\n\nIf the endpoints you\'re going to hit require authentication, use `AuthenticatedClient` instead:\n\n```python\nfrom juice_core_uplink_api_client import AuthenticatedClient\n\nclient = AuthenticatedClient(base_url="https://api.example.com", token="SuperSecretToken")\n```\n\nNow call your endpoint and use your models:\n\n```python\nfrom juice_core_uplink_api_client.models import MyDataModel\nfrom juice_core_uplink_api_client.api.my_tag import get_my_data_model\nfrom juice_core_uplink_api_client.types import Response\n\nmy_data: MyDataModel = get_my_data_model.sync(client=client)\n# or if you need more info (e.g. status_code)\nresponse: Response[MyDataModel] = get_my_data_model.sync_detailed(client=client)\n```\n\nOr do the same thing with an async version:\n\n```python\nfrom juice_core_uplink_api_client.models import MyDataModel\nfrom juice_core_uplink_api_client.api.my_tag import get_my_data_model\nfrom juice_core_uplink_api_client.types import Response\n\nmy_data: MyDataModel = await get_my_data_model.asyncio(client=client)\nresponse: Response[MyDataModel] = await get_my_data_model.asyncio_detailed(client=client)\n```\n\nBy default, when you\'re calling an HTTPS API it will attempt to verify that SSL is working correctly. Using certificate verification is highly recommended most of the time, but sometimes you may need to authenticate to a server (especially an internal server) using a custom certificate bundle.\n\n```python\nclient = AuthenticatedClient(\n    base_url="https://internal_api.example.com", \n    token="SuperSecretToken",\n    verify_ssl="/path/to/certificate_bundle.pem",\n)\n```\n\nYou can also disable certificate validation altogether, but beware that **this is a security risk**.\n\n```python\nclient = AuthenticatedClient(\n    base_url="https://internal_api.example.com", \n    token="SuperSecretToken", \n    verify_ssl=False\n)\n```\n\nThings to know:\n1. Every path/method combo becomes a Python module with four functions:\n\n    1. `sync`: Blocking request that returns parsed data (if successful) or `None`\n    1. `sync_detailed`: Blocking request that always returns a `Request`, optionally with `parsed` set if the request was successful.\n    1. `asyncio`: Like `sync` but async instead of blocking\n    1. `asyncio_detailed`: Like `sync_detailed` but async instead of blocking\n\n1. All path/query params, and bodies become method arguments.\n1. If your endpoint had any tags on it, the first tag will be used as a module name for the function (my_tag above)\n1. Any endpoint which did not have a tag will be in `juice_core_uplink_api_client.api.default`\n\n## Building / publishing this Client\n\nThis project uses [Poetry](https://python-poetry.org/) to manage dependencies  and packaging.  Here are the basics:\n\n1. Update the metadata in pyproject.toml (e.g. authors, version)\n1. If you\'re using a private repository, configure it with Poetry\n    1. `poetry config repositories.<your-repository-name> <url-to-your-repository>`\n    1. `poetry config http-basic.<your-repository-name> <username> <password>`\n1. Publish the client with `poetry publish --build -r <your-repository-name>` or, if for public PyPI, just `poetry publish --build`\n\nIf you want to install this client into another project without publishing it (e.g. for development) then:\n\n1. If that project **is using Poetry**, you can simply do `poetry add <path-to-this-client>` from that project\n1. If that project is not using Poetry:\n    1. Build a wheel with `poetry build -f wheel`\n    1. Install that wheel from the other project `pip install <path-to-wheel>`\n',
    'author': 'None',
    'author_email': 'None',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
