"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MigrateTask = exports.MigrateTaskProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const rds_generated_1 = require("./rds.generated");
Object.defineProperty(exports, "MigrateTaskProperty", { enumerable: true, get: function () { return rds_generated_1.RosMigrateTask; } });
/**
 * A ROS resource type:  `ALIYUN::RDS::MigrateTask`
 */
class MigrateTask extends ros.Resource {
    /**
     * Create a new `ALIYUN::RDS::MigrateTask`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosMigrateTask = new rds_generated_1.RosMigrateTask(this, id, {
            isOnlineDb: props.isOnlineDb,
            dbInstanceId: props.dbInstanceId,
            ossObjectPositions: props.ossObjectPositions,
            checkDbMode: props.checkDbMode,
            backupMode: props.backupMode,
            dbName: props.dbName,
            ossUrls: props.ossUrls,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosMigrateTask;
        this.attrMigrateTaskId = rosMigrateTask.attrMigrateTaskId;
    }
}
exports.MigrateTask = MigrateTask;
//# sourceMappingURL=data:application/json;base64,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