# -*- coding: utf-8 -*-
# Generated by Django 1.11.8 on 2018-01-17 17:57
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import oauth_provider.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Consumer',
            fields=[
                ('name', models.CharField(max_length=255)),
                ('description', models.TextField(blank=True)),
                ('key', models.CharField(max_length=1024, primary_key=True, serialize=False)),
                ('secret', models.CharField(blank=True, max_length=1024)),
                ('status', models.SmallIntegerField(choices=[(1, 'Pending'), (2, 'Accepted'), (3, 'Canceled'), (4, 'Rejected')], default=1)),
                ('xauth_allowed', models.BooleanField(default=False, verbose_name='Allow xAuth')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Nonce',
            fields=[
                ('token_key', models.CharField(max_length=32)),
                ('consumer_key', models.CharField(max_length=1024)),
                ('key', models.CharField(max_length=255, primary_key=True, serialize=False)),
                ('timestamp', models.PositiveIntegerField(db_index=True)),
            ],
        ),
        migrations.CreateModel(
            name='Scope',
            fields=[
                ('name', models.CharField(max_length=255, primary_key=True, serialize=False)),
                ('url', models.TextField(max_length=2083)),
                ('is_readonly', models.BooleanField(default=True)),
            ],
        ),
        migrations.CreateModel(
            name='Token',
            fields=[
                ('key', models.CharField(default='', max_length=32, primary_key=True, serialize=False)),
                ('secret', models.CharField(blank=True, max_length=1024, null=True)),
                ('token_type', models.SmallIntegerField(choices=[(1, 'Request'), (2, 'Access')])),
                ('timestamp', models.IntegerField(default=oauth_provider.models.default_token_timestamp)),
                ('is_approved', models.BooleanField(default=False)),
                ('verifier', models.CharField(max_length=10)),
                ('callback', models.CharField(blank=True, max_length=2083, null=True)),
                ('callback_confirmed', models.BooleanField(default=False)),
                ('consumer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='oauth_provider.Consumer')),
                ('scope', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='oauth_provider.Scope')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='tokens', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Resource',
            fields=[
            ],
            options={
                'proxy': True,
                'indexes': [],
            },
            bases=('oauth_provider.scope',),
        ),
    ]
