# coding: utf-8

"""
    Allegro REST API

    https://developer.allegro.pl/about  # noqa: E501

    The version of the OpenAPI document: 2020.03.12
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from allegro_api.configuration import Configuration


class ShippingRatesSet(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'name': 'str',
        'rates': 'list[ShippingRate]',
        'last_modified': 'str'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'rates': 'rates',
        'last_modified': 'lastModified'
    }

    def __init__(self, id=None, name=None, rates=None, last_modified=None, local_vars_configuration=None):  # noqa: E501
        """ShippingRatesSet - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._name = None
        self._rates = None
        self._last_modified = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if name is not None:
            self.name = name
        self.rates = rates
        if last_modified is not None:
            self.last_modified = last_modified

    @property
    def id(self):
        """Gets the id of this ShippingRatesSet.  # noqa: E501

        Shipping rates set ID (UUID) When creating a shipping rates set (Post) the field is ignored. It is required when updating (Put) a shipping rates.  # noqa: E501

        :return: The id of this ShippingRatesSet.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ShippingRatesSet.

        Shipping rates set ID (UUID) When creating a shipping rates set (Post) the field is ignored. It is required when updating (Put) a shipping rates.  # noqa: E501

        :param id: The id of this ShippingRatesSet.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def name(self):
        """Gets the name of this ShippingRatesSet.  # noqa: E501

        User defined name of the shipping rates set. It may only contain: letters, numbers, hyphens, dots, commas and spaces.  # noqa: E501

        :return: The name of this ShippingRatesSet.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ShippingRatesSet.

        User defined name of the shipping rates set. It may only contain: letters, numbers, hyphens, dots, commas and spaces.  # noqa: E501

        :param name: The name of this ShippingRatesSet.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) > 64):
            raise ValueError("Invalid value for `name`, length must be less than or equal to `64`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) < 1):
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")  # noqa: E501

        self._name = name

    @property
    def rates(self):
        """Gets the rates of this ShippingRatesSet.  # noqa: E501


        :return: The rates of this ShippingRatesSet.  # noqa: E501
        :rtype: list[ShippingRate]
        """
        return self._rates

    @rates.setter
    def rates(self, rates):
        """Sets the rates of this ShippingRatesSet.


        :param rates: The rates of this ShippingRatesSet.  # noqa: E501
        :type: list[ShippingRate]
        """
        if self.local_vars_configuration.client_side_validation and rates is None:  # noqa: E501
            raise ValueError("Invalid value for `rates`, must not be `None`")  # noqa: E501

        self._rates = rates

    @property
    def last_modified(self):
        """Gets the last_modified of this ShippingRatesSet.  # noqa: E501

        Date and time of the last modification of the set in UTC ISO 8601 format. When creating (Post) or updating (Put) a shipping rates set the field is ignored.  # noqa: E501

        :return: The last_modified of this ShippingRatesSet.  # noqa: E501
        :rtype: str
        """
        return self._last_modified

    @last_modified.setter
    def last_modified(self, last_modified):
        """Sets the last_modified of this ShippingRatesSet.

        Date and time of the last modification of the set in UTC ISO 8601 format. When creating (Post) or updating (Put) a shipping rates set the field is ignored.  # noqa: E501

        :param last_modified: The last_modified of this ShippingRatesSet.  # noqa: E501
        :type: str
        """

        self._last_modified = last_modified

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ShippingRatesSet):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ShippingRatesSet):
            return True

        return self.to_dict() != other.to_dict()
