# coding: utf-8

"""
    Allegro REST API

    https://developer.allegro.pl/about  # noqa: E501

    The version of the OpenAPI document: 2020.03.12
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from allegro_api.configuration import Configuration


class RefundDetails(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'payment': 'RefundPayment',
        'reason': 'str',
        'status': 'str',
        'created_at': 'datetime',
        'total_value': 'RefundTotalValue',
        'line_items': 'list[RefundLineItem]',
        'delivery': 'InitializeRefundDelivery',
        'overpaid': 'InitializeRefundOverpaid',
        'surcharges': 'list[PaymentsSurcharge]',
        'additional_services': 'InitializeRefundAdditionalServices'
    }

    attribute_map = {
        'id': 'id',
        'payment': 'payment',
        'reason': 'reason',
        'status': 'status',
        'created_at': 'createdAt',
        'total_value': 'totalValue',
        'line_items': 'lineItems',
        'delivery': 'delivery',
        'overpaid': 'overpaid',
        'surcharges': 'surcharges',
        'additional_services': 'additionalServices'
    }

    def __init__(self, id=None, payment=None, reason=None, status=None, created_at=None, total_value=None, line_items=None, delivery=None, overpaid=None, surcharges=None, additional_services=None, local_vars_configuration=None):  # noqa: E501
        """RefundDetails - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._payment = None
        self._reason = None
        self._status = None
        self._created_at = None
        self._total_value = None
        self._line_items = None
        self._delivery = None
        self._overpaid = None
        self._surcharges = None
        self._additional_services = None
        self.discriminator = None

        self.id = id
        if payment is not None:
            self.payment = payment
        self.reason = reason
        self.status = status
        self.created_at = created_at
        self.total_value = total_value
        if line_items is not None:
            self.line_items = line_items
        if delivery is not None:
            self.delivery = delivery
        if overpaid is not None:
            self.overpaid = overpaid
        if surcharges is not None:
            self.surcharges = surcharges
        if additional_services is not None:
            self.additional_services = additional_services

    @property
    def id(self):
        """Gets the id of this RefundDetails.  # noqa: E501

        The payment refund identifier.  # noqa: E501

        :return: The id of this RefundDetails.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this RefundDetails.

        The payment refund identifier.  # noqa: E501

        :param id: The id of this RefundDetails.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def payment(self):
        """Gets the payment of this RefundDetails.  # noqa: E501


        :return: The payment of this RefundDetails.  # noqa: E501
        :rtype: RefundPayment
        """
        return self._payment

    @payment.setter
    def payment(self, payment):
        """Sets the payment of this RefundDetails.


        :param payment: The payment of this RefundDetails.  # noqa: E501
        :type: RefundPayment
        """

        self._payment = payment

    @property
    def reason(self):
        """Gets the reason of this RefundDetails.  # noqa: E501

        Reason for a payment refund.  # noqa: E501

        :return: The reason of this RefundDetails.  # noqa: E501
        :rtype: str
        """
        return self._reason

    @reason.setter
    def reason(self, reason):
        """Sets the reason of this RefundDetails.

        Reason for a payment refund.  # noqa: E501

        :param reason: The reason of this RefundDetails.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and reason is None:  # noqa: E501
            raise ValueError("Invalid value for `reason`, must not be `None`")  # noqa: E501
        allowed_values = ["REFUND", "COMPLAINT", "PRODUCT_NOT_AVAILABLE", "PAID_VALUE_TOO_LOW"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and reason not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `reason` ({0}), must be one of {1}"  # noqa: E501
                .format(reason, allowed_values)
            )

        self._reason = reason

    @property
    def status(self):
        """Gets the status of this RefundDetails.  # noqa: E501

        Current status of payment refund.  # noqa: E501

        :return: The status of this RefundDetails.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this RefundDetails.

        Current status of payment refund.  # noqa: E501

        :param status: The status of this RefundDetails.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and status is None:  # noqa: E501
            raise ValueError("Invalid value for `status`, must not be `None`")  # noqa: E501
        allowed_values = ["SUCCESS", "CANCELED", "PARTIAL", "IN_PROGRESS", "VALIDATE_FAILED", "NEW"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and status not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def created_at(self):
        """Gets the created_at of this RefundDetails.  # noqa: E501

        Date and time when the refund was created provided in ISO 8601 format.  # noqa: E501

        :return: The created_at of this RefundDetails.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this RefundDetails.

        Date and time when the refund was created provided in ISO 8601 format.  # noqa: E501

        :param created_at: The created_at of this RefundDetails.  # noqa: E501
        :type: datetime
        """
        if self.local_vars_configuration.client_side_validation and created_at is None:  # noqa: E501
            raise ValueError("Invalid value for `created_at`, must not be `None`")  # noqa: E501

        self._created_at = created_at

    @property
    def total_value(self):
        """Gets the total_value of this RefundDetails.  # noqa: E501


        :return: The total_value of this RefundDetails.  # noqa: E501
        :rtype: RefundTotalValue
        """
        return self._total_value

    @total_value.setter
    def total_value(self, total_value):
        """Sets the total_value of this RefundDetails.


        :param total_value: The total_value of this RefundDetails.  # noqa: E501
        :type: RefundTotalValue
        """
        if self.local_vars_configuration.client_side_validation and total_value is None:  # noqa: E501
            raise ValueError("Invalid value for `total_value`, must not be `None`")  # noqa: E501

        self._total_value = total_value

    @property
    def line_items(self):
        """Gets the line_items of this RefundDetails.  # noqa: E501

        List of order's line items which can be refunded.  # noqa: E501

        :return: The line_items of this RefundDetails.  # noqa: E501
        :rtype: list[RefundLineItem]
        """
        return self._line_items

    @line_items.setter
    def line_items(self, line_items):
        """Sets the line_items of this RefundDetails.

        List of order's line items which can be refunded.  # noqa: E501

        :param line_items: The line_items of this RefundDetails.  # noqa: E501
        :type: list[RefundLineItem]
        """

        self._line_items = line_items

    @property
    def delivery(self):
        """Gets the delivery of this RefundDetails.  # noqa: E501


        :return: The delivery of this RefundDetails.  # noqa: E501
        :rtype: InitializeRefundDelivery
        """
        return self._delivery

    @delivery.setter
    def delivery(self, delivery):
        """Sets the delivery of this RefundDetails.


        :param delivery: The delivery of this RefundDetails.  # noqa: E501
        :type: InitializeRefundDelivery
        """

        self._delivery = delivery

    @property
    def overpaid(self):
        """Gets the overpaid of this RefundDetails.  # noqa: E501


        :return: The overpaid of this RefundDetails.  # noqa: E501
        :rtype: InitializeRefundOverpaid
        """
        return self._overpaid

    @overpaid.setter
    def overpaid(self, overpaid):
        """Sets the overpaid of this RefundDetails.


        :param overpaid: The overpaid of this RefundDetails.  # noqa: E501
        :type: InitializeRefundOverpaid
        """

        self._overpaid = overpaid

    @property
    def surcharges(self):
        """Gets the surcharges of this RefundDetails.  # noqa: E501

        List of surcharges for payment which can be refunded.  # noqa: E501

        :return: The surcharges of this RefundDetails.  # noqa: E501
        :rtype: list[PaymentsSurcharge]
        """
        return self._surcharges

    @surcharges.setter
    def surcharges(self, surcharges):
        """Sets the surcharges of this RefundDetails.

        List of surcharges for payment which can be refunded.  # noqa: E501

        :param surcharges: The surcharges of this RefundDetails.  # noqa: E501
        :type: list[PaymentsSurcharge]
        """

        self._surcharges = surcharges

    @property
    def additional_services(self):
        """Gets the additional_services of this RefundDetails.  # noqa: E501


        :return: The additional_services of this RefundDetails.  # noqa: E501
        :rtype: InitializeRefundAdditionalServices
        """
        return self._additional_services

    @additional_services.setter
    def additional_services(self, additional_services):
        """Sets the additional_services of this RefundDetails.


        :param additional_services: The additional_services of this RefundDetails.  # noqa: E501
        :type: InitializeRefundAdditionalServices
        """

        self._additional_services = additional_services

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RefundDetails):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, RefundDetails):
            return True

        return self.to_dict() != other.to_dict()
