# coding: utf-8

"""
    Allegro REST API

    https://developer.allegro.pl/about  # noqa: E501

    The version of the OpenAPI document: 2020.03.12
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from allegro_api.configuration import Configuration


class CategoryDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'leaf': 'bool',
        'name': 'str',
        'options': 'CategoryOptionsDto',
        'parent': 'CategoryDtoParent'
    }

    attribute_map = {
        'id': 'id',
        'leaf': 'leaf',
        'name': 'name',
        'options': 'options',
        'parent': 'parent'
    }

    def __init__(self, id=None, leaf=None, name=None, options=None, parent=None, local_vars_configuration=None):  # noqa: E501
        """CategoryDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._leaf = None
        self._name = None
        self._options = None
        self._parent = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if leaf is not None:
            self.leaf = leaf
        if name is not None:
            self.name = name
        if options is not None:
            self.options = options
        if parent is not None:
            self.parent = parent

    @property
    def id(self):
        """Gets the id of this CategoryDto.  # noqa: E501

        The ID of the category. This can be either in UUID format or an integer format. You should be ready to accept any string value as the category ID.  # noqa: E501

        :return: The id of this CategoryDto.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this CategoryDto.

        The ID of the category. This can be either in UUID format or an integer format. You should be ready to accept any string value as the category ID.  # noqa: E501

        :param id: The id of this CategoryDto.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def leaf(self):
        """Gets the leaf of this CategoryDto.  # noqa: E501

        Indicates whether the category is at the lowest level. Leaf categories do not have any children. Offers can be listed only in leaf categories.  # noqa: E501

        :return: The leaf of this CategoryDto.  # noqa: E501
        :rtype: bool
        """
        return self._leaf

    @leaf.setter
    def leaf(self, leaf):
        """Sets the leaf of this CategoryDto.

        Indicates whether the category is at the lowest level. Leaf categories do not have any children. Offers can be listed only in leaf categories.  # noqa: E501

        :param leaf: The leaf of this CategoryDto.  # noqa: E501
        :type: bool
        """

        self._leaf = leaf

    @property
    def name(self):
        """Gets the name of this CategoryDto.  # noqa: E501

        Name of the category in Polish.  # noqa: E501

        :return: The name of this CategoryDto.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this CategoryDto.

        Name of the category in Polish.  # noqa: E501

        :param name: The name of this CategoryDto.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def options(self):
        """Gets the options of this CategoryDto.  # noqa: E501


        :return: The options of this CategoryDto.  # noqa: E501
        :rtype: CategoryOptionsDto
        """
        return self._options

    @options.setter
    def options(self, options):
        """Sets the options of this CategoryDto.


        :param options: The options of this CategoryDto.  # noqa: E501
        :type: CategoryOptionsDto
        """

        self._options = options

    @property
    def parent(self):
        """Gets the parent of this CategoryDto.  # noqa: E501


        :return: The parent of this CategoryDto.  # noqa: E501
        :rtype: CategoryDtoParent
        """
        return self._parent

    @parent.setter
    def parent(self, parent):
        """Sets the parent of this CategoryDto.


        :param parent: The parent of this CategoryDto.  # noqa: E501
        :type: CategoryDtoParent
        """

        self._parent = parent

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CategoryDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CategoryDto):
            return True

        return self.to_dict() != other.to_dict()
