# coding: utf-8

"""
    Allegro REST API

    https://developer.allegro.pl/about  # noqa: E501

    The version of the OpenAPI document: 2020.03.12
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from allegro_api.configuration import Configuration


class BaseOperation(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'type': 'str',
        'group': 'str',
        'wallet': 'Wallet',
        'value': 'OperationValue',
        'occurred_at': 'datetime'
    }

    attribute_map = {
        'type': 'type',
        'group': 'group',
        'wallet': 'wallet',
        'value': 'value',
        'occurred_at': 'occurredAt'
    }

    discriminator_value_class_map = {
        'RefundIncreaseOperation': 'RefundIncreaseOperation',
        'PayoutOperationCancel': 'PayoutOperationCancel',
        'RefundCancelOperation': 'RefundCancelOperation',
        'DeductionIncreaseOperation': 'DeductionIncreaseOperation',
        'PayoutOperation': 'PayoutOperation',
        'CorrectionOperation': 'CorrectionOperation',
        'SurchargeOperation': 'SurchargeOperation',
        'ContributionOperation': 'ContributionOperation',
        'RefundChargeOperation': 'RefundChargeOperation',
        'DeductionChargeOperation': 'DeductionChargeOperation'
    }

    def __init__(self, type=None, group=None, wallet=None, value=None, occurred_at=None, local_vars_configuration=None):  # noqa: E501
        """BaseOperation - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._type = None
        self._group = None
        self._wallet = None
        self._value = None
        self._occurred_at = None
        self.discriminator = 'type'

        self.type = type
        self.group = group
        self.wallet = wallet
        self.value = value
        self.occurred_at = occurred_at

    @property
    def type(self):
        """Gets the type of this BaseOperation.  # noqa: E501

        Type of the operation.  # noqa: E501

        :return: The type of this BaseOperation.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this BaseOperation.

        Type of the operation.  # noqa: E501

        :param type: The type of this BaseOperation.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and type is None:  # noqa: E501
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    @property
    def group(self):
        """Gets the group of this BaseOperation.  # noqa: E501

        The group to which the given operation type belongs.  # noqa: E501

        :return: The group of this BaseOperation.  # noqa: E501
        :rtype: str
        """
        return self._group

    @group.setter
    def group(self, group):
        """Sets the group of this BaseOperation.

        The group to which the given operation type belongs.  # noqa: E501

        :param group: The group of this BaseOperation.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and group is None:  # noqa: E501
            raise ValueError("Invalid value for `group`, must not be `None`")  # noqa: E501
        allowed_values = ["INCOME", "OUTCOME", "REFUND"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and group not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `group` ({0}), must be one of {1}"  # noqa: E501
                .format(group, allowed_values)
            )

        self._group = group

    @property
    def wallet(self):
        """Gets the wallet of this BaseOperation.  # noqa: E501


        :return: The wallet of this BaseOperation.  # noqa: E501
        :rtype: Wallet
        """
        return self._wallet

    @wallet.setter
    def wallet(self, wallet):
        """Sets the wallet of this BaseOperation.


        :param wallet: The wallet of this BaseOperation.  # noqa: E501
        :type: Wallet
        """
        if self.local_vars_configuration.client_side_validation and wallet is None:  # noqa: E501
            raise ValueError("Invalid value for `wallet`, must not be `None`")  # noqa: E501

        self._wallet = wallet

    @property
    def value(self):
        """Gets the value of this BaseOperation.  # noqa: E501


        :return: The value of this BaseOperation.  # noqa: E501
        :rtype: OperationValue
        """
        return self._value

    @value.setter
    def value(self, value):
        """Sets the value of this BaseOperation.


        :param value: The value of this BaseOperation.  # noqa: E501
        :type: OperationValue
        """
        if self.local_vars_configuration.client_side_validation and value is None:  # noqa: E501
            raise ValueError("Invalid value for `value`, must not be `None`")  # noqa: E501

        self._value = value

    @property
    def occurred_at(self):
        """Gets the occurred_at of this BaseOperation.  # noqa: E501

        Date and time of the operation in ISO 8601 format.  # noqa: E501

        :return: The occurred_at of this BaseOperation.  # noqa: E501
        :rtype: datetime
        """
        return self._occurred_at

    @occurred_at.setter
    def occurred_at(self, occurred_at):
        """Sets the occurred_at of this BaseOperation.

        Date and time of the operation in ISO 8601 format.  # noqa: E501

        :param occurred_at: The occurred_at of this BaseOperation.  # noqa: E501
        :type: datetime
        """
        if self.local_vars_configuration.client_side_validation and occurred_at is None:  # noqa: E501
            raise ValueError("Invalid value for `occurred_at`, must not be `None`")  # noqa: E501

        self._occurred_at = occurred_at

    def get_real_child_model(self, data):
        """Returns the real base class specified by the discriminator"""
        discriminator_key = self.attribute_map[self.discriminator]
        discriminator_value = data[discriminator_key]
        return self.discriminator_value_class_map.get(discriminator_value)

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BaseOperation):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, BaseOperation):
            return True

        return self.to_dict() != other.to_dict()
