# coding: utf-8

"""
    Allegro REST API

    https://developer.allegro.pl/about  # noqa: E501

    The version of the OpenAPI document: 2020.03.12
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from allegro_api.api_client import ApiClient
from allegro_api.exceptions import (
    ApiTypeError,
    ApiValueError
)


class UsersOfferInformationApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_offer_events(self, **kwargs):  # noqa: E501
        """Get events about the seller's offers  # noqa: E501

        Use this endpoint to get events concerning changes in the authorized seller's offers. At present we support the following events:   - OFFER_ACTIVATED - offer is visible on site and available for purchase, occurs when offer status changes from ACTIVATING to ACTIVE.   - OFFER_CHANGED - occurs when offer's fields has been changed e.g. description or photos.   - OFFER_ENDED - offer is no longer available for purchase, occurs when offer status changes from ACTIVE to ENDED.   - OFFER_STOCK_CHANGED - stock in an offer was changed either via purchase or by seller.   - OFFER_PRICE_CHANGED - occurs when price in an offer was changed.   - OFFER_ARCHIVED - offer is no longer available on listing and has been archived.   - OFFER_BID_PLACED - bid was placed on the offer   - OFFER_BID_CANCELED - bid for offer was canceled  Returned events may occur by actions made via browser or API. The resource allows you to get events concerning active offers and offers scheduled for activation (status ACTIVE and ACTIVATING). Returned events do not concern offers in INACTIVE and ENDED status (the exception is OFFER_ARCHIVED event). Please note that one change may result in more than one event.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_offer_events(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str _from: The ID of the last seen event. Events that occured after the given event will be returned.
        :param int limit: The number of events that will be returned in the response.
        :param list[str] type: The types of events that will be returned in the response. All types of events are returned by default.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: SellerOfferEventsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_offer_events_with_http_info(**kwargs)  # noqa: E501

    def get_offer_events_with_http_info(self, **kwargs):  # noqa: E501
        """Get events about the seller's offers  # noqa: E501

        Use this endpoint to get events concerning changes in the authorized seller's offers. At present we support the following events:   - OFFER_ACTIVATED - offer is visible on site and available for purchase, occurs when offer status changes from ACTIVATING to ACTIVE.   - OFFER_CHANGED - occurs when offer's fields has been changed e.g. description or photos.   - OFFER_ENDED - offer is no longer available for purchase, occurs when offer status changes from ACTIVE to ENDED.   - OFFER_STOCK_CHANGED - stock in an offer was changed either via purchase or by seller.   - OFFER_PRICE_CHANGED - occurs when price in an offer was changed.   - OFFER_ARCHIVED - offer is no longer available on listing and has been archived.   - OFFER_BID_PLACED - bid was placed on the offer   - OFFER_BID_CANCELED - bid for offer was canceled  Returned events may occur by actions made via browser or API. The resource allows you to get events concerning active offers and offers scheduled for activation (status ACTIVE and ACTIVATING). Returned events do not concern offers in INACTIVE and ENDED status (the exception is OFFER_ARCHIVED event). Please note that one change may result in more than one event.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_offer_events_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str _from: The ID of the last seen event. Events that occured after the given event will be returned.
        :param int limit: The number of events that will be returned in the response.
        :param list[str] type: The types of events that will be returned in the response. All types of events are returned by default.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(SellerOfferEventsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['_from', 'limit', 'type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_offer_events" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and ('_from' in local_var_params and  # noqa: E501
                                                        len(local_var_params['_from']) > 256):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `_from` when calling `get_offer_events`, length must be less than or equal to `256`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 1000:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `get_offer_events`, must be a value less than or equal to `1000`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `get_offer_events`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if '_from' in local_var_params and local_var_params['_from'] is not None:  # noqa: E501
            query_params.append(('from', local_var_params['_from']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
            collection_formats['type'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.allegro.public.v1+json', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer-token-for-user']  # noqa: E501

        return self.api_client.call_api(
            '/sale/offer-events', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SellerOfferEventsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_offer_using_get(self, offer_id, **kwargs):  # noqa: E501
        """Get all fields of the particular offer  # noqa: E501

        Use this resource to retrieve all fields of the particular offer. <a href=\"../../sale/#similar-offer\" target=\"_blank\">Read more</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_offer_using_get(offer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str offer_id: Offer identifier. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Offer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_offer_using_get_with_http_info(offer_id, **kwargs)  # noqa: E501

    def get_offer_using_get_with_http_info(self, offer_id, **kwargs):  # noqa: E501
        """Get all fields of the particular offer  # noqa: E501

        Use this resource to retrieve all fields of the particular offer. <a href=\"../../sale/#similar-offer\" target=\"_blank\">Read more</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_offer_using_get_with_http_info(offer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str offer_id: Offer identifier. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Offer, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['offer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_offer_using_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'offer_id' is set
        if self.api_client.client_side_validation and ('offer_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['offer_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `offer_id` when calling `get_offer_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'offer_id' in local_var_params:
            path_params['offerId'] = local_var_params['offer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer-token-for-user']  # noqa: E501

        return self.api_client.call_api(
            '/sale/offers/{offerId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Offer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_offers_using_get(self, **kwargs):  # noqa: E501
        """Get seller's offers  # noqa: E501

        Use this resource to get the list of the seller's offers. You can use different query parameters to filter the list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_offers_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str offer_id: Offer ID.
        :param str name: The text to search in the offer title.
        :param float selling_mode_price_amount_gte: The lower threshold of price.
        :param float selling_mode_price_amount_lte: The upper threshold of price.
        :param list[str] publication_status: The publication status of the offer. Passing more than one value will search for offers with any of the given statuses. By default all statuses are included. Example: `publication.status=INACTIVE&publication.status=ACTIVE` - returns offers with status `INACTIVE` or `ACTIVE`.
        :param list[str] selling_mode_format: The offer's selling format. Passing more than one value will search for offers with any of the given formats. By default all formats are included. Example: `sellingMode.format=BUY_NOW&sellingMode.format=ADVERTISEMENT` - returns offers with with format `BUY_NOW` or `ADVERTISEMENT`.
        :param list[str] external_id: The ID from the client's external system. Passing more than one value will search for offers with any of the given IDs. By default no ID is included. Example: `external.id=1233&external.id=1234` - returns offers with ID `1233` or `1234`. Single ID length shouldn't exceed 100 characters.
        :param str delivery_shipping_rates_id: The ID of shipping rates. Returns offers with given shipping rates ID.
        :param bool delivery_shipping_rates_id_empty: Allow to filter offers by existence of shipping rates ID.
        :param str sort: The results' sorting order. No prefix in the value means ascending order. `-` prefix means descending order. If you don't provide the sort parameter, the list is sorted by offer creation time, descending.
        :param int limit: The maximum number of offers returned in the response.
        :param int offset: Index of the first returned offer from all search results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OffersSearchResultDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.search_offers_using_get_with_http_info(**kwargs)  # noqa: E501

    def search_offers_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """Get seller's offers  # noqa: E501

        Use this resource to get the list of the seller's offers. You can use different query parameters to filter the list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_offers_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str offer_id: Offer ID.
        :param str name: The text to search in the offer title.
        :param float selling_mode_price_amount_gte: The lower threshold of price.
        :param float selling_mode_price_amount_lte: The upper threshold of price.
        :param list[str] publication_status: The publication status of the offer. Passing more than one value will search for offers with any of the given statuses. By default all statuses are included. Example: `publication.status=INACTIVE&publication.status=ACTIVE` - returns offers with status `INACTIVE` or `ACTIVE`.
        :param list[str] selling_mode_format: The offer's selling format. Passing more than one value will search for offers with any of the given formats. By default all formats are included. Example: `sellingMode.format=BUY_NOW&sellingMode.format=ADVERTISEMENT` - returns offers with with format `BUY_NOW` or `ADVERTISEMENT`.
        :param list[str] external_id: The ID from the client's external system. Passing more than one value will search for offers with any of the given IDs. By default no ID is included. Example: `external.id=1233&external.id=1234` - returns offers with ID `1233` or `1234`. Single ID length shouldn't exceed 100 characters.
        :param str delivery_shipping_rates_id: The ID of shipping rates. Returns offers with given shipping rates ID.
        :param bool delivery_shipping_rates_id_empty: Allow to filter offers by existence of shipping rates ID.
        :param str sort: The results' sorting order. No prefix in the value means ascending order. `-` prefix means descending order. If you don't provide the sort parameter, the list is sorted by offer creation time, descending.
        :param int limit: The maximum number of offers returned in the response.
        :param int offset: Index of the first returned offer from all search results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OffersSearchResultDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['offer_id', 'name', 'selling_mode_price_amount_gte', 'selling_mode_price_amount_lte', 'publication_status', 'selling_mode_format', 'external_id', 'delivery_shipping_rates_id', 'delivery_shipping_rates_id_empty', 'sort', 'limit', 'offset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_offers_using_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and ('external_id' in local_var_params and  # noqa: E501
                                                        len(local_var_params['external_id']) > 100):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `external_id` when calling `search_offers_using_get`, number of items must be less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 1000:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `search_offers_using_get`, must be a value less than or equal to `1000`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `search_offers_using_get`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'offset' in local_var_params and local_var_params['offset'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `offset` when calling `search_offers_using_get`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'offer_id' in local_var_params and local_var_params['offer_id'] is not None:  # noqa: E501
            query_params.append(('offer.id', local_var_params['offer_id']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'selling_mode_price_amount_gte' in local_var_params and local_var_params['selling_mode_price_amount_gte'] is not None:  # noqa: E501
            query_params.append(('sellingMode.price.amount.gte', local_var_params['selling_mode_price_amount_gte']))  # noqa: E501
        if 'selling_mode_price_amount_lte' in local_var_params and local_var_params['selling_mode_price_amount_lte'] is not None:  # noqa: E501
            query_params.append(('sellingMode.price.amount.lte', local_var_params['selling_mode_price_amount_lte']))  # noqa: E501
        if 'publication_status' in local_var_params and local_var_params['publication_status'] is not None:  # noqa: E501
            query_params.append(('publication.status', local_var_params['publication_status']))  # noqa: E501
            collection_formats['publication.status'] = 'multi'  # noqa: E501
        if 'selling_mode_format' in local_var_params and local_var_params['selling_mode_format'] is not None:  # noqa: E501
            query_params.append(('sellingMode.format', local_var_params['selling_mode_format']))  # noqa: E501
            collection_formats['sellingMode.format'] = 'multi'  # noqa: E501
        if 'external_id' in local_var_params and local_var_params['external_id'] is not None:  # noqa: E501
            query_params.append(('external.id', local_var_params['external_id']))  # noqa: E501
            collection_formats['external.id'] = 'multi'  # noqa: E501
        if 'delivery_shipping_rates_id' in local_var_params and local_var_params['delivery_shipping_rates_id'] is not None:  # noqa: E501
            query_params.append(('delivery.shippingRates.id', local_var_params['delivery_shipping_rates_id']))  # noqa: E501
        if 'delivery_shipping_rates_id_empty' in local_var_params and local_var_params['delivery_shipping_rates_id_empty'] is not None:  # noqa: E501
            query_params.append(('delivery.shippingRates.id.empty', local_var_params['delivery_shipping_rates_id_empty']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer-token-for-user']  # noqa: E501

        return self.api_client.call_api(
            '/sale/offers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OffersSearchResultDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
