# coding: utf-8

"""
    Allegro REST API

    https://developer.allegro.pl/about  # noqa: E501

    The version of the OpenAPI document: 2020.03.12
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from allegro_api.api_client import ApiClient
from allegro_api.exceptions import (
    ApiTypeError,
    ApiValueError
)


class SetsAndRebatesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_promotion_using_post1(self, seller_create_rebate_request_dto, **kwargs):  # noqa: E501
        """Create a new promotion  # noqa: E501

        This endpoint creates a new promotion. You can define the following types of promotions: 1. Bundle In order to create a new bundle, you have to define a  promotion with a single benefit of type **ORDER_FIXED_DISCOUNT** and a single criterion of type **CONTAINS_OFFERS**. In the benefit specification you have to declare the discount amount that you want to be deducted from the sum of bundled offers prices. In the offer criterion you need to pass a list of offers that are to be grouped as a bundle. For each offer you have to define a fixed quantity (that many pieces of your offer will be part of the bundle) and you also have to set a promotionEntryPoint flag (offers with this flag set to true will have a section that allows the users to purchase your bundle).  2. Multipack In order to create a new multipack, you have to define a promotion with a single benefit of type **UNIT_PERCENTAGE_DISCOUNT** and a single criterion of type **CONTAINS_OFFERS**. The benefit specification should contain a configuration section with a percentage which indicates the specific discount for the discounted offer. This percentage should be an integer value greater than 15 for quantity 2, greater than 30 for quantity 3, greater than 40 for quantity 4, greater than 50 for quantity 5 and lower than or equal to 100. The specification should also contain a trigger section with a field forEachQuantity that defines the amount of items in the multipack which is necessary to trigger the benefit. Additionally, the discountedNumber field must be set to 1 by default as you can only discount one unit in a multipack. Finally, the offer criterion specifies the offer for which the multipack promotion will take effect. 3. Cross-offer multipack A cross-offer multipack is created in the same fashion as a standard multipack. The only difference is that you need to pass more than 1 offer in the offer criterion section. This group of offers is then considered as a pool from which users can pick and choose forEachQuantity offers and the cheapest of them gets a discount. Read more about <a href=\"../../news/2017-10-18-news_promocyjne_zestawy_ofert/\" target=\"_blank\">bundles</a>, <a href=\"../../news/2018-02-01-rabaty_ilosciowe/\" target=\"_blank\">multipack</a> and <a href=\"../../news/2018-10-08-rabaty_ilosciowe/\" target=\"_blank\">cross-offer multipack</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_promotion_using_post1(seller_create_rebate_request_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param SellerCreateRebateRequestDto seller_create_rebate_request_dto: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: SellerRebateDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_promotion_using_post1_with_http_info(seller_create_rebate_request_dto, **kwargs)  # noqa: E501

    def create_promotion_using_post1_with_http_info(self, seller_create_rebate_request_dto, **kwargs):  # noqa: E501
        """Create a new promotion  # noqa: E501

        This endpoint creates a new promotion. You can define the following types of promotions: 1. Bundle In order to create a new bundle, you have to define a  promotion with a single benefit of type **ORDER_FIXED_DISCOUNT** and a single criterion of type **CONTAINS_OFFERS**. In the benefit specification you have to declare the discount amount that you want to be deducted from the sum of bundled offers prices. In the offer criterion you need to pass a list of offers that are to be grouped as a bundle. For each offer you have to define a fixed quantity (that many pieces of your offer will be part of the bundle) and you also have to set a promotionEntryPoint flag (offers with this flag set to true will have a section that allows the users to purchase your bundle).  2. Multipack In order to create a new multipack, you have to define a promotion with a single benefit of type **UNIT_PERCENTAGE_DISCOUNT** and a single criterion of type **CONTAINS_OFFERS**. The benefit specification should contain a configuration section with a percentage which indicates the specific discount for the discounted offer. This percentage should be an integer value greater than 15 for quantity 2, greater than 30 for quantity 3, greater than 40 for quantity 4, greater than 50 for quantity 5 and lower than or equal to 100. The specification should also contain a trigger section with a field forEachQuantity that defines the amount of items in the multipack which is necessary to trigger the benefit. Additionally, the discountedNumber field must be set to 1 by default as you can only discount one unit in a multipack. Finally, the offer criterion specifies the offer for which the multipack promotion will take effect. 3. Cross-offer multipack A cross-offer multipack is created in the same fashion as a standard multipack. The only difference is that you need to pass more than 1 offer in the offer criterion section. This group of offers is then considered as a pool from which users can pick and choose forEachQuantity offers and the cheapest of them gets a discount. Read more about <a href=\"../../news/2017-10-18-news_promocyjne_zestawy_ofert/\" target=\"_blank\">bundles</a>, <a href=\"../../news/2018-02-01-rabaty_ilosciowe/\" target=\"_blank\">multipack</a> and <a href=\"../../news/2018-10-08-rabaty_ilosciowe/\" target=\"_blank\">cross-offer multipack</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_promotion_using_post1_with_http_info(seller_create_rebate_request_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param SellerCreateRebateRequestDto seller_create_rebate_request_dto: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(SellerRebateDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['seller_create_rebate_request_dto']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_promotion_using_post1" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'seller_create_rebate_request_dto' is set
        if self.api_client.client_side_validation and ('seller_create_rebate_request_dto' not in local_var_params or  # noqa: E501
                                                        local_var_params['seller_create_rebate_request_dto'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `seller_create_rebate_request_dto` when calling `create_promotion_using_post1`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'seller_create_rebate_request_dto' in local_var_params:
            body_params = local_var_params['seller_create_rebate_request_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer-token-for-user']  # noqa: E501

        return self.api_client.call_api(
            '/sale/loyalty/promotions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SellerRebateDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deactivate_promotion_using_delete(self, promotion_id, **kwargs):  # noqa: E501
        """Deactivate a promotion by id  # noqa: E501

        Use this resource to deactivate the requested promotion. You need to use its unique id. Read more about <a href=\"../../news/2017-10-18-news_promocyjne_zestawy_ofert/#4\" target=\"_blank\">bundles</a> and <a href=\"../../news/2018-02-01-rabaty_ilosciowe/#4\" target=\"_blank\">multipack</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deactivate_promotion_using_delete(promotion_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str promotion_id: Promotion identifier. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.deactivate_promotion_using_delete_with_http_info(promotion_id, **kwargs)  # noqa: E501

    def deactivate_promotion_using_delete_with_http_info(self, promotion_id, **kwargs):  # noqa: E501
        """Deactivate a promotion by id  # noqa: E501

        Use this resource to deactivate the requested promotion. You need to use its unique id. Read more about <a href=\"../../news/2017-10-18-news_promocyjne_zestawy_ofert/#4\" target=\"_blank\">bundles</a> and <a href=\"../../news/2018-02-01-rabaty_ilosciowe/#4\" target=\"_blank\">multipack</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deactivate_promotion_using_delete_with_http_info(promotion_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str promotion_id: Promotion identifier. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['promotion_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deactivate_promotion_using_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'promotion_id' is set
        if self.api_client.client_side_validation and ('promotion_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['promotion_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `promotion_id` when calling `deactivate_promotion_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'promotion_id' in local_var_params:
            path_params['promotionId'] = local_var_params['promotion_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer-token-for-user']  # noqa: E501

        return self.api_client.call_api(
            '/sale/loyalty/promotions/{promotionId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_promotion_using_get(self, promotion_id, **kwargs):  # noqa: E501
        """Get a promotion data by id  # noqa: E501

        Use this resource to returns the requested promotion. You need to use its unique id. Read more about <a href=\"../../news/2017-10-18-news_promocyjne_zestawy_ofert/#3\" target=\"_blank\">bundles</a> and <a href=\"../../news/2018-02-01-rabaty_ilosciowe/#3\" target=\"_blank\">multipack</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_promotion_using_get(promotion_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str promotion_id: Promotion identifier. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: SellerRebateDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_promotion_using_get_with_http_info(promotion_id, **kwargs)  # noqa: E501

    def get_promotion_using_get_with_http_info(self, promotion_id, **kwargs):  # noqa: E501
        """Get a promotion data by id  # noqa: E501

        Use this resource to returns the requested promotion. You need to use its unique id. Read more about <a href=\"../../news/2017-10-18-news_promocyjne_zestawy_ofert/#3\" target=\"_blank\">bundles</a> and <a href=\"../../news/2018-02-01-rabaty_ilosciowe/#3\" target=\"_blank\">multipack</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_promotion_using_get_with_http_info(promotion_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str promotion_id: Promotion identifier. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(SellerRebateDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['promotion_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_promotion_using_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'promotion_id' is set
        if self.api_client.client_side_validation and ('promotion_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['promotion_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `promotion_id` when calling `get_promotion_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'promotion_id' in local_var_params:
            path_params['promotionId'] = local_var_params['promotion_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer-token-for-user']  # noqa: E501

        return self.api_client.call_api(
            '/sale/loyalty/promotions/{promotionId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SellerRebateDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_seller_promotions_using_get1(self, user_id, **kwargs):  # noqa: E501
        """Get the user's list of promotions  # noqa: E501

        <p>Get a list of promotions defined by the authorized user.</p> <p>Restrictions:</p> <p>Sum of limit and offset must be equal to or lower than 50000. Limit must be equal to or lower than 5000.</p> <p>Example:</p> <p>offset = 49950 and limit = 50 will return promotions</p> <p>offset = 49950 and limit = 51 will return 422 http error</p> <p>offset = 0 and limit = 5000 will return promotions</p> <p>offset = 0 and limit = 5001 will return 422 http error</p> <p>Read more about <a href=\"../../news/2017-10-18-news_promocyjne_zestawy_ofert/#2\" target=\"_blank\">Bundles</a> and <a href=\"../../news/2018-02-01-rabaty_ilosciowe/#2\" target=\"_blank\">Multipack</a>.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_seller_promotions_using_get1(user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_id: The id of the user who is the owner of the promotions. (required)
        :param int limit: Limit of promotions per page.
        :param int offset: Distance between the beginning of the document and the point from which promotions are returned.
        :param str offer_id: Filter by offer id.
        :param str promotion_type: Filter by promotion type.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: SellerRebatesDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_seller_promotions_using_get1_with_http_info(user_id, **kwargs)  # noqa: E501

    def list_seller_promotions_using_get1_with_http_info(self, user_id, **kwargs):  # noqa: E501
        """Get the user's list of promotions  # noqa: E501

        <p>Get a list of promotions defined by the authorized user.</p> <p>Restrictions:</p> <p>Sum of limit and offset must be equal to or lower than 50000. Limit must be equal to or lower than 5000.</p> <p>Example:</p> <p>offset = 49950 and limit = 50 will return promotions</p> <p>offset = 49950 and limit = 51 will return 422 http error</p> <p>offset = 0 and limit = 5000 will return promotions</p> <p>offset = 0 and limit = 5001 will return 422 http error</p> <p>Read more about <a href=\"../../news/2017-10-18-news_promocyjne_zestawy_ofert/#2\" target=\"_blank\">Bundles</a> and <a href=\"../../news/2018-02-01-rabaty_ilosciowe/#2\" target=\"_blank\">Multipack</a>.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_seller_promotions_using_get1_with_http_info(user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_id: The id of the user who is the owner of the promotions. (required)
        :param int limit: Limit of promotions per page.
        :param int offset: Distance between the beginning of the document and the point from which promotions are returned.
        :param str offer_id: Filter by offer id.
        :param str promotion_type: Filter by promotion type.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(SellerRebatesDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['user_id', 'limit', 'offset', 'offer_id', 'promotion_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_seller_promotions_using_get1" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_id' is set
        if self.api_client.client_side_validation and ('user_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_id` when calling `list_seller_promotions_using_get1`")  # noqa: E501

        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 5000:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_seller_promotions_using_get1`, must be a value less than or equal to `5000`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_seller_promotions_using_get1`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'offset' in local_var_params and local_var_params['offset'] > 49999:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `offset` when calling `list_seller_promotions_using_get1`, must be a value less than or equal to `49999`")  # noqa: E501
        if self.api_client.client_side_validation and 'offset' in local_var_params and local_var_params['offset'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `offset` when calling `list_seller_promotions_using_get1`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'user_id' in local_var_params and local_var_params['user_id'] is not None:  # noqa: E501
            query_params.append(('user.id', local_var_params['user_id']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'offer_id' in local_var_params and local_var_params['offer_id'] is not None:  # noqa: E501
            query_params.append(('offer.id', local_var_params['offer_id']))  # noqa: E501
        if 'promotion_type' in local_var_params and local_var_params['promotion_type'] is not None:  # noqa: E501
            query_params.append(('promotionType', local_var_params['promotion_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer-token-for-user']  # noqa: E501

        return self.api_client.call_api(
            '/sale/loyalty/promotions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SellerRebatesDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
