# coding: utf-8

"""
    Allegro REST API

    https://developer.allegro.pl/about  # noqa: E501

    The version of the OpenAPI document: 2020.03.12
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from allegro_api.api_client import ApiClient
from allegro_api.exceptions import (
    ApiTypeError,
    ApiValueError
)


class PublicOfferInformationApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_listing(self, **kwargs):  # noqa: E501
        """Search offers  # noqa: E501

        Use this resource to get a list of offers based on the provided query parameters. At least one of: phrase, seller.id or category.id is required. Additional available parameters vary depending on category.id. The parameters are defined in the filters entity. <a href=\"../../news/2018-07-03-listing_ofert/\" target=\"_blank\">Read more</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_listing(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str category_id: The identifier of the category, where you want to search for offers.
        :param str phrase: The search phrase. The phrase is searched in different fields of the offers depending on the value of the `searchMode` parameter.
        :param str seller_id: The identifier of a seller, to limit the results to offers from this seller. May be provided more than once.
        :param str search_mode: Defines where the given phrase should be searched in. Allowed values:    - *REGULAR* - searching for a phrase in the title,   - *DESCRIPTIONS* - searching for a phrase in the title and the descriptions,   - *CLOSED* - searching for a phrase in the title of closed offers.
        :param int offset: Index of the first returned offer from all search results.
        :param int limit: The maximum number of offers in a response.
        :param str sort: Search results sorting order. `+` or no prefix in the value means ascending order. `-` prefix means descending order.
        :param str include: Specify parts of the response that should be included in the output. Allowed values are the names of top level entities and *all* as an alias to all entities. By default, all top level entities are included. Use `-` prefix to exclude an entity. Example: `include=-all&include=filters&include=sort` - returns only filters and sort entities.
        :param bool fallback: Defines the behaviour of the search engine when no results with exact phrase match are found:    - *true* - related (not exact) results are returned,   - *false* - empty results are returned.
        :param dict(str, str) dynamic_filters: You can filter and customize your search results to find exactly what you need by applying filters ids and their dictionary values to query according to the flowing pattern: id=value. When the filter definition looks like:   ````     {      \"id\": \"parameter.11323\",      \"type\": \"MULTI\",      \"name\": \"Stan\",      \"values\": [{        \"value\": \"11323_1\",        \"name\": \"nowe\",        \"count\": 21,        \"selected\": false       },       {        \"value\": \"11323_2\",        \"name\": \"używane\",        \"count\": 157,        \"selected\": false       },       {        \"value\": \"11323_238066\",        \"name\": \"po zwrocie\",        \"count\": 1,        \"selected\": false       }      ]     }   ```` You can use 'Stan' filter to query results, i.e.:   * `parameter.11323=11323_1` for \"nowe\"   * `parameter.11323=11323_2` for \"używane\"   * `parameter.11323=11323_238066` for \"po zwrocie\".
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ListingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_listing_with_http_info(**kwargs)  # noqa: E501

    def get_listing_with_http_info(self, **kwargs):  # noqa: E501
        """Search offers  # noqa: E501

        Use this resource to get a list of offers based on the provided query parameters. At least one of: phrase, seller.id or category.id is required. Additional available parameters vary depending on category.id. The parameters are defined in the filters entity. <a href=\"../../news/2018-07-03-listing_ofert/\" target=\"_blank\">Read more</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_listing_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str category_id: The identifier of the category, where you want to search for offers.
        :param str phrase: The search phrase. The phrase is searched in different fields of the offers depending on the value of the `searchMode` parameter.
        :param str seller_id: The identifier of a seller, to limit the results to offers from this seller. May be provided more than once.
        :param str search_mode: Defines where the given phrase should be searched in. Allowed values:    - *REGULAR* - searching for a phrase in the title,   - *DESCRIPTIONS* - searching for a phrase in the title and the descriptions,   - *CLOSED* - searching for a phrase in the title of closed offers.
        :param int offset: Index of the first returned offer from all search results.
        :param int limit: The maximum number of offers in a response.
        :param str sort: Search results sorting order. `+` or no prefix in the value means ascending order. `-` prefix means descending order.
        :param str include: Specify parts of the response that should be included in the output. Allowed values are the names of top level entities and *all* as an alias to all entities. By default, all top level entities are included. Use `-` prefix to exclude an entity. Example: `include=-all&include=filters&include=sort` - returns only filters and sort entities.
        :param bool fallback: Defines the behaviour of the search engine when no results with exact phrase match are found:    - *true* - related (not exact) results are returned,   - *false* - empty results are returned.
        :param dict(str, str) dynamic_filters: You can filter and customize your search results to find exactly what you need by applying filters ids and their dictionary values to query according to the flowing pattern: id=value. When the filter definition looks like:   ````     {      \"id\": \"parameter.11323\",      \"type\": \"MULTI\",      \"name\": \"Stan\",      \"values\": [{        \"value\": \"11323_1\",        \"name\": \"nowe\",        \"count\": 21,        \"selected\": false       },       {        \"value\": \"11323_2\",        \"name\": \"używane\",        \"count\": 157,        \"selected\": false       },       {        \"value\": \"11323_238066\",        \"name\": \"po zwrocie\",        \"count\": 1,        \"selected\": false       }      ]     }   ```` You can use 'Stan' filter to query results, i.e.:   * `parameter.11323=11323_1` for \"nowe\"   * `parameter.11323=11323_2` for \"używane\"   * `parameter.11323=11323_238066` for \"po zwrocie\".
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ListingResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['category_id', 'phrase', 'seller_id', 'search_mode', 'offset', 'limit', 'sort', 'include', 'fallback', 'dynamic_filters']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_listing" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `get_listing`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `get_listing`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'category_id' in local_var_params and local_var_params['category_id'] is not None:  # noqa: E501
            query_params.append(('category.id', local_var_params['category_id']))  # noqa: E501
        if 'phrase' in local_var_params and local_var_params['phrase'] is not None:  # noqa: E501
            query_params.append(('phrase', local_var_params['phrase']))  # noqa: E501
        if 'seller_id' in local_var_params and local_var_params['seller_id'] is not None:  # noqa: E501
            query_params.append(('seller.id', local_var_params['seller_id']))  # noqa: E501
        if 'search_mode' in local_var_params and local_var_params['search_mode'] is not None:  # noqa: E501
            query_params.append(('searchMode', local_var_params['search_mode']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'include' in local_var_params and local_var_params['include'] is not None:  # noqa: E501
            query_params.append(('include', local_var_params['include']))  # noqa: E501
        if 'fallback' in local_var_params and local_var_params['fallback'] is not None:  # noqa: E501
            query_params.append(('fallback', local_var_params['fallback']))  # noqa: E501
        if 'dynamic_filters' in local_var_params and local_var_params['dynamic_filters'] is not None:  # noqa: E501
            query_params.append(('Dynamic filters', local_var_params['dynamic_filters']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer-token-for-application', 'bearer-token-for-user']  # noqa: E501

        return self.api_client.call_api(
            '/offers/listing', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ListingResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
