# coding: utf-8

"""
    Allegro REST API

    https://developer.allegro.pl/about  # noqa: E501

    The version of the OpenAPI document: 2020.03.12
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from allegro_api.api_client import ApiClient
from allegro_api.exceptions import (
    ApiTypeError,
    ApiValueError
)


class ProductsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_flat_product_parameters_using_get(self, category_id, **kwargs):  # noqa: E501
        """Get product parameters available in given category  # noqa: E501

        Use this resource to get the list of product parameters available in given category. You can use these parameters to create a new product. <a href=\"../../productization\" target=\"_blank\">Read more</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_flat_product_parameters_using_get(category_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str category_id: The category ID. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CategoryProductParameterList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_flat_product_parameters_using_get_with_http_info(category_id, **kwargs)  # noqa: E501

    def get_flat_product_parameters_using_get_with_http_info(self, category_id, **kwargs):  # noqa: E501
        """Get product parameters available in given category  # noqa: E501

        Use this resource to get the list of product parameters available in given category. You can use these parameters to create a new product. <a href=\"../../productization\" target=\"_blank\">Read more</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_flat_product_parameters_using_get_with_http_info(category_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str category_id: The category ID. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CategoryProductParameterList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['category_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flat_product_parameters_using_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'category_id' is set
        if self.api_client.client_side_validation and ('category_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['category_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `category_id` when calling `get_flat_product_parameters_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'category_id' in local_var_params:
            path_params['categoryId'] = local_var_params['category_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer-token-for-application', 'bearer-token-for-user']  # noqa: E501

        return self.api_client.call_api(
            '/sale/categories/{categoryId}/product-parameters', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CategoryProductParameterList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_sale_product(self, product_id, **kwargs):  # noqa: E501
        """Get all data of the particular product  # noqa: E501

        Use this resource to retrieve all data of the particular product. <a href=\"../../productization/#details\" target=\"_blank\">Read more</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sale_product(product_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str product_id: The product identifier. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: SaleProductDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_sale_product_with_http_info(product_id, **kwargs)  # noqa: E501

    def get_sale_product_with_http_info(self, product_id, **kwargs):  # noqa: E501
        """Get all data of the particular product  # noqa: E501

        Use this resource to retrieve all data of the particular product. <a href=\"../../productization/#details\" target=\"_blank\">Read more</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sale_product_with_http_info(product_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str product_id: The product identifier. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(SaleProductDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['product_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sale_product" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'product_id' is set
        if self.api_client.client_side_validation and ('product_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['product_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `product_id` when calling `get_sale_product`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'product_id' in local_var_params:
            path_params['productId'] = local_var_params['product_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer-token-for-user']  # noqa: E501

        return self.api_client.call_api(
            '/sale/products/{productId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SaleProductDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_sale_products(self, **kwargs):  # noqa: E501
        """Get search products results  # noqa: E501

        Use this resource to get a list of products according to provided parameters. At least ean or phrase parameter is required. <a href=\"../../productization/#search\" target=\"_blank\">Read more</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sale_products(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ean: The EAN values can include EAN, ISBN, and UPC identifier types.
        :param str phrase: Search phrase.
        :param str category_id: The category identifier to filter results.
        :param dict(str, str) dynamic_filters: You can filter and customize your search results to find exactly what you need by applying filters ids and their dictionary values to query according to the flowing pattern: id=value. When the filter definition looks like:   ````   {     \"id\": \"127448\",     \"name\": \"Kolor\",     \"type\": \"SINGLE\",     \"values\": [       {         \"name\": \"biały\",         \"value\": \"2\"       },       {         \"name\": \"czarny\",         \"value\": \"1\" }     ]   }   ```` You can use 'Kolor' filter to query results, i.e.:   * `127448=2` for \"biały\"   * `127448=1` for \"czarny\".
        :param str page_id: A \"cursor\" to the next set of results.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GetSaleProductsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_sale_products_with_http_info(**kwargs)  # noqa: E501

    def get_sale_products_with_http_info(self, **kwargs):  # noqa: E501
        """Get search products results  # noqa: E501

        Use this resource to get a list of products according to provided parameters. At least ean or phrase parameter is required. <a href=\"../../productization/#search\" target=\"_blank\">Read more</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sale_products_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str ean: The EAN values can include EAN, ISBN, and UPC identifier types.
        :param str phrase: Search phrase.
        :param str category_id: The category identifier to filter results.
        :param dict(str, str) dynamic_filters: You can filter and customize your search results to find exactly what you need by applying filters ids and their dictionary values to query according to the flowing pattern: id=value. When the filter definition looks like:   ````   {     \"id\": \"127448\",     \"name\": \"Kolor\",     \"type\": \"SINGLE\",     \"values\": [       {         \"name\": \"biały\",         \"value\": \"2\"       },       {         \"name\": \"czarny\",         \"value\": \"1\" }     ]   }   ```` You can use 'Kolor' filter to query results, i.e.:   * `127448=2` for \"biały\"   * `127448=1` for \"czarny\".
        :param str page_id: A \"cursor\" to the next set of results.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GetSaleProductsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['ean', 'phrase', 'category_id', 'dynamic_filters', 'page_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sale_products" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and ('ean' in local_var_params and  # noqa: E501
                                                        len(local_var_params['ean']) > 18):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `ean` when calling `get_sale_products`, length must be less than or equal to `18`")  # noqa: E501
        if self.api_client.client_side_validation and ('phrase' in local_var_params and  # noqa: E501
                                                        len(local_var_params['phrase']) > 1024):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `phrase` when calling `get_sale_products`, length must be less than or equal to `1024`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ean' in local_var_params and local_var_params['ean'] is not None:  # noqa: E501
            query_params.append(('ean', local_var_params['ean']))  # noqa: E501
        if 'phrase' in local_var_params and local_var_params['phrase'] is not None:  # noqa: E501
            query_params.append(('phrase', local_var_params['phrase']))  # noqa: E501
        if 'category_id' in local_var_params and local_var_params['category_id'] is not None:  # noqa: E501
            query_params.append(('category.id', local_var_params['category_id']))  # noqa: E501
        if 'dynamic_filters' in local_var_params and local_var_params['dynamic_filters'] is not None:  # noqa: E501
            query_params.append(('Dynamic filters', local_var_params['dynamic_filters']))  # noqa: E501
        if 'page_id' in local_var_params and local_var_params['page_id'] is not None:  # noqa: E501
            query_params.append(('page.id', local_var_params['page_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer-token-for-user']  # noqa: E501

        return self.api_client.call_api(
            '/sale/products', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetSaleProductsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def propose_sale_product(self, propose_sale_product_request, **kwargs):  # noqa: E501
        """Propose a product  # noqa: E501

        Use this resource to propose a product.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.propose_sale_product(propose_sale_product_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param ProposeSaleProductRequest propose_sale_product_request: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: SaleProductDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.propose_sale_product_with_http_info(propose_sale_product_request, **kwargs)  # noqa: E501

    def propose_sale_product_with_http_info(self, propose_sale_product_request, **kwargs):  # noqa: E501
        """Propose a product  # noqa: E501

        Use this resource to propose a product.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.propose_sale_product_with_http_info(propose_sale_product_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param ProposeSaleProductRequest propose_sale_product_request: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(SaleProductDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['propose_sale_product_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method propose_sale_product" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'propose_sale_product_request' is set
        if self.api_client.client_side_validation and ('propose_sale_product_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['propose_sale_product_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `propose_sale_product_request` when calling `propose_sale_product`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'propose_sale_product_request' in local_var_params:
            body_params = local_var_params['propose_sale_product_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer-token-for-user']  # noqa: E501

        return self.api_client.call_api(
            '/sale/product-proposals', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SaleProductDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
