# coding: utf-8

"""
    Allegro REST API

    https://developer.allegro.pl/about  # noqa: E501

    The version of the OpenAPI document: 2020.03.12
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from allegro_api.api_client import ApiClient
from allegro_api.exceptions import (
    ApiTypeError,
    ApiValueError
)


class PricingApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def calculate_fee_preview_using_post(self, public_offer_preview_request, **kwargs):  # noqa: E501
        """Calculate fee and commission for an offer  # noqa: E501

        Provides information about fee and commission for an offer.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.calculate_fee_preview_using_post(public_offer_preview_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param PublicOfferPreviewRequest public_offer_preview_request: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FeePreviewResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.calculate_fee_preview_using_post_with_http_info(public_offer_preview_request, **kwargs)  # noqa: E501

    def calculate_fee_preview_using_post_with_http_info(self, public_offer_preview_request, **kwargs):  # noqa: E501
        """Calculate fee and commission for an offer  # noqa: E501

        Provides information about fee and commission for an offer.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.calculate_fee_preview_using_post_with_http_info(public_offer_preview_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param PublicOfferPreviewRequest public_offer_preview_request: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FeePreviewResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['public_offer_preview_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method calculate_fee_preview_using_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'public_offer_preview_request' is set
        if self.api_client.client_side_validation and ('public_offer_preview_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['public_offer_preview_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `public_offer_preview_request` when calling `calculate_fee_preview_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'public_offer_preview_request' in local_var_params:
            body_params = local_var_params['public_offer_preview_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer-token-for-user']  # noqa: E501

        return self.api_client.call_api(
            '/pricing/offer-fee-preview', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FeePreviewResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def offer_quotes_public_using_get(self, offer_id, **kwargs):  # noqa: E501
        """Get the user's current offer quotes  # noqa: E501

        This endpoint returns current offer quotes (listing and promo fees) cycles for authenticated user and list of offers. <a href=\"../../news/2018-02-14-zasob_do_sprawdzania_daty_oplaty/\" target=\"_blank\">Read more</a>. <br/>2018-07-18 - resource update <a href=\"../../news/2018-07-18-aktualizacja_zasob_do_sprawdzania_daty_oplaty/\" target=\"_blank\">here</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.offer_quotes_public_using_get(offer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] offer_id: List of offer Ids, maximum 20 values. (required)
        :param str name: Offer quote name.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OfferQuotesDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.offer_quotes_public_using_get_with_http_info(offer_id, **kwargs)  # noqa: E501

    def offer_quotes_public_using_get_with_http_info(self, offer_id, **kwargs):  # noqa: E501
        """Get the user's current offer quotes  # noqa: E501

        This endpoint returns current offer quotes (listing and promo fees) cycles for authenticated user and list of offers. <a href=\"../../news/2018-02-14-zasob_do_sprawdzania_daty_oplaty/\" target=\"_blank\">Read more</a>. <br/>2018-07-18 - resource update <a href=\"../../news/2018-07-18-aktualizacja_zasob_do_sprawdzania_daty_oplaty/\" target=\"_blank\">here</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.offer_quotes_public_using_get_with_http_info(offer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] offer_id: List of offer Ids, maximum 20 values. (required)
        :param str name: Offer quote name.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OfferQuotesDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['offer_id', 'name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method offer_quotes_public_using_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'offer_id' is set
        if self.api_client.client_side_validation and ('offer_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['offer_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `offer_id` when calling `offer_quotes_public_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'offer_id' in local_var_params and local_var_params['offer_id'] is not None:  # noqa: E501
            query_params.append(('offer.id', local_var_params['offer_id']))  # noqa: E501
            collection_formats['offer.id'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer-token-for-user']  # noqa: E501

        return self.api_client.call_api(
            '/pricing/offer-quotes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OfferQuotesDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def preview_fees_public_api_using_post(self, wrapper_type_for_preview_conditions, **kwargs):  # noqa: E501
        """Preview offer fees  # noqa: E501

        This endpoint calculates fees for a provided offer conditions. The quotation is estimated and based on the current configuration of the Allegro price list and the data entered in this API. The stated price does not include package discounts. The rules of charging and amount of charges are described in the Allegro regulations in Appendix 4. The final amount of the fee for the offer will be available after approval under the tab: My Account> Accounts> History. <a href=\"../../news/2017-10-30-kalkulator_ogloszenia/\" target=\"_blank\">Read more</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.preview_fees_public_api_using_post(wrapper_type_for_preview_conditions, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param WrapperTypeForPreviewConditions wrapper_type_for_preview_conditions: command (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: WrapsListingAndCommissionsFees
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.preview_fees_public_api_using_post_with_http_info(wrapper_type_for_preview_conditions, **kwargs)  # noqa: E501

    def preview_fees_public_api_using_post_with_http_info(self, wrapper_type_for_preview_conditions, **kwargs):  # noqa: E501
        """Preview offer fees  # noqa: E501

        This endpoint calculates fees for a provided offer conditions. The quotation is estimated and based on the current configuration of the Allegro price list and the data entered in this API. The stated price does not include package discounts. The rules of charging and amount of charges are described in the Allegro regulations in Appendix 4. The final amount of the fee for the offer will be available after approval under the tab: My Account> Accounts> History. <a href=\"../../news/2017-10-30-kalkulator_ogloszenia/\" target=\"_blank\">Read more</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.preview_fees_public_api_using_post_with_http_info(wrapper_type_for_preview_conditions, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param WrapperTypeForPreviewConditions wrapper_type_for_preview_conditions: command (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(WrapsListingAndCommissionsFees, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['wrapper_type_for_preview_conditions']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method preview_fees_public_api_using_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'wrapper_type_for_preview_conditions' is set
        if self.api_client.client_side_validation and ('wrapper_type_for_preview_conditions' not in local_var_params or  # noqa: E501
                                                        local_var_params['wrapper_type_for_preview_conditions'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `wrapper_type_for_preview_conditions` when calling `preview_fees_public_api_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'wrapper_type_for_preview_conditions' in local_var_params:
            body_params = local_var_params['wrapper_type_for_preview_conditions']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer-token-for-user']  # noqa: E501

        return self.api_client.call_api(
            '/pricing/fee-preview', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WrapsListingAndCommissionsFees',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
