# coding: utf-8

"""
    Allegro REST API

    https://developer.allegro.pl/about  # noqa: E501

    The version of the OpenAPI document: 2020.03.12
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from allegro_api.api_client import ApiClient
from allegro_api.exceptions import (
    ApiTypeError,
    ApiValueError
)


class OfferManagementApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def change_publication_status_using_put(self, command_id, publication_change_command_dto, **kwargs):  # noqa: E501
        """Batch offer publish / unpublish  # noqa: E501

        Use this resource to modify multiple offers publication at once. <a href=\"../../sale/#step-8-offer-publication-commands\" target=\"_blank\">Read more</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.change_publication_status_using_put(command_id, publication_change_command_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str command_id: Command identifier. (required)
        :param PublicationChangeCommandDto publication_change_command_dto: publicationChangeCommandDto (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GeneralReport
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.change_publication_status_using_put_with_http_info(command_id, publication_change_command_dto, **kwargs)  # noqa: E501

    def change_publication_status_using_put_with_http_info(self, command_id, publication_change_command_dto, **kwargs):  # noqa: E501
        """Batch offer publish / unpublish  # noqa: E501

        Use this resource to modify multiple offers publication at once. <a href=\"../../sale/#step-8-offer-publication-commands\" target=\"_blank\">Read more</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.change_publication_status_using_put_with_http_info(command_id, publication_change_command_dto, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str command_id: Command identifier. (required)
        :param PublicationChangeCommandDto publication_change_command_dto: publicationChangeCommandDto (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GeneralReport, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['command_id', 'publication_change_command_dto']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method change_publication_status_using_put" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'command_id' is set
        if self.api_client.client_side_validation and ('command_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['command_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `command_id` when calling `change_publication_status_using_put`")  # noqa: E501
        # verify the required parameter 'publication_change_command_dto' is set
        if self.api_client.client_side_validation and ('publication_change_command_dto' not in local_var_params or  # noqa: E501
                                                        local_var_params['publication_change_command_dto'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `publication_change_command_dto` when calling `change_publication_status_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'command_id' in local_var_params:
            path_params['commandId'] = local_var_params['command_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'publication_change_command_dto' in local_var_params:
            body_params = local_var_params['publication_change_command_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer-token-for-user']  # noqa: E501

        return self.api_client.call_api(
            '/sale/offer-publication-commands/{commandId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GeneralReport',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_change_price_command_using_put(self, offer_id, command_id, change_price_without_output, **kwargs):  # noqa: E501
        """Modify the Buy Now price in an offer  # noqa: E501

        Use this resource to change the Buy Now price in a single offer. <a href=\"../../news/2016-08-01-zmiana-ceny/\" target=\"_blank\">Read more</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_change_price_command_using_put(offer_id, command_id, change_price_without_output, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str offer_id: The offer identifier. (required)
        :param str command_id: The unique command id generated by you. (required)
        :param ChangePriceWithoutOutput change_price_without_output: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ChangePrice
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_change_price_command_using_put_with_http_info(offer_id, command_id, change_price_without_output, **kwargs)  # noqa: E501

    def create_change_price_command_using_put_with_http_info(self, offer_id, command_id, change_price_without_output, **kwargs):  # noqa: E501
        """Modify the Buy Now price in an offer  # noqa: E501

        Use this resource to change the Buy Now price in a single offer. <a href=\"../../news/2016-08-01-zmiana-ceny/\" target=\"_blank\">Read more</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_change_price_command_using_put_with_http_info(offer_id, command_id, change_price_without_output, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str offer_id: The offer identifier. (required)
        :param str command_id: The unique command id generated by you. (required)
        :param ChangePriceWithoutOutput change_price_without_output: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ChangePrice, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['offer_id', 'command_id', 'change_price_without_output']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_change_price_command_using_put" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'offer_id' is set
        if self.api_client.client_side_validation and ('offer_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['offer_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `offer_id` when calling `create_change_price_command_using_put`")  # noqa: E501
        # verify the required parameter 'command_id' is set
        if self.api_client.client_side_validation and ('command_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['command_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `command_id` when calling `create_change_price_command_using_put`")  # noqa: E501
        # verify the required parameter 'change_price_without_output' is set
        if self.api_client.client_side_validation and ('change_price_without_output' not in local_var_params or  # noqa: E501
                                                        local_var_params['change_price_without_output'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `change_price_without_output` when calling `create_change_price_command_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'offer_id' in local_var_params:
            path_params['offerId'] = local_var_params['offer_id']  # noqa: E501
        if 'command_id' in local_var_params:
            path_params['commandId'] = local_var_params['command_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'change_price_without_output' in local_var_params:
            body_params = local_var_params['change_price_without_output']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer-token-for-user']  # noqa: E501

        return self.api_client.call_api(
            '/offers/{offerId}/change-price-commands/{commandId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ChangePrice',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_offer_using_post(self, offer, **kwargs):  # noqa: E501
        """Create a draft offer  # noqa: E501

        Use this resource to create a draft offer. <a href=\"../../sale/#step-6-draft\" target=\"_blank\">Read more</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_offer_using_post(offer, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Offer offer: offer (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Offer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_offer_using_post_with_http_info(offer, **kwargs)  # noqa: E501

    def create_offer_using_post_with_http_info(self, offer, **kwargs):  # noqa: E501
        """Create a draft offer  # noqa: E501

        Use this resource to create a draft offer. <a href=\"../../sale/#step-6-draft\" target=\"_blank\">Read more</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_offer_using_post_with_http_info(offer, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Offer offer: offer (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Offer, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['offer']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_offer_using_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'offer' is set
        if self.api_client.client_side_validation and ('offer' not in local_var_params or  # noqa: E501
                                                        local_var_params['offer'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `offer` when calling `create_offer_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'offer' in local_var_params:
            body_params = local_var_params['offer']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer-token-for-user']  # noqa: E501

        return self.api_client.call_api(
            '/sale/offers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Offer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_offer_using_delete(self, offer_id, **kwargs):  # noqa: E501
        """Delete a draft offer  # noqa: E501

        Use this resource to delete a draft offer. <a href=\"../../news/2018-10-09_draft_delete/\" target=\"_blank\">Read more</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_offer_using_delete(offer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str offer_id: Offer identifier. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_offer_using_delete_with_http_info(offer_id, **kwargs)  # noqa: E501

    def delete_offer_using_delete_with_http_info(self, offer_id, **kwargs):  # noqa: E501
        """Delete a draft offer  # noqa: E501

        Use this resource to delete a draft offer. <a href=\"../../news/2018-10-09_draft_delete/\" target=\"_blank\">Read more</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_offer_using_delete_with_http_info(offer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str offer_id: Offer identifier. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['offer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_offer_using_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'offer_id' is set
        if self.api_client.client_side_validation and ('offer_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['offer_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `offer_id` when calling `delete_offer_using_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'offer_id' in local_var_params:
            path_params['offerId'] = local_var_params['offer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['bearer-token-for-user']  # noqa: E501

        return self.api_client.call_api(
            '/sale/offers/{offerId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_publication_report_using_get(self, command_id, **kwargs):  # noqa: E501
        """Publish command summary  # noqa: E501

        Use this resource to retrieve information about the offer listing statuses. You will receive a summary with a number of correctly listed offers and errors. <a href=\"../../sale/#step-8-offer-publication-commands\" target=\"_blank\">Read more</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_publication_report_using_get(command_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str command_id: Command identifier. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GeneralReport
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_publication_report_using_get_with_http_info(command_id, **kwargs)  # noqa: E501

    def get_publication_report_using_get_with_http_info(self, command_id, **kwargs):  # noqa: E501
        """Publish command summary  # noqa: E501

        Use this resource to retrieve information about the offer listing statuses. You will receive a summary with a number of correctly listed offers and errors. <a href=\"../../sale/#step-8-offer-publication-commands\" target=\"_blank\">Read more</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_publication_report_using_get_with_http_info(command_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str command_id: Command identifier. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GeneralReport, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['command_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_publication_report_using_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'command_id' is set
        if self.api_client.client_side_validation and ('command_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['command_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `command_id` when calling `get_publication_report_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'command_id' in local_var_params:
            path_params['commandId'] = local_var_params['command_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer-token-for-user']  # noqa: E501

        return self.api_client.call_api(
            '/sale/offer-publication-commands/{commandId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GeneralReport',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_publication_tasks_using_get(self, command_id, **kwargs):  # noqa: E501
        """Publish command detailed report  # noqa: E501

        Use this resource to retrieve information about the offer statuses on the site (Defaults: limit = 100, offset = 0). <a href=\"../../sale/#step-8-offer-publication-commands\" target=\"_blank\">Read more</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_publication_tasks_using_get(command_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str command_id: Command identifier. (required)
        :param int limit: The limit of elements in the response.
        :param int offset: The offset of elements in the response.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TaskReport
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_publication_tasks_using_get_with_http_info(command_id, **kwargs)  # noqa: E501

    def get_publication_tasks_using_get_with_http_info(self, command_id, **kwargs):  # noqa: E501
        """Publish command detailed report  # noqa: E501

        Use this resource to retrieve information about the offer statuses on the site (Defaults: limit = 100, offset = 0). <a href=\"../../sale/#step-8-offer-publication-commands\" target=\"_blank\">Read more</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_publication_tasks_using_get_with_http_info(command_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str command_id: Command identifier. (required)
        :param int limit: The limit of elements in the response.
        :param int offset: The offset of elements in the response.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TaskReport, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['command_id', 'limit', 'offset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_publication_tasks_using_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'command_id' is set
        if self.api_client.client_side_validation and ('command_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['command_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `command_id` when calling `get_publication_tasks_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'command_id' in local_var_params:
            path_params['commandId'] = local_var_params['command_id']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer-token-for-user']  # noqa: E501

        return self.api_client.call_api(
            '/sale/offer-publication-commands/{commandId}/tasks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaskReport',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_offer_using_put(self, offer_id, offer, **kwargs):  # noqa: E501
        """Complete a draft offer or edit an offer  # noqa: E501

        Use this resource to complete a draft offer or edit ongoing offers. <a href=\"../../sale/#step-7-complete\" target=\"_blank\">Read more</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_offer_using_put(offer_id, offer, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str offer_id: Offer identifier. (required)
        :param Offer offer: offer (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Offer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_offer_using_put_with_http_info(offer_id, offer, **kwargs)  # noqa: E501

    def update_offer_using_put_with_http_info(self, offer_id, offer, **kwargs):  # noqa: E501
        """Complete a draft offer or edit an offer  # noqa: E501

        Use this resource to complete a draft offer or edit ongoing offers. <a href=\"../../sale/#step-7-complete\" target=\"_blank\">Read more</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_offer_using_put_with_http_info(offer_id, offer, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str offer_id: Offer identifier. (required)
        :param Offer offer: offer (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Offer, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['offer_id', 'offer']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_offer_using_put" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'offer_id' is set
        if self.api_client.client_side_validation and ('offer_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['offer_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `offer_id` when calling `update_offer_using_put`")  # noqa: E501
        # verify the required parameter 'offer' is set
        if self.api_client.client_side_validation and ('offer' not in local_var_params or  # noqa: E501
                                                        local_var_params['offer'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `offer` when calling `update_offer_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'offer_id' in local_var_params:
            path_params['offerId'] = local_var_params['offer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'offer' in local_var_params:
            body_params = local_var_params['offer']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer-token-for-user']  # noqa: E501

        return self.api_client.call_api(
            '/sale/offers/{offerId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Offer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
