# coding: utf-8

"""
    Allegro REST API

    https://developer.allegro.pl/about  # noqa: E501

    The version of the OpenAPI document: 2020.03.12
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from allegro_api.api_client import ApiClient
from allegro_api.exceptions import (
    ApiTypeError,
    ApiValueError
)


class ImagesAndAttachmentsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_offer_attachment_using_post(self, offer_attachment_request, **kwargs):  # noqa: E501
        """Create an offer attachment  # noqa: E501

        You can attach PDF files to your offers. We will present them under the offer description in the Additional information section. You can attach up to 7 files to one offer – one per each type from the list:   * \\- Guide (MANUAL)   * \\- Special offer terms (SPECIAL_OFFER_RULES)   * \\- Competition terms (COMPETITION_RULES)   * \\- Book excerpt (BOOK_EXCERPT)   * \\- Manual (USER_MANUAL)   * \\- Installation manual (INSTALLATION_INSTRUCTIONS)   * \\- Game manual (GAME_INSTRUCTIONS)  Uploading attachments flow:   1. Create an attachment object to receive an upload URL (*POST /sale/offer-attachments*),   2. Use the upload URL to submit the PDF file (*PUT /sale/offer-attachments/{attachmentId}*),   3. Add attachments to the offer (*PUT /sale/offers/{offerId}*).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_offer_attachment_using_post(offer_attachment_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param OfferAttachmentRequest offer_attachment_request: offer attachment (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OfferAttachment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_offer_attachment_using_post_with_http_info(offer_attachment_request, **kwargs)  # noqa: E501

    def create_offer_attachment_using_post_with_http_info(self, offer_attachment_request, **kwargs):  # noqa: E501
        """Create an offer attachment  # noqa: E501

        You can attach PDF files to your offers. We will present them under the offer description in the Additional information section. You can attach up to 7 files to one offer – one per each type from the list:   * \\- Guide (MANUAL)   * \\- Special offer terms (SPECIAL_OFFER_RULES)   * \\- Competition terms (COMPETITION_RULES)   * \\- Book excerpt (BOOK_EXCERPT)   * \\- Manual (USER_MANUAL)   * \\- Installation manual (INSTALLATION_INSTRUCTIONS)   * \\- Game manual (GAME_INSTRUCTIONS)  Uploading attachments flow:   1. Create an attachment object to receive an upload URL (*POST /sale/offer-attachments*),   2. Use the upload URL to submit the PDF file (*PUT /sale/offer-attachments/{attachmentId}*),   3. Add attachments to the offer (*PUT /sale/offers/{offerId}*).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_offer_attachment_using_post_with_http_info(offer_attachment_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param OfferAttachmentRequest offer_attachment_request: offer attachment (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OfferAttachment, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['offer_attachment_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_offer_attachment_using_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'offer_attachment_request' is set
        if self.api_client.client_side_validation and ('offer_attachment_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['offer_attachment_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `offer_attachment_request` when calling `create_offer_attachment_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'offer_attachment_request' in local_var_params:
            body_params = local_var_params['offer_attachment_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer-token-for-user']  # noqa: E501

        return self.api_client.call_api(
            '/sale/offer-attachments', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OfferAttachment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upload_offer_attachment_using_put(self, attachment_id, **kwargs):  # noqa: E501
        """Upload an offer attachment  # noqa: E501

        Upload an offer attachment. This operation should be used after creating an offer attachment with *POST /sale/offer-attachments* **Important!** You can find the URL address to upload the file to our server in the *Location* response header of *POST /sale/offer-attachments*. The URL is unique and one-time. As its format may change in time, you should always use the address from the header. Do not compose the address on your own.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_offer_attachment_using_put(attachment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str attachment_id: The ID of the attachment. (required)
        :param file body:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.upload_offer_attachment_using_put_with_http_info(attachment_id, **kwargs)  # noqa: E501

    def upload_offer_attachment_using_put_with_http_info(self, attachment_id, **kwargs):  # noqa: E501
        """Upload an offer attachment  # noqa: E501

        Upload an offer attachment. This operation should be used after creating an offer attachment with *POST /sale/offer-attachments* **Important!** You can find the URL address to upload the file to our server in the *Location* response header of *POST /sale/offer-attachments*. The URL is unique and one-time. As its format may change in time, you should always use the address from the header. Do not compose the address on your own.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_offer_attachment_using_put_with_http_info(attachment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str attachment_id: The ID of the attachment. (required)
        :param file body:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_hosts = ['https://upload.{environment}']  # noqa: E501
        local_var_host = local_var_hosts[0]
        if kwargs.get('_host_index'):
            if int(kwags.get('_host_index')) < 0 or int(kawgs.get('_host_index')) >= len(local_var_hosts):
                raise ApiValueError("Invalid host index. Must be 0 <= index < %s" % len(local_var_host))
            local_var_host = local_var_hosts[int(kwargs.get('_host_index'))]
        local_var_params = locals()

        all_params = ['attachment_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params and key != "_host_index":
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_offer_attachment_using_put" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'attachment_id' is set
        if self.api_client.client_side_validation and ('attachment_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['attachment_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `attachment_id` when calling `upload_offer_attachment_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'attachment_id' in local_var_params:
            path_params['attachmentId'] = local_var_params['attachment_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/pdf'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer-token-for-user']  # noqa: E501

        return self.api_client.call_api(
            '/sale/offer-attachments/{attachmentId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            _host=local_var_host,
            collection_formats=collection_formats)

    def upload_offer_image_using_post(self, offer_image_link_upload_request, **kwargs):  # noqa: E501
        """Upload an offer image  # noqa: E501

        Upload image to our servers. You can choose from two upload options:   * \\- provide a link and we will download an image for you   * \\- send an image as binary data  **Important!** Remember to use dedicated domain for upload, i.e.   * \\- https://upload.allegro.pl for Production   * \\- https://upload.allegro.pl.allegrosandbox.pl for Sandbox  More information about rules for photos in an offer's gallery and description you will find <a href=\"https://allegro.pl/dla-sprzedajacych/nowe-zasady-dla-zdjec-w-galerii-i-w-opisie-YLlAAa2oXf7\" target=\"_blank\">here</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_offer_image_using_post(offer_image_link_upload_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param OfferImageLinkUploadRequest offer_image_link_upload_request: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OfferImageUploadResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.upload_offer_image_using_post_with_http_info(offer_image_link_upload_request, **kwargs)  # noqa: E501

    def upload_offer_image_using_post_with_http_info(self, offer_image_link_upload_request, **kwargs):  # noqa: E501
        """Upload an offer image  # noqa: E501

        Upload image to our servers. You can choose from two upload options:   * \\- provide a link and we will download an image for you   * \\- send an image as binary data  **Important!** Remember to use dedicated domain for upload, i.e.   * \\- https://upload.allegro.pl for Production   * \\- https://upload.allegro.pl.allegrosandbox.pl for Sandbox  More information about rules for photos in an offer's gallery and description you will find <a href=\"https://allegro.pl/dla-sprzedajacych/nowe-zasady-dla-zdjec-w-galerii-i-w-opisie-YLlAAa2oXf7\" target=\"_blank\">here</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_offer_image_using_post_with_http_info(offer_image_link_upload_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param OfferImageLinkUploadRequest offer_image_link_upload_request: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OfferImageUploadResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_hosts = ['https://upload.{environment}']  # noqa: E501
        local_var_host = local_var_hosts[0]
        if kwargs.get('_host_index'):
            if int(kwags.get('_host_index')) < 0 or int(kawgs.get('_host_index')) >= len(local_var_hosts):
                raise ApiValueError("Invalid host index. Must be 0 <= index < %s" % len(local_var_host))
            local_var_host = local_var_hosts[int(kwargs.get('_host_index'))]
        local_var_params = locals()

        all_params = ['offer_image_link_upload_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params and key != "_host_index":
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_offer_image_using_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'offer_image_link_upload_request' is set
        if self.api_client.client_side_validation and ('offer_image_link_upload_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['offer_image_link_upload_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `offer_image_link_upload_request` when calling `upload_offer_image_using_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'offer_image_link_upload_request' in local_var_params:
            body_params = local_var_params['offer_image_link_upload_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/vnd.allegro.public.v1+json', 'image/jpeg', 'image/png'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer-token-for-user']  # noqa: E501

        return self.api_client.call_api(
            '/sale/images', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OfferImageUploadResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            _host=local_var_host,
            collection_formats=collection_formats)
