# coding: utf-8

"""
    Allegro REST API

    https://developer.allegro.pl/about  # noqa: E501

    The version of the OpenAPI document: 2020.03.12
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from allegro_api.api_client import ApiClient
from allegro_api.exceptions import (
    ApiTypeError,
    ApiValueError
)


class ClassifiedsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def assign_classified_packages_using_put(self, offer_id, classified_packages, **kwargs):  # noqa: E501
        """Assign packages to a classified  # noqa: E501

        Use this resource to assign classified packages to an offer.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assign_classified_packages_using_put(offer_id, classified_packages, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str offer_id: The offer ID. (required)
        :param ClassifiedPackages classified_packages: Packages that should be assigned to the classified. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.assign_classified_packages_using_put_with_http_info(offer_id, classified_packages, **kwargs)  # noqa: E501

    def assign_classified_packages_using_put_with_http_info(self, offer_id, classified_packages, **kwargs):  # noqa: E501
        """Assign packages to a classified  # noqa: E501

        Use this resource to assign classified packages to an offer.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assign_classified_packages_using_put_with_http_info(offer_id, classified_packages, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str offer_id: The offer ID. (required)
        :param ClassifiedPackages classified_packages: Packages that should be assigned to the classified. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['offer_id', 'classified_packages']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method assign_classified_packages_using_put" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'offer_id' is set
        if self.api_client.client_side_validation and ('offer_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['offer_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `offer_id` when calling `assign_classified_packages_using_put`")  # noqa: E501
        # verify the required parameter 'classified_packages' is set
        if self.api_client.client_side_validation and ('classified_packages' not in local_var_params or  # noqa: E501
                                                        local_var_params['classified_packages'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `classified_packages` when calling `assign_classified_packages_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'offer_id' in local_var_params:
            path_params['offerId'] = local_var_params['offer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'classified_packages' in local_var_params:
            body_params = local_var_params['classified_packages']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer-token-for-user']  # noqa: E501

        return self.api_client.call_api(
            '/sale/offer-classifieds-packages/{offerId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_classified_package_configuration_using_get(self, package_id, **kwargs):  # noqa: E501
        """Get the configuration of a package  # noqa: E501

        Use this resource to retrieve the configuration of a classifieds package.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_classified_package_configuration_using_get(package_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str package_id: The classifieds package ID. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ClassifiedPackageConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_classified_package_configuration_using_get_with_http_info(package_id, **kwargs)  # noqa: E501

    def get_classified_package_configuration_using_get_with_http_info(self, package_id, **kwargs):  # noqa: E501
        """Get the configuration of a package  # noqa: E501

        Use this resource to retrieve the configuration of a classifieds package.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_classified_package_configuration_using_get_with_http_info(package_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str package_id: The classifieds package ID. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ClassifiedPackageConfig, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['package_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_classified_package_configuration_using_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'package_id' is set
        if self.api_client.client_side_validation and ('package_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['package_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `package_id` when calling `get_classified_package_configuration_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'package_id' in local_var_params:
            path_params['packageId'] = local_var_params['package_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer-token-for-user']  # noqa: E501

        return self.api_client.call_api(
            '/sale/classifieds-packages/{packageId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ClassifiedPackageConfig',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_classified_package_configurations_for_category_using_get(self, category_id, **kwargs):  # noqa: E501
        """Get configurations of packages  # noqa: E501

        Use this resource to retrieve configurations of classifieds packages for a category.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_classified_package_configurations_for_category_using_get(category_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str category_id: The category ID. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ClassifiedPackageConfigs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_classified_package_configurations_for_category_using_get_with_http_info(category_id, **kwargs)  # noqa: E501

    def get_classified_package_configurations_for_category_using_get_with_http_info(self, category_id, **kwargs):  # noqa: E501
        """Get configurations of packages  # noqa: E501

        Use this resource to retrieve configurations of classifieds packages for a category.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_classified_package_configurations_for_category_using_get_with_http_info(category_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str category_id: The category ID. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ClassifiedPackageConfigs, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['category_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_classified_package_configurations_for_category_using_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'category_id' is set
        if self.api_client.client_side_validation and ('category_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['category_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `category_id` when calling `get_classified_package_configurations_for_category_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'category_id' in local_var_params and local_var_params['category_id'] is not None:  # noqa: E501
            query_params.append(('category.id', local_var_params['category_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer-token-for-user']  # noqa: E501

        return self.api_client.call_api(
            '/sale/classifieds-packages', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ClassifiedPackageConfigs',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_classified_packages_using_get(self, offer_id, **kwargs):  # noqa: E501
        """Get classified packages assigned to an offer  # noqa: E501

        Use this resource to retrieve classified packages currently assigned to an offer.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_classified_packages_using_get(offer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str offer_id: Offer ID. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ClassifiedResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_classified_packages_using_get_with_http_info(offer_id, **kwargs)  # noqa: E501

    def get_classified_packages_using_get_with_http_info(self, offer_id, **kwargs):  # noqa: E501
        """Get classified packages assigned to an offer  # noqa: E501

        Use this resource to retrieve classified packages currently assigned to an offer.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_classified_packages_using_get_with_http_info(offer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str offer_id: Offer ID. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ClassifiedResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['offer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_classified_packages_using_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'offer_id' is set
        if self.api_client.client_side_validation and ('offer_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['offer_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `offer_id` when calling `get_classified_packages_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'offer_id' in local_var_params:
            path_params['offerId'] = local_var_params['offer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer-token-for-user']  # noqa: E501

        return self.api_client.call_api(
            '/sale/offer-classifieds-packages/{offerId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ClassifiedResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
