# coding: utf-8

"""
    Allegro REST API

    https://developer.allegro.pl/about  # noqa: E501

    The version of the OpenAPI document: 2020.03.12
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from allegro_api.api_client import ApiClient
from allegro_api.exceptions import (
    ApiTypeError,
    ApiValueError
)


class CategoriesAndParametersApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_categories_using_get(self, **kwargs):  # noqa: E501
        """Get IDs of Allegro categories  # noqa: E501

        Use this resource to traverse the Allegro categories tree. It returns the list of the given category's children or a list of the main Allegro categories. <a href=\"../../sale/#categories\" target=\"_blank\">Read more</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_categories_using_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str parent_id: The ID of the category which children should be returned. If omitted, the list of main Allegro categories will be returned.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CategoriesDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_categories_using_get_with_http_info(**kwargs)  # noqa: E501

    def get_categories_using_get_with_http_info(self, **kwargs):  # noqa: E501
        """Get IDs of Allegro categories  # noqa: E501

        Use this resource to traverse the Allegro categories tree. It returns the list of the given category's children or a list of the main Allegro categories. <a href=\"../../sale/#categories\" target=\"_blank\">Read more</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_categories_using_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str parent_id: The ID of the category which children should be returned. If omitted, the list of main Allegro categories will be returned.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CategoriesDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['parent_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_categories_using_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'parent_id' in local_var_params and local_var_params['parent_id'] is not None:  # noqa: E501
            query_params.append(('parent.id', local_var_params['parent_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer-token-for-application', 'bearer-token-for-user']  # noqa: E501

        return self.api_client.call_api(
            '/sale/categories', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CategoriesDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_category_using_get1(self, category_id, **kwargs):  # noqa: E501
        """Get a category by ID  # noqa: E501

        Use this resource to get the details of a specific category. <a href=\"../../news/2018-07-09-wielowariantowosc/#01\" target=\"_blank\">Read more</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_category_using_get1(category_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str category_id: The category ID. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CategoryDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_category_using_get1_with_http_info(category_id, **kwargs)  # noqa: E501

    def get_category_using_get1_with_http_info(self, category_id, **kwargs):  # noqa: E501
        """Get a category by ID  # noqa: E501

        Use this resource to get the details of a specific category. <a href=\"../../news/2018-07-09-wielowariantowosc/#01\" target=\"_blank\">Read more</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_category_using_get1_with_http_info(category_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str category_id: The category ID. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CategoryDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['category_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_category_using_get1" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'category_id' is set
        if self.api_client.client_side_validation and ('category_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['category_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `category_id` when calling `get_category_using_get1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'category_id' in local_var_params:
            path_params['categoryId'] = local_var_params['category_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer-token-for-application', 'bearer-token-for-user']  # noqa: E501

        return self.api_client.call_api(
            '/sale/categories/{categoryId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CategoryDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_flat_parameters_using_get2(self, category_id, **kwargs):  # noqa: E501
        """Get parameters supported by a category  # noqa: E501

        Use this resource to get the list of parameters that are supported by the given category. <a href=\"../../sale/#parameters\" target=\"_blank\">Read more</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_flat_parameters_using_get2(category_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str category_id: The category ID. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CategoryParameterList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_flat_parameters_using_get2_with_http_info(category_id, **kwargs)  # noqa: E501

    def get_flat_parameters_using_get2_with_http_info(self, category_id, **kwargs):  # noqa: E501
        """Get parameters supported by a category  # noqa: E501

        Use this resource to get the list of parameters that are supported by the given category. <a href=\"../../sale/#parameters\" target=\"_blank\">Read more</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_flat_parameters_using_get2_with_http_info(category_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str category_id: The category ID. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CategoryParameterList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['category_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flat_parameters_using_get2" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'category_id' is set
        if self.api_client.client_side_validation and ('category_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['category_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `category_id` when calling `get_flat_parameters_using_get2`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'category_id' in local_var_params:
            path_params['categoryId'] = local_var_params['category_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer-token-for-application', 'bearer-token-for-user']  # noqa: E501

        return self.api_client.call_api(
            '/sale/categories/{categoryId}/parameters', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CategoryParameterList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
