# coding: utf-8

"""
    Allegro REST API

    https://developer.allegro.pl/about  # noqa: E501

    The version of the OpenAPI document: 2020.03.12
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from allegro_api.api_client import ApiClient
from allegro_api.exceptions import (
    ApiTypeError,
    ApiValueError
)


class BatchOfferModificationApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_general_report_using_get(self, command_id, **kwargs):  # noqa: E501
        """Modification command summary  # noqa: E501

        Use this resource to find out how many offers were edited within one {commandId}. You will receive a summary with a number of successfully edited offers. <a href=\"../../news/2018-04-19-news_grupowa_edycja_ofert_update/#2\" target=\"_blank\">Read more</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_general_report_using_get(command_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str command_id: Command identifier. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GeneralReport
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_general_report_using_get_with_http_info(command_id, **kwargs)  # noqa: E501

    def get_general_report_using_get_with_http_info(self, command_id, **kwargs):  # noqa: E501
        """Modification command summary  # noqa: E501

        Use this resource to find out how many offers were edited within one {commandId}. You will receive a summary with a number of successfully edited offers. <a href=\"../../news/2018-04-19-news_grupowa_edycja_ofert_update/#2\" target=\"_blank\">Read more</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_general_report_using_get_with_http_info(command_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str command_id: Command identifier. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GeneralReport, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['command_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_general_report_using_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'command_id' is set
        if self.api_client.client_side_validation and ('command_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['command_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `command_id` when calling `get_general_report_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'command_id' in local_var_params:
            path_params['commandId'] = local_var_params['command_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer-token-for-user']  # noqa: E501

        return self.api_client.call_api(
            '/sale/offer-modification-commands/{commandId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GeneralReport',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_price_modification_command_status_using_get(self, command_id, **kwargs):  # noqa: E501
        """Change price command summary  # noqa: E501

        Returns status and summary of particular command execution.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_price_modification_command_status_using_get(command_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str command_id: Command identifier. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GeneralReport
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_price_modification_command_status_using_get_with_http_info(command_id, **kwargs)  # noqa: E501

    def get_price_modification_command_status_using_get_with_http_info(self, command_id, **kwargs):  # noqa: E501
        """Change price command summary  # noqa: E501

        Returns status and summary of particular command execution.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_price_modification_command_status_using_get_with_http_info(command_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str command_id: Command identifier. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GeneralReport, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['command_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_price_modification_command_status_using_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'command_id' is set
        if self.api_client.client_side_validation and ('command_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['command_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `command_id` when calling `get_price_modification_command_status_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'command_id' in local_var_params:
            path_params['commandId'] = local_var_params['command_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer-token-for-user']  # noqa: E501

        return self.api_client.call_api(
            '/sale/offer-price-change-commands/{commandId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GeneralReport',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_price_modification_command_tasks_statuses_using_get(self, command_id, **kwargs):  # noqa: E501
        """Change price command detailed report  # noqa: E501

        Defaults: limit = 100, offset = 0.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_price_modification_command_tasks_statuses_using_get(command_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str command_id: Command identifier. (required)
        :param int limit: The limit of elements in the response.
        :param int offset: The offset of elements in the response.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TaskReport
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_price_modification_command_tasks_statuses_using_get_with_http_info(command_id, **kwargs)  # noqa: E501

    def get_price_modification_command_tasks_statuses_using_get_with_http_info(self, command_id, **kwargs):  # noqa: E501
        """Change price command detailed report  # noqa: E501

        Defaults: limit = 100, offset = 0.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_price_modification_command_tasks_statuses_using_get_with_http_info(command_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str command_id: Command identifier. (required)
        :param int limit: The limit of elements in the response.
        :param int offset: The offset of elements in the response.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TaskReport, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['command_id', 'limit', 'offset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_price_modification_command_tasks_statuses_using_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'command_id' is set
        if self.api_client.client_side_validation and ('command_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['command_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `command_id` when calling `get_price_modification_command_tasks_statuses_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'command_id' in local_var_params:
            path_params['commandId'] = local_var_params['command_id']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer-token-for-user']  # noqa: E501

        return self.api_client.call_api(
            '/sale/offer-price-change-commands/{commandId}/tasks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaskReport',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_quantity_modification_command_status_using_get(self, command_id, **kwargs):  # noqa: E501
        """Change quantity command summary  # noqa: E501

        Returns status and summary of the command.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_quantity_modification_command_status_using_get(command_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str command_id: Command identifier. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GeneralReport
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_quantity_modification_command_status_using_get_with_http_info(command_id, **kwargs)  # noqa: E501

    def get_quantity_modification_command_status_using_get_with_http_info(self, command_id, **kwargs):  # noqa: E501
        """Change quantity command summary  # noqa: E501

        Returns status and summary of the command.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_quantity_modification_command_status_using_get_with_http_info(command_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str command_id: Command identifier. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GeneralReport, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['command_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_quantity_modification_command_status_using_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'command_id' is set
        if self.api_client.client_side_validation and ('command_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['command_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `command_id` when calling `get_quantity_modification_command_status_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'command_id' in local_var_params:
            path_params['commandId'] = local_var_params['command_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer-token-for-user']  # noqa: E501

        return self.api_client.call_api(
            '/sale/offer-quantity-change-commands/{commandId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GeneralReport',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_quantity_modification_command_tasks_statuses_using_get(self, command_id, **kwargs):  # noqa: E501
        """Change quantity command detailed report  # noqa: E501

        Defaults: limit = 100, offset = 0.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_quantity_modification_command_tasks_statuses_using_get(command_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str command_id: Command identifier. (required)
        :param int limit: The limit of elements in the response.
        :param int offset: The offset of elements in the response.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TaskReport
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_quantity_modification_command_tasks_statuses_using_get_with_http_info(command_id, **kwargs)  # noqa: E501

    def get_quantity_modification_command_tasks_statuses_using_get_with_http_info(self, command_id, **kwargs):  # noqa: E501
        """Change quantity command detailed report  # noqa: E501

        Defaults: limit = 100, offset = 0.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_quantity_modification_command_tasks_statuses_using_get_with_http_info(command_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str command_id: Command identifier. (required)
        :param int limit: The limit of elements in the response.
        :param int offset: The offset of elements in the response.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TaskReport, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['command_id', 'limit', 'offset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_quantity_modification_command_tasks_statuses_using_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'command_id' is set
        if self.api_client.client_side_validation and ('command_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['command_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `command_id` when calling `get_quantity_modification_command_tasks_statuses_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'command_id' in local_var_params:
            path_params['commandId'] = local_var_params['command_id']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer-token-for-user']  # noqa: E501

        return self.api_client.call_api(
            '/sale/offer-quantity-change-commands/{commandId}/tasks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaskReport',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tasks_using_get(self, command_id, **kwargs):  # noqa: E501
        """Modification command detailed report  # noqa: E501

        Use this resource to retrieve a detailed summary of changes introduced within one {commandId} (defaults: limit = 100, offset = 0). <a href=\"../../news/2018-04-19-news_grupowa_edycja_ofert_update/#2\" target=\"_blank\">Read more</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tasks_using_get(command_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str command_id: Command identifier. (required)
        :param int limit: The limit of elements in the response.
        :param int offset: The offset of elements in the response.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TaskReport
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_tasks_using_get_with_http_info(command_id, **kwargs)  # noqa: E501

    def get_tasks_using_get_with_http_info(self, command_id, **kwargs):  # noqa: E501
        """Modification command detailed report  # noqa: E501

        Use this resource to retrieve a detailed summary of changes introduced within one {commandId} (defaults: limit = 100, offset = 0). <a href=\"../../news/2018-04-19-news_grupowa_edycja_ofert_update/#2\" target=\"_blank\">Read more</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tasks_using_get_with_http_info(command_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str command_id: Command identifier. (required)
        :param int limit: The limit of elements in the response.
        :param int offset: The offset of elements in the response.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TaskReport, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['command_id', 'limit', 'offset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tasks_using_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'command_id' is set
        if self.api_client.client_side_validation and ('command_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['command_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `command_id` when calling `get_tasks_using_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'command_id' in local_var_params:
            path_params['commandId'] = local_var_params['command_id']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer-token-for-user']  # noqa: E501

        return self.api_client.call_api(
            '/sale/offer-modification-commands/{commandId}/tasks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaskReport',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def modification_command_using_put(self, command_id, offer_change_command, **kwargs):  # noqa: E501
        """Batch offer modification  # noqa: E501

        Use this resource to modify multiple offers at once. <a href=\"../../news/2018-04-19-news_grupowa_edycja_ofert_update/#1\" target=\"_blank\">Read more</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modification_command_using_put(command_id, offer_change_command, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str command_id: Command identifier. (required)
        :param OfferChangeCommand offer_change_command: offerChangeCommandDto (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GeneralReport
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.modification_command_using_put_with_http_info(command_id, offer_change_command, **kwargs)  # noqa: E501

    def modification_command_using_put_with_http_info(self, command_id, offer_change_command, **kwargs):  # noqa: E501
        """Batch offer modification  # noqa: E501

        Use this resource to modify multiple offers at once. <a href=\"../../news/2018-04-19-news_grupowa_edycja_ofert_update/#1\" target=\"_blank\">Read more</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modification_command_using_put_with_http_info(command_id, offer_change_command, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str command_id: Command identifier. (required)
        :param OfferChangeCommand offer_change_command: offerChangeCommandDto (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GeneralReport, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['command_id', 'offer_change_command']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method modification_command_using_put" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'command_id' is set
        if self.api_client.client_side_validation and ('command_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['command_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `command_id` when calling `modification_command_using_put`")  # noqa: E501
        # verify the required parameter 'offer_change_command' is set
        if self.api_client.client_side_validation and ('offer_change_command' not in local_var_params or  # noqa: E501
                                                        local_var_params['offer_change_command'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `offer_change_command` when calling `modification_command_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'command_id' in local_var_params:
            path_params['commandId'] = local_var_params['command_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'offer_change_command' in local_var_params:
            body_params = local_var_params['offer_change_command']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer-token-for-user']  # noqa: E501

        return self.api_client.call_api(
            '/sale/offer-modification-commands/{commandId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GeneralReport',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def price_modification_command_using_put(self, command_id, offer_price_change_command, **kwargs):  # noqa: E501
        """Batch offer price modification  # noqa: E501

        Change price of offers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.price_modification_command_using_put(command_id, offer_price_change_command, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str command_id: Command identifier. (required)
        :param OfferPriceChangeCommand offer_price_change_command: offerPriceChangeCommandDto (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GeneralReport
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.price_modification_command_using_put_with_http_info(command_id, offer_price_change_command, **kwargs)  # noqa: E501

    def price_modification_command_using_put_with_http_info(self, command_id, offer_price_change_command, **kwargs):  # noqa: E501
        """Batch offer price modification  # noqa: E501

        Change price of offers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.price_modification_command_using_put_with_http_info(command_id, offer_price_change_command, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str command_id: Command identifier. (required)
        :param OfferPriceChangeCommand offer_price_change_command: offerPriceChangeCommandDto (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GeneralReport, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['command_id', 'offer_price_change_command']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method price_modification_command_using_put" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'command_id' is set
        if self.api_client.client_side_validation and ('command_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['command_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `command_id` when calling `price_modification_command_using_put`")  # noqa: E501
        # verify the required parameter 'offer_price_change_command' is set
        if self.api_client.client_side_validation and ('offer_price_change_command' not in local_var_params or  # noqa: E501
                                                        local_var_params['offer_price_change_command'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `offer_price_change_command` when calling `price_modification_command_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'command_id' in local_var_params:
            path_params['commandId'] = local_var_params['command_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'offer_price_change_command' in local_var_params:
            body_params = local_var_params['offer_price_change_command']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer-token-for-user']  # noqa: E501

        return self.api_client.call_api(
            '/sale/offer-price-change-commands/{commandId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GeneralReport',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def quantity_modification_command_using_put(self, command_id, offer_quantity_change_command, **kwargs):  # noqa: E501
        """Batch offer quantity modification  # noqa: E501

        Change quantity of multiple offers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.quantity_modification_command_using_put(command_id, offer_quantity_change_command, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str command_id: Command identifier. (required)
        :param OfferQuantityChangeCommand offer_quantity_change_command: offerQuantityChangeCommandDto (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GeneralReport
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.quantity_modification_command_using_put_with_http_info(command_id, offer_quantity_change_command, **kwargs)  # noqa: E501

    def quantity_modification_command_using_put_with_http_info(self, command_id, offer_quantity_change_command, **kwargs):  # noqa: E501
        """Batch offer quantity modification  # noqa: E501

        Change quantity of multiple offers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.quantity_modification_command_using_put_with_http_info(command_id, offer_quantity_change_command, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str command_id: Command identifier. (required)
        :param OfferQuantityChangeCommand offer_quantity_change_command: offerQuantityChangeCommandDto (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GeneralReport, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['command_id', 'offer_quantity_change_command']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method quantity_modification_command_using_put" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'command_id' is set
        if self.api_client.client_side_validation and ('command_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['command_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `command_id` when calling `quantity_modification_command_using_put`")  # noqa: E501
        # verify the required parameter 'offer_quantity_change_command' is set
        if self.api_client.client_side_validation and ('offer_quantity_change_command' not in local_var_params or  # noqa: E501
                                                        local_var_params['offer_quantity_change_command'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `offer_quantity_change_command` when calling `quantity_modification_command_using_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'command_id' in local_var_params:
            path_params['commandId'] = local_var_params['command_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'offer_quantity_change_command' in local_var_params:
            body_params = local_var_params['offer_quantity_change_command']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/vnd.allegro.public.v1+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer-token-for-user']  # noqa: E501

        return self.api_client.call_api(
            '/sale/offer-quantity-change-commands/{commandId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GeneralReport',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
