# allegro-pl-rest-api
https://developer.allegro.pl/about

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 2020.03.12
- Package version: 2020.03.12
- Build date: 2020-03-12T10:42:07.824938+01:00[Europe/Berlin]
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://github.com/allegro/allegro-api/issues](https://github.com/allegro/allegro-api/issues)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import allegro_api
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import allegro_api
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import allegro_api
from allegro_api.rest import ApiException
from pprint import pprint

configuration = allegro_api.Configuration()
# Configure OAuth2 access token for authorization: bearer-token-for-user
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# Defining host is optional and default to https://api.allegro.pl
configuration.host = "https://api.allegro.pl"
# Enter a context with an instance of the API client
with allegro_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = allegro_api.AdditionalServicesApi(api_client)
    additional_services_group_request = allegro_api.AdditionalServicesGroupRequest() # AdditionalServicesGroupRequest | Additional service group body

    try:
        # Create additional services group
        api_response = api_instance.create_additional_services_group_using_post(additional_services_group_request)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AdditionalServicesApi->create_additional_services_group_using_post: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *https://api.allegro.pl*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AdditionalServicesApi* | [**create_additional_services_group_using_post**](docs/AdditionalServicesApi.md#create_additional_services_group_using_post) | **POST** /sale/offer-additional-services/groups | Create additional services group
*AdditionalServicesApi* | [**get_additional_services_group_using_get**](docs/AdditionalServicesApi.md#get_additional_services_group_using_get) | **GET** /sale/offer-additional-services/groups/{groupId} | Get the details of an additional services group
*AdditionalServicesApi* | [**get_list_of_additional_services_definitions_using_get**](docs/AdditionalServicesApi.md#get_list_of_additional_services_definitions_using_get) | **GET** /sale/offer-additional-services/definitions | Get the user&#39;s additional services definitions
*AdditionalServicesApi* | [**get_list_of_additional_services_groups_using_get**](docs/AdditionalServicesApi.md#get_list_of_additional_services_groups_using_get) | **GET** /sale/offer-additional-services/groups | Get the user&#39;s additional services groups
*AdditionalServicesApi* | [**modify_additional_services_group_using_put**](docs/AdditionalServicesApi.md#modify_additional_services_group_using_put) | **PUT** /sale/offer-additional-services/groups/{groupId} | Modify an additional services group
*AfterSaleServicesApi* | [**get_public_seller_listing_using_get**](docs/AfterSaleServicesApi.md#get_public_seller_listing_using_get) | **GET** /after-sales-service-conditions/implied-warranties | Get the user&#39;s implied warranties
*AfterSaleServicesApi* | [**get_public_seller_listing_using_get1**](docs/AfterSaleServicesApi.md#get_public_seller_listing_using_get1) | **GET** /after-sales-service-conditions/return-policies | Get the user&#39;s return policies
*AfterSaleServicesApi* | [**get_public_seller_listing_using_get2**](docs/AfterSaleServicesApi.md#get_public_seller_listing_using_get2) | **GET** /after-sales-service-conditions/warranties | Get the user&#39;s warranties
*AuctionsAndBiddingApi* | [**get_bid**](docs/AuctionsAndBiddingApi.md#get_bid) | **GET** /bidding/offers/{offerId}/bid | Get current user&#39;s bid information
*AuctionsAndBiddingApi* | [**place_bid**](docs/AuctionsAndBiddingApi.md#place_bid) | **PUT** /bidding/offers/{offerId}/bid | Place a bid in an auction
*BadgeCampaignsApi* | [**badge_applications_get_all**](docs/BadgeCampaignsApi.md#badge_applications_get_all) | **GET** /sale/badge-applications | [BETA] Get a list of badge applications
*BadgeCampaignsApi* | [**badge_applications_get_one**](docs/BadgeCampaignsApi.md#badge_applications_get_one) | **GET** /sale/badge-applications/{applicationId} | [BETA] Get a badge application details
*BadgeCampaignsApi* | [**badge_campaigns_get_all**](docs/BadgeCampaignsApi.md#badge_campaigns_get_all) | **GET** /sale/badge-campaigns | [BETA] Get a list of available badge campaigns
*BadgeCampaignsApi* | [**get_badges**](docs/BadgeCampaignsApi.md#get_badges) | **GET** /sale/badges | [BETA] Get a list of badges
*BadgeCampaignsApi* | [**post_badges**](docs/BadgeCampaignsApi.md#post_badges) | **POST** /sale/badges | [BETA] Apply for badge in selected offer
*BatchOfferModificationApi* | [**get_general_report_using_get**](docs/BatchOfferModificationApi.md#get_general_report_using_get) | **GET** /sale/offer-modification-commands/{commandId} | Modification command summary
*BatchOfferModificationApi* | [**get_price_modification_command_status_using_get**](docs/BatchOfferModificationApi.md#get_price_modification_command_status_using_get) | **GET** /sale/offer-price-change-commands/{commandId} | Change price command summary
*BatchOfferModificationApi* | [**get_price_modification_command_tasks_statuses_using_get**](docs/BatchOfferModificationApi.md#get_price_modification_command_tasks_statuses_using_get) | **GET** /sale/offer-price-change-commands/{commandId}/tasks | Change price command detailed report
*BatchOfferModificationApi* | [**get_quantity_modification_command_status_using_get**](docs/BatchOfferModificationApi.md#get_quantity_modification_command_status_using_get) | **GET** /sale/offer-quantity-change-commands/{commandId} | Change quantity command summary
*BatchOfferModificationApi* | [**get_quantity_modification_command_tasks_statuses_using_get**](docs/BatchOfferModificationApi.md#get_quantity_modification_command_tasks_statuses_using_get) | **GET** /sale/offer-quantity-change-commands/{commandId}/tasks | Change quantity command detailed report
*BatchOfferModificationApi* | [**get_tasks_using_get**](docs/BatchOfferModificationApi.md#get_tasks_using_get) | **GET** /sale/offer-modification-commands/{commandId}/tasks | Modification command detailed report
*BatchOfferModificationApi* | [**modification_command_using_put**](docs/BatchOfferModificationApi.md#modification_command_using_put) | **PUT** /sale/offer-modification-commands/{commandId} | Batch offer modification
*BatchOfferModificationApi* | [**price_modification_command_using_put**](docs/BatchOfferModificationApi.md#price_modification_command_using_put) | **PUT** /sale/offer-price-change-commands/{commandId} | Batch offer price modification
*BatchOfferModificationApi* | [**quantity_modification_command_using_put**](docs/BatchOfferModificationApi.md#quantity_modification_command_using_put) | **PUT** /sale/offer-quantity-change-commands/{commandId} | Batch offer quantity modification
*BillingApi* | [**get_billing_entries**](docs/BillingApi.md#get_billing_entries) | **GET** /billing/billing-entries | Get a list of billing entries
*BlacklistManagementApi* | [**do_add_to_black_list**](docs/BlacklistManagementApi.md#do_add_to_black_list) | **POST** /sale/blacklisted-users | Add a users to the blacklist
*BlacklistManagementApi* | [**do_get_black_list_users**](docs/BlacklistManagementApi.md#do_get_black_list_users) | **GET** /sale/blacklisted-users | Get list of blacklisted users
*BlacklistManagementApi* | [**do_remove_from_black_list**](docs/BlacklistManagementApi.md#do_remove_from_black_list) | **DELETE** /sale/blacklisted-users/{excludedUserId} | Remove users from the blacklist
*CategoriesAndParametersApi* | [**get_categories_using_get**](docs/CategoriesAndParametersApi.md#get_categories_using_get) | **GET** /sale/categories | Get IDs of Allegro categories
*CategoriesAndParametersApi* | [**get_category_using_get1**](docs/CategoriesAndParametersApi.md#get_category_using_get1) | **GET** /sale/categories/{categoryId} | Get a category by ID
*CategoriesAndParametersApi* | [**get_flat_parameters_using_get2**](docs/CategoriesAndParametersApi.md#get_flat_parameters_using_get2) | **GET** /sale/categories/{categoryId}/parameters | Get parameters supported by a category
*ClassifiedsApi* | [**assign_classified_packages_using_put**](docs/ClassifiedsApi.md#assign_classified_packages_using_put) | **PUT** /sale/offer-classifieds-packages/{offerId} | Assign packages to a classified
*ClassifiedsApi* | [**get_classified_package_configuration_using_get**](docs/ClassifiedsApi.md#get_classified_package_configuration_using_get) | **GET** /sale/classifieds-packages/{packageId} | Get the configuration of a package
*ClassifiedsApi* | [**get_classified_package_configurations_for_category_using_get**](docs/ClassifiedsApi.md#get_classified_package_configurations_for_category_using_get) | **GET** /sale/classifieds-packages | Get configurations of packages
*ClassifiedsApi* | [**get_classified_packages_using_get**](docs/ClassifiedsApi.md#get_classified_packages_using_get) | **GET** /sale/offer-classifieds-packages/{offerId} | Get classified packages assigned to an offer
*CompatibilityListApi* | [**get_categories_that_support_compatibility_list**](docs/CompatibilityListApi.md#get_categories_that_support_compatibility_list) | **GET** /sale/compatibility-list/supported-categories | Get list of categories where compatibility list is supported
*CompatibilityListApi* | [**get_compatible_products**](docs/CompatibilityListApi.md#get_compatible_products) | **GET** /sale/compatible-products | Get list of compatible products
*CompatibilityListApi* | [**get_compatible_products_groups**](docs/CompatibilityListApi.md#get_compatible_products_groups) | **GET** /sale/compatible-products/groups | Get list of compatible product groups
*ContactsApi* | [**create_contact_using_post**](docs/ContactsApi.md#create_contact_using_post) | **POST** /sale/offer-contacts | Create a new contact
*ContactsApi* | [**get_contact_using_get**](docs/ContactsApi.md#get_contact_using_get) | **GET** /sale/offer-contacts/{id} | Get contact details
*ContactsApi* | [**get_list_of_contacts_using_get**](docs/ContactsApi.md#get_list_of_contacts_using_get) | **GET** /sale/offer-contacts | Get the user&#39;s contacts
*ContactsApi* | [**modify_contact_using_put**](docs/ContactsApi.md#modify_contact_using_put) | **PUT** /sale/offer-contacts/{id} | Modify contact details
*DeliveryApi* | [**create_shipping_rates_set_using_post**](docs/DeliveryApi.md#create_shipping_rates_set_using_post) | **POST** /sale/shipping-rates | Create a new shipping rates set
*DeliveryApi* | [**get_list_of_delivery_methods_using_get**](docs/DeliveryApi.md#get_list_of_delivery_methods_using_get) | **GET** /sale/delivery-methods | Get the list of delivery methods
*DeliveryApi* | [**get_list_of_shipping_ratest_using_get**](docs/DeliveryApi.md#get_list_of_shipping_ratest_using_get) | **GET** /sale/shipping-rates | Get the user&#39;s shipping rates
*DeliveryApi* | [**get_offer_shipping_rates_get**](docs/DeliveryApi.md#get_offer_shipping_rates_get) | **GET** /sale/offers/{offerId}/shipping-rates | [BETA] Get shipping rates assigned to an offer
*DeliveryApi* | [**get_sale_delivery_settings**](docs/DeliveryApi.md#get_sale_delivery_settings) | **GET** /sale/delivery-settings | Get the user&#39;s delivery settings
*DeliveryApi* | [**get_shipping_rates_set_using_get**](docs/DeliveryApi.md#get_shipping_rates_set_using_get) | **GET** /sale/shipping-rates/{id} | Get the details of a shipping rates set
*DeliveryApi* | [**modify_shipping_rates_set_using_put**](docs/DeliveryApi.md#modify_shipping_rates_set_using_put) | **PUT** /sale/shipping-rates/{id} | Edit a user&#39;s shipping rates set
*DeliveryApi* | [**put_sale_delivery_settings**](docs/DeliveryApi.md#put_sale_delivery_settings) | **PUT** /sale/delivery-settings | Modify the user&#39;s delivery settings
*DisputesApi* | [**add_message_to_dispute_using_post**](docs/DisputesApi.md#add_message_to_dispute_using_post) | **POST** /sale/disputes/{disputeId}/messages | Add a message to a dispute
*DisputesApi* | [**create_an_attachment_using_post**](docs/DisputesApi.md#create_an_attachment_using_post) | **POST** /sale/dispute-attachments | Create an attachment declaration
*DisputesApi* | [**get_attachment_using_get**](docs/DisputesApi.md#get_attachment_using_get) | **GET** /sale/dispute-attachments/{attachmentId} | Get an attachment
*DisputesApi* | [**get_dispute_using_get**](docs/DisputesApi.md#get_dispute_using_get) | **GET** /sale/disputes/{disputeId} | Get a single dispute
*DisputesApi* | [**get_list_of_disputes_using_get**](docs/DisputesApi.md#get_list_of_disputes_using_get) | **GET** /sale/disputes | Get the user&#39;s disputes
*DisputesApi* | [**get_messages_from_dispute_using_get**](docs/DisputesApi.md#get_messages_from_dispute_using_get) | **GET** /sale/disputes/{disputeId}/messages | Get the messages within a dispute
*DisputesApi* | [**upload_dispute_attachment_using_put**](docs/DisputesApi.md#upload_dispute_attachment_using_put) | **PUT** /sale/dispute-attachments/{attachmentId} | Upload a dispute message attachment
*ImagesAndAttachmentsApi* | [**create_offer_attachment_using_post**](docs/ImagesAndAttachmentsApi.md#create_offer_attachment_using_post) | **POST** /sale/offer-attachments | Create an offer attachment
*ImagesAndAttachmentsApi* | [**upload_offer_attachment_using_put**](docs/ImagesAndAttachmentsApi.md#upload_offer_attachment_using_put) | **PUT** /sale/offer-attachments/{attachmentId} | Upload an offer attachment
*ImagesAndAttachmentsApi* | [**upload_offer_image_using_post**](docs/ImagesAndAttachmentsApi.md#upload_offer_image_using_post) | **POST** /sale/images | Upload an offer image
*InformationAboutUserApi* | [**add_additional_email_using_post**](docs/InformationAboutUserApi.md#add_additional_email_using_post) | **POST** /account/additional-emails | Add a new additional email address to user&#39;s account
*InformationAboutUserApi* | [**answer_user_rating_using_put**](docs/InformationAboutUserApi.md#answer_user_rating_using_put) | **PUT** /sale/user-ratings/{ratingId}/answer | Answer for user&#39;s rating
*InformationAboutUserApi* | [**delete_additional_email_using_delete**](docs/InformationAboutUserApi.md#delete_additional_email_using_delete) | **DELETE** /account/additional-emails/{emailId} | Delete an additional email address
*InformationAboutUserApi* | [**get_additional_email_using_get**](docs/InformationAboutUserApi.md#get_additional_email_using_get) | **GET** /account/additional-emails/{emailId} | Get information about a particular additional email
*InformationAboutUserApi* | [**get_list_of_additional_emails_using_get**](docs/InformationAboutUserApi.md#get_list_of_additional_emails_using_get) | **GET** /account/additional-emails | Get user&#39;s additional emails
*InformationAboutUserApi* | [**get_user_ratings_using_get**](docs/InformationAboutUserApi.md#get_user_ratings_using_get) | **GET** /sale/user-ratings | Get the user&#39;s ratings
*InformationAboutUserApi* | [**me_get**](docs/InformationAboutUserApi.md#me_get) | **GET** /me | Get basic information about user
*InformationAboutUserApi* | [**user_rating_removal_using_put**](docs/InformationAboutUserApi.md#user_rating_removal_using_put) | **PUT** /sale/user-ratings/{ratingId}/removal | Request removal of user&#39;s rating
*OfferManagementApi* | [**change_publication_status_using_put**](docs/OfferManagementApi.md#change_publication_status_using_put) | **PUT** /sale/offer-publication-commands/{commandId} | Batch offer publish / unpublish
*OfferManagementApi* | [**create_change_price_command_using_put**](docs/OfferManagementApi.md#create_change_price_command_using_put) | **PUT** /offers/{offerId}/change-price-commands/{commandId} | Modify the Buy Now price in an offer
*OfferManagementApi* | [**create_offer_using_post**](docs/OfferManagementApi.md#create_offer_using_post) | **POST** /sale/offers | Create a draft offer
*OfferManagementApi* | [**delete_offer_using_delete**](docs/OfferManagementApi.md#delete_offer_using_delete) | **DELETE** /sale/offers/{offerId} | Delete a draft offer
*OfferManagementApi* | [**get_publication_report_using_get**](docs/OfferManagementApi.md#get_publication_report_using_get) | **GET** /sale/offer-publication-commands/{commandId} | Publish command summary
*OfferManagementApi* | [**get_publication_tasks_using_get**](docs/OfferManagementApi.md#get_publication_tasks_using_get) | **GET** /sale/offer-publication-commands/{commandId}/tasks | Publish command detailed report
*OfferManagementApi* | [**update_offer_using_put**](docs/OfferManagementApi.md#update_offer_using_put) | **PUT** /sale/offers/{offerId} | Complete a draft offer or edit an offer
*OfferRatingApi* | [**offer_rating_get**](docs/OfferRatingApi.md#offer_rating_get) | **GET** /sale/offers/{offerId}/rating | Get offer rating
*OfferTagsApi* | [**assign_tag_to_offer_post**](docs/OfferTagsApi.md#assign_tag_to_offer_post) | **POST** /sale/offers/{offerId}/tags | Assign tags to an offer
*OfferTagsApi* | [**create_tag_post1**](docs/OfferTagsApi.md#create_tag_post1) | **POST** /sale/offer-tags | Create a tag
*OfferTagsApi* | [**delete_tag_using_delete**](docs/OfferTagsApi.md#delete_tag_using_delete) | **DELETE** /sale/offer-tags/{tagId} | Delete a tag
*OfferTagsApi* | [**list_assigned_offer_tags_get**](docs/OfferTagsApi.md#list_assigned_offer_tags_get) | **GET** /sale/offers/{offerId}/tags | Get tags assigned to an offer
*OfferTagsApi* | [**list_seller_tags_get1**](docs/OfferTagsApi.md#list_seller_tags_get1) | **GET** /sale/offer-tags | Get the user&#39;s tags
*OfferTagsApi* | [**update_tag_put**](docs/OfferTagsApi.md#update_tag_put) | **PUT** /sale/offer-tags/{tagId} | Modify a tag
*OfferVariantsApi* | [**create_or_update_variant_set**](docs/OfferVariantsApi.md#create_or_update_variant_set) | **PUT** /sale/offer-variants/{setId} | [BETA] Create or update variant set
*OfferVariantsApi* | [**delete_variant_set**](docs/OfferVariantsApi.md#delete_variant_set) | **DELETE** /sale/offer-variants/{setId} | [BETA] Delete a variant set
*OfferVariantsApi* | [**get_variant_set**](docs/OfferVariantsApi.md#get_variant_set) | **GET** /sale/offer-variants/{setId} | [BETA] Get a variant set
*OfferVariantsApi* | [**get_variant_sets**](docs/OfferVariantsApi.md#get_variant_sets) | **GET** /sale/offer-variants | [BETA] Get the user&#39;s variant sets
*OrderManagementApi* | [**create_order_shipments_using_post**](docs/OrderManagementApi.md#create_order_shipments_using_post) | **POST** /order/checkout-forms/{id}/shipments | Add a parcel tracking number
*OrderManagementApi* | [**find_mapping**](docs/OrderManagementApi.md#find_mapping) | **GET** /order/line-item-id-mappings | Get mapping for line item id
*OrderManagementApi* | [**get_list_of_orders_using_get**](docs/OrderManagementApi.md#get_list_of_orders_using_get) | **GET** /order/checkout-forms | Get the user&#39;s orders
*OrderManagementApi* | [**get_order_events_statistics_using_get**](docs/OrderManagementApi.md#get_order_events_statistics_using_get) | **GET** /order/event-stats | Get order events statistics
*OrderManagementApi* | [**get_order_events_using_get**](docs/OrderManagementApi.md#get_order_events_using_get) | **GET** /order/events | Get order events
*OrderManagementApi* | [**get_order_shipments_using_get**](docs/OrderManagementApi.md#get_order_shipments_using_get) | **GET** /order/checkout-forms/{id}/shipments | Get a list of parcel tracking numbers
*OrderManagementApi* | [**get_orders_details_using_get**](docs/OrderManagementApi.md#get_orders_details_using_get) | **GET** /order/checkout-forms/{id} | Get an order&#39;s details
*OrderManagementApi* | [**set_order_fulfillment_using_put**](docs/OrderManagementApi.md#set_order_fulfillment_using_put) | **PUT** /order/checkout-forms/{id}/fulfillment | Set seller order status
*PaymentsApi* | [**get_payment_id_mapping**](docs/PaymentsApi.md#get_payment_id_mapping) | **GET** /payments/payment-id-mappings | Mapping of payment identifiers
*PaymentsApi* | [**get_payments_operation_history**](docs/PaymentsApi.md#get_payments_operation_history) | **GET** /payments/payment-operations | Payment operations history
*PaymentsApi* | [**get_refunded_payments**](docs/PaymentsApi.md#get_refunded_payments) | **GET** /payments/refunds | Get a list of refunded payments
*PaymentsApi* | [**initiate_refund**](docs/PaymentsApi.md#initiate_refund) | **POST** /payments/refunds | Initiate a refund of a payment
*PointsOfServiceApi* | [**create_pos_using_post**](docs/PointsOfServiceApi.md#create_pos_using_post) | **POST** /points-of-service | Create a point of service
*PointsOfServiceApi* | [**delete_pos_using_delete**](docs/PointsOfServiceApi.md#delete_pos_using_delete) | **DELETE** /points-of-service/{id} | Delete a point of service
*PointsOfServiceApi* | [**get_pos_data_using_get**](docs/PointsOfServiceApi.md#get_pos_data_using_get) | **GET** /points-of-service/{id} | Get the details of a point of service
*PointsOfServiceApi* | [**get_pos_list_using_get**](docs/PointsOfServiceApi.md#get_pos_list_using_get) | **GET** /points-of-service | Get the user&#39;s points of service
*PointsOfServiceApi* | [**modify_pos_using_put**](docs/PointsOfServiceApi.md#modify_pos_using_put) | **PUT** /points-of-service/{id} | Modify a point of service
*PricingApi* | [**calculate_fee_preview_using_post**](docs/PricingApi.md#calculate_fee_preview_using_post) | **POST** /pricing/offer-fee-preview | Calculate fee and commission for an offer
*PricingApi* | [**offer_quotes_public_using_get**](docs/PricingApi.md#offer_quotes_public_using_get) | **GET** /pricing/offer-quotes | Get the user&#39;s current offer quotes
*PricingApi* | [**preview_fees_public_api_using_post**](docs/PricingApi.md#preview_fees_public_api_using_post) | **POST** /pricing/fee-preview | Preview offer fees
*ProductsApi* | [**get_flat_product_parameters_using_get**](docs/ProductsApi.md#get_flat_product_parameters_using_get) | **GET** /sale/categories/{categoryId}/product-parameters | Get product parameters available in given category
*ProductsApi* | [**get_sale_product**](docs/ProductsApi.md#get_sale_product) | **GET** /sale/products/{productId} | Get all data of the particular product
*ProductsApi* | [**get_sale_products**](docs/ProductsApi.md#get_sale_products) | **GET** /sale/products | Get search products results
*ProductsApi* | [**propose_sale_product**](docs/ProductsApi.md#propose_sale_product) | **POST** /sale/product-proposals | Propose a product
*PromotionCampaignsApi* | [**add_promotion_to_campaign_using_post**](docs/PromotionCampaignsApi.md#add_promotion_to_campaign_using_post) | **POST** /sale/loyalty/promotion-campaigns | Create an application for a promotion campaign
*PromotionCampaignsApi* | [**delete_campaign_from_promotion_using_delete**](docs/PromotionCampaignsApi.md#delete_campaign_from_promotion_using_delete) | **DELETE** /sale/loyalty/promotion-campaigns | Delete a campaign in a promotion
*PromotionCampaignsApi* | [**delete_promotion_campaign_application_using_delete**](docs/PromotionCampaignsApi.md#delete_promotion_campaign_application_using_delete) | **DELETE** /sale/loyalty/promotion-campaign-applications/{applicationId} | Delete an application for promotion campaign
*PromotionCampaignsApi* | [**get_promotion_campaign_application_using_get**](docs/PromotionCampaignsApi.md#get_promotion_campaign_application_using_get) | **GET** /sale/loyalty/promotion-campaign-applications/{applicationId} | Get an application for promotion campaign
*PromotionCampaignsApi* | [**get_promotion_campaigns_using_get**](docs/PromotionCampaignsApi.md#get_promotion_campaigns_using_get) | **GET** /sale/loyalty/promotion-campaigns | Get the user&#39;s promotion campaigns
*PublicOfferInformationApi* | [**get_listing**](docs/PublicOfferInformationApi.md#get_listing) | **GET** /offers/listing | Search offers
*PublicUserInformationApi* | [**get_user_summary_using_get**](docs/PublicUserInformationApi.md#get_user_summary_using_get) | **GET** /users/{userId}/ratings-summary | Get any user&#39;s ratings summary
*SetsAndRebatesApi* | [**create_promotion_using_post1**](docs/SetsAndRebatesApi.md#create_promotion_using_post1) | **POST** /sale/loyalty/promotions | Create a new promotion
*SetsAndRebatesApi* | [**deactivate_promotion_using_delete**](docs/SetsAndRebatesApi.md#deactivate_promotion_using_delete) | **DELETE** /sale/loyalty/promotions/{promotionId} | Deactivate a promotion by id
*SetsAndRebatesApi* | [**get_promotion_using_get**](docs/SetsAndRebatesApi.md#get_promotion_using_get) | **GET** /sale/loyalty/promotions/{promotionId} | Get a promotion data by id
*SetsAndRebatesApi* | [**list_seller_promotions_using_get1**](docs/SetsAndRebatesApi.md#list_seller_promotions_using_get1) | **GET** /sale/loyalty/promotions | Get the user&#39;s list of promotions
*SizeTablesApi* | [**get_table_using_get**](docs/SizeTablesApi.md#get_table_using_get) | **GET** /sale/size-tables/{tableId} | Get a size table details
*SizeTablesApi* | [**get_tables_using_get**](docs/SizeTablesApi.md#get_tables_using_get) | **GET** /sale/size-tables | Get the user&#39;s size tables
*UsersOfferInformationApi* | [**get_offer_events**](docs/UsersOfferInformationApi.md#get_offer_events) | **GET** /sale/offer-events | Get events about the seller&#39;s offers
*UsersOfferInformationApi* | [**get_offer_using_get**](docs/UsersOfferInformationApi.md#get_offer_using_get) | **GET** /sale/offers/{offerId} | Get all fields of the particular offer
*UsersOfferInformationApi* | [**search_offers_using_get**](docs/UsersOfferInformationApi.md#search_offers_using_get) | **GET** /sale/offers | Get seller&#39;s offers


## Documentation For Models

 - [AdditionalEmail](docs/AdditionalEmail.md)
 - [AdditionalEmailRequest](docs/AdditionalEmailRequest.md)
 - [AdditionalEmailsResponse](docs/AdditionalEmailsResponse.md)
 - [AdditionalServiceDefinitionRequest](docs/AdditionalServiceDefinitionRequest.md)
 - [AdditionalServiceRequest](docs/AdditionalServiceRequest.md)
 - [AdditionalServiceResponse](docs/AdditionalServiceResponse.md)
 - [AdditionalServicesGroup](docs/AdditionalServicesGroup.md)
 - [AdditionalServicesGroupRequest](docs/AdditionalServicesGroupRequest.md)
 - [AdditionalServicesGroupResponse](docs/AdditionalServicesGroupResponse.md)
 - [AdditionalServicesGroups](docs/AdditionalServicesGroups.md)
 - [Address](docs/Address.md)
 - [AfterSalesServices](docs/AfterSalesServices.md)
 - [Answer](docs/Answer.md)
 - [ApplicationTimePolicy](docs/ApplicationTimePolicy.md)
 - [Attachment](docs/Attachment.md)
 - [AttachmentDeclaration](docs/AttachmentDeclaration.md)
 - [AttachmentFile](docs/AttachmentFile.md)
 - [AttachmentFileRequest](docs/AttachmentFileRequest.md)
 - [AttachmentType](docs/AttachmentType.md)
 - [AuctionDetails](docs/AuctionDetails.md)
 - [AuthError](docs/AuthError.md)
 - [AvailableConstraint](docs/AvailableConstraint.md)
 - [AverageRates](docs/AverageRates.md)
 - [Badge](docs/Badge.md)
 - [BadgeApplication](docs/BadgeApplication.md)
 - [BadgeApplicationBargainPrice](docs/BadgeApplicationBargainPrice.md)
 - [BadgeApplicationCampaign](docs/BadgeApplicationCampaign.md)
 - [BadgeApplicationMarketPrice](docs/BadgeApplicationMarketPrice.md)
 - [BadgeApplicationOffer](docs/BadgeApplicationOffer.md)
 - [BadgeApplicationPrices](docs/BadgeApplicationPrices.md)
 - [BadgeApplicationProcess](docs/BadgeApplicationProcess.md)
 - [BadgeApplicationPurchaseConstraints](docs/BadgeApplicationPurchaseConstraints.md)
 - [BadgeApplicationPurchaseConstraintsLimit](docs/BadgeApplicationPurchaseConstraintsLimit.md)
 - [BadgeApplicationPurchaseConstraintsLimitPerUser](docs/BadgeApplicationPurchaseConstraintsLimitPerUser.md)
 - [BadgeApplicationRejectionReason](docs/BadgeApplicationRejectionReason.md)
 - [BadgeApplicationRejectionReasonMessage](docs/BadgeApplicationRejectionReasonMessage.md)
 - [BadgeApplicationRequest](docs/BadgeApplicationRequest.md)
 - [BadgeApplications](docs/BadgeApplications.md)
 - [BadgeCampaign](docs/BadgeCampaign.md)
 - [BadgeProcess](docs/BadgeProcess.md)
 - [BadgePublicationTimePolicy](docs/BadgePublicationTimePolicy.md)
 - [BadgesList](docs/BadgesList.md)
 - [BaseOperation](docs/BaseOperation.md)
 - [BasicDefinitionResponse](docs/BasicDefinitionResponse.md)
 - [Benefit](docs/Benefit.md)
 - [BenefitSpecification](docs/BenefitSpecification.md)
 - [BidRequest](docs/BidRequest.md)
 - [BlackListPagedResponse](docs/BlackListPagedResponse.md)
 - [BlackListResponse](docs/BlackListResponse.md)
 - [BlacklistRequest](docs/BlacklistRequest.md)
 - [BlacklistUser](docs/BlacklistUser.md)
 - [BundleBenefitSpecification](docs/BundleBenefitSpecification.md)
 - [BundleBenefitSpecificationAllOf](docs/BundleBenefitSpecificationAllOf.md)
 - [BuyNowPrice](docs/BuyNowPrice.md)
 - [BuyerParticipant](docs/BuyerParticipant.md)
 - [BuyerParticipantAllOf](docs/BuyerParticipantAllOf.md)
 - [BuyerReference](docs/BuyerReference.md)
 - [CampaignRefusalReason](docs/CampaignRefusalReason.md)
 - [CampaignRequestDto](docs/CampaignRequestDto.md)
 - [CampaignResponseDto](docs/CampaignResponseDto.md)
 - [Caption](docs/Caption.md)
 - [CategoriesDto](docs/CategoriesDto.md)
 - [Category](docs/Category.md)
 - [CategoryDto](docs/CategoryDto.md)
 - [CategoryDtoParent](docs/CategoryDtoParent.md)
 - [CategoryOptionsDto](docs/CategoryOptionsDto.md)
 - [CategoryParameter](docs/CategoryParameter.md)
 - [CategoryParameterList](docs/CategoryParameterList.md)
 - [CategoryParameterOptions](docs/CategoryParameterOptions.md)
 - [CategoryProductParameter](docs/CategoryProductParameter.md)
 - [CategoryProductParameterList](docs/CategoryProductParameterList.md)
 - [Cells](docs/Cells.md)
 - [ChangePrice](docs/ChangePrice.md)
 - [ChangePriceInput](docs/ChangePriceInput.md)
 - [ChangePriceWithoutOutput](docs/ChangePriceWithoutOutput.md)
 - [CheckoutForm](docs/CheckoutForm.md)
 - [CheckoutFormAddWaybillCreated](docs/CheckoutFormAddWaybillCreated.md)
 - [CheckoutFormAddWaybillRequest](docs/CheckoutFormAddWaybillRequest.md)
 - [CheckoutFormAdditionalService](docs/CheckoutFormAdditionalService.md)
 - [CheckoutFormBuyerAddressReference](docs/CheckoutFormBuyerAddressReference.md)
 - [CheckoutFormBuyerReference](docs/CheckoutFormBuyerReference.md)
 - [CheckoutFormDeliveryAddress](docs/CheckoutFormDeliveryAddress.md)
 - [CheckoutFormDeliveryMethod](docs/CheckoutFormDeliveryMethod.md)
 - [CheckoutFormDeliveryPickupPoint](docs/CheckoutFormDeliveryPickupPoint.md)
 - [CheckoutFormDeliveryPickupPointAddress](docs/CheckoutFormDeliveryPickupPointAddress.md)
 - [CheckoutFormDeliveryReference](docs/CheckoutFormDeliveryReference.md)
 - [CheckoutFormDeliveryTime](docs/CheckoutFormDeliveryTime.md)
 - [CheckoutFormDeliveryTimeGuaranteed](docs/CheckoutFormDeliveryTimeGuaranteed.md)
 - [CheckoutFormDiscount](docs/CheckoutFormDiscount.md)
 - [CheckoutFormFulfillment](docs/CheckoutFormFulfillment.md)
 - [CheckoutFormFulfillmentShipmentSummary](docs/CheckoutFormFulfillmentShipmentSummary.md)
 - [CheckoutFormFulfillmentShipmentSummaryLineItemsSent](docs/CheckoutFormFulfillmentShipmentSummaryLineItemsSent.md)
 - [CheckoutFormFulfillmentStatus](docs/CheckoutFormFulfillmentStatus.md)
 - [CheckoutFormInvoiceAddress](docs/CheckoutFormInvoiceAddress.md)
 - [CheckoutFormInvoiceAddressCompany](docs/CheckoutFormInvoiceAddressCompany.md)
 - [CheckoutFormInvoiceAddressNaturalPerson](docs/CheckoutFormInvoiceAddressNaturalPerson.md)
 - [CheckoutFormInvoiceInfo](docs/CheckoutFormInvoiceInfo.md)
 - [CheckoutFormLineItem](docs/CheckoutFormLineItem.md)
 - [CheckoutFormOrderWaybillResponse](docs/CheckoutFormOrderWaybillResponse.md)
 - [CheckoutFormPaymentProvider](docs/CheckoutFormPaymentProvider.md)
 - [CheckoutFormPaymentReference](docs/CheckoutFormPaymentReference.md)
 - [CheckoutFormPaymentType](docs/CheckoutFormPaymentType.md)
 - [CheckoutFormReference](docs/CheckoutFormReference.md)
 - [CheckoutFormStatus](docs/CheckoutFormStatus.md)
 - [CheckoutFormSummary](docs/CheckoutFormSummary.md)
 - [CheckoutForms](docs/CheckoutForms.md)
 - [ClassifiedExtension](docs/ClassifiedExtension.md)
 - [ClassifiedPackage](docs/ClassifiedPackage.md)
 - [ClassifiedPackageConfig](docs/ClassifiedPackageConfig.md)
 - [ClassifiedPackageConfigs](docs/ClassifiedPackageConfigs.md)
 - [ClassifiedPackages](docs/ClassifiedPackages.md)
 - [ClassifiedPromotion](docs/ClassifiedPromotion.md)
 - [ClassifiedPublication](docs/ClassifiedPublication.md)
 - [ClassifiedResponse](docs/ClassifiedResponse.md)
 - [ClassifiedsPackages](docs/ClassifiedsPackages.md)
 - [CommandOutput](docs/CommandOutput.md)
 - [CommandTask](docs/CommandTask.md)
 - [CommissionResponse](docs/CommissionResponse.md)
 - [Company](docs/Company.md)
 - [CompatibilityList](docs/CompatibilityList.md)
 - [CompatibilityListIdItem](docs/CompatibilityListIdItem.md)
 - [CompatibilityListIdItemAdditionalInfo](docs/CompatibilityListIdItemAdditionalInfo.md)
 - [CompatibilityListIdItemAllOf](docs/CompatibilityListIdItemAllOf.md)
 - [CompatibilityListItem](docs/CompatibilityListItem.md)
 - [CompatibilityListItemProductBased](docs/CompatibilityListItemProductBased.md)
 - [CompatibilityListManual](docs/CompatibilityListManual.md)
 - [CompatibilityListManualAllOf](docs/CompatibilityListManualAllOf.md)
 - [CompatibilityListProductBased](docs/CompatibilityListProductBased.md)
 - [CompatibilityListProductBasedAllOf](docs/CompatibilityListProductBasedAllOf.md)
 - [CompatibilityListSupportedCategoriesDto](docs/CompatibilityListSupportedCategoriesDto.md)
 - [CompatibilityListSupportedCategoriesDtoSupportedCategories](docs/CompatibilityListSupportedCategoriesDtoSupportedCategories.md)
 - [CompatibilityListSupportedCategoriesDtoValidationRules](docs/CompatibilityListSupportedCategoriesDtoValidationRules.md)
 - [CompatibilityListTextItem](docs/CompatibilityListTextItem.md)
 - [CompatibilityListTextItemAllOf](docs/CompatibilityListTextItemAllOf.md)
 - [CompatibleProductDto](docs/CompatibleProductDto.md)
 - [CompatibleProductDtoAttributes](docs/CompatibleProductDtoAttributes.md)
 - [CompatibleProductDtoGroup](docs/CompatibleProductDtoGroup.md)
 - [CompatibleProductsGroupsDto](docs/CompatibleProductsGroupsDto.md)
 - [CompatibleProductsGroupsDtoGroups](docs/CompatibleProductsGroupsDtoGroups.md)
 - [CompatibleProductsListDto](docs/CompatibleProductsListDto.md)
 - [Configuration](docs/Configuration.md)
 - [ConstraintCriteria](docs/ConstraintCriteria.md)
 - [ContactRequest](docs/ContactRequest.md)
 - [ContactResponse](docs/ContactResponse.md)
 - [ContactResponseList](docs/ContactResponseList.md)
 - [ContributionOperation](docs/ContributionOperation.md)
 - [ContributionOperationAllOf](docs/ContributionOperationAllOf.md)
 - [Coordinates](docs/Coordinates.md)
 - [CorrectionOperation](docs/CorrectionOperation.md)
 - [CorrectionOperationAllOf](docs/CorrectionOperationAllOf.md)
 - [CurrentPrice](docs/CurrentPrice.md)
 - [Deduction](docs/Deduction.md)
 - [DeductionChargeOperation](docs/DeductionChargeOperation.md)
 - [DeductionChargeOperationAllOf](docs/DeductionChargeOperationAllOf.md)
 - [DeductionIncreaseOperation](docs/DeductionIncreaseOperation.md)
 - [DeductionIncreaseOperationAllOf](docs/DeductionIncreaseOperationAllOf.md)
 - [DefinitionsResponse](docs/DefinitionsResponse.md)
 - [Delivery](docs/Delivery.md)
 - [DeliverySettingsDto](docs/DeliverySettingsDto.md)
 - [DeliverySettingsDtoCustomCost](docs/DeliverySettingsDtoCustomCost.md)
 - [DeliverySettingsDtoFreeDelivery](docs/DeliverySettingsDtoFreeDelivery.md)
 - [DeliverySettingsDtoJoinPolicy](docs/DeliverySettingsDtoJoinPolicy.md)
 - [DescribesListingFee](docs/DescribesListingFee.md)
 - [DescribesSuccessCommissionFee](docs/DescribesSuccessCommissionFee.md)
 - [DescriptionSection](docs/DescriptionSection.md)
 - [DescriptionSectionItem](docs/DescriptionSectionItem.md)
 - [DescriptionSectionItemImage](docs/DescriptionSectionItemImage.md)
 - [DescriptionSectionItemImageAllOf](docs/DescriptionSectionItemImageAllOf.md)
 - [DescriptionSectionItemText](docs/DescriptionSectionItemText.md)
 - [DescriptionSectionItemTextAllOf](docs/DescriptionSectionItemTextAllOf.md)
 - [DictionaryCategoryParameter](docs/DictionaryCategoryParameter.md)
 - [DictionaryCategoryProductParameter](docs/DictionaryCategoryProductParameter.md)
 - [DictionaryCategoryProductParameterAllOf](docs/DictionaryCategoryProductParameterAllOf.md)
 - [DictionaryCategoryProductParameterAllOfDictionary](docs/DictionaryCategoryProductParameterAllOfDictionary.md)
 - [DictionaryCategoryProductParameterAllOfRestrictions](docs/DictionaryCategoryProductParameterAllOfRestrictions.md)
 - [Dispute](docs/Dispute.md)
 - [DisputeAttachment](docs/DisputeAttachment.md)
 - [DisputeAttachmentId](docs/DisputeAttachmentId.md)
 - [DisputeAuthor](docs/DisputeAuthor.md)
 - [DisputeAuthorRole](docs/DisputeAuthorRole.md)
 - [DisputeCheckoutForm](docs/DisputeCheckoutForm.md)
 - [DisputeFirstMessage](docs/DisputeFirstMessage.md)
 - [DisputeListResponse](docs/DisputeListResponse.md)
 - [DisputeMessage](docs/DisputeMessage.md)
 - [DisputeMessageAuthor](docs/DisputeMessageAuthor.md)
 - [DisputeMessageList](docs/DisputeMessageList.md)
 - [DisputeUser](docs/DisputeUser.md)
 - [EmailRequest](docs/EmailRequest.md)
 - [EmailResponse](docs/EmailResponse.md)
 - [Error](docs/Error.md)
 - [ErrorsHolder](docs/ErrorsHolder.md)
 - [ExternalId](docs/ExternalId.md)
 - [Fee](docs/Fee.md)
 - [FeePreviewResponse](docs/FeePreviewResponse.md)
 - [FloatCategoryParameter](docs/FloatCategoryParameter.md)
 - [FloatCategoryProductParameter](docs/FloatCategoryProductParameter.md)
 - [FloatCategoryProductParameterAllOf](docs/FloatCategoryProductParameterAllOf.md)
 - [FloatCategoryProductParameterAllOfRestrictions](docs/FloatCategoryProductParameterAllOfRestrictions.md)
 - [FullDefinitionResponse](docs/FullDefinitionResponse.md)
 - [GeneralReport](docs/GeneralReport.md)
 - [GetBadgeCampaignsList](docs/GetBadgeCampaignsList.md)
 - [GetSaleProductsResponse](docs/GetSaleProductsResponse.md)
 - [GetSaleProductsResponseNextPage](docs/GetSaleProductsResponseNextPage.md)
 - [Header](docs/Header.md)
 - [ImageUrl](docs/ImageUrl.md)
 - [ImpliedWarrantiesListImpliedWarrantyBasic](docs/ImpliedWarrantiesListImpliedWarrantyBasic.md)
 - [ImpliedWarranty](docs/ImpliedWarranty.md)
 - [ImpliedWarrantyBasic](docs/ImpliedWarrantyBasic.md)
 - [InitializeRefund](docs/InitializeRefund.md)
 - [InitializeRefundAdditionalServices](docs/InitializeRefundAdditionalServices.md)
 - [InitializeRefundDelivery](docs/InitializeRefundDelivery.md)
 - [InitializeRefundOverpaid](docs/InitializeRefundOverpaid.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse2001](docs/InlineResponse2001.md)
 - [InlineResponse2001DeliveryMethods](docs/InlineResponse2001DeliveryMethods.md)
 - [InlineResponse2001ShippingRatesConstraints](docs/InlineResponse2001ShippingRatesConstraints.md)
 - [InlineResponse2001ShippingRatesConstraintsFirstItemRate](docs/InlineResponse2001ShippingRatesConstraintsFirstItemRate.md)
 - [InlineResponse2001ShippingRatesConstraintsMaxQuantityPerPackage](docs/InlineResponse2001ShippingRatesConstraintsMaxQuantityPerPackage.md)
 - [InlineResponse2001ShippingRatesConstraintsNextItemRate](docs/InlineResponse2001ShippingRatesConstraintsNextItemRate.md)
 - [InlineResponse2001ShippingRatesConstraintsShippingTime](docs/InlineResponse2001ShippingRatesConstraintsShippingTime.md)
 - [InlineResponse2001ShippingRatesConstraintsShippingTimeDefault](docs/InlineResponse2001ShippingRatesConstraintsShippingTimeDefault.md)
 - [InlineResponse200ShippingRates](docs/InlineResponse200ShippingRates.md)
 - [IntegerCategoryParameter](docs/IntegerCategoryParameter.md)
 - [IntegerCategoryProductParameter](docs/IntegerCategoryProductParameter.md)
 - [IntegerCategoryProductParameterAllOf](docs/IntegerCategoryProductParameterAllOf.md)
 - [IntegerCategoryProductParameterAllOfRestrictions](docs/IntegerCategoryProductParameterAllOfRestrictions.md)
 - [JustId](docs/JustId.md)
 - [LatestOrderEvent](docs/LatestOrderEvent.md)
 - [LineItemIdMappings](docs/LineItemIdMappings.md)
 - [LineItemIdMappingsMappings](docs/LineItemIdMappingsMappings.md)
 - [ListingCategory](docs/ListingCategory.md)
 - [ListingCategoryWithCount](docs/ListingCategoryWithCount.md)
 - [ListingOffer](docs/ListingOffer.md)
 - [ListingResponse](docs/ListingResponse.md)
 - [ListingResponseCategories](docs/ListingResponseCategories.md)
 - [ListingResponseFilters](docs/ListingResponseFilters.md)
 - [ListingResponseFiltersValues](docs/ListingResponseFiltersValues.md)
 - [ListingResponseOffers](docs/ListingResponseOffers.md)
 - [ListingResponseSearchMeta](docs/ListingResponseSearchMeta.md)
 - [ListingResponseSort](docs/ListingResponseSort.md)
 - [Location](docs/Location.md)
 - [MaxPrice](docs/MaxPrice.md)
 - [MeResponse](docs/MeResponse.md)
 - [MessageAuthorRole](docs/MessageAuthorRole.md)
 - [MessageRequest](docs/MessageRequest.md)
 - [MinimalPrice](docs/MinimalPrice.md)
 - [Modification](docs/Modification.md)
 - [ModificationDelivery](docs/ModificationDelivery.md)
 - [ModificationPayments](docs/ModificationPayments.md)
 - [ModificationPromotion](docs/ModificationPromotion.md)
 - [ModificationPublication](docs/ModificationPublication.md)
 - [ModificationSizeTable](docs/ModificationSizeTable.md)
 - [MultiPackBenefitSpecification](docs/MultiPackBenefitSpecification.md)
 - [MultiPackBenefitSpecificationAllOf](docs/MultiPackBenefitSpecificationAllOf.md)
 - [MultiPackBenefitSpecificationAllOfConfiguration](docs/MultiPackBenefitSpecificationAllOfConfiguration.md)
 - [MultiPackBenefitSpecificationAllOfTrigger](docs/MultiPackBenefitSpecificationAllOfTrigger.md)
 - [MyBidResponse](docs/MyBidResponse.md)
 - [Offer](docs/Offer.md)
 - [OfferActivatedEvent](docs/OfferActivatedEvent.md)
 - [OfferActivatedEventAllOf](docs/OfferActivatedEventAllOf.md)
 - [OfferAdditionalServices](docs/OfferAdditionalServices.md)
 - [OfferArchivedEvent](docs/OfferArchivedEvent.md)
 - [OfferArchivedEventAllOf](docs/OfferArchivedEventAllOf.md)
 - [OfferAttachment](docs/OfferAttachment.md)
 - [OfferAttachmentRequest](docs/OfferAttachmentRequest.md)
 - [OfferBadgeCampaign](docs/OfferBadgeCampaign.md)
 - [OfferBidCanceledEvent](docs/OfferBidCanceledEvent.md)
 - [OfferBidCanceledEventAllOf](docs/OfferBidCanceledEventAllOf.md)
 - [OfferBidPlacedEvent](docs/OfferBidPlacedEvent.md)
 - [OfferBidPlacedEventAllOf](docs/OfferBidPlacedEventAllOf.md)
 - [OfferCategory](docs/OfferCategory.md)
 - [OfferChangeCommand](docs/OfferChangeCommand.md)
 - [OfferChangedEvent](docs/OfferChangedEvent.md)
 - [OfferChangedEventAllOf](docs/OfferChangedEventAllOf.md)
 - [OfferCriterium](docs/OfferCriterium.md)
 - [OfferDelivery](docs/OfferDelivery.md)
 - [OfferEndedEvent](docs/OfferEndedEvent.md)
 - [OfferEndedEventAllOf](docs/OfferEndedEventAllOf.md)
 - [OfferEventBaseOffer](docs/OfferEventBaseOffer.md)
 - [OfferEventEndedOffer](docs/OfferEventEndedOffer.md)
 - [OfferEventEndedOfferAllOf](docs/OfferEventEndedOfferAllOf.md)
 - [OfferEventEndedOfferAllOfPublication](docs/OfferEventEndedOfferAllOfPublication.md)
 - [OfferFixedPrice](docs/OfferFixedPrice.md)
 - [OfferId](docs/OfferId.md)
 - [OfferImageLinkUploadRequest](docs/OfferImageLinkUploadRequest.md)
 - [OfferImageUploadResponse](docs/OfferImageUploadResponse.md)
 - [OfferImages](docs/OfferImages.md)
 - [OfferListingDto](docs/OfferListingDto.md)
 - [OfferListingDtoImage](docs/OfferListingDtoImage.md)
 - [OfferListingDtoV1Delivery](docs/OfferListingDtoV1Delivery.md)
 - [OfferListingDtoV1Publication](docs/OfferListingDtoV1Publication.md)
 - [OfferListingDtoV1SaleInfo](docs/OfferListingDtoV1SaleInfo.md)
 - [OfferListingDtoV1Stats](docs/OfferListingDtoV1Stats.md)
 - [OfferListingDtoV1Stock](docs/OfferListingDtoV1Stock.md)
 - [OfferLowestPrice](docs/OfferLowestPrice.md)
 - [OfferPrice](docs/OfferPrice.md)
 - [OfferPriceChangeCommand](docs/OfferPriceChangeCommand.md)
 - [OfferPriceChangedEvent](docs/OfferPriceChangedEvent.md)
 - [OfferPriceChangedEventAllOf](docs/OfferPriceChangedEventAllOf.md)
 - [OfferPromotion](docs/OfferPromotion.md)
 - [OfferPublication](docs/OfferPublication.md)
 - [OfferQuantityChangeCommand](docs/OfferQuantityChangeCommand.md)
 - [OfferQuoteDto](docs/OfferQuoteDto.md)
 - [OfferQuotesDto](docs/OfferQuotesDto.md)
 - [OfferRating](docs/OfferRating.md)
 - [OfferRatingScoreDistribution](docs/OfferRatingScoreDistribution.md)
 - [OfferRatingSizeFeedback](docs/OfferRatingSizeFeedback.md)
 - [OfferReference](docs/OfferReference.md)
 - [OfferRequirements](docs/OfferRequirements.md)
 - [OfferSeller](docs/OfferSeller.md)
 - [OfferSellingMode](docs/OfferSellingMode.md)
 - [OfferShippingRates](docs/OfferShippingRates.md)
 - [OfferStatus](docs/OfferStatus.md)
 - [OfferStock](docs/OfferStock.md)
 - [OfferStockChangedEvent](docs/OfferStockChangedEvent.md)
 - [OfferStockChangedEventAllOf](docs/OfferStockChangedEventAllOf.md)
 - [OfferVendor](docs/OfferVendor.md)
 - [OffersSearchResultDto](docs/OffersSearchResultDto.md)
 - [OpenHour](docs/OpenHour.md)
 - [OperationParticipantAddress](docs/OperationParticipantAddress.md)
 - [OperationPayment](docs/OperationPayment.md)
 - [OperationValue](docs/OperationValue.md)
 - [Order](docs/Order.md)
 - [OrderEvent](docs/OrderEvent.md)
 - [OrderEventData](docs/OrderEventData.md)
 - [OrderEventStats](docs/OrderEventStats.md)
 - [OrderEventType](docs/OrderEventType.md)
 - [OrderEventsList](docs/OrderEventsList.md)
 - [OrderLineItem](docs/OrderLineItem.md)
 - [Parameter](docs/Parameter.md)
 - [ParameterRangeValue](docs/ParameterRangeValue.md)
 - [ParametersForPreviewPrice](docs/ParametersForPreviewPrice.md)
 - [Participant](docs/Participant.md)
 - [Payment](docs/Payment.md)
 - [PaymentIdMapping](docs/PaymentIdMapping.md)
 - [PaymentOperations](docs/PaymentOperations.md)
 - [Payments](docs/Payments.md)
 - [PaymentsSurcharge](docs/PaymentsSurcharge.md)
 - [Payout](docs/Payout.md)
 - [PayoutOperation](docs/PayoutOperation.md)
 - [PayoutOperationAllOf](docs/PayoutOperationAllOf.md)
 - [PayoutOperationCancel](docs/PayoutOperationCancel.md)
 - [PayoutOperationCancelAllOf](docs/PayoutOperationCancelAllOf.md)
 - [PhonesRequest](docs/PhonesRequest.md)
 - [PhonesResponse](docs/PhonesResponse.md)
 - [Pos](docs/Pos.md)
 - [Price](docs/Price.md)
 - [PriceModification](docs/PriceModification.md)
 - [PriceModificationFixedPrice](docs/PriceModificationFixedPrice.md)
 - [PriceModificationFixedPriceAllOf](docs/PriceModificationFixedPriceAllOf.md)
 - [PriceModificationFixedPriceHolder](docs/PriceModificationFixedPriceHolder.md)
 - [PriceModificationPercentageChangeDecrease](docs/PriceModificationPercentageChangeDecrease.md)
 - [PriceModificationPercentageChangeDecreaseAllOf](docs/PriceModificationPercentageChangeDecreaseAllOf.md)
 - [PriceModificationPercentageChangeIncrease](docs/PriceModificationPercentageChangeIncrease.md)
 - [PriceModificationPercentageChangeIncreaseAllOf](docs/PriceModificationPercentageChangeIncreaseAllOf.md)
 - [PriceModificationValueChangeDecrease](docs/PriceModificationValueChangeDecrease.md)
 - [PriceModificationValueChangeDecreaseAllOf](docs/PriceModificationValueChangeDecreaseAllOf.md)
 - [PriceModificationValueChangeHolder](docs/PriceModificationValueChangeHolder.md)
 - [PriceModificationValueChangeIncrease](docs/PriceModificationValueChangeIncrease.md)
 - [PriceModificationValueChangeIncreaseAllOf](docs/PriceModificationValueChangeIncreaseAllOf.md)
 - [ProcessingStatus](docs/ProcessingStatus.md)
 - [ProductParameter](docs/ProductParameter.md)
 - [ProductParameterOptions](docs/ProductParameterOptions.md)
 - [ProductsCategoryPath](docs/ProductsCategoryPath.md)
 - [ProductsCategorySubcategories](docs/ProductsCategorySubcategories.md)
 - [Promotion](docs/Promotion.md)
 - [PromotionCampaignRequestDto](docs/PromotionCampaignRequestDto.md)
 - [PromotionCampaignResponseDto](docs/PromotionCampaignResponseDto.md)
 - [PromotionCampaignsResponseDto](docs/PromotionCampaignsResponseDto.md)
 - [PromotionRequestDto](docs/PromotionRequestDto.md)
 - [PromotionResponseDto](docs/PromotionResponseDto.md)
 - [ProposeSaleProductRequest](docs/ProposeSaleProductRequest.md)
 - [PublicOfferPreviewRequest](docs/PublicOfferPreviewRequest.md)
 - [PublicTableDto](docs/PublicTableDto.md)
 - [PublicTableImageDto](docs/PublicTableImageDto.md)
 - [PublicTablesDto](docs/PublicTablesDto.md)
 - [Publication](docs/Publication.md)
 - [PublicationChangeCommandDto](docs/PublicationChangeCommandDto.md)
 - [PublicationModification](docs/PublicationModification.md)
 - [PublicationTimePolicy](docs/PublicationTimePolicy.md)
 - [QuantityModification](docs/QuantityModification.md)
 - [QuoteResponse](docs/QuoteResponse.md)
 - [Rates](docs/Rates.md)
 - [Reference](docs/Reference.md)
 - [RefundAdditionalServicesValue](docs/RefundAdditionalServicesValue.md)
 - [RefundCancelOperation](docs/RefundCancelOperation.md)
 - [RefundCancelOperationAllOf](docs/RefundCancelOperationAllOf.md)
 - [RefundChargeOperation](docs/RefundChargeOperation.md)
 - [RefundChargeOperationAllOf](docs/RefundChargeOperationAllOf.md)
 - [RefundDeliveryValue](docs/RefundDeliveryValue.md)
 - [RefundDetails](docs/RefundDetails.md)
 - [RefundIncreaseOperation](docs/RefundIncreaseOperation.md)
 - [RefundIncreaseOperationAllOf](docs/RefundIncreaseOperationAllOf.md)
 - [RefundLineItem](docs/RefundLineItem.md)
 - [RefundLineItemValue](docs/RefundLineItemValue.md)
 - [RefundOverpaidValue](docs/RefundOverpaidValue.md)
 - [RefundPayment](docs/RefundPayment.md)
 - [RefundSurchargeValue](docs/RefundSurchargeValue.md)
 - [RefundTotalValue](docs/RefundTotalValue.md)
 - [RefusalMessage](docs/RefusalMessage.md)
 - [Removal](docs/Removal.md)
 - [RemovalRequest](docs/RemovalRequest.md)
 - [ReturnPoliciesListReturnPolicyBasic](docs/ReturnPoliciesListReturnPolicyBasic.md)
 - [ReturnPolicy](docs/ReturnPolicy.md)
 - [ReturnPolicyBasic](docs/ReturnPolicyBasic.md)
 - [SaleProductCompatibilityList](docs/SaleProductCompatibilityList.md)
 - [SaleProductDto](docs/SaleProductDto.md)
 - [SaleProductResponseCategoriesDto](docs/SaleProductResponseCategoriesDto.md)
 - [SaleProductResponseDto](docs/SaleProductResponseDto.md)
 - [SearchResult](docs/SearchResult.md)
 - [Seller](docs/Seller.md)
 - [SellerCreateRebateRequestDto](docs/SellerCreateRebateRequestDto.md)
 - [SellerOfferBaseEvent](docs/SellerOfferBaseEvent.md)
 - [SellerOfferEventsResponse](docs/SellerOfferEventsResponse.md)
 - [SellerParticipant](docs/SellerParticipant.md)
 - [SellerParticipantAllOf](docs/SellerParticipantAllOf.md)
 - [SellerRebateDto](docs/SellerRebateDto.md)
 - [SellerRebateOfferCriterion](docs/SellerRebateOfferCriterion.md)
 - [SellerRebateOfferCriterionOffers](docs/SellerRebateOfferCriterionOffers.md)
 - [SellerRebatesDto](docs/SellerRebatesDto.md)
 - [SellerReference](docs/SellerReference.md)
 - [SellingMode](docs/SellingMode.md)
 - [SellingModeFormat](docs/SellingModeFormat.md)
 - [ShippingRate](docs/ShippingRate.md)
 - [ShippingRateDeliveryMethod](docs/ShippingRateDeliveryMethod.md)
 - [ShippingRateFirstItemRate](docs/ShippingRateFirstItemRate.md)
 - [ShippingRateNextItemRate](docs/ShippingRateNextItemRate.md)
 - [ShippingRateShippingTime](docs/ShippingRateShippingTime.md)
 - [ShippingRates](docs/ShippingRates.md)
 - [ShippingRatesSet](docs/ShippingRatesSet.md)
 - [SinglePromotionCampaignResponseDto](docs/SinglePromotionCampaignResponseDto.md)
 - [StandardizedDescription](docs/StandardizedDescription.md)
 - [StartingPrice](docs/StartingPrice.md)
 - [Stock](docs/Stock.md)
 - [StringCategoryParameter](docs/StringCategoryParameter.md)
 - [StringCategoryProductParameter](docs/StringCategoryProductParameter.md)
 - [StringCategoryProductParameterAllOf](docs/StringCategoryProductParameterAllOf.md)
 - [StringCategoryProductParameterAllOfRestrictions](docs/StringCategoryProductParameterAllOfRestrictions.md)
 - [Subject](docs/Subject.md)
 - [Surcharge](docs/Surcharge.md)
 - [SurchargeOperation](docs/SurchargeOperation.md)
 - [SurchargeOperationAllOf](docs/SurchargeOperationAllOf.md)
 - [TagId](docs/TagId.md)
 - [TagIdsRequest](docs/TagIdsRequest.md)
 - [TagListResponse](docs/TagListResponse.md)
 - [TagRequest](docs/TagRequest.md)
 - [TagResponse](docs/TagResponse.md)
 - [TaskCount](docs/TaskCount.md)
 - [TaskReport](docs/TaskReport.md)
 - [TecdocSpecification](docs/TecdocSpecification.md)
 - [TecdocSpecificationItem](docs/TecdocSpecificationItem.md)
 - [User](docs/User.md)
 - [UserCampaignEligibility](docs/UserCampaignEligibility.md)
 - [UserRating](docs/UserRating.md)
 - [UserRatingAnswerRequest](docs/UserRatingAnswerRequest.md)
 - [UserRatingListResponse](docs/UserRatingListResponse.md)
 - [UserRatingRemovalRequest](docs/UserRatingRemovalRequest.md)
 - [UserRatingRemovalRequestRequest](docs/UserRatingRemovalRequestRequest.md)
 - [UserRatingSummaryResponse](docs/UserRatingSummaryResponse.md)
 - [UserRatingSummaryResponseNotRecommended](docs/UserRatingSummaryResponseNotRecommended.md)
 - [UserRatingSummaryResponseRecommended](docs/UserRatingSummaryResponseRecommended.md)
 - [Validation](docs/Validation.md)
 - [ValidationError](docs/ValidationError.md)
 - [VariantSet](docs/VariantSet.md)
 - [VariantSetOffer](docs/VariantSetOffer.md)
 - [VariantSetParameter](docs/VariantSetParameter.md)
 - [VariantSets](docs/VariantSets.md)
 - [VariantSetsVariantSet](docs/VariantSetsVariantSet.md)
 - [VisibilityTimePolicy](docs/VisibilityTimePolicy.md)
 - [Wallet](docs/Wallet.md)
 - [WalletBalance](docs/WalletBalance.md)
 - [WarrantiesListWarrantyBasic](docs/WarrantiesListWarrantyBasic.md)
 - [Warranty](docs/Warranty.md)
 - [WarrantyBasic](docs/WarrantyBasic.md)
 - [WrapperTypeForPreviewConditions](docs/WrapperTypeForPreviewConditions.md)
 - [WrapsListingAndCommissionsFees](docs/WrapsListingAndCommissionsFees.md)


## Documentation For Authorization


## bearer-token-for-application

- **Type**: OAuth
- **Flow**: application
- **Authorization URL**: 
- **Scopes**: N/A


## bearer-token-for-user

- **Type**: OAuth
- **Flow**: accessCode
- **Authorization URL**: https://allegro.pl/auth/oauth/authorize
- **Scopes**: N/A


## Author




