# coding: utf-8

"""
    IGVF Project API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 83.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class Treatment(BaseModel):
    """
    A protein or chemical treatment applied to samples such as lipopolysaccharide, interleukin-2, or leucine.
    """ # noqa: E501
    preview_timestamp: Optional[StrictStr] = Field(default=None, description="The date the object was previewed.")
    release_timestamp: Optional[StrictStr] = Field(default=None, description="The date the object was released.")
    lab: Optional[StrictStr] = Field(default=None, description="Lab associated with the submission.")
    award: Optional[StrictStr] = Field(default=None, description="Grant associated with the submission.")
    sources: Optional[List[StrictStr]] = Field(default=None, description="The originating lab(s) or vendor(s).")
    lot_id: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="The lot identifier provided by the originating lab or vendor.")
    product_id: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="The product identifier provided by the originating lab or vendor.")
    documents: Optional[List[StrictStr]] = Field(default=None, description="Documents that describe the treatment protocol details.")
    status: Optional[StrictStr] = Field(default=None, description="The status of the metadata object.")
    schema_version: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="The version of the JSON schema that the server uses to validate the object.")
    uuid: Optional[StrictStr] = Field(default=None, description="The unique identifier associated with every object.")
    notes: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="DACC internal notes.")
    aliases: Optional[List[Annotated[str, Field(strict=True)]]] = Field(default=None, description="Lab specific identifiers to reference an object.")
    creation_timestamp: Optional[StrictStr] = Field(default=None, description="The date the object was created.")
    submitted_by: Optional[StrictStr] = Field(default=None, description="The user who submitted the object.")
    submitter_comment: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="Additional information specified by the submitter to be displayed as a comment on the portal.")
    description: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="A plain text description of the object.")
    amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Specific quantity of the applied treatment (used in conjunction with amount_units).")
    amount_units: Optional[StrictStr] = Field(default=None, description="A unit for an amount other than those for time or temperature.")
    duration: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Duration indicates the time elapsed between the start and end of the treatment.")
    duration_units: Optional[StrictStr] = Field(default=None, description="A unit of time.")
    p_h: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Final pH of the solution containing a chemical compound (if applicable)", alias="pH")
    purpose: Optional[StrictStr] = Field(default=None, description="The intended purpose for treating the samples.")
    post_treatment_time: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Post treatment time in conjunction with post treatment time units is used to specify the time that has passed between the point when biosamples were removed from the treatment solution before being sampled or treated with the next treatment.")
    post_treatment_time_units: Optional[StrictStr] = Field(default=None, description="A unit of time.")
    temperature: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The temperature in Celsius to which the sample was exposed")
    temperature_units: Optional[StrictStr] = Field(default=None, description="A unit of temperature.")
    treatment_type: Optional[StrictStr] = Field(default=None, description="The classification of treatment agent that specifies its exact molecular nature. ")
    treatment_term_id: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="Ontology identifier describing a component in the treatment.")
    treatment_term_name: Optional[StrictStr] = Field(default=None, description="Ontology term describing a component in the treatment that is the principal component affecting the biosample being treated. Examples: interferon gamma, interleukin-4, Fibroblast growth factor 2, 20-hydroxyecdysone, 5-bromouridine etc.")
    depletion: Optional[StrictBool] = Field(default=None, description="Treatment is depleted.")
    id: Optional[StrictStr] = Field(default=None, alias="@id")
    type: Optional[List[StrictStr]] = Field(default=None, alias="@type")
    summary: Optional[StrictStr] = None
    biosamples_treated: Optional[List[StrictStr]] = Field(default=None, description="The samples which have been treated using this treatment.")
    __properties: ClassVar[List[str]] = ["preview_timestamp", "release_timestamp", "lab", "award", "sources", "lot_id", "product_id", "documents", "status", "schema_version", "uuid", "notes", "aliases", "creation_timestamp", "submitted_by", "submitter_comment", "description", "amount", "amount_units", "duration", "duration_units", "pH", "purpose", "post_treatment_time", "post_treatment_time_units", "temperature", "temperature_units", "treatment_type", "treatment_term_id", "treatment_term_name", "depletion", "@id", "@type", "summary", "biosamples_treated"]

    @field_validator('lot_id')
    def lot_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^(\S+(\s|\S)*\S+|\S)$", value):
            raise ValueError(r"must validate the regular expression /^(\S+(\s|\S)*\S+|\S)$/")
        return value

    @field_validator('product_id')
    def product_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^(\S+(\s|\S)*\S+|\S)$", value):
            raise ValueError(r"must validate the regular expression /^(\S+(\s|\S)*\S+|\S)$/")
        return value

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['archived', 'deleted', 'in progress', 'preview', 'released']):
            raise ValueError("must be one of enum values ('archived', 'deleted', 'in progress', 'preview', 'released')")
        return value

    @field_validator('schema_version')
    def schema_version_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^\d+(\.\d+)*$", value):
            raise ValueError(r"must validate the regular expression /^\d+(\.\d+)*$/")
        return value

    @field_validator('notes')
    def notes_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^(\S+(\s|\S)*\S+|\S)$", value):
            raise ValueError(r"must validate the regular expression /^(\S+(\s|\S)*\S+|\S)$/")
        return value

    @field_validator('submitter_comment')
    def submitter_comment_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^(\S+(\s|\S)*\S+|\S)$", value):
            raise ValueError(r"must validate the regular expression /^(\S+(\s|\S)*\S+|\S)$/")
        return value

    @field_validator('description')
    def description_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^(\S+(\s|\S)*\S+|\S)$", value):
            raise ValueError(r"must validate the regular expression /^(\S+(\s|\S)*\S+|\S)$/")
        return value

    @field_validator('amount_units')
    def amount_units_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['mg/kg', 'mg/mL', 'mM', 'ng/mL', 'nM', 'percent', 'μg/kg', 'μg/kg', 'μg/mL', 'μM', 'kpa']):
            raise ValueError("must be one of enum values ('mg/kg', 'mg/mL', 'mM', 'ng/mL', 'nM', 'percent', 'μg/kg', 'μg/kg', 'μg/mL', 'μM', 'kpa')")
        return value

    @field_validator('duration_units')
    def duration_units_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['second', 'minute', 'hour', 'day']):
            raise ValueError("must be one of enum values ('second', 'minute', 'hour', 'day')")
        return value

    @field_validator('purpose')
    def purpose_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['activation', 'agonist', 'antagonist', 'control', 'differentiation', 'de-differentiation', 'perturbation', 'selection', 'stimulation']):
            raise ValueError("must be one of enum values ('activation', 'agonist', 'antagonist', 'control', 'differentiation', 'de-differentiation', 'perturbation', 'selection', 'stimulation')")
        return value

    @field_validator('post_treatment_time_units')
    def post_treatment_time_units_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['minute', 'hour', 'day', 'week', 'month']):
            raise ValueError("must be one of enum values ('minute', 'hour', 'day', 'week', 'month')")
        return value

    @field_validator('temperature_units')
    def temperature_units_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Celsius']):
            raise ValueError("must be one of enum values ('Celsius')")
        return value

    @field_validator('treatment_type')
    def treatment_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['chemical', 'protein', 'environmental']):
            raise ValueError("must be one of enum values ('chemical', 'protein', 'environmental')")
        return value

    @field_validator('treatment_term_id')
    def treatment_term_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^((CHEBI:[0-9]{1,7})|(UniProtKB:[A-Z0-9]{6})|(NTR:[0-9]{2,8}))$", value):
            raise ValueError(r"must validate the regular expression /^((CHEBI:[0-9]{1,7})|(UniProtKB:[A-Z0-9]{6})|(NTR:[0-9]{2,8}))$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Treatment from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Treatment from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "preview_timestamp": obj.get("preview_timestamp"),
            "release_timestamp": obj.get("release_timestamp"),
            "lab": obj.get("lab"),
            "award": obj.get("award"),
            "sources": obj.get("sources"),
            "lot_id": obj.get("lot_id"),
            "product_id": obj.get("product_id"),
            "documents": obj.get("documents"),
            "status": obj.get("status"),
            "schema_version": obj.get("schema_version"),
            "uuid": obj.get("uuid"),
            "notes": obj.get("notes"),
            "aliases": obj.get("aliases"),
            "creation_timestamp": obj.get("creation_timestamp"),
            "submitted_by": obj.get("submitted_by"),
            "submitter_comment": obj.get("submitter_comment"),
            "description": obj.get("description"),
            "amount": obj.get("amount"),
            "amount_units": obj.get("amount_units"),
            "duration": obj.get("duration"),
            "duration_units": obj.get("duration_units"),
            "pH": obj.get("pH"),
            "purpose": obj.get("purpose"),
            "post_treatment_time": obj.get("post_treatment_time"),
            "post_treatment_time_units": obj.get("post_treatment_time_units"),
            "temperature": obj.get("temperature"),
            "temperature_units": obj.get("temperature_units"),
            "treatment_type": obj.get("treatment_type"),
            "treatment_term_id": obj.get("treatment_term_id"),
            "treatment_term_name": obj.get("treatment_term_name"),
            "depletion": obj.get("depletion"),
            "@id": obj.get("@id"),
            "@type": obj.get("@type"),
            "summary": obj.get("summary"),
            "biosamples_treated": obj.get("biosamples_treated")
        })
        return _obj


