from __future__ import annotations
from datetime import datetime
from kiota_abstractions.serialization import AdditionalDataHolder, Parsable, ParseNode, SerializationWriter
from kiota_abstractions.utils import lazy_import
from typing import Any, Callable, Dict, List, Optional, Union

windows_malware_threat_state = lazy_import('msgraph.generated.models.windows_malware_threat_state')

class WindowsMalwareStateCount(AdditionalDataHolder, Parsable):
    """
    Windows Malware State Summary.
    """
    @property
    def additional_data(self,) -> Dict[str, Any]:
        """
        Gets the additionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
        Returns: Dict[str, Any]
        """
        return self._additional_data
    
    @additional_data.setter
    def additional_data(self,value: Dict[str, Any]) -> None:
        """
        Sets the additionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
        Args:
            value: Value to set for the AdditionalData property.
        """
        self._additional_data = value
    
    def __init__(self,) -> None:
        """
        Instantiates a new windowsMalwareStateCount and sets the default values.
        """
        # Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
        self._additional_data: Dict[str, Any] = {}

        # Count of devices with malware detections for this malware State
        self._device_count: Optional[int] = None
        # Count of distinct malwares for this malware State. Valid values -2147483648 to 2147483647
        self._distinct_malware_count: Optional[int] = None
        # The Timestamp of the last update for the device count in UTC
        self._last_update_date_time: Optional[datetime] = None
        # Count of total malware detections for this malware State. Valid values -2147483648 to 2147483647
        self._malware_detection_count: Optional[int] = None
        # The OdataType property
        self._odata_type: Optional[str] = None
        # Malware threat status
        self._state: Optional[windows_malware_threat_state.WindowsMalwareThreatState] = None
    
    @staticmethod
    def create_from_discriminator_value(parse_node: Optional[ParseNode] = None) -> WindowsMalwareStateCount:
        """
        Creates a new instance of the appropriate class based on discriminator value
        Args:
            parseNode: The parse node to use to read the discriminator value and create the object
        Returns: WindowsMalwareStateCount
        """
        if parse_node is None:
            raise Exception("parse_node cannot be undefined")
        return WindowsMalwareStateCount()
    
    @property
    def device_count(self,) -> Optional[int]:
        """
        Gets the deviceCount property value. Count of devices with malware detections for this malware State
        Returns: Optional[int]
        """
        return self._device_count
    
    @device_count.setter
    def device_count(self,value: Optional[int] = None) -> None:
        """
        Sets the deviceCount property value. Count of devices with malware detections for this malware State
        Args:
            value: Value to set for the deviceCount property.
        """
        self._device_count = value
    
    @property
    def distinct_malware_count(self,) -> Optional[int]:
        """
        Gets the distinctMalwareCount property value. Count of distinct malwares for this malware State. Valid values -2147483648 to 2147483647
        Returns: Optional[int]
        """
        return self._distinct_malware_count
    
    @distinct_malware_count.setter
    def distinct_malware_count(self,value: Optional[int] = None) -> None:
        """
        Sets the distinctMalwareCount property value. Count of distinct malwares for this malware State. Valid values -2147483648 to 2147483647
        Args:
            value: Value to set for the distinctMalwareCount property.
        """
        self._distinct_malware_count = value
    
    def get_field_deserializers(self,) -> Dict[str, Callable[[ParseNode], None]]:
        """
        The deserialization information for the current model
        Returns: Dict[str, Callable[[ParseNode], None]]
        """
        fields = {
            "device_count": lambda n : setattr(self, 'device_count', n.get_int_value()),
            "distinct_malware_count": lambda n : setattr(self, 'distinct_malware_count', n.get_int_value()),
            "last_update_date_time": lambda n : setattr(self, 'last_update_date_time', n.get_datetime_value()),
            "malware_detection_count": lambda n : setattr(self, 'malware_detection_count', n.get_int_value()),
            "@odata.type": lambda n : setattr(self, 'odata_type', n.get_str_value()),
            "state": lambda n : setattr(self, 'state', n.get_enum_value(windows_malware_threat_state.WindowsMalwareThreatState)),
        }
        return fields
    
    @property
    def last_update_date_time(self,) -> Optional[datetime]:
        """
        Gets the lastUpdateDateTime property value. The Timestamp of the last update for the device count in UTC
        Returns: Optional[datetime]
        """
        return self._last_update_date_time
    
    @last_update_date_time.setter
    def last_update_date_time(self,value: Optional[datetime] = None) -> None:
        """
        Sets the lastUpdateDateTime property value. The Timestamp of the last update for the device count in UTC
        Args:
            value: Value to set for the lastUpdateDateTime property.
        """
        self._last_update_date_time = value
    
    @property
    def malware_detection_count(self,) -> Optional[int]:
        """
        Gets the malwareDetectionCount property value. Count of total malware detections for this malware State. Valid values -2147483648 to 2147483647
        Returns: Optional[int]
        """
        return self._malware_detection_count
    
    @malware_detection_count.setter
    def malware_detection_count(self,value: Optional[int] = None) -> None:
        """
        Sets the malwareDetectionCount property value. Count of total malware detections for this malware State. Valid values -2147483648 to 2147483647
        Args:
            value: Value to set for the malwareDetectionCount property.
        """
        self._malware_detection_count = value
    
    @property
    def odata_type(self,) -> Optional[str]:
        """
        Gets the @odata.type property value. The OdataType property
        Returns: Optional[str]
        """
        return self._odata_type
    
    @odata_type.setter
    def odata_type(self,value: Optional[str] = None) -> None:
        """
        Sets the @odata.type property value. The OdataType property
        Args:
            value: Value to set for the OdataType property.
        """
        self._odata_type = value
    
    def serialize(self,writer: SerializationWriter) -> None:
        """
        Serializes information the current object
        Args:
            writer: Serialization writer to use to serialize this model
        """
        if writer is None:
            raise Exception("writer cannot be undefined")
        writer.write_int_value("deviceCount", self.device_count)
        writer.write_int_value("distinctMalwareCount", self.distinct_malware_count)
        writer.write_datetime_value("lastUpdateDateTime", self.last_update_date_time)
        writer.write_int_value("malwareDetectionCount", self.malware_detection_count)
        writer.write_str_value("@odata.type", self.odata_type)
        writer.write_enum_value("state", self.state)
        writer.write_additional_data_value(self.additional_data)
    
    @property
    def state(self,) -> Optional[windows_malware_threat_state.WindowsMalwareThreatState]:
        """
        Gets the state property value. Malware threat status
        Returns: Optional[windows_malware_threat_state.WindowsMalwareThreatState]
        """
        return self._state
    
    @state.setter
    def state(self,value: Optional[windows_malware_threat_state.WindowsMalwareThreatState] = None) -> None:
        """
        Sets the state property value. Malware threat status
        Args:
            value: Value to set for the state property.
        """
        self._state = value
    

