from __future__ import annotations
from datetime import datetime
from kiota_abstractions.serialization import AdditionalDataHolder, Parsable, ParseNode, SerializationWriter
from kiota_abstractions.utils import lazy_import
from typing import Any, Callable, Dict, List, Optional, Union

windows_malware_severity = lazy_import('msgraph.generated.models.windows_malware_severity')

class WindowsMalwareSeverityCount(AdditionalDataHolder, Parsable):
    """
    Windows Malware Severity Count Summary
    """
    @property
    def additional_data(self,) -> Dict[str, Any]:
        """
        Gets the additionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
        Returns: Dict[str, Any]
        """
        return self._additional_data
    
    @additional_data.setter
    def additional_data(self,value: Dict[str, Any]) -> None:
        """
        Sets the additionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
        Args:
            value: Value to set for the AdditionalData property.
        """
        self._additional_data = value
    
    def __init__(self,) -> None:
        """
        Instantiates a new windowsMalwareSeverityCount and sets the default values.
        """
        # Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
        self._additional_data: Dict[str, Any] = {}

        # Count of distinct malwares for this malware State. Valid values -2147483648 to 2147483647
        self._distinct_malware_count: Optional[int] = None
        # The Timestamp of the last update for the WindowsMalwareSeverityCount in UTC
        self._last_update_date_time: Optional[datetime] = None
        # Count of threats detections for this malware severity. Valid values -2147483648 to 2147483647
        self._malware_detection_count: Optional[int] = None
        # The OdataType property
        self._odata_type: Optional[str] = None
        # Malware severity
        self._severity: Optional[windows_malware_severity.WindowsMalwareSeverity] = None
    
    @staticmethod
    def create_from_discriminator_value(parse_node: Optional[ParseNode] = None) -> WindowsMalwareSeverityCount:
        """
        Creates a new instance of the appropriate class based on discriminator value
        Args:
            parseNode: The parse node to use to read the discriminator value and create the object
        Returns: WindowsMalwareSeverityCount
        """
        if parse_node is None:
            raise Exception("parse_node cannot be undefined")
        return WindowsMalwareSeverityCount()
    
    @property
    def distinct_malware_count(self,) -> Optional[int]:
        """
        Gets the distinctMalwareCount property value. Count of distinct malwares for this malware State. Valid values -2147483648 to 2147483647
        Returns: Optional[int]
        """
        return self._distinct_malware_count
    
    @distinct_malware_count.setter
    def distinct_malware_count(self,value: Optional[int] = None) -> None:
        """
        Sets the distinctMalwareCount property value. Count of distinct malwares for this malware State. Valid values -2147483648 to 2147483647
        Args:
            value: Value to set for the distinctMalwareCount property.
        """
        self._distinct_malware_count = value
    
    def get_field_deserializers(self,) -> Dict[str, Callable[[ParseNode], None]]:
        """
        The deserialization information for the current model
        Returns: Dict[str, Callable[[ParseNode], None]]
        """
        fields = {
            "distinct_malware_count": lambda n : setattr(self, 'distinct_malware_count', n.get_int_value()),
            "last_update_date_time": lambda n : setattr(self, 'last_update_date_time', n.get_datetime_value()),
            "malware_detection_count": lambda n : setattr(self, 'malware_detection_count', n.get_int_value()),
            "@odata.type": lambda n : setattr(self, 'odata_type', n.get_str_value()),
            "severity": lambda n : setattr(self, 'severity', n.get_enum_value(windows_malware_severity.WindowsMalwareSeverity)),
        }
        return fields
    
    @property
    def last_update_date_time(self,) -> Optional[datetime]:
        """
        Gets the lastUpdateDateTime property value. The Timestamp of the last update for the WindowsMalwareSeverityCount in UTC
        Returns: Optional[datetime]
        """
        return self._last_update_date_time
    
    @last_update_date_time.setter
    def last_update_date_time(self,value: Optional[datetime] = None) -> None:
        """
        Sets the lastUpdateDateTime property value. The Timestamp of the last update for the WindowsMalwareSeverityCount in UTC
        Args:
            value: Value to set for the lastUpdateDateTime property.
        """
        self._last_update_date_time = value
    
    @property
    def malware_detection_count(self,) -> Optional[int]:
        """
        Gets the malwareDetectionCount property value. Count of threats detections for this malware severity. Valid values -2147483648 to 2147483647
        Returns: Optional[int]
        """
        return self._malware_detection_count
    
    @malware_detection_count.setter
    def malware_detection_count(self,value: Optional[int] = None) -> None:
        """
        Sets the malwareDetectionCount property value. Count of threats detections for this malware severity. Valid values -2147483648 to 2147483647
        Args:
            value: Value to set for the malwareDetectionCount property.
        """
        self._malware_detection_count = value
    
    @property
    def odata_type(self,) -> Optional[str]:
        """
        Gets the @odata.type property value. The OdataType property
        Returns: Optional[str]
        """
        return self._odata_type
    
    @odata_type.setter
    def odata_type(self,value: Optional[str] = None) -> None:
        """
        Sets the @odata.type property value. The OdataType property
        Args:
            value: Value to set for the OdataType property.
        """
        self._odata_type = value
    
    def serialize(self,writer: SerializationWriter) -> None:
        """
        Serializes information the current object
        Args:
            writer: Serialization writer to use to serialize this model
        """
        if writer is None:
            raise Exception("writer cannot be undefined")
        writer.write_int_value("distinctMalwareCount", self.distinct_malware_count)
        writer.write_datetime_value("lastUpdateDateTime", self.last_update_date_time)
        writer.write_int_value("malwareDetectionCount", self.malware_detection_count)
        writer.write_str_value("@odata.type", self.odata_type)
        writer.write_enum_value("severity", self.severity)
        writer.write_additional_data_value(self.additional_data)
    
    @property
    def severity(self,) -> Optional[windows_malware_severity.WindowsMalwareSeverity]:
        """
        Gets the severity property value. Malware severity
        Returns: Optional[windows_malware_severity.WindowsMalwareSeverity]
        """
        return self._severity
    
    @severity.setter
    def severity(self,value: Optional[windows_malware_severity.WindowsMalwareSeverity] = None) -> None:
        """
        Sets the severity property value. Malware severity
        Args:
            value: Value to set for the severity property.
        """
        self._severity = value
    

