from __future__ import annotations
from kiota_abstractions.serialization import AdditionalDataHolder, Parsable, ParseNode, SerializationWriter
from kiota_abstractions.utils import lazy_import
from typing import Any, Callable, Dict, List, Optional, Union

os_version_count = lazy_import('msgraph.generated.models.os_version_count')
windows_malware_category_count = lazy_import('msgraph.generated.models.windows_malware_category_count')
windows_malware_execution_state_count = lazy_import('msgraph.generated.models.windows_malware_execution_state_count')
windows_malware_name_count = lazy_import('msgraph.generated.models.windows_malware_name_count')
windows_malware_severity_count = lazy_import('msgraph.generated.models.windows_malware_severity_count')
windows_malware_state_count = lazy_import('msgraph.generated.models.windows_malware_state_count')

class WindowsMalwareOverview(AdditionalDataHolder, Parsable):
    """
    Windows device malware overview.
    """
    @property
    def additional_data(self,) -> Dict[str, Any]:
        """
        Gets the additionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
        Returns: Dict[str, Any]
        """
        return self._additional_data
    
    @additional_data.setter
    def additional_data(self,value: Dict[str, Any]) -> None:
        """
        Sets the additionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
        Args:
            value: Value to set for the AdditionalData property.
        """
        self._additional_data = value
    
    def __init__(self,) -> None:
        """
        Instantiates a new windowsMalwareOverview and sets the default values.
        """
        # Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
        self._additional_data: Dict[str, Any] = {}

        # Count of devices per malware category
        self._malware_category_summary: Optional[List[windows_malware_category_count.WindowsMalwareCategoryCount]] = None
        # Count of devices with malware detected in the last 30 days
        self._malware_detected_device_count: Optional[int] = None
        # Count of devices per malware execution state
        self._malware_execution_state_summary: Optional[List[windows_malware_execution_state_count.WindowsMalwareExecutionStateCount]] = None
        # Count of devices per malware
        self._malware_name_summary: Optional[List[windows_malware_name_count.WindowsMalwareNameCount]] = None
        # Count of active malware per malware severity
        self._malware_severity_summary: Optional[List[windows_malware_severity_count.WindowsMalwareSeverityCount]] = None
        # Count of devices per malware state
        self._malware_state_summary: Optional[List[windows_malware_state_count.WindowsMalwareStateCount]] = None
        # The OdataType property
        self._odata_type: Optional[str] = None
        # Count of devices with malware per windows OS version
        self._os_versions_summary: Optional[List[os_version_count.OsVersionCount]] = None
        # Count of all distinct malwares detected across all devices. Valid values -2147483648 to 2147483647
        self._total_distinct_malware_count: Optional[int] = None
        # Count of all malware detections across all devices. Valid values -2147483648 to 2147483647
        self._total_malware_count: Optional[int] = None
    
    @staticmethod
    def create_from_discriminator_value(parse_node: Optional[ParseNode] = None) -> WindowsMalwareOverview:
        """
        Creates a new instance of the appropriate class based on discriminator value
        Args:
            parseNode: The parse node to use to read the discriminator value and create the object
        Returns: WindowsMalwareOverview
        """
        if parse_node is None:
            raise Exception("parse_node cannot be undefined")
        return WindowsMalwareOverview()
    
    def get_field_deserializers(self,) -> Dict[str, Callable[[ParseNode], None]]:
        """
        The deserialization information for the current model
        Returns: Dict[str, Callable[[ParseNode], None]]
        """
        fields = {
            "malware_category_summary": lambda n : setattr(self, 'malware_category_summary', n.get_collection_of_object_values(windows_malware_category_count.WindowsMalwareCategoryCount)),
            "malware_detected_device_count": lambda n : setattr(self, 'malware_detected_device_count', n.get_int_value()),
            "malware_execution_state_summary": lambda n : setattr(self, 'malware_execution_state_summary', n.get_collection_of_object_values(windows_malware_execution_state_count.WindowsMalwareExecutionStateCount)),
            "malware_name_summary": lambda n : setattr(self, 'malware_name_summary', n.get_collection_of_object_values(windows_malware_name_count.WindowsMalwareNameCount)),
            "malware_severity_summary": lambda n : setattr(self, 'malware_severity_summary', n.get_collection_of_object_values(windows_malware_severity_count.WindowsMalwareSeverityCount)),
            "malware_state_summary": lambda n : setattr(self, 'malware_state_summary', n.get_collection_of_object_values(windows_malware_state_count.WindowsMalwareStateCount)),
            "@odata.type": lambda n : setattr(self, 'odata_type', n.get_str_value()),
            "os_versions_summary": lambda n : setattr(self, 'os_versions_summary', n.get_collection_of_object_values(os_version_count.OsVersionCount)),
            "total_distinct_malware_count": lambda n : setattr(self, 'total_distinct_malware_count', n.get_int_value()),
            "total_malware_count": lambda n : setattr(self, 'total_malware_count', n.get_int_value()),
        }
        return fields
    
    @property
    def malware_category_summary(self,) -> Optional[List[windows_malware_category_count.WindowsMalwareCategoryCount]]:
        """
        Gets the malwareCategorySummary property value. Count of devices per malware category
        Returns: Optional[List[windows_malware_category_count.WindowsMalwareCategoryCount]]
        """
        return self._malware_category_summary
    
    @malware_category_summary.setter
    def malware_category_summary(self,value: Optional[List[windows_malware_category_count.WindowsMalwareCategoryCount]] = None) -> None:
        """
        Sets the malwareCategorySummary property value. Count of devices per malware category
        Args:
            value: Value to set for the malwareCategorySummary property.
        """
        self._malware_category_summary = value
    
    @property
    def malware_detected_device_count(self,) -> Optional[int]:
        """
        Gets the malwareDetectedDeviceCount property value. Count of devices with malware detected in the last 30 days
        Returns: Optional[int]
        """
        return self._malware_detected_device_count
    
    @malware_detected_device_count.setter
    def malware_detected_device_count(self,value: Optional[int] = None) -> None:
        """
        Sets the malwareDetectedDeviceCount property value. Count of devices with malware detected in the last 30 days
        Args:
            value: Value to set for the malwareDetectedDeviceCount property.
        """
        self._malware_detected_device_count = value
    
    @property
    def malware_execution_state_summary(self,) -> Optional[List[windows_malware_execution_state_count.WindowsMalwareExecutionStateCount]]:
        """
        Gets the malwareExecutionStateSummary property value. Count of devices per malware execution state
        Returns: Optional[List[windows_malware_execution_state_count.WindowsMalwareExecutionStateCount]]
        """
        return self._malware_execution_state_summary
    
    @malware_execution_state_summary.setter
    def malware_execution_state_summary(self,value: Optional[List[windows_malware_execution_state_count.WindowsMalwareExecutionStateCount]] = None) -> None:
        """
        Sets the malwareExecutionStateSummary property value. Count of devices per malware execution state
        Args:
            value: Value to set for the malwareExecutionStateSummary property.
        """
        self._malware_execution_state_summary = value
    
    @property
    def malware_name_summary(self,) -> Optional[List[windows_malware_name_count.WindowsMalwareNameCount]]:
        """
        Gets the malwareNameSummary property value. Count of devices per malware
        Returns: Optional[List[windows_malware_name_count.WindowsMalwareNameCount]]
        """
        return self._malware_name_summary
    
    @malware_name_summary.setter
    def malware_name_summary(self,value: Optional[List[windows_malware_name_count.WindowsMalwareNameCount]] = None) -> None:
        """
        Sets the malwareNameSummary property value. Count of devices per malware
        Args:
            value: Value to set for the malwareNameSummary property.
        """
        self._malware_name_summary = value
    
    @property
    def malware_severity_summary(self,) -> Optional[List[windows_malware_severity_count.WindowsMalwareSeverityCount]]:
        """
        Gets the malwareSeveritySummary property value. Count of active malware per malware severity
        Returns: Optional[List[windows_malware_severity_count.WindowsMalwareSeverityCount]]
        """
        return self._malware_severity_summary
    
    @malware_severity_summary.setter
    def malware_severity_summary(self,value: Optional[List[windows_malware_severity_count.WindowsMalwareSeverityCount]] = None) -> None:
        """
        Sets the malwareSeveritySummary property value. Count of active malware per malware severity
        Args:
            value: Value to set for the malwareSeveritySummary property.
        """
        self._malware_severity_summary = value
    
    @property
    def malware_state_summary(self,) -> Optional[List[windows_malware_state_count.WindowsMalwareStateCount]]:
        """
        Gets the malwareStateSummary property value. Count of devices per malware state
        Returns: Optional[List[windows_malware_state_count.WindowsMalwareStateCount]]
        """
        return self._malware_state_summary
    
    @malware_state_summary.setter
    def malware_state_summary(self,value: Optional[List[windows_malware_state_count.WindowsMalwareStateCount]] = None) -> None:
        """
        Sets the malwareStateSummary property value. Count of devices per malware state
        Args:
            value: Value to set for the malwareStateSummary property.
        """
        self._malware_state_summary = value
    
    @property
    def odata_type(self,) -> Optional[str]:
        """
        Gets the @odata.type property value. The OdataType property
        Returns: Optional[str]
        """
        return self._odata_type
    
    @odata_type.setter
    def odata_type(self,value: Optional[str] = None) -> None:
        """
        Sets the @odata.type property value. The OdataType property
        Args:
            value: Value to set for the OdataType property.
        """
        self._odata_type = value
    
    @property
    def os_versions_summary(self,) -> Optional[List[os_version_count.OsVersionCount]]:
        """
        Gets the osVersionsSummary property value. Count of devices with malware per windows OS version
        Returns: Optional[List[os_version_count.OsVersionCount]]
        """
        return self._os_versions_summary
    
    @os_versions_summary.setter
    def os_versions_summary(self,value: Optional[List[os_version_count.OsVersionCount]] = None) -> None:
        """
        Sets the osVersionsSummary property value. Count of devices with malware per windows OS version
        Args:
            value: Value to set for the osVersionsSummary property.
        """
        self._os_versions_summary = value
    
    def serialize(self,writer: SerializationWriter) -> None:
        """
        Serializes information the current object
        Args:
            writer: Serialization writer to use to serialize this model
        """
        if writer is None:
            raise Exception("writer cannot be undefined")
        writer.write_collection_of_object_values("malwareCategorySummary", self.malware_category_summary)
        writer.write_int_value("malwareDetectedDeviceCount", self.malware_detected_device_count)
        writer.write_collection_of_object_values("malwareExecutionStateSummary", self.malware_execution_state_summary)
        writer.write_collection_of_object_values("malwareNameSummary", self.malware_name_summary)
        writer.write_collection_of_object_values("malwareSeveritySummary", self.malware_severity_summary)
        writer.write_collection_of_object_values("malwareStateSummary", self.malware_state_summary)
        writer.write_str_value("@odata.type", self.odata_type)
        writer.write_collection_of_object_values("osVersionsSummary", self.os_versions_summary)
        writer.write_int_value("totalDistinctMalwareCount", self.total_distinct_malware_count)
        writer.write_int_value("totalMalwareCount", self.total_malware_count)
        writer.write_additional_data_value(self.additional_data)
    
    @property
    def total_distinct_malware_count(self,) -> Optional[int]:
        """
        Gets the totalDistinctMalwareCount property value. Count of all distinct malwares detected across all devices. Valid values -2147483648 to 2147483647
        Returns: Optional[int]
        """
        return self._total_distinct_malware_count
    
    @total_distinct_malware_count.setter
    def total_distinct_malware_count(self,value: Optional[int] = None) -> None:
        """
        Sets the totalDistinctMalwareCount property value. Count of all distinct malwares detected across all devices. Valid values -2147483648 to 2147483647
        Args:
            value: Value to set for the totalDistinctMalwareCount property.
        """
        self._total_distinct_malware_count = value
    
    @property
    def total_malware_count(self,) -> Optional[int]:
        """
        Gets the totalMalwareCount property value. Count of all malware detections across all devices. Valid values -2147483648 to 2147483647
        Returns: Optional[int]
        """
        return self._total_malware_count
    
    @total_malware_count.setter
    def total_malware_count(self,value: Optional[int] = None) -> None:
        """
        Sets the totalMalwareCount property value. Count of all malware detections across all devices. Valid values -2147483648 to 2147483647
        Args:
            value: Value to set for the totalMalwareCount property.
        """
        self._total_malware_count = value
    

