from __future__ import annotations
from datetime import datetime
from kiota_abstractions.serialization import AdditionalDataHolder, Parsable, ParseNode, SerializationWriter
from kiota_abstractions.utils import lazy_import
from typing import Any, Callable, Dict, List, Optional, Union

long_running_operation_status = lazy_import('msgraph.generated.models.security.long_running_operation_status')
tenant_allow_block_list_entry_type = lazy_import('msgraph.generated.models.security.tenant_allow_block_list_entry_type')

class TenantAllowBlockListEntryResult(AdditionalDataHolder, Parsable):
    @property
    def additional_data(self,) -> Dict[str, Any]:
        """
        Gets the additionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
        Returns: Dict[str, Any]
        """
        return self._additional_data
    
    @additional_data.setter
    def additional_data(self,value: Dict[str, Any]) -> None:
        """
        Sets the additionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
        Args:
            value: Value to set for the AdditionalData property.
        """
        self._additional_data = value
    
    def __init__(self,) -> None:
        """
        Instantiates a new tenantAllowBlockListEntryResult and sets the default values.
        """
        # Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
        self._additional_data: Dict[str, Any] = {}

        # The entry type of tenant allow block list. The possible values are: url, fileHash, sender, recipient and unkownFutureValue.
        self._entry_type: Optional[tenant_allow_block_list_entry_type.TenantAllowBlockListEntryType] = None
        # Specifies when will this entry expire in date time.
        self._expiration_date_time: Optional[datetime] = None
        # Specifies the identity of the entry generated by the tenant allow block list system.
        self._identity: Optional[str] = None
        # The OdataType property
        self._odata_type: Optional[str] = None
        # Specifies whether the tenant allow block list entry creation operation was successful. The possible values are: notStarted, running, succeeded, failed, skipped and unkownFutureValue.
        self._status: Optional[long_running_operation_status.LongRunningOperationStatus] = None
        # Specifies the value of the created tenant allow block list entry.
        self._value: Optional[str] = None
    
    @staticmethod
    def create_from_discriminator_value(parse_node: Optional[ParseNode] = None) -> TenantAllowBlockListEntryResult:
        """
        Creates a new instance of the appropriate class based on discriminator value
        Args:
            parseNode: The parse node to use to read the discriminator value and create the object
        Returns: TenantAllowBlockListEntryResult
        """
        if parse_node is None:
            raise Exception("parse_node cannot be undefined")
        return TenantAllowBlockListEntryResult()
    
    @property
    def entry_type(self,) -> Optional[tenant_allow_block_list_entry_type.TenantAllowBlockListEntryType]:
        """
        Gets the entryType property value. The entry type of tenant allow block list. The possible values are: url, fileHash, sender, recipient and unkownFutureValue.
        Returns: Optional[tenant_allow_block_list_entry_type.TenantAllowBlockListEntryType]
        """
        return self._entry_type
    
    @entry_type.setter
    def entry_type(self,value: Optional[tenant_allow_block_list_entry_type.TenantAllowBlockListEntryType] = None) -> None:
        """
        Sets the entryType property value. The entry type of tenant allow block list. The possible values are: url, fileHash, sender, recipient and unkownFutureValue.
        Args:
            value: Value to set for the entryType property.
        """
        self._entry_type = value
    
    @property
    def expiration_date_time(self,) -> Optional[datetime]:
        """
        Gets the expirationDateTime property value. Specifies when will this entry expire in date time.
        Returns: Optional[datetime]
        """
        return self._expiration_date_time
    
    @expiration_date_time.setter
    def expiration_date_time(self,value: Optional[datetime] = None) -> None:
        """
        Sets the expirationDateTime property value. Specifies when will this entry expire in date time.
        Args:
            value: Value to set for the expirationDateTime property.
        """
        self._expiration_date_time = value
    
    def get_field_deserializers(self,) -> Dict[str, Callable[[ParseNode], None]]:
        """
        The deserialization information for the current model
        Returns: Dict[str, Callable[[ParseNode], None]]
        """
        fields = {
            "entry_type": lambda n : setattr(self, 'entry_type', n.get_enum_value(tenant_allow_block_list_entry_type.TenantAllowBlockListEntryType)),
            "expiration_date_time": lambda n : setattr(self, 'expiration_date_time', n.get_datetime_value()),
            "identity": lambda n : setattr(self, 'identity', n.get_str_value()),
            "@odata.type": lambda n : setattr(self, 'odata_type', n.get_str_value()),
            "status": lambda n : setattr(self, 'status', n.get_enum_value(long_running_operation_status.LongRunningOperationStatus)),
            "value": lambda n : setattr(self, 'value', n.get_str_value()),
        }
        return fields
    
    @property
    def identity(self,) -> Optional[str]:
        """
        Gets the identity property value. Specifies the identity of the entry generated by the tenant allow block list system.
        Returns: Optional[str]
        """
        return self._identity
    
    @identity.setter
    def identity(self,value: Optional[str] = None) -> None:
        """
        Sets the identity property value. Specifies the identity of the entry generated by the tenant allow block list system.
        Args:
            value: Value to set for the identity property.
        """
        self._identity = value
    
    @property
    def odata_type(self,) -> Optional[str]:
        """
        Gets the @odata.type property value. The OdataType property
        Returns: Optional[str]
        """
        return self._odata_type
    
    @odata_type.setter
    def odata_type(self,value: Optional[str] = None) -> None:
        """
        Sets the @odata.type property value. The OdataType property
        Args:
            value: Value to set for the OdataType property.
        """
        self._odata_type = value
    
    def serialize(self,writer: SerializationWriter) -> None:
        """
        Serializes information the current object
        Args:
            writer: Serialization writer to use to serialize this model
        """
        if writer is None:
            raise Exception("writer cannot be undefined")
        writer.write_enum_value("entryType", self.entry_type)
        writer.write_datetime_value("expirationDateTime", self.expiration_date_time)
        writer.write_str_value("identity", self.identity)
        writer.write_str_value("@odata.type", self.odata_type)
        writer.write_enum_value("status", self.status)
        writer.write_str_value("value", self.value)
        writer.write_additional_data_value(self.additional_data)
    
    @property
    def status(self,) -> Optional[long_running_operation_status.LongRunningOperationStatus]:
        """
        Gets the status property value. Specifies whether the tenant allow block list entry creation operation was successful. The possible values are: notStarted, running, succeeded, failed, skipped and unkownFutureValue.
        Returns: Optional[long_running_operation_status.LongRunningOperationStatus]
        """
        return self._status
    
    @status.setter
    def status(self,value: Optional[long_running_operation_status.LongRunningOperationStatus] = None) -> None:
        """
        Sets the status property value. Specifies whether the tenant allow block list entry creation operation was successful. The possible values are: notStarted, running, succeeded, failed, skipped and unkownFutureValue.
        Args:
            value: Value to set for the status property.
        """
        self._status = value
    
    @property
    def value(self,) -> Optional[str]:
        """
        Gets the value property value. Specifies the value of the created tenant allow block list entry.
        Returns: Optional[str]
        """
        return self._value
    
    @value.setter
    def value(self,value: Optional[str] = None) -> None:
        """
        Sets the value property value. Specifies the value of the created tenant allow block list entry.
        Args:
            value: Value to set for the value property.
        """
        self._value = value
    

