from __future__ import annotations
from kiota_abstractions.serialization import Parsable, ParseNode, SerializationWriter
from kiota_abstractions.utils import lazy_import
from typing import Any, Callable, Dict, List, Optional, Union

alert_evidence = lazy_import('msgraph.generated.models.security.alert_evidence')

class MailClusterEvidence(alert_evidence.AlertEvidence):
    @property
    def cluster_by(self,) -> Optional[str]:
        """
        Gets the clusterBy property value. The clustering logic of the emails inside the cluster.
        Returns: Optional[str]
        """
        return self._cluster_by
    
    @cluster_by.setter
    def cluster_by(self,value: Optional[str] = None) -> None:
        """
        Sets the clusterBy property value. The clustering logic of the emails inside the cluster.
        Args:
            value: Value to set for the clusterBy property.
        """
        self._cluster_by = value
    
    @property
    def cluster_by_value(self,) -> Optional[str]:
        """
        Gets the clusterByValue property value. The value utilized to cluster the similar emails.
        Returns: Optional[str]
        """
        return self._cluster_by_value
    
    @cluster_by_value.setter
    def cluster_by_value(self,value: Optional[str] = None) -> None:
        """
        Sets the clusterByValue property value. The value utilized to cluster the similar emails.
        Args:
            value: Value to set for the clusterByValue property.
        """
        self._cluster_by_value = value
    
    def __init__(self,) -> None:
        """
        Instantiates a new MailClusterEvidence and sets the default values.
        """
        super().__init__()
        # The clustering logic of the emails inside the cluster.
        self._cluster_by: Optional[str] = None
        # The value utilized to cluster the similar emails.
        self._cluster_by_value: Optional[str] = None
        # Count of emails in the email cluster.
        self._email_count: Optional[int] = None
        # Unique identifiers for the emails in the cluster, generated by Microsoft 365.
        self._network_message_ids: Optional[List[str]] = None
        # The OdataType property
        self.odata_type: Optional[str] = None
        # The query used to identify the email cluster.
        self._query: Optional[str] = None
        # Uniform resource name (URN) of the automated investigation where the cluster was identified.
        self._urn: Optional[str] = None
    
    @staticmethod
    def create_from_discriminator_value(parse_node: Optional[ParseNode] = None) -> MailClusterEvidence:
        """
        Creates a new instance of the appropriate class based on discriminator value
        Args:
            parseNode: The parse node to use to read the discriminator value and create the object
        Returns: MailClusterEvidence
        """
        if parse_node is None:
            raise Exception("parse_node cannot be undefined")
        return MailClusterEvidence()
    
    @property
    def email_count(self,) -> Optional[int]:
        """
        Gets the emailCount property value. Count of emails in the email cluster.
        Returns: Optional[int]
        """
        return self._email_count
    
    @email_count.setter
    def email_count(self,value: Optional[int] = None) -> None:
        """
        Sets the emailCount property value. Count of emails in the email cluster.
        Args:
            value: Value to set for the emailCount property.
        """
        self._email_count = value
    
    def get_field_deserializers(self,) -> Dict[str, Callable[[ParseNode], None]]:
        """
        The deserialization information for the current model
        Returns: Dict[str, Callable[[ParseNode], None]]
        """
        fields = {
            "cluster_by": lambda n : setattr(self, 'cluster_by', n.get_str_value()),
            "cluster_by_value": lambda n : setattr(self, 'cluster_by_value', n.get_str_value()),
            "email_count": lambda n : setattr(self, 'email_count', n.get_int_value()),
            "network_message_ids": lambda n : setattr(self, 'network_message_ids', n.get_collection_of_primitive_values(str)),
            "query": lambda n : setattr(self, 'query', n.get_str_value()),
            "urn": lambda n : setattr(self, 'urn', n.get_str_value()),
        }
        super_fields = super().get_field_deserializers()
        fields.update(super_fields)
        return fields
    
    @property
    def network_message_ids(self,) -> Optional[List[str]]:
        """
        Gets the networkMessageIds property value. Unique identifiers for the emails in the cluster, generated by Microsoft 365.
        Returns: Optional[List[str]]
        """
        return self._network_message_ids
    
    @network_message_ids.setter
    def network_message_ids(self,value: Optional[List[str]] = None) -> None:
        """
        Sets the networkMessageIds property value. Unique identifiers for the emails in the cluster, generated by Microsoft 365.
        Args:
            value: Value to set for the networkMessageIds property.
        """
        self._network_message_ids = value
    
    @property
    def query(self,) -> Optional[str]:
        """
        Gets the query property value. The query used to identify the email cluster.
        Returns: Optional[str]
        """
        return self._query
    
    @query.setter
    def query(self,value: Optional[str] = None) -> None:
        """
        Sets the query property value. The query used to identify the email cluster.
        Args:
            value: Value to set for the query property.
        """
        self._query = value
    
    def serialize(self,writer: SerializationWriter) -> None:
        """
        Serializes information the current object
        Args:
            writer: Serialization writer to use to serialize this model
        """
        if writer is None:
            raise Exception("writer cannot be undefined")
        super().serialize(writer)
        writer.write_str_value("clusterBy", self.cluster_by)
        writer.write_str_value("clusterByValue", self.cluster_by_value)
        writer.write_int_value("emailCount", self.email_count)
        writer.write_collection_of_primitive_values("networkMessageIds", self.network_message_ids)
        writer.write_str_value("query", self.query)
        writer.write_str_value("urn", self.urn)
    
    @property
    def urn(self,) -> Optional[str]:
        """
        Gets the urn property value. Uniform resource name (URN) of the automated investigation where the cluster was identified.
        Returns: Optional[str]
        """
        return self._urn
    
    @urn.setter
    def urn(self,value: Optional[str] = None) -> None:
        """
        Sets the urn property value. Uniform resource name (URN) of the automated investigation where the cluster was identified.
        Args:
            value: Value to set for the urn property.
        """
        self._urn = value
    

