from __future__ import annotations
from datetime import datetime
from kiota_abstractions.serialization import Parsable, ParseNode, SerializationWriter
from kiota_abstractions.utils import lazy_import
from typing import Any, Callable, Dict, List, Optional, Union

entity = lazy_import('msgraph.generated.models.entity')

class WindowsDeviceMalwareState(entity.Entity):
    """
    Provides operations to manage the collection of accessReview entities.
    """
    @property
    def additional_information_url(self,) -> Optional[str]:
        """
        Gets the additionalInformationUrl property value. The additional information URL for the discovered malware. Optional. Read-only.
        Returns: Optional[str]
        """
        return self._additional_information_url
    
    @additional_information_url.setter
    def additional_information_url(self,value: Optional[str] = None) -> None:
        """
        Sets the additionalInformationUrl property value. The additional information URL for the discovered malware. Optional. Read-only.
        Args:
            value: Value to set for the additionalInformationUrl property.
        """
        self._additional_information_url = value
    
    def __init__(self,) -> None:
        """
        Instantiates a new windowsDeviceMalwareState and sets the default values.
        """
        super().__init__()
        # The additional information URL for the discovered malware. Optional. Read-only.
        self._additional_information_url: Optional[str] = None
        # The number of times the piece of malware has been detected. Optional. Read-only.
        self._detection_count: Optional[int] = None
        # A flag indicating whether the device has been deleted. Optional. Read-only.
        self._device_deleted: Optional[bool] = None
        # The date and time the piece of malware was initially detected. Optional. Read-only.
        self._initial_detection_date_time: Optional[datetime] = None
        # Date and time the entity was last updated in the multi-tenant management platform. Optional. Read-only.
        self._last_refreshed_date_time: Optional[datetime] = None
        # The date and time the malware state was last changed. Optional. Read-only.
        self._last_state_change_date_time: Optional[datetime] = None
        # The category for the detected malware. Optional. Read-only.
        self._malware_category: Optional[str] = None
        # The display name for the detected malware. Optional. Read-only.
        self._malware_display_name: Optional[str] = None
        # The execution state for the detected malware. Optional. Read-only.
        self._malware_execution_state: Optional[str] = None
        # The unique identifier for the detected malware. Optional. Read-only.
        self._malware_id: Optional[str] = None
        # The severity for the detected malware. Optional. Read-only.
        self._malware_severity: Optional[str] = None
        # The threat state for the detected malware. Optional. Read-only.
        self._malware_threat_state: Optional[str] = None
        # The identifier for the managed device where the malware was detected. Optional. Read-only.
        self._managed_device_id: Optional[str] = None
        # The display name for the managed device where the malware was detected. Optional. Read-only.
        self._managed_device_name: Optional[str] = None
        # The OdataType property
        self.odata_type: Optional[str] = None
        # The display name for the managed tenant. Optional. Read-only.
        self._tenant_display_name: Optional[str] = None
        # The Azure Active Directory tenant identifier for the managed tenant. Optional. Read-only.
        self._tenant_id: Optional[str] = None
    
    @staticmethod
    def create_from_discriminator_value(parse_node: Optional[ParseNode] = None) -> WindowsDeviceMalwareState:
        """
        Creates a new instance of the appropriate class based on discriminator value
        Args:
            parseNode: The parse node to use to read the discriminator value and create the object
        Returns: WindowsDeviceMalwareState
        """
        if parse_node is None:
            raise Exception("parse_node cannot be undefined")
        return WindowsDeviceMalwareState()
    
    @property
    def detection_count(self,) -> Optional[int]:
        """
        Gets the detectionCount property value. The number of times the piece of malware has been detected. Optional. Read-only.
        Returns: Optional[int]
        """
        return self._detection_count
    
    @detection_count.setter
    def detection_count(self,value: Optional[int] = None) -> None:
        """
        Sets the detectionCount property value. The number of times the piece of malware has been detected. Optional. Read-only.
        Args:
            value: Value to set for the detectionCount property.
        """
        self._detection_count = value
    
    @property
    def device_deleted(self,) -> Optional[bool]:
        """
        Gets the deviceDeleted property value. A flag indicating whether the device has been deleted. Optional. Read-only.
        Returns: Optional[bool]
        """
        return self._device_deleted
    
    @device_deleted.setter
    def device_deleted(self,value: Optional[bool] = None) -> None:
        """
        Sets the deviceDeleted property value. A flag indicating whether the device has been deleted. Optional. Read-only.
        Args:
            value: Value to set for the deviceDeleted property.
        """
        self._device_deleted = value
    
    def get_field_deserializers(self,) -> Dict[str, Callable[[ParseNode], None]]:
        """
        The deserialization information for the current model
        Returns: Dict[str, Callable[[ParseNode], None]]
        """
        fields = {
            "additional_information_url": lambda n : setattr(self, 'additional_information_url', n.get_str_value()),
            "detection_count": lambda n : setattr(self, 'detection_count', n.get_int_value()),
            "device_deleted": lambda n : setattr(self, 'device_deleted', n.get_bool_value()),
            "initial_detection_date_time": lambda n : setattr(self, 'initial_detection_date_time', n.get_datetime_value()),
            "last_refreshed_date_time": lambda n : setattr(self, 'last_refreshed_date_time', n.get_datetime_value()),
            "last_state_change_date_time": lambda n : setattr(self, 'last_state_change_date_time', n.get_datetime_value()),
            "malware_category": lambda n : setattr(self, 'malware_category', n.get_str_value()),
            "malware_display_name": lambda n : setattr(self, 'malware_display_name', n.get_str_value()),
            "malware_execution_state": lambda n : setattr(self, 'malware_execution_state', n.get_str_value()),
            "malware_id": lambda n : setattr(self, 'malware_id', n.get_str_value()),
            "malware_severity": lambda n : setattr(self, 'malware_severity', n.get_str_value()),
            "malware_threat_state": lambda n : setattr(self, 'malware_threat_state', n.get_str_value()),
            "managed_device_id": lambda n : setattr(self, 'managed_device_id', n.get_str_value()),
            "managed_device_name": lambda n : setattr(self, 'managed_device_name', n.get_str_value()),
            "tenant_display_name": lambda n : setattr(self, 'tenant_display_name', n.get_str_value()),
            "tenant_id": lambda n : setattr(self, 'tenant_id', n.get_str_value()),
        }
        super_fields = super().get_field_deserializers()
        fields.update(super_fields)
        return fields
    
    @property
    def initial_detection_date_time(self,) -> Optional[datetime]:
        """
        Gets the initialDetectionDateTime property value. The date and time the piece of malware was initially detected. Optional. Read-only.
        Returns: Optional[datetime]
        """
        return self._initial_detection_date_time
    
    @initial_detection_date_time.setter
    def initial_detection_date_time(self,value: Optional[datetime] = None) -> None:
        """
        Sets the initialDetectionDateTime property value. The date and time the piece of malware was initially detected. Optional. Read-only.
        Args:
            value: Value to set for the initialDetectionDateTime property.
        """
        self._initial_detection_date_time = value
    
    @property
    def last_refreshed_date_time(self,) -> Optional[datetime]:
        """
        Gets the lastRefreshedDateTime property value. Date and time the entity was last updated in the multi-tenant management platform. Optional. Read-only.
        Returns: Optional[datetime]
        """
        return self._last_refreshed_date_time
    
    @last_refreshed_date_time.setter
    def last_refreshed_date_time(self,value: Optional[datetime] = None) -> None:
        """
        Sets the lastRefreshedDateTime property value. Date and time the entity was last updated in the multi-tenant management platform. Optional. Read-only.
        Args:
            value: Value to set for the lastRefreshedDateTime property.
        """
        self._last_refreshed_date_time = value
    
    @property
    def last_state_change_date_time(self,) -> Optional[datetime]:
        """
        Gets the lastStateChangeDateTime property value. The date and time the malware state was last changed. Optional. Read-only.
        Returns: Optional[datetime]
        """
        return self._last_state_change_date_time
    
    @last_state_change_date_time.setter
    def last_state_change_date_time(self,value: Optional[datetime] = None) -> None:
        """
        Sets the lastStateChangeDateTime property value. The date and time the malware state was last changed. Optional. Read-only.
        Args:
            value: Value to set for the lastStateChangeDateTime property.
        """
        self._last_state_change_date_time = value
    
    @property
    def malware_category(self,) -> Optional[str]:
        """
        Gets the malwareCategory property value. The category for the detected malware. Optional. Read-only.
        Returns: Optional[str]
        """
        return self._malware_category
    
    @malware_category.setter
    def malware_category(self,value: Optional[str] = None) -> None:
        """
        Sets the malwareCategory property value. The category for the detected malware. Optional. Read-only.
        Args:
            value: Value to set for the malwareCategory property.
        """
        self._malware_category = value
    
    @property
    def malware_display_name(self,) -> Optional[str]:
        """
        Gets the malwareDisplayName property value. The display name for the detected malware. Optional. Read-only.
        Returns: Optional[str]
        """
        return self._malware_display_name
    
    @malware_display_name.setter
    def malware_display_name(self,value: Optional[str] = None) -> None:
        """
        Sets the malwareDisplayName property value. The display name for the detected malware. Optional. Read-only.
        Args:
            value: Value to set for the malwareDisplayName property.
        """
        self._malware_display_name = value
    
    @property
    def malware_execution_state(self,) -> Optional[str]:
        """
        Gets the malwareExecutionState property value. The execution state for the detected malware. Optional. Read-only.
        Returns: Optional[str]
        """
        return self._malware_execution_state
    
    @malware_execution_state.setter
    def malware_execution_state(self,value: Optional[str] = None) -> None:
        """
        Sets the malwareExecutionState property value. The execution state for the detected malware. Optional. Read-only.
        Args:
            value: Value to set for the malwareExecutionState property.
        """
        self._malware_execution_state = value
    
    @property
    def malware_id(self,) -> Optional[str]:
        """
        Gets the malwareId property value. The unique identifier for the detected malware. Optional. Read-only.
        Returns: Optional[str]
        """
        return self._malware_id
    
    @malware_id.setter
    def malware_id(self,value: Optional[str] = None) -> None:
        """
        Sets the malwareId property value. The unique identifier for the detected malware. Optional. Read-only.
        Args:
            value: Value to set for the malwareId property.
        """
        self._malware_id = value
    
    @property
    def malware_severity(self,) -> Optional[str]:
        """
        Gets the malwareSeverity property value. The severity for the detected malware. Optional. Read-only.
        Returns: Optional[str]
        """
        return self._malware_severity
    
    @malware_severity.setter
    def malware_severity(self,value: Optional[str] = None) -> None:
        """
        Sets the malwareSeverity property value. The severity for the detected malware. Optional. Read-only.
        Args:
            value: Value to set for the malwareSeverity property.
        """
        self._malware_severity = value
    
    @property
    def malware_threat_state(self,) -> Optional[str]:
        """
        Gets the malwareThreatState property value. The threat state for the detected malware. Optional. Read-only.
        Returns: Optional[str]
        """
        return self._malware_threat_state
    
    @malware_threat_state.setter
    def malware_threat_state(self,value: Optional[str] = None) -> None:
        """
        Sets the malwareThreatState property value. The threat state for the detected malware. Optional. Read-only.
        Args:
            value: Value to set for the malwareThreatState property.
        """
        self._malware_threat_state = value
    
    @property
    def managed_device_id(self,) -> Optional[str]:
        """
        Gets the managedDeviceId property value. The identifier for the managed device where the malware was detected. Optional. Read-only.
        Returns: Optional[str]
        """
        return self._managed_device_id
    
    @managed_device_id.setter
    def managed_device_id(self,value: Optional[str] = None) -> None:
        """
        Sets the managedDeviceId property value. The identifier for the managed device where the malware was detected. Optional. Read-only.
        Args:
            value: Value to set for the managedDeviceId property.
        """
        self._managed_device_id = value
    
    @property
    def managed_device_name(self,) -> Optional[str]:
        """
        Gets the managedDeviceName property value. The display name for the managed device where the malware was detected. Optional. Read-only.
        Returns: Optional[str]
        """
        return self._managed_device_name
    
    @managed_device_name.setter
    def managed_device_name(self,value: Optional[str] = None) -> None:
        """
        Sets the managedDeviceName property value. The display name for the managed device where the malware was detected. Optional. Read-only.
        Args:
            value: Value to set for the managedDeviceName property.
        """
        self._managed_device_name = value
    
    def serialize(self,writer: SerializationWriter) -> None:
        """
        Serializes information the current object
        Args:
            writer: Serialization writer to use to serialize this model
        """
        if writer is None:
            raise Exception("writer cannot be undefined")
        super().serialize(writer)
        writer.write_str_value("additionalInformationUrl", self.additional_information_url)
        writer.write_int_value("detectionCount", self.detection_count)
        writer.write_bool_value("deviceDeleted", self.device_deleted)
        writer.write_datetime_value("initialDetectionDateTime", self.initial_detection_date_time)
        writer.write_datetime_value("lastRefreshedDateTime", self.last_refreshed_date_time)
        writer.write_datetime_value("lastStateChangeDateTime", self.last_state_change_date_time)
        writer.write_str_value("malwareCategory", self.malware_category)
        writer.write_str_value("malwareDisplayName", self.malware_display_name)
        writer.write_str_value("malwareExecutionState", self.malware_execution_state)
        writer.write_str_value("malwareId", self.malware_id)
        writer.write_str_value("malwareSeverity", self.malware_severity)
        writer.write_str_value("malwareThreatState", self.malware_threat_state)
        writer.write_str_value("managedDeviceId", self.managed_device_id)
        writer.write_str_value("managedDeviceName", self.managed_device_name)
        writer.write_str_value("tenantDisplayName", self.tenant_display_name)
        writer.write_str_value("tenantId", self.tenant_id)
    
    @property
    def tenant_display_name(self,) -> Optional[str]:
        """
        Gets the tenantDisplayName property value. The display name for the managed tenant. Optional. Read-only.
        Returns: Optional[str]
        """
        return self._tenant_display_name
    
    @tenant_display_name.setter
    def tenant_display_name(self,value: Optional[str] = None) -> None:
        """
        Sets the tenantDisplayName property value. The display name for the managed tenant. Optional. Read-only.
        Args:
            value: Value to set for the tenantDisplayName property.
        """
        self._tenant_display_name = value
    
    @property
    def tenant_id(self,) -> Optional[str]:
        """
        Gets the tenantId property value. The Azure Active Directory tenant identifier for the managed tenant. Optional. Read-only.
        Returns: Optional[str]
        """
        return self._tenant_id
    
    @tenant_id.setter
    def tenant_id(self,value: Optional[str] = None) -> None:
        """
        Sets the tenantId property value. The Azure Active Directory tenant identifier for the managed tenant. Optional. Read-only.
        Args:
            value: Value to set for the tenantId property.
        """
        self._tenant_id = value
    

