from __future__ import annotations
from kiota_abstractions.serialization import AdditionalDataHolder, Parsable, ParseNode, SerializationWriter
from kiota_abstractions.utils import lazy_import
from typing import Any, Callable, Dict, List, Optional, Union

defender_threat_action = lazy_import('msgraph.generated.models.defender_threat_action')

class DefenderDetectedMalwareActions(AdditionalDataHolder, Parsable):
    """
    Specify Defender’s actions to take on detected Malware per threat level.
    """
    @property
    def additional_data(self,) -> Dict[str, Any]:
        """
        Gets the additionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
        Returns: Dict[str, Any]
        """
        return self._additional_data
    
    @additional_data.setter
    def additional_data(self,value: Dict[str, Any]) -> None:
        """
        Sets the additionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
        Args:
            value: Value to set for the AdditionalData property.
        """
        self._additional_data = value
    
    def __init__(self,) -> None:
        """
        Instantiates a new defenderDetectedMalwareActions and sets the default values.
        """
        # Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
        self._additional_data: Dict[str, Any] = {}

        # Defender’s default action to take on detected Malware threats.
        self._high_severity: Optional[defender_threat_action.DefenderThreatAction] = None
        # Defender’s default action to take on detected Malware threats.
        self._low_severity: Optional[defender_threat_action.DefenderThreatAction] = None
        # Defender’s default action to take on detected Malware threats.
        self._moderate_severity: Optional[defender_threat_action.DefenderThreatAction] = None
        # The OdataType property
        self._odata_type: Optional[str] = None
        # Defender’s default action to take on detected Malware threats.
        self._severe_severity: Optional[defender_threat_action.DefenderThreatAction] = None
    
    @staticmethod
    def create_from_discriminator_value(parse_node: Optional[ParseNode] = None) -> DefenderDetectedMalwareActions:
        """
        Creates a new instance of the appropriate class based on discriminator value
        Args:
            parseNode: The parse node to use to read the discriminator value and create the object
        Returns: DefenderDetectedMalwareActions
        """
        if parse_node is None:
            raise Exception("parse_node cannot be undefined")
        return DefenderDetectedMalwareActions()
    
    def get_field_deserializers(self,) -> Dict[str, Callable[[ParseNode], None]]:
        """
        The deserialization information for the current model
        Returns: Dict[str, Callable[[ParseNode], None]]
        """
        fields = {
            "high_severity": lambda n : setattr(self, 'high_severity', n.get_enum_value(defender_threat_action.DefenderThreatAction)),
            "low_severity": lambda n : setattr(self, 'low_severity', n.get_enum_value(defender_threat_action.DefenderThreatAction)),
            "moderate_severity": lambda n : setattr(self, 'moderate_severity', n.get_enum_value(defender_threat_action.DefenderThreatAction)),
            "@odata.type": lambda n : setattr(self, 'odata_type', n.get_str_value()),
            "severe_severity": lambda n : setattr(self, 'severe_severity', n.get_enum_value(defender_threat_action.DefenderThreatAction)),
        }
        return fields
    
    @property
    def high_severity(self,) -> Optional[defender_threat_action.DefenderThreatAction]:
        """
        Gets the highSeverity property value. Defender’s default action to take on detected Malware threats.
        Returns: Optional[defender_threat_action.DefenderThreatAction]
        """
        return self._high_severity
    
    @high_severity.setter
    def high_severity(self,value: Optional[defender_threat_action.DefenderThreatAction] = None) -> None:
        """
        Sets the highSeverity property value. Defender’s default action to take on detected Malware threats.
        Args:
            value: Value to set for the highSeverity property.
        """
        self._high_severity = value
    
    @property
    def low_severity(self,) -> Optional[defender_threat_action.DefenderThreatAction]:
        """
        Gets the lowSeverity property value. Defender’s default action to take on detected Malware threats.
        Returns: Optional[defender_threat_action.DefenderThreatAction]
        """
        return self._low_severity
    
    @low_severity.setter
    def low_severity(self,value: Optional[defender_threat_action.DefenderThreatAction] = None) -> None:
        """
        Sets the lowSeverity property value. Defender’s default action to take on detected Malware threats.
        Args:
            value: Value to set for the lowSeverity property.
        """
        self._low_severity = value
    
    @property
    def moderate_severity(self,) -> Optional[defender_threat_action.DefenderThreatAction]:
        """
        Gets the moderateSeverity property value. Defender’s default action to take on detected Malware threats.
        Returns: Optional[defender_threat_action.DefenderThreatAction]
        """
        return self._moderate_severity
    
    @moderate_severity.setter
    def moderate_severity(self,value: Optional[defender_threat_action.DefenderThreatAction] = None) -> None:
        """
        Sets the moderateSeverity property value. Defender’s default action to take on detected Malware threats.
        Args:
            value: Value to set for the moderateSeverity property.
        """
        self._moderate_severity = value
    
    @property
    def odata_type(self,) -> Optional[str]:
        """
        Gets the @odata.type property value. The OdataType property
        Returns: Optional[str]
        """
        return self._odata_type
    
    @odata_type.setter
    def odata_type(self,value: Optional[str] = None) -> None:
        """
        Sets the @odata.type property value. The OdataType property
        Args:
            value: Value to set for the OdataType property.
        """
        self._odata_type = value
    
    def serialize(self,writer: SerializationWriter) -> None:
        """
        Serializes information the current object
        Args:
            writer: Serialization writer to use to serialize this model
        """
        if writer is None:
            raise Exception("writer cannot be undefined")
        writer.write_enum_value("highSeverity", self.high_severity)
        writer.write_enum_value("lowSeverity", self.low_severity)
        writer.write_enum_value("moderateSeverity", self.moderate_severity)
        writer.write_str_value("@odata.type", self.odata_type)
        writer.write_enum_value("severeSeverity", self.severe_severity)
        writer.write_additional_data_value(self.additional_data)
    
    @property
    def severe_severity(self,) -> Optional[defender_threat_action.DefenderThreatAction]:
        """
        Gets the severeSeverity property value. Defender’s default action to take on detected Malware threats.
        Returns: Optional[defender_threat_action.DefenderThreatAction]
        """
        return self._severe_severity
    
    @severe_severity.setter
    def severe_severity(self,value: Optional[defender_threat_action.DefenderThreatAction] = None) -> None:
        """
        Sets the severeSeverity property value. Defender’s default action to take on detected Malware threats.
        Args:
            value: Value to set for the severeSeverity property.
        """
        self._severe_severity = value
    

