from __future__ import annotations
from kiota_abstractions.serialization import AdditionalDataHolder, Parsable, ParseNode, SerializationWriter
from kiota_abstractions.utils import lazy_import
from typing import Any, Callable, Dict, List, Optional, Union

class ChangeNotificationEncryptedContent(AdditionalDataHolder, Parsable):
    @property
    def additional_data(self,) -> Dict[str, Any]:
        """
        Gets the additionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
        Returns: Dict[str, Any]
        """
        return self._additional_data
    
    @additional_data.setter
    def additional_data(self,value: Dict[str, Any]) -> None:
        """
        Sets the additionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
        Args:
            value: Value to set for the AdditionalData property.
        """
        self._additional_data = value
    
    def __init__(self,) -> None:
        """
        Instantiates a new changeNotificationEncryptedContent and sets the default values.
        """
        # Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
        self._additional_data: Dict[str, Any] = {}

        # Base64-encoded encrypted data that produces a full resource respresented as JSON. The data has been encrypted with the provided dataKey using an AES/CBC/PKCS5PADDING cipher suite.
        self._data: Optional[str] = None
        # Base64-encoded symmetric key generated by Microsoft Graph to encrypt the data value and to generate the data signature. This key is encrypted with the certificate public key that was provided during the subscription. It must be decrypted with the certificate private key before it can be used to decrypt the data or verify the signature. This key has been encrypted with the following cipher suite: RSA/ECB/OAEPWithSHA1AndMGF1Padding.
        self._data_key: Optional[str] = None
        # Base64-encoded HMAC-SHA256 hash of the data for validation purposes.
        self._data_signature: Optional[str] = None
        # ID of the certificate used to encrypt the dataKey.
        self._encryption_certificate_id: Optional[str] = None
        # Hexadecimal representation of the thumbprint of the certificate used to encrypt the dataKey.
        self._encryption_certificate_thumbprint: Optional[str] = None
        # The OdataType property
        self._odata_type: Optional[str] = None
    
    @staticmethod
    def create_from_discriminator_value(parse_node: Optional[ParseNode] = None) -> ChangeNotificationEncryptedContent:
        """
        Creates a new instance of the appropriate class based on discriminator value
        Args:
            parseNode: The parse node to use to read the discriminator value and create the object
        Returns: ChangeNotificationEncryptedContent
        """
        if parse_node is None:
            raise Exception("parse_node cannot be undefined")
        return ChangeNotificationEncryptedContent()
    
    @property
    def data(self,) -> Optional[str]:
        """
        Gets the data property value. Base64-encoded encrypted data that produces a full resource respresented as JSON. The data has been encrypted with the provided dataKey using an AES/CBC/PKCS5PADDING cipher suite.
        Returns: Optional[str]
        """
        return self._data
    
    @data.setter
    def data(self,value: Optional[str] = None) -> None:
        """
        Sets the data property value. Base64-encoded encrypted data that produces a full resource respresented as JSON. The data has been encrypted with the provided dataKey using an AES/CBC/PKCS5PADDING cipher suite.
        Args:
            value: Value to set for the data property.
        """
        self._data = value
    
    @property
    def data_key(self,) -> Optional[str]:
        """
        Gets the dataKey property value. Base64-encoded symmetric key generated by Microsoft Graph to encrypt the data value and to generate the data signature. This key is encrypted with the certificate public key that was provided during the subscription. It must be decrypted with the certificate private key before it can be used to decrypt the data or verify the signature. This key has been encrypted with the following cipher suite: RSA/ECB/OAEPWithSHA1AndMGF1Padding.
        Returns: Optional[str]
        """
        return self._data_key
    
    @data_key.setter
    def data_key(self,value: Optional[str] = None) -> None:
        """
        Sets the dataKey property value. Base64-encoded symmetric key generated by Microsoft Graph to encrypt the data value and to generate the data signature. This key is encrypted with the certificate public key that was provided during the subscription. It must be decrypted with the certificate private key before it can be used to decrypt the data or verify the signature. This key has been encrypted with the following cipher suite: RSA/ECB/OAEPWithSHA1AndMGF1Padding.
        Args:
            value: Value to set for the dataKey property.
        """
        self._data_key = value
    
    @property
    def data_signature(self,) -> Optional[str]:
        """
        Gets the dataSignature property value. Base64-encoded HMAC-SHA256 hash of the data for validation purposes.
        Returns: Optional[str]
        """
        return self._data_signature
    
    @data_signature.setter
    def data_signature(self,value: Optional[str] = None) -> None:
        """
        Sets the dataSignature property value. Base64-encoded HMAC-SHA256 hash of the data for validation purposes.
        Args:
            value: Value to set for the dataSignature property.
        """
        self._data_signature = value
    
    @property
    def encryption_certificate_id(self,) -> Optional[str]:
        """
        Gets the encryptionCertificateId property value. ID of the certificate used to encrypt the dataKey.
        Returns: Optional[str]
        """
        return self._encryption_certificate_id
    
    @encryption_certificate_id.setter
    def encryption_certificate_id(self,value: Optional[str] = None) -> None:
        """
        Sets the encryptionCertificateId property value. ID of the certificate used to encrypt the dataKey.
        Args:
            value: Value to set for the encryptionCertificateId property.
        """
        self._encryption_certificate_id = value
    
    @property
    def encryption_certificate_thumbprint(self,) -> Optional[str]:
        """
        Gets the encryptionCertificateThumbprint property value. Hexadecimal representation of the thumbprint of the certificate used to encrypt the dataKey.
        Returns: Optional[str]
        """
        return self._encryption_certificate_thumbprint
    
    @encryption_certificate_thumbprint.setter
    def encryption_certificate_thumbprint(self,value: Optional[str] = None) -> None:
        """
        Sets the encryptionCertificateThumbprint property value. Hexadecimal representation of the thumbprint of the certificate used to encrypt the dataKey.
        Args:
            value: Value to set for the encryptionCertificateThumbprint property.
        """
        self._encryption_certificate_thumbprint = value
    
    def get_field_deserializers(self,) -> Dict[str, Callable[[ParseNode], None]]:
        """
        The deserialization information for the current model
        Returns: Dict[str, Callable[[ParseNode], None]]
        """
        fields = {
            "data": lambda n : setattr(self, 'data', n.get_str_value()),
            "data_key": lambda n : setattr(self, 'data_key', n.get_str_value()),
            "data_signature": lambda n : setattr(self, 'data_signature', n.get_str_value()),
            "encryption_certificate_id": lambda n : setattr(self, 'encryption_certificate_id', n.get_str_value()),
            "encryption_certificate_thumbprint": lambda n : setattr(self, 'encryption_certificate_thumbprint', n.get_str_value()),
            "@odata.type": lambda n : setattr(self, 'odata_type', n.get_str_value()),
        }
        return fields
    
    @property
    def odata_type(self,) -> Optional[str]:
        """
        Gets the @odata.type property value. The OdataType property
        Returns: Optional[str]
        """
        return self._odata_type
    
    @odata_type.setter
    def odata_type(self,value: Optional[str] = None) -> None:
        """
        Sets the @odata.type property value. The OdataType property
        Args:
            value: Value to set for the OdataType property.
        """
        self._odata_type = value
    
    def serialize(self,writer: SerializationWriter) -> None:
        """
        Serializes information the current object
        Args:
            writer: Serialization writer to use to serialize this model
        """
        if writer is None:
            raise Exception("writer cannot be undefined")
        writer.write_str_value("data", self.data)
        writer.write_str_value("dataKey", self.data_key)
        writer.write_str_value("dataSignature", self.data_signature)
        writer.write_str_value("encryptionCertificateId", self.encryption_certificate_id)
        writer.write_str_value("encryptionCertificateThumbprint", self.encryption_certificate_thumbprint)
        writer.write_str_value("@odata.type", self.odata_type)
        writer.write_additional_data_value(self.additional_data)
    

