"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ControlPolicy = exports.ControlPolicyProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cloudfw_generated_1 = require("./cloudfw.generated");
Object.defineProperty(exports, "ControlPolicyProperty", { enumerable: true, get: function () { return cloudfw_generated_1.RosControlPolicy; } });
/**
 * A ROS resource type:  `ALIYUN::CLOUDFW::ControlPolicy`
 */
class ControlPolicy extends ros.Resource {
    /**
     * Create a new `ALIYUN::CLOUDFW::ControlPolicy`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosControlPolicy = new cloudfw_generated_1.RosControlPolicy(this, id, {
            destination: props.destination,
            applicationName: props.applicationName,
            description: props.description,
            sourceType: props.sourceType,
            destPort: props.destPort,
            aclAction: props.aclAction,
            destinationType: props.destinationType,
            direction: props.direction,
            source: props.source,
            destPortType: props.destPortType,
            proto: props.proto,
            regionId: props.regionId ? props.regionId : 'cn-hangzhou',
            newOrder: props.newOrder,
            destPortGroup: props.destPortGroup,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosControlPolicy;
        this.attrAclUuid = rosControlPolicy.attrAclUuid;
    }
}
exports.ControlPolicy = ControlPolicy;
//# sourceMappingURL=data:application/json;base64,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