"use strict";
// Generated from the AliCloud ROS Resource Specification
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosControlPolicy = exports.RosAddressBook = void 0;
const ros = require("@alicloud/ros-cdk-core");
/**
 * Determine whether the given properties match those of a `RosAddressBookProps`
 *
 * @param properties - the TypeScript properties of a `RosAddressBookProps`
 *
 * @returns the result of the validation.
 */
function RosAddressBookPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('groupName', ros.requiredValidator)(properties.groupName));
    errors.collect(ros.propertyValidator('groupName', ros.validateString)(properties.groupName));
    errors.collect(ros.propertyValidator('description', ros.requiredValidator)(properties.description));
    if (properties.description && (Array.isArray(properties.description) || (typeof properties.description) === 'string')) {
        errors.collect(ros.propertyValidator('description', ros.validateLength)({
            data: properties.description.length,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('description', ros.validateString)(properties.description));
    if (properties.tagRelation && (typeof properties.tagRelation) !== 'object') {
        errors.collect(ros.propertyValidator('tagRelation', ros.validateAllowedValues)({
            data: properties.tagRelation,
            allowedValues: ["and", "or"],
        }));
    }
    errors.collect(ros.propertyValidator('tagRelation', ros.validateString)(properties.tagRelation));
    errors.collect(ros.propertyValidator('groupType', ros.requiredValidator)(properties.groupType));
    if (properties.groupType && (typeof properties.groupType) !== 'object') {
        errors.collect(ros.propertyValidator('groupType', ros.validateAllowedValues)({
            data: properties.groupType,
            allowedValues: ["domain", "ip", "port", "tag"],
        }));
    }
    errors.collect(ros.propertyValidator('groupType', ros.validateString)(properties.groupType));
    if (properties.tagList && (Array.isArray(properties.tagList) || (typeof properties.tagList) === 'string')) {
        errors.collect(ros.propertyValidator('tagList', ros.validateLength)({
            data: properties.tagList.length,
            min: undefined,
            max: 100,
        }));
    }
    errors.collect(ros.propertyValidator('tagList', ros.listValidator(RosAddressBook_TagListPropertyValidator))(properties.tagList));
    if (properties.regionId && (typeof properties.regionId) !== 'object') {
        errors.collect(ros.propertyValidator('regionId', ros.validateAllowedValues)({
            data: properties.regionId,
            allowedValues: ["cn-hangzhou", "ap-southeast-1"],
        }));
    }
    errors.collect(ros.propertyValidator('regionId', ros.validateString)(properties.regionId));
    errors.collect(ros.propertyValidator('autoAddTagEcs', ros.validateBoolean)(properties.autoAddTagEcs));
    errors.collect(ros.propertyValidator('addressList', ros.validateString)(properties.addressList));
    return errors.wrap('supplied properties not correct for "RosAddressBookProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CLOUDFW::AddressBook` resource
 *
 * @param properties - the TypeScript properties of a `RosAddressBookProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CLOUDFW::AddressBook` resource.
 */
// @ts-ignore TS6133
function rosAddressBookPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosAddressBookPropsValidator(properties).assertSuccess();
    }
    return {
        Description: ros.stringToRosTemplate(properties.description),
        GroupName: ros.stringToRosTemplate(properties.groupName),
        GroupType: ros.stringToRosTemplate(properties.groupType),
        AddressList: ros.stringToRosTemplate(properties.addressList),
        AutoAddTagEcs: ros.booleanToRosTemplate(properties.autoAddTagEcs),
        RegionId: ros.stringToRosTemplate(properties.regionId),
        TagList: ros.listMapper(rosAddressBookTagListPropertyToRosTemplate)(properties.tagList),
        TagRelation: ros.stringToRosTemplate(properties.tagRelation),
    };
}
/**
 * A ROS template type:  `ALIYUN::CLOUDFW::AddressBook`
 */
class RosAddressBook extends ros.RosResource {
    /**
     * Create a new `ALIYUN::CLOUDFW::AddressBook`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosAddressBook.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrGroupUuid = this.getAtt('GroupUuid');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.description = props.description;
        this.groupName = props.groupName;
        this.groupType = props.groupType;
        this.addressList = props.addressList;
        this.autoAddTagEcs = props.autoAddTagEcs;
        this.regionId = props.regionId;
        this.tagList = props.tagList;
        this.tagRelation = props.tagRelation;
    }
    get rosProperties() {
        return {
            description: this.description,
            groupName: this.groupName,
            groupType: this.groupType,
            addressList: this.addressList,
            autoAddTagEcs: this.autoAddTagEcs,
            regionId: this.regionId,
            tagList: this.tagList,
            tagRelation: this.tagRelation,
        };
    }
    renderProperties(props) {
        return rosAddressBookPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosAddressBook = RosAddressBook;
/**
 * The resource type name for this resource class.
 */
RosAddressBook.ROS_RESOURCE_TYPE_NAME = "ALIYUN::CLOUDFW::AddressBook";
/**
 * Determine whether the given properties match those of a `TagListProperty`
 *
 * @param properties - the TypeScript properties of a `TagListProperty`
 *
 * @returns the result of the validation.
 */
function RosAddressBook_TagListPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('tagKey', ros.validateString)(properties.tagKey));
    errors.collect(ros.propertyValidator('tagValue', ros.validateString)(properties.tagValue));
    return errors.wrap('supplied properties not correct for "TagListProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CLOUDFW::AddressBook.TagList` resource
 *
 * @param properties - the TypeScript properties of a `TagListProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CLOUDFW::AddressBook.TagList` resource.
 */
// @ts-ignore TS6133
function rosAddressBookTagListPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosAddressBook_TagListPropertyValidator(properties).assertSuccess();
    return {
        TagKey: ros.stringToRosTemplate(properties.tagKey),
        TagValue: ros.stringToRosTemplate(properties.tagValue),
    };
}
/**
 * Determine whether the given properties match those of a `RosControlPolicyProps`
 *
 * @param properties - the TypeScript properties of a `RosControlPolicyProps`
 *
 * @returns the result of the validation.
 */
function RosControlPolicyPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('destination', ros.requiredValidator)(properties.destination));
    if (properties.destination && (Array.isArray(properties.destination) || (typeof properties.destination) === 'string')) {
        errors.collect(ros.propertyValidator('destination', ros.validateLength)({
            data: properties.destination.length,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('destination', ros.validateString)(properties.destination));
    errors.collect(ros.propertyValidator('applicationName', ros.requiredValidator)(properties.applicationName));
    if (properties.applicationName && (typeof properties.applicationName) !== 'object') {
        errors.collect(ros.propertyValidator('applicationName', ros.validateAllowedValues)({
            data: properties.applicationName,
            allowedValues: ["ANY", "HTTP", "HTTPS", "MQTT", "Memcache", "MongoDB", "MySQL", "RDP", "Redis", "SMTP", "SMTPS", "SSH", "SSL", "VNC"],
        }));
    }
    errors.collect(ros.propertyValidator('applicationName', ros.validateString)(properties.applicationName));
    errors.collect(ros.propertyValidator('description', ros.requiredValidator)(properties.description));
    if (properties.description && (Array.isArray(properties.description) || (typeof properties.description) === 'string')) {
        errors.collect(ros.propertyValidator('description', ros.validateLength)({
            data: properties.description.length,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('description', ros.validateString)(properties.description));
    errors.collect(ros.propertyValidator('sourceType', ros.requiredValidator)(properties.sourceType));
    if (properties.sourceType && (typeof properties.sourceType) !== 'object') {
        errors.collect(ros.propertyValidator('sourceType', ros.validateAllowedValues)({
            data: properties.sourceType,
            allowedValues: ["group", "location", "net"],
        }));
    }
    errors.collect(ros.propertyValidator('sourceType', ros.validateString)(properties.sourceType));
    errors.collect(ros.propertyValidator('destPort', ros.validateString)(properties.destPort));
    errors.collect(ros.propertyValidator('aclAction', ros.requiredValidator)(properties.aclAction));
    if (properties.aclAction && (typeof properties.aclAction) !== 'object') {
        errors.collect(ros.propertyValidator('aclAction', ros.validateAllowedValues)({
            data: properties.aclAction,
            allowedValues: ["accept", "drop", "log"],
        }));
    }
    errors.collect(ros.propertyValidator('aclAction', ros.validateString)(properties.aclAction));
    errors.collect(ros.propertyValidator('destinationType', ros.requiredValidator)(properties.destinationType));
    if (properties.destinationType && (typeof properties.destinationType) !== 'object') {
        errors.collect(ros.propertyValidator('destinationType', ros.validateAllowedValues)({
            data: properties.destinationType,
            allowedValues: ["domain", "group", "location", "net"],
        }));
    }
    errors.collect(ros.propertyValidator('destinationType', ros.validateString)(properties.destinationType));
    errors.collect(ros.propertyValidator('direction', ros.requiredValidator)(properties.direction));
    if (properties.direction && (typeof properties.direction) !== 'object') {
        errors.collect(ros.propertyValidator('direction', ros.validateAllowedValues)({
            data: properties.direction,
            allowedValues: ["in", "out"],
        }));
    }
    errors.collect(ros.propertyValidator('direction', ros.validateString)(properties.direction));
    errors.collect(ros.propertyValidator('source', ros.requiredValidator)(properties.source));
    if (properties.source && (Array.isArray(properties.source) || (typeof properties.source) === 'string')) {
        errors.collect(ros.propertyValidator('source', ros.validateLength)({
            data: properties.source.length,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('source', ros.validateString)(properties.source));
    if (properties.destPortType && (typeof properties.destPortType) !== 'object') {
        errors.collect(ros.propertyValidator('destPortType', ros.validateAllowedValues)({
            data: properties.destPortType,
            allowedValues: ["group", "port"],
        }));
    }
    errors.collect(ros.propertyValidator('destPortType', ros.validateString)(properties.destPortType));
    errors.collect(ros.propertyValidator('proto', ros.requiredValidator)(properties.proto));
    if (properties.proto && (typeof properties.proto) !== 'object') {
        errors.collect(ros.propertyValidator('proto', ros.validateAllowedValues)({
            data: properties.proto,
            allowedValues: ["ANY", "ICMP", "TCP", "UDP"],
        }));
    }
    errors.collect(ros.propertyValidator('proto', ros.validateString)(properties.proto));
    if (properties.regionId && (typeof properties.regionId) !== 'object') {
        errors.collect(ros.propertyValidator('regionId', ros.validateAllowedValues)({
            data: properties.regionId,
            allowedValues: ["cn-hangzhou", "ap-southeast-1"],
        }));
    }
    errors.collect(ros.propertyValidator('regionId', ros.validateString)(properties.regionId));
    errors.collect(ros.propertyValidator('newOrder', ros.requiredValidator)(properties.newOrder));
    if (properties.newOrder && (typeof properties.newOrder) !== 'object') {
        errors.collect(ros.propertyValidator('newOrder', ros.validateRange)({
            data: properties.newOrder,
            min: -1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('newOrder', ros.validateNumber)(properties.newOrder));
    errors.collect(ros.propertyValidator('destPortGroup', ros.validateString)(properties.destPortGroup));
    return errors.wrap('supplied properties not correct for "RosControlPolicyProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::CLOUDFW::ControlPolicy` resource
 *
 * @param properties - the TypeScript properties of a `RosControlPolicyProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::CLOUDFW::ControlPolicy` resource.
 */
// @ts-ignore TS6133
function rosControlPolicyPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosControlPolicyPropsValidator(properties).assertSuccess();
    }
    return {
        AclAction: ros.stringToRosTemplate(properties.aclAction),
        ApplicationName: ros.stringToRosTemplate(properties.applicationName),
        Description: ros.stringToRosTemplate(properties.description),
        Destination: ros.stringToRosTemplate(properties.destination),
        DestinationType: ros.stringToRosTemplate(properties.destinationType),
        Direction: ros.stringToRosTemplate(properties.direction),
        NewOrder: ros.numberToRosTemplate(properties.newOrder),
        Proto: ros.stringToRosTemplate(properties.proto),
        Source: ros.stringToRosTemplate(properties.source),
        SourceType: ros.stringToRosTemplate(properties.sourceType),
        DestPort: ros.stringToRosTemplate(properties.destPort),
        DestPortGroup: ros.stringToRosTemplate(properties.destPortGroup),
        DestPortType: ros.stringToRosTemplate(properties.destPortType),
        RegionId: ros.stringToRosTemplate(properties.regionId),
    };
}
/**
 * A ROS template type:  `ALIYUN::CLOUDFW::ControlPolicy`
 */
class RosControlPolicy extends ros.RosResource {
    /**
     * Create a new `ALIYUN::CLOUDFW::ControlPolicy`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosControlPolicy.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrAclUuid = this.getAtt('AclUuid');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.aclAction = props.aclAction;
        this.applicationName = props.applicationName;
        this.description = props.description;
        this.destination = props.destination;
        this.destinationType = props.destinationType;
        this.direction = props.direction;
        this.newOrder = props.newOrder;
        this.proto = props.proto;
        this.source = props.source;
        this.sourceType = props.sourceType;
        this.destPort = props.destPort;
        this.destPortGroup = props.destPortGroup;
        this.destPortType = props.destPortType;
        this.regionId = props.regionId;
    }
    get rosProperties() {
        return {
            aclAction: this.aclAction,
            applicationName: this.applicationName,
            description: this.description,
            destination: this.destination,
            destinationType: this.destinationType,
            direction: this.direction,
            newOrder: this.newOrder,
            proto: this.proto,
            source: this.source,
            sourceType: this.sourceType,
            destPort: this.destPort,
            destPortGroup: this.destPortGroup,
            destPortType: this.destPortType,
            regionId: this.regionId,
        };
    }
    renderProperties(props) {
        return rosControlPolicyPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosControlPolicy = RosControlPolicy;
/**
 * The resource type name for this resource class.
 */
RosControlPolicy.ROS_RESOURCE_TYPE_NAME = "ALIYUN::CLOUDFW::ControlPolicy";
//# sourceMappingURL=data:application/json;base64,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