"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddressBook = exports.AddressBookProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cloudfw_generated_1 = require("./cloudfw.generated");
Object.defineProperty(exports, "AddressBookProperty", { enumerable: true, get: function () { return cloudfw_generated_1.RosAddressBook; } });
/**
 * A ROS resource type:  `ALIYUN::CLOUDFW::AddressBook`
 */
class AddressBook extends ros.Resource {
    /**
     * Create a new `ALIYUN::CLOUDFW::AddressBook`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosAddressBook = new cloudfw_generated_1.RosAddressBook(this, id, {
            groupName: props.groupName,
            description: props.description,
            tagRelation: props.tagRelation,
            groupType: props.groupType,
            tagList: props.tagList,
            regionId: props.regionId ? props.regionId : 'cn-hangzhou',
            autoAddTagEcs: props.autoAddTagEcs ? props.autoAddTagEcs : false,
            addressList: props.addressList,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosAddressBook;
        this.attrGroupUuid = rosAddressBook.attrGroupUuid;
    }
}
exports.AddressBook = AddressBook;
//# sourceMappingURL=data:application/json;base64,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